/***************************************************************************
 *   Copyright (C) 2007-2009 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KGmailNotifier.                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#ifndef ATOMCONTENTHANDLER_H
#define ATOMCONTENTHANDLER_H

#include <QXmlDefaultHandler>

#include <vector>

class AtomContentHandler : public QXmlDefaultHandler
{
public:
    AtomContentHandler();
    ~AtomContentHandler();

    // Reimplemented from class QXmlDefaultHandler
    bool startDocument();
    bool startElement(const QString&, const QString&, const QString&, const QXmlAttributes&);
    bool endElement(const QString&, const QString&, const QString&);
    bool characters(const QString&);

    // Access methods
    unsigned int messageCount() const;
    const QString& lastSender() const;
    const QString& lastSubject() const;

private:
    AtomContentHandler(const AtomContentHandler&);
    AtomContentHandler& operator=(const AtomContentHandler&);

    unsigned int m_messageCount;
    QString m_lastSubject;
    QString m_lastSender;

    unsigned int m_numEntriesParsed;
    std::vector<QString> m_currentPath;

    QString currentPath() const;
};

#endif // ATOMCONTENTHANDLER_H
