/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifndef KFTPQUEUEKFTPTRANSFERFILE_H
#define KFTPQUEUEKFTPTRANSFERFILE_H

#include "kftptransfer.h"

class KFTPSessionConnection;
class KFTPQueueManager;

namespace KFTPNetwork {
  class Error;
}

namespace KFTPQueue {

/**
 * This class represents a queued file transfer.
 *
 * @author Jernej Kos
 */
class TransferFile : public Transfer
{
Q_OBJECT
friend class Manager;
public:
    TransferFile(QObject *parent);
    ~TransferFile();
    
    /**
     * @overload
     * Reimplemented from KFTPQueue::Transfer.
     */
    void execute();
    
    /**
     * @overload
     * Reimplemented from KFTPQueue::Transfer.
     */
    void abort();
    
    /**
     * Returns the connection opposite of one that is passed.
     *
     * @param conn The connection.
     * @return The opposite connection.
     */
    KFTPSessionConnection *getOppositeConnection(KFTPSessionConnection *conn);
    
    /**
     * Returns the remote connection.
     *
     * @return The remote connection.
     */
    KFTPSessionConnection *remoteConnection();
private:
    /* Source/destination connections */
    KFTPSessionConnection *m_srcConnection;
    KFTPSessionConnection *m_dstConnection;
    
    /* Update timers */
    QTimer *m_updateTimer;
    QTimer *m_dfTimer;

    /* FXP */
    QTime m_elapsedTime;

    /* Command to finish */
    CommandType m_finishCmd;
    
    /**
     * @overload
     * Reimplemented from KFTPQueue::Transfer.
     */
    void resetTransfer();
private slots:
    void slotTimerUpdate();
    void slotTimerDiskFree();
    
    void slotDiskFree(const QString &mountPoint, unsigned long kBSize, unsigned long kBUsed, unsigned long kBAvail);
    
    void slotCommandFinished(CommandType cmd);
    void slotResumedOffset(filesize_t offset);
    
    void slotClientConnected(bool success);
    void slotSessionAborting();
    
    void slotErrorHandler(KFTPNetwork::Error error);
    void slotConnectionAvailable();
};

}

#endif
