
/***********************************************************************
 *
 * encrypt.h -   defs and protos for encrypt.c
 *
 * $Id: encrypt.h 259 2003-08-18 19:03:27Z eagle $
 *
 * $Log$
 * Revision 1.2  2003/08/18 19:03:26  eagle
 * Update the arguments for send_encrypted_chunk and receive_encrypted_chunk
 * to match the header prototypes for Kerberos v5 1.3.x.  This will now
 * produce warnings for Kerberos v5 1.2.x, but it should end up being
 * equivalent, and this method is more completely correct.
 *
 * Revision 1.1  1994/06/08 17:22:08  schemers
 * Initial revision
 *
 *
 *----------------------------------------------------------------------
 * Copyright (c) 1994 Board of Trustees, Leland Stanford Jr. University
 ***********************************************************************/

#ifndef ENCRYPT_H
#define ENCRYPT_H

int 
send_encrypted_chunk(
         char *in,
         int   in_len,
         int   sock,
         des_cblock *session,
         des_key_schedule sched,
         struct sockaddr_in *sender,
         struct sockaddr_in *receiver);


int 
receive_encrypted_chunk(
         MSG_DAT *m_data,
         char *out,
         int   out_max,
         int   sock,
         des_cblock *session,
         des_key_schedule sched,
         struct sockaddr_in *sender,
         struct sockaddr_in *receiver);

#endif

