/***************************************************************************
                          kfmproject.cpp  -  description
                             -------------------
    begin                : Thu Aug 30 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kfmproject.h"

#include "kfocustasklist.h"
#include "kfocuslogbook.h"

KFMProject::KFMProject()
	: QObject(0,"KFMProject"), taskList_(NULL), logBook_(NULL)
{
	id_ = -1;
	name_ = "Project";
	taskList(new KFMTaskList());
	logBook(new KFMLogBook());
}

KFMProject::~KFMProject(){
	delete logBook_;
	delete taskList_;
}

/////////////////////////////////////////////////////////////////
// Private methods and slots

void KFMProject::taskList(KFMTaskList* taskList){
	if (taskList_ != taskList) {
		if (taskList_ != NULL) {
			disconnect(taskList_, 0, this, 0);
		}
	
		taskList_ = taskList;
		
		if (taskList != NULL) {
			connect(taskList_, SIGNAL( contentsChanged() ), this, SLOT( onTaskListContentsChanged() ));
		}
		
		emit contentsChanged();
	}
}


void KFMProject::logBook(KFMLogBook* logBook){
	if (logBook_ != logBook) {
		if (logBook_ != NULL) {
			disconnect(logBook_, 0, this, 0);
		}
	
		logBook_ = logBook;
		
		if (logBook != NULL) {
			connect(logBook_, SIGNAL( contentsChanged() ), this, SLOT( onLogBookContentsChanged() ));
		}
		
		emit contentsChanged();
	}
}

void KFMProject::onTaskListContentsChanged(){
	emit contentsChanged();
}

void KFMProject::onLogBookContentsChanged(){
	emit contentsChanged();
}


///////////////////////////////////////////////////////////////////
// Public methods and slots

QString KFMProject::name() const{
	return name_;
}

void KFMProject::name(QString name){
	if (name_ != name) {
		name_ = name;
		
		emit nameChanged();
		emit contentsChanged();
	}
}

	
KFMTaskList* KFMProject::taskList() const{
	return taskList_;
}

KFMLogBook* KFMProject::logBook() const{
	return logBook_;
}


void KFMProject::clear(){
	taskList_->clearTasks();
	logBook_->clearEntries();
	name("");
}


QString KFMProject::xmlTag(){
	return QString("project");
}

QDomElement KFMProject::domElement(QDomDocument* doc){
	QDomElement eProject = doc->createElement(xmlTag());
	
		// Save the project id
		eProject.setAttribute("id", id());
		
		// Save project components
		QDomElement eName = doc->createElement("name");
			eName.appendChild(doc->createTextNode(name()));
			eProject.appendChild(eName);
			
		eProject.appendChild(taskList_->domElement(doc));
		eProject.appendChild(logBook_->domElement(doc));
	
		return eProject;
}
	
void KFMProject::domElement(QDomElement eProject){

	// Load project id
	id(eProject.attribute("id",QString::number(-1)).toInt());
	
	// Load project components
	QDomNode n = eProject.firstChild();
	while (!n.isNull()) {
		QDomElement e = n.toElement();
		if (!e.isNull()) {
			if (e.tagName() == "name") {
				QDomText t = e.firstChild().toText();
				name(t.data());
			}
			else if (e.tagName() == KFMTaskList::xmlTag()) {
				taskList_->domElement(e);
			}
			else if (e.tagName() == KFMLogBook::xmlTag()) {
				logBook_->domElement(e);
			}
		}
	
		n = n.nextSibling();
	}
}
