#include <stdlib.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>

#include <qobject.h>
#include <qfile.h>

#include <kstandarddirs.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kdebug.h>

#include "main.h"

#include "pref.h"


kfishPref *kfishPref::s_prefs = 0L;

kfishPref *kfishPref::prefs()
{
	if( !s_prefs )
		s_prefs = new kfishPref;
	return s_prefs;
}

kfishPref::kfishPref()
{
    m_width = 5;
    m_height = 5;
    
    m_fishList = new QDict<QString>;
    m_fishList -> setAutoDelete(true);

    config = kfishApp -> config();
    load();
}


kfishPref::~kfishPref()
{
    delete m_fishList;
}

void kfishPref::load()
{
    config->setGroup("KFish General");
    // MAIN
    m_fishName = config->readEntry("Fish's Name", "Cily");
    m_fishFile = config->readEntry("Fish's File", "gnomefish.png");
    m_numBubble = config->readNumEntry("Number of Bubbles", 20);
    m_widthSpace = config->readNumEntry("Width Space on Horizontal", 60);
    
    // ANIMATION
    m_animationFish = static_cast<fishAnimations> (config->readNumEntry("Animation", kfishPref::Mouse));
    m_animationTimer = config->readNumEntry("Animation Timer", 30);

    // i emit a changePref here becouse when the user change the configuration and then apply
    // but then he doesn't like the way things changed, he just press cancel and we restore to the last
    // saved pref
    m_fishList -> clear();
    QFile file(locate("data","kfish/pics/fishslist"));
    if ( file.open( IO_ReadOnly ) ) {
        QString skey, *sfile;
        QTextStream lector(&file);
        while (!lector.atEnd()) {
            skey = lector.readLine().stripWhiteSpace();
            sfile = new QString(lector.readLine().stripWhiteSpace());
            m_fishList -> insert(skey, sfile);
        }
    }
    else {
        kdWarning() << "Can't find fishlist..." << endl;
        
    }
    emit changePref();
}

void kfishPref::write()
{
    config->setGroup("KFish General");
    // MAIN
    config->writeEntry("Fish's Name",m_fishName);
    config->writeEntry("Fish's File",m_fishFile);
    config->writeEntry("Number of Bubbles",m_numBubble);
    config->writeEntry("Width Space on Horizontal",m_widthSpace);
    // ANIMATION
    config->writeEntry("Animation",m_animationFish);
    config->writeEntry("Animation Timer",m_animationTimer);

    config->sync();
    emit changePref();
}

const QDict<QString> *kfishPref::getFishList() const
{
    return m_fishList;    
}

void kfishPref::emitChangePref()
{
    emit changePref();
}
