/***************************************************************************
 *   Copyright (C) 2005 by Debajyoti Bera <dbera.web@gmail.com>            *
 *   Copyright (C) 2005 Novell, Inc.                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA           *
 ***************************************************************************/

#ifndef BEAGLESEARCH_H
#define BEAGLESEARCH_H

#include <qobject.h>
#include <qtimer.h>
#include <qstringlist.h>

extern "C" {
#include <glib.h>
#include <beagle/beagle.h>
#include <beagle/beagle-query-part-property.h>
}

/**
  Interface to beagle-query
*/
class BeagleSearch : public QObject {
Q_OBJECT

public:

enum TileGroup {
	Unknown=1,
	Application,  	// in combo box
	Contact,
	Folder,
	Image,  	// in combo box
	Audio,  	// in combo box
	Video,  	// in combo box
	Documents,  	// in combo box
	Conversations,  // in combo box
	Website,        // in combo box
	Feed,
	Note
};

typedef QValueList<QString> PropertyList;

typedef struct beagle_result_struct {
	QString		*uri;
	QString		*parent_uri;
	QString		*source;
	PropertyList    properties;
	QString		hit_type;
	QString		*mime_type;
	time_t		last_index_time;
	double          score;
	QString 	*snippet;
	TileGroup       tilegroup;
} beagle_result_struct;

typedef QPtrList<beagle_result_struct> BeagleResultList;
typedef QValueList<QString> BeagleVanishedURIList;


    BeagleSearch(QObject *parent = 0, const char *name = 0);

    ~BeagleSearch();
    bool search(QString& searchstr);

signals:
    void found(BeagleSearch::BeagleResultList &results);
    void vanished(BeagleSearch::BeagleVanishedURIList &results);
    void finished();
    void oops_error(const QString& msg);
	
private slots:
    void gotHits(BeagleResultList& items);
    void lostHits(BeagleVanishedURIList& items);
    void finishedSearch();
    void updateResults();

private:
	static void hits_added_cb (BeagleQuery *, BeagleHitsAddedResponse *, BeagleClient* client);
	static void hits_subtracted_cb (BeagleQuery *, BeagleHitsSubtractedResponse *);
	static void finished_cb (BeagleQuery *, BeagleFinishedResponse *, GMainLoop *);
	static BeagleSearch *current_instance;
	static QString *get_uri_from_feed_hit (BeagleHit *);
	static QString *get_uri_from_file_hit (BeagleHit *);
	static QString *get_parent_uri_from_file_hit (BeagleHit *);
	static QString *get_source_from_file_hit (BeagleHit *);

	BeagleClient   *client;
	BeagleQuery    *query;
	GMainLoop      *main_loop;
	QTimer         *timer;

	bool initBeagle();
        void stopBeagle();
	bool query_running;
	QStringList beagle_query_list;
};

#endif
