/*
 * linux/kernel/power/swsusp.h
 *
 * Copyright (c) 2004 Herbert Xu <herbert@gondor.apana.org.au>
 *
 * This file is licensed under the GPLv2.
 */

#include <linux/delay.h>
#include <linux/kernel.h>
#include <linux/suspend.h>
#include <linux/types.h>

struct link {
	char dummy[PAGE_SIZE - sizeof(swp_entry_t)];
	swp_entry_t next;
};

union diskpage {
	union swap_header swh;
	struct link link;
	struct suspend_header sh;
};

extern dev_t swsusp_resume_device;
extern const char name_suspend[];
extern const char name_resume[];

extern suspend_pagedir_t *pagedir_save;
extern int pagedir_order;

/*
 * Debug
 */
#define	DEBUG_DEFAULT
#undef	DEBUG_PROCESS
#undef	DEBUG_SLOW
#define TEST_SWSUSP 0		/* Set to 1 to reboot instead of halt machine after suspension */

#ifdef DEBUG_DEFAULT
# define PRINTK(f, a...)	printk(f, ## a)
#else
# define PRINTK(f, a...)       	do { } while(0)
#endif

#ifdef DEBUG_SLOW
#define MDELAY(a) mdelay(a)
#else
#define MDELAY(a) do { } while(0)
#endif
