/***************************************************************************
 *   Copyright (C) 2005 by Stephen Leaf                                    *
 *   smileaf@smileaf.org                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KDMTHEME_H_
#define _KDMTHEME_H_

#include <kcmodule.h>
#include <kaboutdata.h>
#include <qmap.h>
#include <klistview.h>

class kdmtheme: public KCModule
{
	Q_OBJECT

public:
	kdmtheme( QWidget *parent=0, const char *name=0, const QStringList& = QStringList() );
	~kdmtheme();

	virtual void load();
	virtual void save();
	virtual void defaults();
	virtual int buttons();
	virtual QString quickHelp() const;
	virtual const KAboutData *aboutData()const
	{ return p_myAboutData; };
	virtual QStringList findThemeDirs(const QString &archiveName);
	virtual QStringList installThemes(QStringList &themes, const QString &archiveName);

public slots:
    void configChanged();
	void installNewTheme();
	void insertTheme(QString theme);
	void removeSelectedTheme();
	void themeSelected(QListViewItem *);
	void themeSelected();
	void updateTheme(const QString &screenshot, const QString &copyright, const QString &description);
	void toggleUseTheme(bool);

private:
	void insertItem( const QString &_theme, const QString &_activeName = QString::null );
	void removeTheme( const QString &theme );

	KDMThemeConfig *p_configWidget;
	KAboutData *p_myAboutData;
	KSimpleConfig *config;
	QListViewItem *m_defaultTheme;
	QListViewItem *m_selectedTheme;
	QMap <QString, QString>m_themeNames;
	QStringList themes;
};

#endif
