/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 Thomas Nagy                            *
 *   Thomas Nagy <tnagyemail-com@yahoo.fr>                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _DTREELISTVIEW_H
#define _DTREELISTVIEW_H

#include <qpixmap.h>
#include <qvaluelist.h>

#include <klistview.h>

#include "gui/DGuiItem.h"
#include "gui/DGuiView.h"
#include "datastruct/DItem.h"

class QDragEnterEvent;
class QMouseEvent;
class QDropEvent;
class QDragObject;
class DTreeListPopup;
class DTreeListTip;
/**
 * This class is a linear view for the mindmap
 *
 * @short Mindmap linear view
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 * @version 0.3.1
 */
class DTreeListView : public KListView, public DGuiView
{
	Q_OBJECT

	public:
		DTreeListView( QWidget* parent=0, const char* name=0 );
		~DTreeListView();

	private:
		DTreeListPopup* m_menu;
		DTreeListTip*   m_tip;

		void plug();
		void unplug();

	public slots:
		void settingsChanged();
		void updateItem(int);
		void createItem(int);
		void removeItem(int);
		void updateSelectedItem(int, DGuiView*);

		void changeSelection();

		void applyChoice(int id);
		void contentsMousePressEvent(QMouseEvent* me);

	public:
		void keyPressEvent(QKeyEvent *);

	protected slots:
		void changeRef(int, int, bool add=true);
		void applyMoved( QListViewItem *, QListViewItem * afterFirst, QListViewItem * afterNow );
};

#endif // _DTREELISTVIEW_H
