/***************************************************************************
 *   Copyright (C) 2005 Thomas Nagy                                        *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <klocale.h>
#include <klineedit.h>
#include <kurlrequester.h>

#include "DDataItem.h"
#include "urlpair_base.h"
#include "urldlg.h"

urldlg::urldlg( QWidget*parent, URLObject& object ) :
	KDialogBase(parent, 0, true, i18n("Edit Link"), Ok|Cancel),
	m_object( object )
{
	m_content = new urlpair_base(this);
	setMainWidget(m_content);

	m_content->urlrequester->setURL( m_object.m_url );
	m_content->caption->setText( m_object.m_caption );

	connect(this, SIGNAL(okClicked()), this, SLOT(slotApply()));
}

urldlg::~urldlg()
{
	delete m_content;
}

void urldlg::slotApply()
{
	m_object.m_url = m_content->urlrequester->url();
	m_object.m_caption = m_content->caption->text();
}

#include "urldlg.moc"
