/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _KDISSERTPART_H_
#define _KDISSERTPART_H_

#include <kparts/part.h>
#include <kparts/factory.h>

class QWidget;
class QPainter;
class KURL;
class KAboutData;
class KToggleAction;
class KRadioAction;
class DGuiView;
class DCanvasView;
class DTreeListView;
class TreeListViewFrame;
class DDataControl;
class DDataItem;

/**
 * This is a "Part".  It that does all the real work in a KPart
 * application.
 *
 * @short Main Part
 * @author Thomas Nagy <tnagytwofivesix@yahoo.fr>
 * @version 0.3.3
 */
class KDissertPart : public KParts::ReadWritePart
{
	Q_OBJECT
	public:
		/**
		 * Default constructor
		 */
		KDissertPart(QWidget *parentWidget, const char *widgetName,
				QObject *parent, const char *name, const QStringList & /*args*/);

		/**
		 * Destructor
		 */
		virtual ~KDissertPart();

		/**
		 * This is a virtual function inherited from KParts::ReadWritePart.  
		 * A shell will use this to inform this Part if it should act
		 * read-only
		 */
		virtual void setReadWrite(bool rw);

		bool openURL(KURL url);

		static KAboutData *createAboutData();

		inline TreeListViewFrame *treeview() { return m_treelistframe; }

		/*
		 * Tell the views that the settings have changed
		 */
		void settingsChanged();
		void savePicURL(const KURL&);

		QString m_caption;

	protected:
		/**
		 * This must be implemented by each part
		 */
		virtual bool openFile();

		/**
		 * This must be implemented by each read-write part
		 */
		virtual bool saveFile();

		/**
		 * This queries a file to save the document to
		 */
		bool saveFileAs();

		void guiActivateEvent( KParts::GUIActivateEvent* event );

	signals:
		void accessed(const KURL &);
		void stateChanged();
		void itemSelected(DDataItem*, bool);
		void itemChanged(int);

	protected slots:

		/**
		 * Reimplemented to disable and enable Save action
		 */
		virtual void setModified(bool modified);

		/**
		 * This calls the document properties dialog
		 */
		void docProperties();

		/**
		 * This is called when a mindmap item is selected (flag actions)
		 */
		void itemChanged(int, DGuiView*);

		/**
		 * Checks which color is selected and applies
		 * the color to selected objects
		 */
		void applyColors();

		/**
		 * This is called when the list of object selected on the map has
		 * changed, to update the color actions (enabled, checked, ..)
		 */
		void updateColorActionsState();

		void setUndoState(bool st);
		void setRedoState(bool st);

		void emitStatusBarMessage(const QString &);

		void setActionType(int);
	
		void importData();
		
	private slots:

		void setItemChanged(int);
		void launchURL(const QString& url, bool usekfmclient);
		void checkFlags();

	public slots:

		/// Switch to point mode, to select mindmap trees
		void setPointMode();

		/// Switch to link mode, to link mindmap items
		void setLinkMode();

		/// Switch to sort mode, to sort mindmap trees
		void setSortMode();

		/// Switch to scroll mode, to navigate in the mindmap view
		void setScrollMode();

		/// remove all mindmap items
		void clearDocument();

		void slotFileOpen();
		void slotFileSave();
		void slotFileSaveAs();
		void slotPrintMap();
		void slotRefresh();

		/*
		 * This method calls the document generators
		 */
		void generateDocument();

		/**
		 * This method bypasses the document generators
		 * This covers the 'preview document' feature
		 */
		void regenerateDocument();
		
		/*
		 * This method is used to take a snapshot of the mindmap
		 * view as a png file
		 */
		void savePic();


		void focusIn();
		void focusOut();

		void focus20();
		void focus35();
		void focus50();
		void focus75();
		void focus100();
		void focus125();
		void focus150();
		void focus200();

	private:

		/// This object holds the mindmap view
		DCanvasView* m_canvasview;
		/// This object holds the tree view
		DTreeListView* m_treelistview;
		TreeListViewFrame* m_treelistframe;
		/// This object handles the mindmap data
		DDataControl* m_data;

		/// keep the save action ready
		KAction* m_saveAction;

		void checkReExportState();
		
		void setZoom(float zoom);
		void updateColorActions();
		int m_lastid;

		KToggleAction *m_warning, *m_good, *m_idea, *m_work, *m_clarify, *m_question, *m_trash, *m_meeting, *m_trouble;
		KRadioAction *m_zoom20, *m_zoom35, *m_zoom50, *m_zoom75, *m_zoom100, *m_zoom125, *m_zoom150, *m_zoom200;
		KAction *m_undo, *m_redo;
		KRadioAction *m_default, *m_theme1, *m_theme2, *m_theme3, *m_theme4, *m_theme5, *m_theme6, *m_custom;
		KAction *m_regenerate;

		KRadioAction *m_select, *m_link, *m_sort, *m_scroll;
};

#endif // _KDISSERTPART_H_
