/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <qstring.h>
#include <qcolor.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qfont.h>

#include <kdebug.h>

#include "aux.h"
#include "DDataItem.h"

#include "DDataControl.h"
#include "DissertParser.h"

URLObject tmpobj;

DissertParser::DissertParser(DDataControl*d, int idstart, bool importing) : QXmlDefaultHandler() 
{
	m_idstart = idstart;
	m_importing = importing;
	m_id = DItem::NOITEM;
	m_inItem = false;

	m_docversion  = 0;
	m_datacontrol = d;
}

int DissertParser::realID(int val)
{
	if (val==DItem::NOITEM)
		return val;
	return m_idstart+val;
}

bool DissertParser::startDocument()
{
	return true;
}

bool DissertParser::startElement( const QString&, const QString&, const QString& qName, const QXmlAttributes& attrs)
{
	if (qName == "item")
	{
		m_inItem = true;
	}
	else if (qName == "ref")
	{
		int iddest = realID( attrs.value("dest").toInt() );
		//QString txt = attrs.value(1);
		m_datacontrol->requestRefChange( m_id, iddest, true, false);
	}
	else if (qName == "meta" && !m_importing)
	{
		m_datacontrol->m_fname = attrs.value("fname");
		m_datacontrol->m_sname = attrs.value("sname");
		m_datacontrol->m_email = attrs.value("email");
		m_datacontrol->m_company = attrs.value("company");

		m_datacontrol->m_pixSize = attrs.value("pixsize").toInt();
		m_datacontrol->m_col_background.setNamedColor( attrs.value("colbackground") );
		m_datacontrol->m_col_link.setNamedColor( attrs.value("collink") );
		m_datacontrol->m_col_ref.setNamedColor( attrs.value("colref") );

		m_datacontrol->m_canvasFont.fromString( attrs.value("canvasfont") );
		m_datacontrol->m_picturesOnCanvas = (bool) attrs.value("picturesoncanvas").toInt();

		m_datacontrol->m_generator_lasturl = attrs.value("generator_lasturl");
		m_datacontrol->m_generator_lastgen = attrs.value("generator_lastgen");
		m_datacontrol->m_generator_count = attrs.value("generator_count").toInt();
		
		m_datacontrol->m_showDirectionSize = attrs.value("showdirectionsize").toInt();
		m_datacontrol->m_linkstyle = attrs.value("linkstyle").toInt();
	}
	else if (qName == "link")
	{
		URLObject obj;
		obj.m_url = attrs.value("url");
		obj.m_caption = attrs.value("caption");

		DDataItem *item = m_datacontrol->dataItem(m_id);

		if (obj.m_url.length() || obj.m_caption.length())
			item->m_urllist.append( obj );
	}

	m_str = QString::null;
	return true;
}

bool DissertParser::endElement( const QString&, const QString&, const QString& qName )
{
	if (qName == "id")
	{
		m_id = realID( m_str.toInt() );
		m_datacontrol->createItemWithId( m_id );
	}
	else if (qName == "version" && !m_importing)
	{
		m_docversion = m_str.toInt();
	}
	else if (m_datacontrol->isRegistered(m_id))
	{
		DDataItem *item = m_datacontrol->dataItem(m_id);

		if (qName == "xpos")
		{
			item->setXY( m_str.toDouble(), item->y());
		}
		else if (qName == "ypos")
		{
			item->setXY( item->x(), m_str.toDouble());
		}
		else if (qName == "parent")
		{
			item->setParent( realID( m_str.toInt() ) );
		}
		else if (qName == "child")
		{
			item->addChild( realID(m_str.toInt()) );
		}
		else if (qName == "defaultfont")
		{
			item->m_defaultFont.fromString(m_str);
		}
		else if (qName == "colorscheme")
		{
			int val = m_str.toInt();
			if (m_docversion < 6)
			{
				switch (val)
				{
					case 4:
						val = 6;
						break;
					case 5:
						val = 4;
						break;
					case 6:
						val = 7;
						break;
					case 7:
						val = 5;
						break;
					default:
						break;
				}
			}
			item->m_colorscheme = val;
		}
		else if (qName == "fillcolor")
		{
			item->m_fillcolor.setNamedColor(m_str);
		}
		else if (qName == "outlinecolor")
		{
			item->m_outlinecolor.setNamedColor(m_str);
		}
		else if (qName == "textcolor")
		{
			item->m_textcolor.setNamedColor(m_str);
		}
		else if (qName == "abstract" || qName == "text")
		{
			// provided for old files, automatic conversion to richtext
			if (! m_str.startsWith("<html>"))
			{
				item->m_text.append("<html>");
				item->m_text.append( DDataItem::protectXML( m_str ) );
				item->m_text.append("</html>");
			}
			else
			{
				item->m_text = m_str;
			}

			// old files did not have a summary
			if (item->m_summary == NULL)
				item->m_summary = item->m_text.left(50);
		}
		else if (qName == "summary" || qName == "title")
		{
			item->m_summary = m_str;
		}
		else if (qName == "comment" )
		{
			item->m_comment = m_str;
		}
		else if (qName == "url")
		{
			if (m_docversion < 1)
				item->m_picurl = m_str;
			else
				tmpobj.m_url = m_str;

		}
		else if (qName == "picurl")
		{
			item->m_picurl = m_str;
		}
		else if (qName == "piccaption" || qName == "legend" )
		{
			item->m_piccaption = m_str;
		}
		else if (qName == "urlcaption" )
		{
			tmpobj.m_caption = m_str;
			if (tmpobj.m_url.length() || tmpobj.m_caption.length())
				item->m_urllist.append( tmpobj );
		}
		else if (qName == "flag" )
		{
			item->m_flags.append( m_str.toInt() );
		}

		// going to next item
		else if (qName == "item")
		{
			m_inItem = false;
			m_id = DItem::NOITEM;
		}
	}

	return true;
}

bool DissertParser::characters( const QString& s)
{
	m_str = s;
	return true;
}
