/***************************************************************************
 *   Copyright (C) 2005 Thomas Nagy                                        *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <qdir.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qmap.h>
#include <qpixmap.h>
#include <qtextcodec.h>
#include <qregexp.h>

#include <kurl.h>
#include <klocale.h>
#include <kdebug.h>
#include <ktempdir.h>
#include <kgenericfactory.h>

#include "settings.h"
#include "aux.h"
#include "DItem.h"
#include "DDataControl.h"
#include "DDataItem.h"
#include "KDissertPart.h"

#include "kdissapplet.h"

K_EXPORT_COMPONENT_FACTORY(libkdissapplet, kdissappletFactory)
	QObject *kdissappletFactory::createObject(QObject *part, const char *, const char *, const QStringList &) { return new kdissapplet(part); }

kdissapplet::kdissapplet() : DGenerator()
{
}

kdissapplet::kdissapplet(QObject* obj) : DGenerator(obj)
{
}

kdissapplet::~kdissapplet() {}

const QString kdissapplet::identifikation()
{
	return "kdissapplet";
}

const QString kdissapplet::fullName()
{
	return i18n("Java Applet");
}

const QString kdissapplet::group()
{
	return i18n("HTML");
}

const QString kdissapplet::description()
{
	return i18n("This template generates a Java applet that can be added to a website. It can be viewed using a Java-enabled web browser (konqueror, firefox for example)");
}

const QString kdissapplet::quickstart()
{
	return i18n("You will need a Java development kit properlty installed (javac, jar) for building the applet. Go into the directory created and view the applet with \"make view\".");
}

bool kdissapplet::writeMaindoc(DDataItem *root, const QString & path)
{
	QString picpath = path + "/pics/map.png";

	m_data->setItemSelected(DItem::NOITEM, NULL);
	
	KDissertPart *part = (KDissertPart*) (parent());
	part->savePicURL( KURL(picpath) );

	QFile textfile(path+"/README");
        if (!textfile.open(IO_WriteOnly | IO_Append) )
        {
                kdDebug()<<"could not open html file for append :-/"<<endl;
                return false;
        }

        QTextStream u(&textfile);
        if (Settings::templatesUTF8())
        {
                u.setEncoding(QTextStream::UnicodeUTF8);
        }
	u<<i18n("This is kadapplet v0.1")<<"\n";
	u<<i18n("It requires a working java installation (javac, jar, appletviewer) for running")<<"\n";
	u<<"\n";
	u<<i18n("To launch the applet, use the following command:")<<"\n";
	u<<"cd "<<path<<" && make view\n\n";
	u<<i18n("To build the applet, use the following command:")<<"\n";
	u<<"cd "<<path<<" && make\n";
	textfile.close();
	
	notifyDocGenerated( path+"/README" );

	return true;
}

#include "kdissapplet.moc"
