/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <kurl.h>
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include "KDissert.h"

static const char description[] =
I18N_NOOP("A tool for document creation using mindmap trees");

static const char version[] = "0.9.0";

static KCmdLineOptions options[] =
{
	{ "+[URL]", I18N_NOOP( "Document to open." ), 0 },
	KCmdLineLastOption
};

int main(int argc, char **argv)
{
	KAboutData about("kdissert", I18N_NOOP("kdissert"), version, description,
			KAboutData::License_GPL, "(C) 2003, 2004, 2005 Thomas Nagy", 0, "http://www.kde-apps.org/content/show.php?content=12725", "tnagyemail-mail@yahoo.fr");
	about.addAuthor( "Thomas Nagy", 0, "tnagy2^8@yahoo.fr" );

	// warning, utf-8 char
	about.addCredit( "André Somers", "patches, ideas" );
	about.addCredit( "Julien Antille", "build system improvements - bksys" );

	KCmdLineArgs::init(argc, argv, &about);
	KCmdLineArgs::addCmdLineOptions(options);

	KApplication app;

	// See if we are starting with session management
	// TODO
	//if (app.isRestored())
	//{
	//RESTORE(kdissert);
	//} else
	{
		// no session.. just start up normally
		KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		KDissert *widget = new KDissert(KMdi::IDEAlMode);

		if (args->count() != 0)
		{
			for (int i=0; i < args->count(); i++)
			{
				//kdissert *widget = new kdissert;
				widget->openURL( args->url( i ) );
			}
		}
		else
		{
			widget->slotFileNew();
		}

		widget->show();
		args->clear();
	}

	return app.exec();
}
