/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <qstring.h>
#include <qcolor.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qfont.h>

#include <kdebug.h>

#include "aux.h"
#include "settings.h"
#include "DDataItem.h"

#include "DDataControl.h"
#include "FFParser.h"

FFParser::FFParser(DDataControl*d) : QXmlDefaultHandler() 
{
	m_id = DItem::NOITEM;
	m_inItem = false;

	m_docversion = 0;
	m_datacontrol=d;

	m_lastid = 0;
}

bool FFParser::startDocument()
{
	return true;
}

bool FFParser::startElement( const QString&, const QString&, const QString& qName, const QXmlAttributes& atts)
{
	if (qName == "node")
	{
		m_lastid++;
		int parent = DItem::NOITEM;
		if (! m_ancestors.isEmpty())
		{
			parent = m_ancestors.pop();
			m_ancestors.push(parent);
		}

		m_datacontrol->createItemWithId( m_lastid );
		m_ancestors.push( m_lastid );
		m_id = m_lastid;

		DDataItem *item = m_datacontrol->dataItem(m_id);
		item->m_x = 2000;
		item->m_y = 2000;

		for (int i=0; i<atts.count(); i++)
		{
			QString name  = atts.qName(i);
			QString value = atts.value(i);

			if (name == "TEXT")
			{
				if (value.length() < 50)
				{
					item->m_summary = value;
				}
				else
				{
					item->m_summary = value.left(40);
					item->m_text = value;
				}
			}
			else if (name == "COLOR")
			{
				item->m_colorscheme = Settings::EnumColorMode::custom_;;
				item->m_fillcolor = QColor(value);
			}
			else if (name == "LINK")
			{
				URLObject obj;
				obj.m_url = value;
				item->m_urllist.append( obj );
			}
		}

		m_inItem = true;
	}
	m_str = QString::null;
	return true;
}

bool FFParser::endElement( const QString&, const QString&, const QString& qName )
{
	if (qName == "map")
	{
		// this is the end of the mindmap
		if (m_ancestors.isEmpty())
			return true;
		else
			return false;
	}
	if (qName == "node")
	{
		if (m_ancestors.isEmpty()) //  is impossible
			kdWarning()<<"BUG in FFParser::endElement"<<qName<<endl;

		// remove the current item	
		int id = m_ancestors.pop();

		// if the item has a parent, let him know
		if (!m_ancestors.isEmpty())
		{
			int parentid = m_ancestors.pop();
			m_datacontrol->dataItem(id)->setParent(parentid);
			m_datacontrol->dataItem(parentid)->addChild(id);
			m_ancestors.push(parentid);
			m_id = parentid;
		}
		else
		{
			m_id = DItem::NOITEM;
			m_inItem = false;
		}
	}
	else if ( m_datacontrol->isRegistered(m_id) )
	{	
		//DDataItem *item = m_datacontrol->dataItem(m_id);
		//kdWarning()<<"this was read : "<<qName<<endl;
		if (qName == "edge")
		{
			// ignore
		}
	}
	else
	{
		kdWarning()<<"BUG : item was not created : "<<qName<<" "<<m_str<<endl;
		return false;
	}

	return true;
}

bool FFParser::characters( const QString& s)
{
	m_str = s;
	return true;
}
