
/**
 *
 *  This file is part of the kdewebdev package
 *  Copyright (c) 2002 Keith Isdale <keith@kdewebdev.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#include <QLineEdit>

#include "ui_xsldbgtemplates.h" 
#include "xsldbgdebugger.h" 
#include "xsldbgtemplatesimpl.h" 
 
XsldbgTemplatesImpl::XsldbgTemplatesImpl(XsldbgDebugger *debugger, 
	QWidget *parent /*=0*/) 
		:  QWidget(parent)
{	 
	setupUi(this);
	this->debugger = debugger; 
	 
	connect(debugger, SIGNAL(templateItem(QString /* name*/, QString /*mode*/, QString /* fileName */, int /* lineNumber */)), 
		this, SLOT(slotProcTemplateItem(QString /* name*/,  QString /*mode*/, QString /* fileName */, int /* lineNumber */))); 
	connect( templatesView,  SIGNAL(itemSelectionChanged()), 
						this, SLOT(itemSelectionChanged())); 
	connect(&resizeTimer, SIGNAL(timeout()), this, SLOT(resizeContents()));
	resizeContents();
						 
	show(); 
} 
 
XsldbgTemplatesImpl::~XsldbgTemplatesImpl(){ 
    debugger = 0L; 
} 
 
 
void XsldbgTemplatesImpl::slotProcTemplateItem(QString  name, QString mode, QString  fileName , int  lineNumber ) 
{ 
	static int insertPosition = 0; 
	if (name.isNull()){ 
	     templatesView->clearContents(); 
	    insertPosition=0;
	}else{ 
	  resizeTimer.stop();
	  if (insertPosition >= templatesView->rowCount())
	  templatesView->insertRow(insertPosition);
	  QTableWidgetItem *cellItem;
	  for (int column=NameColumn; column<=LineNumberColumn; column++){
	    cellItem = templatesView->item(insertPosition, column); 
	    if (!cellItem)
		templatesView->setItem(insertPosition, column, new QTableWidgetItem);
	    cellItem = templatesView->item(insertPosition, column); 
	    if (cellItem){
	       switch(column){
	       case NameColumn:
		    cellItem->setText(name);
	       break;
               case ModeColumn:
		    cellItem->setText(mode);
	       break;
               case FileNameColumn:
		    cellItem->setText(fileName);
	       break;
               case LineNumberColumn:
		    if (lineNumber != -1)
			cellItem->setText(QString::number(lineNumber));
		    else
			cellItem->setText("");
	       break;
	       }
	    }
	 }
	resizeTimer.start();
	insertPosition++;
     }
} 
 
 
void XsldbgTemplatesImpl::itemSelectionChanged() 
{ 
	QList<QTableWidgetItem *> items = templatesView->selectedItems();
	if (!items.isEmpty()){
	    QString fileName;
	    int lineNumber = 0;
	    bool ok=false;
	    QTableWidgetItem *cellItem;
	    for (int i = 0; i < items.size(); ++i) {
		cellItem = items[i];	
		switch(cellItem->column()){
		    case FileNameColumn:
			fileName = cellItem->text();
		    break;
		    case LineNumberColumn:
                           lineNumber = cellItem->text().toInt(&ok);
			   if (!ok)
				lineNumber = 0;
		    break;
		}
	    }
	    if (!fileName.isEmpty())
		debugger->gotoLine(fileName, lineNumber);			 
	} 
} 
 
void XsldbgTemplatesImpl::resizeContents()
{
   templatesView->resizeColumnsToContents();
    
}
void XsldbgTemplatesImpl::refresh() 
{ 
	debugger->fakeInput("templates", true) ; 
} 
 
 

#include "xsldbgtemplatesimpl.moc"
