/* -*- C++ -*-

   This file implements the KVaio module for KMilo.

   $ Author: Mirko Boehm $
   $ Copyright: (C) 1996-2003, Mirko Boehm $
   $ Contact: mirko@kde.org
         http://www.kde.org
         http://www.hackerbuero.org $
   $ License: LGPL with the following explicit clarification:
         This code may be linked against any version of the Qt toolkit
         from Troll Tech, Norway. $

   $Id: kmilo_kvaio.cpp,v 1.5.2.1 2004/03/27 17:49:46 waba Exp $

   * Portions of this code are
   * (C) 2001-2002 Stelian Pop <stelian@popies.net> and
   * (C) 2001-2002 Alcove <www.alcove.com>.
   * Thanks to Stelian for the implementation of the sonypi driver.
*/

#include <kgenericfactory.h>

#include "kmilo_kvaio.h"
#include "kvaio.h"

namespace KMilo {

KMiloKVaio::KMiloKVaio(QObject *parent, const char *name,
		       const QStringList& args)
    : Monitor(parent, name, args),
      m_kvaio(0)
{
}


KMiloKVaio::~KMiloKVaio() {
}


bool KMiloKVaio::init()
{
    m_kvaio = new KVaio(this);

    return m_kvaio->driver()!=0;
}


Monitor::DisplayType KMiloKVaio::poll() {
Monitor::DisplayType rc = (Monitor::DisplayType)None;
return rc;
}


int KMiloKVaio::progress() const {
	return 10;
}

}

void KMiloKVaio::reconfigure(KConfig* k)
{
    m_kvaio->loadConfiguration(k);
}

K_EXPORT_COMPONENT_FACTORY(kmilo_kvaio, KGenericFactory<KMiloKVaio>("kmilo_kvaio"))

