// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */



#ifndef __KDETVOSS_PLUGIN_H
#define __KDETVOSS_PLUGIN_H

#include <kdetvmixerplugin.h>
#include <qstringlist.h>
#include <qmap.h>

class QComboBox;

/**
 * OSS Mixer Plugin
 *
 * @version $Id: kdetv_oss.h 439804 2005-07-28 23:45:59Z mueller $
 */
class KdetvOSS : public KdetvMixerPlugin
{
    Q_OBJECT

public:
    KdetvOSS(Kdetv *ktv, QObject *parent, const char* name);
    virtual ~KdetvOSS();

    virtual int probeDevices();
    virtual int setMixer(const QString& mixer);

    virtual int setVolume(int left, int right);
    virtual int volumeLeft();
    virtual int volumeRight();

    virtual int setMuted(bool mute);
    virtual bool muted();

    int volume();
    
public slots:
    virtual QWidget *configWidget(QWidget*, const char *);
    virtual void saveConfig();

private slots:
    void deviceChanged(const QString& dev);

private:
    int _fd;
    int _devnum;
    int _mask;
    int _left;
    int _right;
    bool _muted;
    
    QString _dev;    
    struct { int left, right; }  preMuteLevels;    
    QStringList _devlist;
    QMap<QString,QStringList> _mixerMap;
    QComboBox *_cfg_devs, *_cfg_mixers;
};

#endif

