// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef CHANNELIOXML_H
#define CHANNELIOXML_H

#include <qdom.h>
#include "channel.h"

#include "kdetvchannelplugin.h"

/**
 * Implements the XML channel format.
 *
 * @author Richard Moore, rich@kde.org
 */
class ChannelIOFormatXML : public KdetvChannelPlugin
{
public:
    ChannelIOFormatXML(Kdetv *ktv, QObject *parent, const char* name);
    virtual ~ChannelIOFormatXML() {}

    virtual bool load( ChannelStore *store, ChannelFileMetaInfo *info,
                       QIODevice *file, const QString& fmt );
    virtual bool save( ChannelStore *store, ChannelFileMetaInfo *info,
                       QIODevice *file, const QString& fmt );

    QDomDocument document() const { return doc; }

    bool readDocument( ChannelStore *store, ChannelFileMetaInfo *info );
    void writeDocument( ChannelStore *store, ChannelFileMetaInfo *info );

protected:
    // Read helpers
    Channel *readChannelFormat2( const QDomElement &elem );
    Channel *readChannelFormat3( const QDomElement &elem );
    Channel *readChannelFormat4( const QDomElement &elem );
    void readChannelPropertiesList(const QDomElement &elem, Channel& ch);
    void readChannelPropertiesListOld(const QDomElement &elem, Channel& ch);
    void readPicturePropertiesList(const QDomElement &elem, Channel& ch);
    void readControlLists(const QDomElement &elem, Channel& ch);
    QString readText( const QDomElement &elem, const QString &tag );
    int readTextInt( const QDomElement &elem, const QString &tag );
    Q_ULLONG readTextULongLong( const QDomElement &elem, const QString &tag );
    bool readTextBool( const QDomElement &elem, const QString &tag );
    void readVariant(const QDomElement &elem, QString& name, QVariant& value);
    QVariant readVariantOld(const QDomElement &elem);
    bool readAttrBool(const QDomElement &elem, const QString &name);
    QString readAttrText(const QDomElement &elem, const QString &name, const QString& defaultText);
    int readAttrInt(const QDomElement &elem, const QString &name);
    void getMetaInfo(const QDomElement &e, ChannelFileMetaInfo *info);

    // Write helpers
    QDomElement writeChannel( QDomElement &parent, const Channel& ch );
    QDomElement writeText( QDomElement &parent, const QString &tag, const QString &text );
    QDomElement writeTextInt( QDomElement &parent, const QString &tag, int text );
    QDomElement writeTextULongLong( QDomElement &parent, const QString &tag, Q_ULLONG text );
    QDomElement writeTextBool( QDomElement &parent, const QString &tag, bool val );
    QDomElement writeElement( QDomNode &parent, const QString &tag );
    void writeVariant(QDomElement &parent, const QString& name, const QVariant& value);
    void writeAttrBool(QDomElement &parent, const QString &name, const bool val);
    void writeAttrText(QDomElement &parent, const QString &name, const QString& text);
    void setMetaInfo(QDomElement &e, ChannelFileMetaInfo *info);
    void writePropertyList(QDomElement &parent, const Channel::PropertyList list);

private:
    QDomDocument doc;
    ChannelStore *store;
};

#endif // CHANNELIOXML_H

