// -*- c++ -*-
/***************************************************************************
                           kdetvimagefiltercontext.h
                           -------------------------
    begin                : Mon Jun 14 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef KDETVIMAGEFILTERCONTEXT_H
#define KDETVIMAGEFILTERCONTEXT_H

class KdetvSharedImage;
class KdetvImagePool;

/*
 * Assumptions: 
 *   Filters only get contexts where all images are valid
 *   No mixed image sizes or formats
 *   out picture is a progressive image
 *   Image history contains fields, images[0] is the most recent field
 *   Image history must not be modified!
 */

class KdetvImageFilterContext
{
 public:
    KdetvImageFilterContext();
    virtual ~KdetvImageFilterContext();

    // Image to be displayed
    KdetvSharedImage*     out;

    // Part of the output image to be displayed (if supported by output device) -> Overscan
    unsigned int          out_x, out_y, out_width, out_height;

    // Field history
    KdetvSharedImage**    images;
    unsigned int          imageCount;

    // Where to get new images from
    KdetvImagePool*       imagesWithBuffer;
    KdetvImagePool*       imagesWithoutBuffer;
};

#endif
