// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 Richard Moore, rich@kde.org
 *
 *   This program is free software; you can redistribute it and/or modify 
 *   it under the terms of the GNU General Public License as published by 
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#ifndef SIDEBAR_H
#define SIDEBAR_H

#include <qwidget.h>

class KHTMLPart;
class KHTMLView;

class ChannelEditor;
class KdetvWidget;
class ConfigData;
class QHideEvent;

/**
 * Displays a widget as sidebar, showing the widget caption as the
 * title of the bar.
 *
 * @author Richard Moore, rich@kde.org
*/
class Sidebar : public QWidget
{
    Q_OBJECT

public:
    Sidebar( KdetvWidget* scrn, QWidget *parent, const char *name=0 );
    virtual ~Sidebar();

    void createViews();

    ChannelEditor *channels() const { return chans; }
    //    KHTMLView *listings() const { return lists; }
    //    KHTMLPart *listingsPart() const { return listPart; }

signals:
    void visibilityChanged( bool );

public slots:
    void viewChanged( QWidget *view );
    //    void useListingsURL( bool );
    //    void listingsURLChanged( QString *url );
    void toggleView( bool );

protected:
    ChannelEditor *createChannels();
    //    QWidget *createListings();

private:
    virtual void hideEvent(QHideEvent*);
    virtual void showEvent(QShowEvent*);
    
    KdetvWidget *screen;

    ChannelEditor *chans;
    KHTMLPart *listPart;
    KHTMLView *lists;

    ConfigData *cfg;
};

#endif // SIDEBAR_H
