/***************************************************************************
 *   Copyright (C) 2005-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#ifndef _KDESVNPART_H_
#define _KDESVNPART_H_

#include "kdesvn-config.h"

#include <kparts/part.h>
#include <kparts/genericfactory.h>
#include <kparts/factory.h>
#include <kparts/statusbarextension.h>
#include <kparts/browserextension.h>

#include <KComponentData>

class kdesvnView;
class QPainter;
class KUrl;
class KdesvnBrowserExtension;
class KAboutApplicationDialog;

/**
 * This is a "Part".  It that does all the real work in a KPart
 * application.
 *
 * @short Main Part
 * @author Rajko Albrecht <rajko.albrecht@tecways.com>
 * @version 0.1
 */
class KDESVN_EXPORT kdesvnpart : public KParts::ReadOnlyPart
{
    Q_OBJECT
public:
    /**
     * Default constructor
     */
    kdesvnpart(QWidget *parentWidget,
                    QObject *parent, const QVariantList& args = QVariantList());

    kdesvnpart(QWidget *parentWidget,
               QObject *parent, bool ownapp, const QVariantList& args = QVariantList());

    /**
     * Destructor
     */
    virtual ~kdesvnpart();
    virtual bool closeUrl();
    static KAboutData* createAboutData();

signals:
    void refreshTree();
    void settingsChanged();

public slots:
    virtual void slotDispPopup(const QString&,QWidget**target);
    virtual void slotFileProperties();
    virtual bool openUrl(const KUrl&);
    virtual void slotSshAdd();

protected:
    /**
     * This must be implemented by each part
     */
    virtual bool openFile();
    virtual void setupActions();
    KAboutApplicationDialog* m_aboutDlg;

    void init(QWidget *parentWidget, bool full);

protected slots:
    virtual void slotLogFollowNodes(bool);
    virtual void slotDisplayIgnored(bool);
    virtual void slotDisplayUnkown(bool);
    virtual void slotUrlChanged(const QString&);
#if KDE_VERSION_MAJOR<4
    void reportBug();
#endif
    void showAboutApplication();
    void appHelpActivated();
    virtual void slotShowSettings();

private:
    kdesvnView *m_view;
    KdesvnBrowserExtension*m_browserExt;

protected slots:
    void slotSettingsChanged(const QString&);

protected slots:
    virtual void slotHideUnchanged(bool);
    virtual void slotEnableNetwork(bool);
};

class commandline_part;
class KCmdLineArgs;

class KPARTS_EXPORT KdesvnBrowserExtension : public KParts::BrowserExtension
{
    Q_OBJECT
public:
    KdesvnBrowserExtension(kdesvnpart*);
    virtual ~KdesvnBrowserExtension();

public slots:
    void properties();
};

#endif // _KDESVNPART_H_
