/*
    Copyright (c) 2010 Klarälvdalens Datakonsult AB,
                       a KDAB Group company <info@kdab.com>
    Author: Kevin Ottens <kevin@kdab.com>

    This library is free software; you can redistribute it and/or modify it
    under the terms of the GNU Library General Public License as published by
    the Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This library is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
    License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to the
    Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
    02110-1301, USA.
*/

#ifndef RETRIEVECOLLECTIONMETADATATASK_H
#define RETRIEVECOLLECTIONMETADATATASK_H

#include "resourcetask.h"

class RetrieveCollectionMetadataTask : public ResourceTask
{
    Q_OBJECT

public:
    explicit RetrieveCollectionMetadataTask(const ResourceStateInterface::Ptr &resource, QObject *parent = Q_NULLPTR);
    virtual ~RetrieveCollectionMetadataTask();

private Q_SLOTS:
    void onGetMetaDataDone(KJob *job);
    void onGetAclDone(KJob *job);
    void onRightsReceived(KJob *job);
    void onQuotasReceived(KJob *job);

protected:
    void doStart(KIMAP::Session *session) Q_DECL_OVERRIDE;

private:
    void endTaskIfNeeded();

    int m_pendingMetaDataJobs;

    Akonadi::Collection m_collection;
    KIMAP::Session *m_session;
};

#endif
