/*
 * settingsdialog.cpp
 *
 * Copyright (c) 2007 Frerich Raabe <raabe@kde.org>
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 */
#include "settingsdialog.h"
#include "settings.h"
#include "ui_visualsettings.h"
#include "feedsettingswidget.h"

SettingsDialog::SettingsDialog( QWidget *parent )
    : KConfigDialog( parent, "settings", Settings::self() )
{
    setFaceType( KPageDialog::Tabbed );

    QWidget *page = new QWidget( 0 );
    {
        Ui::VisualSettings ui;
        ui.setupUi( page );
    }
    addPage( page, i18n( "Appearance" ) );

    m_feedSettingsWidget = new FeedSettingsWidget( 0 );
    addPage( m_feedSettingsWidget, i18n( "Feed Access" ) );
}

QStringList SettingsDialog::feedUrls() const
{
    return m_feedSettingsWidget->feedUrls();
}

#include "settingsdialog.moc"

