/***************************************************************************
* $Id: DropSite.java,v 1.2 2003/12/21 05:47:44 rdale Exp $
**
* Drop site example implementation
**
* Created : 979899
**
* Copyright (C) 1997 by Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/
import org.kde.qt.*;
import java.util.*;


class DropSite extends QLabel
{
	SecretSource s;

void setSecretSource(SecretSource source)
{
	s = source;
}

DropSite( QWidget  parent )
{
	this(parent, null);
}

DropSite( QWidget  parent, String  name )
{
    super( parent, name );
    setAcceptDrops(true);
}


{
    // nothing necessary
}


protected void dragMoveEvent( QDragMoveEvent  e )
{
    // Check if you want the drag at e.pos()...
    // Give the user some feedback...
}


protected void dragEnterEvent( QDragEnterEvent e )
{
    // Check if you want the drag...
    if ( SecretDrag.canDecode( e )
      || QTextDrag.canDecode( e )
      || QImageDrag.canDecode( e )
      || QUriDrag.canDecode( e ) ) {
	e.accept();
	}

    // Give the user some feedback...
    String t = "";
    for( int i=0; e.format( i ) != null; i++ ) {
		t += "\n";
	    t += e.format( i );
    }
    emit("message", t );
    setBackgroundColor(white());
}

protected void dragLeaveEvent( QDragLeaveEvent e  )
{
    // Give the user some feedback...
    emit("message", "");
    setBackgroundColor(lightGray());
}


protected void dropEvent( QDropEvent  e )
{
    setBackgroundColor(lightGray());

    // Try to decode to the data you understand...

    StringBuffer str = new StringBuffer("");
	if ( QTextDrag.decode( e, str ) ) {
	setText( str.toString() );
	setMinimumSize( minimumSize().expandedTo( sizeHint() ) );
	return;
    }

    QPixmap pm = new QPixmap();
    if ( QImageDrag.decode( e, pm ) ) {
	setPixmap( pm );
	setMinimumSize( minimumSize().expandedTo( sizeHint() ) );
	return;
    }

	ArrayList strings = new ArrayList();
    if ( QUriDrag.decode( e, strings ) ) {
	String m = "Full URLs:\n";
	Iterator it = strings.iterator();
	while (it.hasNext())
		m += "   " + (String) it.next() + "\n";
	ArrayList files = new ArrayList();
	if ( QUriDrag.decodeLocalFiles( e, files ) ) {
	    m = m + "Files:\n";
		Iterator i = strings.iterator();
		while (i.hasNext())
		m = m + "   " + (String) i.next() + "\n";
	}
	setText( m );
	setMinimumSize( minimumSize().expandedTo( sizeHint() ) );
	return;
    }

    if ( SecretDrag.decode( e, str ) ) {
	setText( str.toString() );
	setMinimumSize( minimumSize().expandedTo( sizeHint() ) );
	return;
    }
}

protected void mousePressEvent( QMouseEvent  e )
{
    QDragObject drobj;
    if ( pixmap() != null ) {
	drobj = new QImageDrag( pixmap().convertToImage(), this );
	QPixmap pm = new QPixmap();
	pm.convertFromImage(pixmap().convertToImage().smoothScale(
	    pixmap().width()/3,pixmap().height()/3));
	drobj.setPixmap(pm,new QPoint(-5,-7));
	// Try it.
//	new DragMoviePlayer(drobj);
    } else {
	drobj = new QTextDrag( text(), this );
    }
    drobj.dragCopy();
}

class DragMoviePlayer extends QObject {
    QDragObject dobj;
    QMovie movie;

DragMoviePlayer( QDragObject p )
{
//    QObject(p),
    dobj = p;
    movie = new QMovie("trolltech.gif" );
    movie.connectUpdate(this,SLOT("updatePixmap(QRect)"));
}

void updatePixmap( QRect rect )
{
    dobj.setPixmap(movie.framePixmap());
}


}

void backgroundColorChange( QColor color )
{
    // Reduce flicker by using repaint() rather than update()
    repaint();
}

}
