#!/usr/bin/env python

"""**************************************************************************
** $Id: fontdisplayer.py,v 1.2 2005/01/30 20:49:33 sedwards Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
***************************************************************************"""

import sys
from qt import *

class FontRowTable( QFrame ):
    def __init__( self, parent=None, name=None ):
        QFrame.__init__( self, parent, name )

        self.setBackgroundMode(self.PaletteBase)
        self.setFrameStyle(self.Panel|self.Sunken)
        self.setMargin(8)
        self.setRow(0)
        self.row = 0
        self.tablefont = QFont( QApplication.font() )

    def sizeHint( self ) :
        width  = 16*self.cellSize().width()+QSize(2,2).width()*(self.margin()+self.frameWidth())
        height = 16*self.cellSize().height()+QSize(2,2).height()*(self.margin()+self.frameWidth())
        return QSize(width,height)
        
    def cellSize( self ) :
        fm = self.fontMetrics()
        return QSize( fm.maxWidth(), fm.lineSpacing() + 1 )
    
    def paintEvent( self, e ):
        QFrame.paintEvent(self, e)
        p = QPainter(self)
        p.setClipRegion(e.region())
        r = QRect(e.rect())
        fm = self.fontMetrics()
        ml = self.frameWidth() + self.margin() + 1 + max(0,-fm.minLeftBearing())
        mt = self.frameWidth() + self.margin()
        cell = QSize((self.width()-15-ml)/16,(self.height()-15-mt)/16)

        if not cell.width() or not cell.height() :
            return

        mini = r.left() / cell.width()
        maxi = (r.right()+cell.width()-1) / cell.width()
        minj = r.top() / cell.height()
        maxj = (r.bottom()+cell.height()-1) / cell.height()

        h = fm.height()

        body      = QColor(255,255,192);
        negative  = QColor(255,192,192);
        positive  = QColor(192,192,255);
        rnegative = QColor(255,128,128);
        rpositive = QColor(128,128,255);

        for j in range(minj, maxj+1, 1) :
            for i in range(mini, maxi+1, 1) :
                if i < 16 and j < 16 :
                    x = i*cell.width()
                    y = j*cell.height()

                    ch = QChar(j*16+i) #,self.row) # just accept one argument!!!

                    if fm.inFont(ch) :
                        w = fm.width(ch)
                        l = fm.leftBearing(ch)
                        r = fm.rightBearing(ch)

                        x += ml
                        y += mt+h

                        p.fillRect(x,y,w,-h,QBrush(body))
                        
                        if w :
                            if l :
                                if l < 0: sign = negative
                                else: sign = positive
                                if l > 0: lsign = 0
                                else: lsign = 1
                                p.fillRect(x+lsign, y-h/2, abs(l),-h/2, QBrush(sign))
                            if r :
                                if r < 0: sign = rnegative
                                else: sign = rpositive
                                if r > 0: rsign = r
                                else: rsign = 0
                                p.fillRect(x+w-rsign,y+2, abs(r),-h/2, QBrush(sign))
                        s = QString( ch )
                        p.setPen(QPen(Qt.black))
                        p.drawText(x,y,s)
    
    def setRow( self, r ) :
        self.row = r

        fm = self.fontMetrics()
        str = " minLB=%d minRB=%d maxW=%d" % (fm.minLeftBearing(), fm.minRightBearing(), fm.maxWidth())
        self.emit( PYSIGNAL("fontInformation"), ( QString(str), ) )
        self.update()
        
    def chooseFont( self ) :
        ok = 0
        oldfont = QFont( self.tablefont )
        self.tablefont, ok = QFontDialog.getFont(oldfont, self)
        if ok:
            self.setFont(self.tablefont)
        else:
            self.tablefont = oldfont

class FontDisplayer( QMainWindow ) :
    def __init__( self, parent=None, name=None ):
        QMainWindow.__init__( self, parent, name )
        table = FontRowTable(self)
        controls = QToolBar(self)
        
        QLabel(self.tr("Row:"), controls)
        self.row = QSpinBox(0,255,1,controls)
        controls.addSeparator()
        fontbutton = QPushButton(self.tr("Font..."), controls)
        status = QStatusBar(self) 
        
        self.connect( self.row, SIGNAL("valueChanged(int)"), table.setRow )
        self.connect( fontbutton, SIGNAL("clicked()"), table.chooseFont )
        self.connect( table, PYSIGNAL("fontInformation"),
                      status, SLOT("message(const QString&)") )
        table.setRow(0)
        self.setCentralWidget(table)

def main( args ):
    # Use an interesting font
    QApplication.setFont(QFont("unifont",16))
    app = QApplication(sys.argv)
    
    m = FontDisplayer()
    sh = QSize( m.centralWidget().sizeHint() )
    m.resize(sh.width(), sh.height() + 3 * m.statusBar().height())
    app.setMainWidget(m);
    m.setCaption("Qt Example - QFD");
    m.show()
    
    app.exec_loop()
    
if __name__=="__main__":
    main(sys.argv)
