namespace Binge.Bits
{
	using System;
	using System.Collections;
	using System.IO;
	using System.Text;
	using System.Xml;
	using Binge;

	public enum QtMethodTypes
	{
		Default,
		Signal,
		Slot
	}

	public class Method: MethodBase
	{
		public bool IsVirtual, IsOverride, IsNew, IsExtern, IsAbstract;
		public QtMethodTypes QtMethodType;

		public Method (): this (true) {}

		public Method (bool init): base (init)
		{
			if (! init) return;

			IsVirtual = IsOverride = IsNew = IsExtern = IsAbstract = false;
			QtMethodType = QtMethodTypes.Default;
		}

		public override string ToString ()
		{
			return "Method";
		}
	}
}
