/***************************************************************************
                            KRootPixmap.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KROOTPIXMAP_H
#define KROOTPIXMAP_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 Creates pseudo-transparent widgets.

 A pseudo-transparent widget is a widget with its background pixmap set to
 that part of the desktop background that it is currently obscuring. This
 gives a transparency effect.

 To create a transparent widget, construct a KRootPixmap and pass it a
 pointer to your widget. That's it! Moving, resizing and background changes
 are handled automatically.

 Instead of using the default behaviour, you can ask KRootPixmap
 to emit a @ref backgroundUpdated(const QPixmap &) signal whenever
 the background needs updating by using @ref setCustomPainting(bool).
 Alternatively by reimplementing @ref updateBackground(KSharedPixmap*)
 you can take complete control of the behaviour.

 @author Geert Jansen <jansen@kde.org>

 @version $Id: KRootPixmap.h,v 1.3 2002/03/15 02:12:22 rdale Exp $
 
 @short 
 Creates pseudo-transparent widgets.
*/
@class KSharedPixmap; 

@interface KRootPixmap : QObject 

/** 
 Constructs a KRootPixmap. The KRootPixmap will be created as a child
 of the target widget so it will be deleted automatically when the
 widget is destroyed.

*/
- initWithWidget: (QWidget *)target name: (NSString *)name;
- initWithWidget: (QWidget *)target ;

/** 
 Constructs a KRootPixmap where the parent QObject and target QWidget are
 different.
     
*/
- initWithWidget: (QWidget *)target parent: (QObject *)parent name: (NSString *)name;
- initWithWidget: (QWidget *)target parent: (QObject *)parent ;

/** 
 Destructs the object.
     
*/
- (void) dealloc;

/** 
 Checks if pseudo-transparency is available.

*/
- (BOOL) isAvailable;

/** 
 Returns true if the KRootPixmap is active.
     
*/
- (BOOL) isActive;

/** 
 Returns the number of the current desktop.
     
*/
- (int) currentDesktop;

/** 
 Returns true if custom painting is enabled, false otherwise.

*/
- (BOOL) customPainting;

/** 
 Deprecated, use @ref -isAvailable instead.

     
*/
- (BOOL) checkAvailable: (BOOL)arg1;

/** 
 Starts background handling.
     
*/
- start;

/** 
 Stops background handling.
     
*/
- stop;

/** 
 Sets the fade effect.

 This effect will fade the background to the
 specified color.

*/
- setFadeEffect: (double)strength color: (QColor *)color;

/** 
 Repaints the widget background. Normally, you shouldn't need this
 as it is handled automatically.

*/
- repaint: (BOOL)force;

/** 
 Repaints the widget background. Normally, you shouldn't need this
 as it is handled automatically. This is equivalent to calling
 repaint( false ).
     
*/
- repaint;

/** 
 Enables custom handling of the background painting. If custom
 painting is enabled then KRootPixmap will emit a
 @ref -backgroundUpdated signal when the background for the
 target widget changes, instead of applying the new background.
     
*/
- setCustomPainting: (BOOL)enable;

/** 
 Asks KDesktop to export the desktop background as a KSharedPixmap.
 This method uses DCOP to call KBackgroundIface/setExport(int).
     
*/
- enableExports;

/** 
 Reimplemented to filter the events from the target widget and
 track its movements.
     
*/
- (BOOL) eventFilter: (QObject *)arg1 event: (QEvent *)arg2;

/** 
 Called when the pixmap has been updated. The default implementation
 applies the fade effect, then sets the target's background, or emits
 @ref backgroundUpdated(const QPixmap &) depending on the painting mode.
     
*/
- updateBackground: (KSharedPixmap*)arg1;
@end

/** Override these methods in subclasses of KRootPixmap to customise event handling behaviour */
@protocol KRootPixmapEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
