/***************************************************************************
                            KFileIconView.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KFILEICONVIEW_H
#define KFILEICONVIEW_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KFileView.h>
#include <kdeobjc/KIconView.h>

/**

 An icon-view capable of showing @ref KFileItem's. Used in the filedialog
 for example. Most of the documentation is in @ref KFileView class.

 @short 
 An icon-view capable of showing @ref KFileItem's.
*/
@class KActionCollection; 
@class KFileItem; 

@class KConfig; 
@class KFileIconViewItem; 
@class KFileViewSignaler; 

@interface KFileIconView : KIconView 
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- (void) dealloc;
- (QWidget*) widget;
- clearView;
- setAutoUpdate: (BOOL)arg1;
- updateView: (BOOL)arg1;
- updateFileView: (KFileItem*)arg1;
- removeFileItem: (KFileItem*)arg1;
- listingCompleted;
- insertFileItem: (KFileItem*)i;
- setSelectionMode: (int)sm;
- setSelected: (KFileItem*)arg1 bool: (BOOL)arg2;
- (BOOL) isSelected: (KFileItem*)i;
- clearSelection;
- selectAll;
- invertSelection;
- setCurrentItem: (KFileItem*)arg1;
- (KFileItem*) currentFileItem;
- (KFileItem*) firstFileItem;
- (KFileItem*) nextItem: (KFileItem*)arg1;
- (KFileItem*) prevItem: (KFileItem*)arg1;

/** 
 Sets the size of the icons to show. Defaults to @ref -[KIcon SizeSmall].
     
*/
- setIconSize: (int)size;

/** 
 Sets the size of the previews. Defaults to @ref -[KIcon SizeLarge].
     
*/
- setPreviewSize: (int)size;

/** 

*/
- (int) iconSize;
- ensureItemVisible: (KFileItem*)arg1;
- setSorting: (int)sort;
- readConfig: (KConfig*)arg1 group: (NSString *)group;
- readConfig: (KConfig*)arg1 ;
- writeConfig: (KConfig*)arg1 group: (NSString *)group;
- writeConfig: (KConfig*)arg1 ;
- mimeTypeDeterminationFinished;
- determineIcon: (KFileIconViewItem*)item;
- (QScrollView*) scrollWidget;

/** 
 Starts loading previews for all files shown and shows them. Switches
 into 'large rows' mode, if that isn't the current mode yet.
     
*/
- showPreviews;
@end

@class KFileViewItem; 

@class KActionCollection; 
@class KFileItem; 

@class KConfig; 
@class KFileIconViewItem; 
@class KFileViewSignaler; 

@interface KFileIconView (KFileViewImplementation) <KFileViewInterface>
@end

/** Override these methods in subclasses of KFileIconView to customise event handling behaviour */
@protocol KFileIconViewEventHandling

/** 
 Reimplemented to not let QIconView eat return-key events
     
*/
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) fe;
- childEvent:(QChildEvent*) arg1;
- viewportDragMoveEvent:(QDragMoveEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- contentsWheelEvent:(QWheelEvent*) arg1;
- leaveEvent:(QEvent*) e;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contentsContextMenuEvent:(QContextMenuEvent*) e;
- viewportContextMenuEvent:(QContextMenuEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- viewportMousePressEvent:(QMouseEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- viewportMouseReleaseEvent:(QMouseEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- viewportMouseDoubleClickEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragLeaveEvent:(QDragLeaveEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) e;
- contentsDropEvent:(QDropEvent*) e;
- focusInEvent:(QFocusEvent*) e;
- imEndEvent:(QIMEvent*) arg1;
- contentsDragLeaveEvent:(QDragLeaveEvent*) e;
- viewportDropEvent:(QDropEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- contentsMouseDoubleClickEvent:(QMouseEvent*) e;
- viewportDragEnterEvent:(QDragEnterEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- viewportMouseMoveEvent:(QMouseEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- contentsDragMoveEvent:(QDragMoveEvent*) e;
- moveEvent:(QMoveEvent*) arg1;
- contentsMouseReleaseEvent:(QMouseEvent*) e;
- viewportWheelEvent:(QWheelEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;

/** 
 Reimplemented to remove an eventual tooltip
     
*/
- hideEvent:(QHideEvent*) arg1;
- contentsDragEnterEvent:(QDragEnterEvent*) e;
- contentsMouseMoveEvent:(QMouseEvent*) e;
- contentsMousePressEvent:(QMouseEvent*) e;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- viewportPaintEvent:(QPaintEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- viewportResizeEvent:(QResizeEvent*) arg1;
- resizeEvent:(QResizeEvent*) e;
@end


#endif
