/***************************************************************************
                            kde_KXMLGUIClient.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KXMLGUICLIENT
#define KDE_KXMLGUICLIENT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*

 A KXMLGUIClient can be used with @ref KXMLGUIFactory to create a
 GUI from actions and an XML document, and can be dynamically merged
 with other KXMLGUIClients.
 
 @short *

*/
#define KXMLGUICLIENT_StateNoReverse	0
#define KXMLGUICLIENT_StateReverse	1

/** *
 Constructs a KXMLGUIClient which can be used with a
 @ref KXMLGUIFactory to create a GUI from actions and an XML document, and
 which can be dynamically merged with other KXMLGUIClients.
   
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KXMLGUIClient * kde_new_KXMLGUIClient();

/** *
 Constructs a KXMLGUIClient which can be used with a @ref KXMLGUIFactory
 to create a GUI from actions and an XML document,
 and which can be dynamically merged with other KXMLGUIClients.

 This constructor takes an additional @p parent argument, which makes
 the client a child client of the parent.

 Child clients are automatically added to the GUI if the parent is added.

   
*/
kde_KXMLGUIClient * kde_new_KXMLGUIClient1(kde_KXMLGUIClient* parent);

/** *
 Destructs the KXMLGUIClient.
   
*/
void kde_del_KXMLGUIClient( kde_KXMLGUIClient* p );

/** *
 Retrieves an action of the client by name.  If not found, it looks in its child clients.
 This method is provided for convenience, as it uses @ref #actionCollection()
 to get the action object.
   
*/
kde_KAction* kde_KXMLGUIClient_action(kde_KXMLGUIClient* instPointer,char* name);

/** *
 Retrieves an action for a given @ref QDomElement. The default
 implementation uses the "name" attribute to query the action
 object via the other action() method.
   
*/
kde_KAction* kde_KXMLGUIClient_action1(kde_KXMLGUIClient* instPointer,qt_QDomElement* element);

/** *
 Retrieves the entire action collection for the GUI client
   
*/
kde_KActionCollection* kde_KXMLGUIClient_actionCollection(kde_KXMLGUIClient* instPointer);

/** *

*/
kde_KInstance* kde_KXMLGUIClient_instance(kde_KXMLGUIClient* instPointer);

/** *

*/
qt_QDomDocument* kde_KXMLGUIClient_domDocument(kde_KXMLGUIClient* instPointer);

/** *
 This will return the name of the XML file as set by @ref #setXMLFile().
 If @ref #setXML() is used directly, then this will return NULL.

 The filename that this returns is obvious for components as each
 component has exactly one XML file.  In non-components, however,
 there are usually two: the global file and the local file.  This
 function doesn't really care about that, though.  It will always
 return the last XML file set.  This, in almost all cases, will
 be the local XML file.

*/
qt_QString * kde_KXMLGUIClient_xmlFile(kde_KXMLGUIClient* instPointer);
qt_QString * kde_KXMLGUIClient_localXMLFile(kde_KXMLGUIClient* instPointer);

/** *

   
*/
void kde_KXMLGUIClient_setXMLGUIBuildDocument(kde_KXMLGUIClient* instPointer,qt_QDomDocument* doc);

/** *

   
*/
qt_QDomDocument* kde_KXMLGUIClient_xmlguiBuildDocument(kde_KXMLGUIClient* instPointer);

/** *
 This method is called by the @ref KXMLGUIFactory as soon as the client
 is added to the KXMLGUIFactory's GUI.
   
*/
void kde_KXMLGUIClient_setFactory(kde_KXMLGUIClient* instPointer,kde_KXMLGUIFactory* factory);

/** *
 Retrieves a pointer to the @ref KXMLGUIFactory this client is
 associated with (will return 0L if the client's GUI has not been built
 by a KXMLGUIFactory.
   
*/
kde_KXMLGUIFactory* kde_KXMLGUIClient_factory(kde_KXMLGUIClient* instPointer);

/** *
 KXMLGUIClients can form a simple child/parent object tree. This
 method returns a pointer to the parent client or 0L if it has no
 parent client assigned.
   
*/
kde_KXMLGUIClient* kde_KXMLGUIClient_parentClient(kde_KXMLGUIClient* instPointer);

/** *
 Use this method to make a client a child client of another client.
 Usually you don't need to call this method, as it is called
 automatically when using the second constructor, which takes a
 arent argument.
   
*/
void kde_KXMLGUIClient_insertChildClient(kde_KXMLGUIClient* instPointer,kde_KXMLGUIClient* child);

/** *
 Removes the given @p child from the client's children list.
   
*/
void kde_KXMLGUIClient_removeChildClient(kde_KXMLGUIClient* instPointer,kde_KXMLGUIClient* child);

/** *
 A client can have an own @ref KXMLGUIBuilder.
 Use this method to assign your builder instance to the client (so that the
 @ref KXMLGUIFactory can use it when building the client's GUI)

 Client specific guibuilders are useful if you want to create
 custom container widgets for your GUI.
   
*/
void kde_KXMLGUIClient_setClientBuilder(kde_KXMLGUIClient* instPointer,kde_KXMLGUIBuilder* builder);

/** *
 Retrieves the client's GUI builder or 0L if no client specific
 builder has been assigned via @ref #setClientBuilder()
   
*/
kde_KXMLGUIBuilder* kde_KXMLGUIClient_clientBuilder(kde_KXMLGUIClient* instPointer);

/** *
 Forces this client to re-read its XML resource file.  This is
 intended to be used when you know that the resource file has
 changed and you will soon be rebuilding the GUI.  It has no
 useful effect with non-KParts GUIs, so don't bother using it
 unless your app is component based.
   
*/
void kde_KXMLGUIClient_reloadXML(kde_KXMLGUIClient* instPointer);

/** *
 The complement of \ref plugActionList() ...
   
*/
void kde_KXMLGUIClient_unplugActionList(kde_KXMLGUIClient* instPointer,qt_QString * name);
void kde_KXMLGUIClient_addStateActionEnabled(kde_KXMLGUIClient* instPointer,qt_QString * state, qt_QString * action);
void kde_KXMLGUIClient_addStateActionDisabled(kde_KXMLGUIClient* instPointer,qt_QString * state, qt_QString * action);
void kde_KXMLGUIClient_beginXMLPlug(kde_KXMLGUIClient* instPointer,qt_QWidget * arg1);
void kde_KXMLGUIClient_endXMLPlug(kde_KXMLGUIClient* instPointer);
void kde_KXMLGUIClient_prepareXMLUnplug(kde_KXMLGUIClient* instPointer,qt_QWidget * arg1);
qt_QString * kde_KXMLGUIClient_findMostRecentXMLFile( qt_QStringList* files, qt_QString * doc);

/** *
 Sets the instance (@ref KInstance) for this part.

 Call this first in the inherited class constructor.
 (At least before @ref setXMLFile().)
   
*/
void kde_KXMLGUIClient_setInstance(kde_KXMLGUIClient* instPointer,kde_KInstance* instance);

/** *
 Sets the name of the rc file containing the XML for the part.

 Call this in the Part-inherited class constructor.

*/
void kde_KXMLGUIClient_setXMLFile(kde_KXMLGUIClient* instPointer,qt_QString * file, int merge, int setXMLDoc);
void kde_KXMLGUIClient_setLocalXMLFile(kde_KXMLGUIClient* instPointer,qt_QString * file);

/** *
 Sets the XML for the part.

 Call this in the Part-inherited class constructor if you
  don't call @ref setXMLFile().

*/
void kde_KXMLGUIClient_setXML(kde_KXMLGUIClient* instPointer,qt_QString * document, int merge);

/** *
 Sets the Document for the part, describing the layout of the GUI.

 Call this in the Part-inherited class constructor if you don't call
 @ref setXMLFile or @ref setXML .
   
*/
void kde_KXMLGUIClient_setDOMDocument(kde_KXMLGUIClient* instPointer,qt_QDomDocument* document, int merge);

/** *
 This function will attempt to give up some memory after the GUI
 is built.  It should never be used in apps where the GUI may be
 rebuilt at some later time (components, for instance).
   
*/
void kde_KXMLGUIClient_conserveMemory(kde_KXMLGUIClient* instPointer);

/** *
 Actions can collectively be assigned a "State". To accomplish this
 the respective actions are tagged as <enable> or <disable> in
 a <State> </State> group of the XMLfile. During program execution the
 programmer can call stateChanged() to set actions to a defined state.

*/
void kde_KXMLGUIClient_stateChanged(kde_KXMLGUIClient* instPointer,qt_QString * newstate, int reverse);
void kde_KXMLGUIClient_virtual_hook(kde_KXMLGUIClient* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
