/***************************************************************************
                            kde_KServiceType.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSERVICETYPE
#define KDE_KSERVICETYPE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A service type is the generic notion for a mimetype, a type of service
 instead of a type of file.
 For instance, KOfficeFilter is a service type.
 It is associated to services according to the user profile (kuserprofile.h)
 
 @short *
 A service type is the generic notion for a mimetype, a type of service
 instead of a type of file.
*/

/** *
 Constructor.  You may pass in arguments to create a servicetype with
 specific properties
   
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KServiceType * kde_new_KServiceType(qt_QString * _fullpath, qt_QString * _name, qt_QString * _icon, qt_QString * _comment);

/** *
 Construct a service type and take all informations from a config file.

*/
kde_KServiceType * kde_new_KServiceType1(qt_QString * _fullpath);

/** *
 Construct a service type and take all informations from a deskop file.
   
*/
kde_KServiceType * kde_new_KServiceType2(kde_KDesktopFile* config);

/** *

 The stream must already be positionned at the correct offset
   
*/
kde_KServiceType * kde_new_KServiceType3(qt_QDataStream * _str, int offset);
void kde_del_KServiceType( kde_KServiceType* p );

/** *

*/
qt_QString * kde_KServiceType_icon(kde_KServiceType* instPointer);

/** *

*/
qt_QString * kde_KServiceType_comment(kde_KServiceType* instPointer);

/** *

*/
qt_QString * kde_KServiceType_name(kde_KServiceType* instPointer);

/** *

*/
qt_QString * kde_KServiceType_desktopEntryPath(kde_KServiceType* instPointer);

/** *

*/
int kde_KServiceType_isDerived(kde_KServiceType* instPointer);

/** *
 If this service type inherits from another service type,
 return the name of the parent. Otherwise QString::null.
   
*/
qt_QString * kde_KServiceType_parentServiceType(kde_KServiceType* instPointer);

/** *

*/
int kde_KServiceType_inherits(kde_KServiceType* instPointer,qt_QString * servTypeName);
qt_QVariant * kde_KServiceType_property(kde_KServiceType* instPointer,qt_QString * _name);
qt_QStringList* kde_KServiceType_propertyNames(kde_KServiceType* instPointer);
int kde_KServiceType_isValid(kde_KServiceType* instPointer);
int kde_KServiceType_propertyDef(kde_KServiceType* instPointer,qt_QString * _name);
qt_QStringList* kde_KServiceType_propertyDefNames(kde_KServiceType* instPointer);

/** *
 Save ourselves to the data stream.
   
*/
void kde_KServiceType_save(kde_KServiceType* instPointer,qt_QDataStream * arg1);

/** *
 Load ourselves from the data stream.
   
*/
void kde_KServiceType_load(kde_KServiceType* instPointer,qt_QDataStream * arg1);

/** *

*/
void * kde_KServiceType_serviceType( qt_QString * _name);

/** *

*/

/** *

*/
void kde_KServiceType_init(kde_KServiceType* instPointer,kde_KDesktopFile* config);
void kde_KServiceType_virtual_hook(kde_KServiceType* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
