/***************************************************************************
                            kde_KScanDialog.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSCANDIALOG
#define KDE_KSCANDIALOG

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This is a base class for scanning dialogs. You can derive from this class
 and implement your own dialog. An implementation is available in
 kdegraphics/libkscan.

 Application developers that wish to add scanning support to their program
 can use the static method @p KScanDialog::getScanDialog() to get an instance
 of the user's preferred scanning dialog.

 Typical usage looks like this (e.g. in a slotShowScanDialog() method):

 <pre>
 if ( !m_scanDialog ) {
     m_scanDialog = KScanDialog::getScanDialog( this, "scandialog" );
     if ( !m_scanDialog ) // no scanning support installed?
         return;

     connect( m_scanDialog, SIGNAL( finalImage( const QImage&, int )),
              SLOT( slotScanned( const QImage&, int ) ));
 }

 if ( m_scanDialog->setup() ) // only if scanner configured/available
     m_scanDialog->show();
 </pre>

 This will create and show a non-modal scanning dialog. Connect to more
 signals if you like.

 If you implement an own scan-dialog, you also have to implement a
 KScanDialogFactory.

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A baseclass and accessor for Scanning Dialogs.
*/

/** *
 Destructs the scan dialog.
     
*/
#ifdef __cplusplus
extern   "C" {
#endif
void kde_del_KScanDialog( kde_KScanDialog* p );

/** *
 Reimplement this if you need to set up some things, before showing the
 dialog, e.g. to ask the user for the scanner device to use. If you 
 return false (e.g. there is no device available or the user aborted
 device selection), the dialog will not be shown.

 Returns true by default.
     
*/
int kde_KScanDialog_setup(kde_KScanDialog* instPointer);

/** *
 Creates the user's preferred scanning dialog and returns it,
 or 0L if no scan-support
 is available. Pass a suitable @p parent widget, if you like. If you
 don't you have to 'delete' the returned pointer yourself.
     
*/
kde_KScanDialog* kde_KScanDialog_getScanDialog( qt_QWidget * parent, char* name, int modal);

/** *
 Constructs the scan dialog. If you implement an own dialog, you can
 customize it with the usual @ref KDialogBase flags.

*/
kde_KScanDialog * kde_new_KScanDialog(int dialogFace, int buttonMask, qt_QWidget * parent, char* name, int modal);

/** *

*/
int kde_KScanDialog_id(kde_KScanDialog* instPointer);

/** *

     
*/
int kde_KScanDialog_nextId(kde_KScanDialog* instPointer);
void kde_KScanDialog_virtual_hook(kde_KScanDialog* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
