/***************************************************************************
                            kde_KDockWidget.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KDOCKWIDGET
#define KDE_KDOCKWIDGET

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Floatable widget that can be dragged around with the mouse and
 encapsulate the actual widgets (and member of the dockwidget class
 set).

 You just grip the double-lined panel, tear it off its parent
 widget, drag it somewhere and let it loose. Depending on the
 position where you leave it, the dockwidget becomes a toplevel
 window on the desktop (floating mode) or docks to a new widget
 (dock mode). Note: A KDockWidget can only be docked to a
 KDockWidget.

 If you want to use this kind of widget, your main application
 window has to be a @ref KDockMainWindow.  That is because it has
 got several additional dock management features, for instance a
 @ref KDockManager that has an overview over all dockwidgets and and
 a dockmovemanager (internal class) that handles the dock process.

 Usually you create an KDockWidget that covers the actual widget in this way:
 <PRE>
 ...
 KDockMainWindow* mainWidget;
 ...
 KDockWidget* dock = 0L;
 dock = mainWidget->createDockWidget( "Any window caption", nicePixmap, 0L, i18n("window caption")); // 0L==no parent
 QWidget* actualWidget = new QWidget( dock);
 dock->setWidget( actualWidget); // embed it
 dock->setToolTipString(i18n("That's me")); // available when appearing as tab page
 ...
 </PRE>

 See @ref KDockMainWindow how a dockwidget is docked in.

 @author Max Judin (documentation: Falk Brettschneider).
 
 @short *
 Floatable widget that can be dragged around with the mouse and
 encapsulate the actual widgets (and member of the dockwidget class
 set).
*/
#define KDOCKWIDGET_DockNone	0
#define KDOCKWIDGET_DockTop	0x0001
#define KDOCKWIDGET_DockLeft	0x0002
#define KDOCKWIDGET_DockRight	0x0004
#define KDOCKWIDGET_DockBottom	0x0008
#define KDOCKWIDGET_DockCenter	0x0010
#define KDOCKWIDGET_DockDesktop	0x0020
#define KDOCKWIDGET_DockToSpecialSites	0x0040
#define KDOCKWIDGET_DockCorner	DockTop|DockLeft|DockRight|KDOCKWIDGET_DockBottom
#define KDOCKWIDGET_DockFullSite	KDOCKWIDGET_DockCorner|KDOCKWIDGET_DockCenter
#define KDOCKWIDGET_DockFullDocking	KDOCKWIDGET_DockFullSite|KDOCKWIDGET_DockDesktop

/** *
 Construct a dockwidget.

 Initially, docking to another and docking to this is allowed for
 every @p DockPosition.  It is supposed to be no (tab) group. It will
 taken under control of its dockmanager.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KDockWidget * kde_new_KDockWidget(kde_KDockManager* dockManager, char* name, qt_QPixmap * pixmap, qt_QWidget * parent, qt_QString * strCaption, qt_QString * strTabPageLabel, int f);

/** *
 Destructs a dockwidget.
   
*/
void kde_del_KDockWidget( kde_KDockWidget* p );

/** *
 This is a key method of this class! Use it to dock dockwidgets to
 another dockwidget at the right position within its
 @ref KDockMainWindow or a toplevel dockwidget.

 If the target is null, it will become a toplevel dockwidget at position pos;
 Note: Docking to another dockwidget means exactly:
 A new parent dockwidget will be created, that replaces the target dockwidget and contains another single helper widget (tab widget or panner)
 which contains both dockwidgets, this and the target dockwidget. So consider parent<->child relationships change completely during such actions.

*/

/** *
 Specify where it is either possible or impossible for this to dock to another dockwidget.

*/
void kde_KDockWidget_setEnableDocking(kde_KDockWidget* instPointer,int pos);

/** *

*/
int kde_KDockWidget_enableDocking(kde_KDockWidget* instPointer);

/** *
 Specify where it is either possible or impossible for another dockwidget to dock to this.

*/
void kde_KDockWidget_setDockSite(kde_KDockWidget* instPointer,int pos);

/** *

*/
int kde_KDockWidget_dockSite(kde_KDockWidget* instPointer);

/** *
 Sets the embedded widget.

 A QLayout takes care about proper resizing, automatically.

*/
void kde_KDockWidget_setWidget(kde_KDockWidget* instPointer,qt_QWidget * w);

/** *
 Get the embedded widget.

*/
qt_QWidget * kde_KDockWidget_getWidget(kde_KDockWidget* instPointer);

/** *
 Sets the header of this dockwidget.

 A @ref QLayout takes care about proper resizing, automatically.
 The header contains the drag panel, the close button and the stay button.

*/
void kde_KDockWidget_setHeader(kde_KDockWidget* instPointer,kde_KDockWidgetAbstractHeader* ah);

/** *
 Normally it simply shows the dockwidget.

 But additionally, if it is docked to a tab widget (@p DockCenter), it is set as the active (visible) tab page.
   
*/
void kde_KDockWidget_makeDockVisible(kde_KDockWidget* instPointer);

/** *

 There are reasons that it's impossible:

*/
int kde_KDockWidget_mayBeHide(kde_KDockWidget* instPointer);

/** *

*/
int kde_KDockWidget_mayBeShow(kde_KDockWidget* instPointer);

/** *

*/
kde_KDockManager* kde_KDockWidget_dockManager(kde_KDockWidget* instPointer);

/** *
 Stores a string for a tooltip.

 That tooltip string has only a meaning when this dockwidget is shown as tab page.
 In this case the tooltip is shown when one holds the mouse cursor on the tab page header.
 Such tooltip will for instance be useful, if you use only icons there.
 Note: Setting an empty string switches the tooltip off.

*/
void kde_KDockWidget_setToolTipString(kde_KDockWidget* instPointer,qt_QString * ttStr);

/** *

*/
qt_QString * kde_KDockWidget_toolTipString(kde_KDockWidget* instPointer);

/** *

*/
int kde_KDockWidget_isDockBackPossible(kde_KDockWidget* instPointer);

/** *
 Sets a string that is used for the label of the tab page when in tab page mode

*/
void kde_KDockWidget_setTabPageLabel(kde_KDockWidget* instPointer,qt_QString * label);

/** *

*/
qt_QString * kde_KDockWidget_tabPageLabel(kde_KDockWidget* instPointer);

/** *
 Catches and processes some @ref QWidget events that are interesting for dockwidgets.
   
*/
int kde_KDockWidget_event(kde_KDockWidget* instPointer,qt_QEvent * arg1);

/** *
 Add dockwidget management actions to @ref QWidget::show.
   
*/
void kde_KDockWidget_show(kde_KDockWidget* instPointer);

/** *

*/
kde_KDockTabGroup* kde_KDockWidget_parentDockTabGroup(kde_KDockWidget* instPointer);
qt_QWidget * kde_KDockWidget_parentDockContainer(kde_KDockWidget* instPointer);

/** *
 Sets the type of the dock window

*/
void kde_KDockWidget_setDockWindowType(kde_KDockWidget* instPointer,int windowType);

/** *
 Sets the type of the dock window

*/
void kde_KDockWidget_setDockWindowTransient(kde_KDockWidget* instPointer,qt_QWidget * parent, int transientEnabled);

/** *
 Lookup the nearest dockwidget docked left/right/top/bottom to this one or return 0

*/
kde_KDockWidget* kde_KDockWidget_findNearestDockWidget(kde_KDockWidget* instPointer,int pos);

/** *
 subject to changes. It doesn't completely work yet without small hacks from within the calling application (Perhaps 
 KDE 3.1.x oder 3.2
 width is in pixel. It only affects a widget, which is placed directly into a horizontal KDockSplitter

*/
void kde_KDockWidget_setForcedFixedWidth(kde_KDockWidget* instPointer,int arg1);

/** *
 subject to changes. It doesn't completely work yet without small hacks from within the calling application (Perhaps 
 KDE 3.1.x oder 3.2
 height is in pixel. It only affects a widget, which is placed directly into a vertical KDockSplitter

*/
void kde_KDockWidget_setForcedFixedHeight(kde_KDockWidget* instPointer,int arg1);
void kde_KDockWidget_restoreFromForcedFixedSize(kde_KDockWidget* instPointer);
int kde_KDockWidget_forcedFixedWidth(kde_KDockWidget* instPointer);
int kde_KDockWidget_forcedFixedHeight(kde_KDockWidget* instPointer);

/** *
 Docks a dockwidget back to the dockwidget that was the neighbor
   widget before the current dock position.
  
*/
void kde_KDockWidget_dockBack(kde_KDockWidget* instPointer);

/** *
 Toggles the visibility state of the dockwidget if it is able to be shown or to be hidden.
   
*/
void kde_KDockWidget_changeHideShowState(kde_KDockWidget* instPointer);

/** *
 Undocks this. It means it becomes a toplevel widget framed by the system window manager.
 A small panel at the top of this undocked widget gives the possibility to drag it into
 another dockwidget by mouse (docking).
   
*/
void kde_KDockWidget_undock(kde_KDockWidget* instPointer);

/** *
 Docks the widget to the desktop (as a toplevel widget)

*/
void kde_KDockWidget_toDesktop(kde_KDockWidget* instPointer);

/** *
 Checks some conditions and shows or hides the dockwidget header (drag panel).
 The header is hidden if:

*/
void kde_KDockWidget_updateHeader(kde_KDockWidget* instPointer);
void kde_KDockWidget_setLatestKDockContainer(kde_KDockWidget* instPointer,qt_QWidget * arg1);
qt_QWidget * kde_KDockWidget_latestKDockContainer(kde_KDockWidget* instPointer);

/** *
 Previous side (left,right,top,bottom) where this dockwidget was before a dragging action, none if it wasn't dragged before.
   
*/
void kde_KDockWidget_virtual_hook(kde_KDockWidget* instPointer,int identifier, void* data);

/** * Does several things here when it has noticed that the former brother widget (closest neighbor) gets lost.
 The former brother widget is needed for a possible dockback action, to speak with the Beatles:
 "To get back to where you once belonged" ;-)
   
*/
void kde_KDockWidget_loseFormerBrotherDockWidget(kde_KDockWidget* instPointer);

#ifdef __cplusplus
}
#endif
#endif
