/* kplview.h
**
** Copyright (C) 1999,2000 Toivo Pedaste <toivo@ucs.uwa.edu.au>
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
** MA 02111-1307, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/


#ifndef KPLVITEM_H
#define KPLVITEM_H

#include "../config.h"
// Standard Headers

// Qt Headers
#include <qframe.h>
#include <qpushbutton.h>
#include <qptrlist.h>
#include <qstring.h>
#include <qlayout.h>

// KDE headers
#include "klistview.h"

// ksetup headers
#include "packageInfo.h"

////////////////////////////////////////////////////////////////////////
class KPLVItem : public QListViewItem
{
public:
  KPLVItem( QListViewItem *parent, packageInfo* pinfo,
	    const QPixmap& thePixmap,
	    QString label1 = 0, QString label2  = 0,
	    QString label3  = 0, QString label4  = 0,
	    QString label5  = 0, QString label6  = 0,
	    QString label7  = 0, QString label8 = 0);


  KPLVItem( KListView *parent, packageInfo* pinfo,
	    const QPixmap& thePixmap,
	    QString label1 = 0, QString label2  = 0,
	    QString label3  = 0, QString label4  = 0,
	    QString label5  = 0, QString label6  = 0,
	    QString label7  = 0, QString label8 = 0);


  KPLVItem *firstChild();
  KPLVItem *nextSibling();

  void toggleMark();
  void setMark(bool mark);
  // flag for install/uninstall

  void hide();
  void show();

  virtual int compare( QListViewItem *i, int col, bool ascending ) const;

  packageInfo *info;
  bool marked;
};

////////////////////////////////////////////////////////////////////////
class KPQListView: public KListView
{
  Q_OBJECT

public:
  KPQListView ( QWidget * parent = 0);

  void contentsMousePressEvent ( QMouseEvent * e );

  bool inMark(int x);

  KPLVItem *firstChild();
  KPLVItem *currentItem();
  void clear();

  KPLVItem *markPkg;

signals:
  void updateMarked();
};

#endif
