// $Id: OptionsDlg.cpp,v 1.23 2003/04/04 13:40:12 willy Exp $
//
// KDat - a tar-based DAT archiver
// Copyright (C) 1998-2000  Sean Vyain, svyain@mail.tds.net
// Copyright (C) 2001-2002  Lawrence Widman, kdat@cardiothink.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <stdlib.h>

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>

#include <kapplication.h>
#include <kfiledialog.h>
#include <kmessagebox.h>

#include "Options.h"
#include "OptionsDlg.h"
#include <klocale.h>
#include <kglobal.h>

#include "OptionsDlg.moc"
#include <knuminput.h>
OptionsDlg::OptionsDlg( QWidget* parent, const char* name )
        : QDialog( parent, name, TRUE )
{
    setCaption( i18n( "KDat: Options" ) );
    setIconText( i18n( "KDat: Options" ) );

    QVBoxLayout *ml = new QVBoxLayout( this, KDialog::spacingHint() );

    QHBoxLayout *h1 = new QHBoxLayout( ml, KDialog::spacingHint() );

    QVBoxLayout *v1 = new QVBoxLayout( h1, KDialog::spacingHint() );
    QVBoxLayout *v2 = new QVBoxLayout( h1, KDialog::spacingHint() );
    QVBoxLayout *v3 = new QVBoxLayout( h1, KDialog::spacingHint() );


    QLabel* lbl1 = new QLabel( i18n( "Default tape size:" ), this );
    v1->addWidget( lbl1 );

    QLabel* lbl2 = new QLabel( i18n( "Tape block size:" ), this );
    v1->addWidget( lbl2 );

    _defaultTapeSize = new KIntNumInput( this );
    _defaultTapeSize->setMinimumWidth( 48 );
    v2->addWidget( _defaultTapeSize );
    connect( _defaultTapeSize, SIGNAL( valueChanged(int) ), this, SLOT( slotChanged() ) );

    _tapeBlockSize = new KIntNumInput( this );
    _tapeBlockSize->setMinimumWidth( 48 );
    v2->addWidget( _tapeBlockSize );
    connect( _tapeBlockSize, SIGNAL( valueChanged(int) ), this, SLOT( slotChanged() ) );

    _defaultTapeSizeUnits = new QComboBox( this );
    _defaultTapeSizeUnits->insertItem( "MB" );
    _defaultTapeSizeUnits->insertItem( "GB" );
    v3->addWidget( _defaultTapeSizeUnits );
    connect( _defaultTapeSizeUnits, SIGNAL( activated(int) ), this, SLOT( slotChanged() ) );

    QLabel* lbl5 = new QLabel( i18n( "bytes" ), this );
    v3->addWidget( lbl5 );

    ml->addSpacing( KDialog::spacingHint() );

    QHBoxLayout *h2 = new QHBoxLayout( ml, KDialog::spacingHint() );

    QVBoxLayout *v4 = new QVBoxLayout( h2, KDialog::spacingHint() );
    QVBoxLayout *v5 = new QVBoxLayout( h2, KDialog::spacingHint() );
    QVBoxLayout *v6 = new QVBoxLayout( h2, KDialog::spacingHint() );

    QLabel* lbl3 = new QLabel( i18n( "Tape device:" ), this );
    v4->addWidget( lbl3 );

    QLabel* lbl4 = new QLabel( i18n( "Tar command:" ), this );
    v4->addWidget( lbl4 );

    _tapeDevice = new QLineEdit( this );
    v5->addWidget( _tapeDevice );
    connect( _tapeDevice, SIGNAL( textChanged ( const QString & ) ), this, SLOT( slotChanged() ) );

    _tarCommand = new QLineEdit( this );
    v5->addWidget( _tarCommand );
    connect( _tarCommand, SIGNAL( textChanged ( const QString & ) ), this, SLOT( slotChanged() ) );

    QPushButton* browseTapeDevice = new QPushButton( i18n( "..." ), this );
    v6->addWidget( browseTapeDevice );

    QPushButton* browseTarCommand = new QPushButton( i18n( "..." ), this );
    v6->addWidget( browseTarCommand );

    ml->addSpacing( KDialog::spacingHint() );

    QGroupBox* g1 = new QGroupBox( i18n( "Tape Drive Options" ), this );
    ml->addWidget( g1 );

    QVBoxLayout *v7 = new QVBoxLayout( g1, KDialog::spacingHint() );
    v7->addSpacing( 2 * KDialog::spacingHint() );

    _loadOnMount = new QCheckBox( i18n( "Load tape on mount" ), g1 );
    v7->addWidget( _loadOnMount );
    connect( _loadOnMount, SIGNAL( toggled(bool) ), this, SLOT( slotChanged() ) );

    _lockOnMount = new QCheckBox( i18n( "Lock tape drive on mount" ), g1 );
    v7->addWidget( _lockOnMount );
    connect( _lockOnMount, SIGNAL( toggled(bool) ), this, SLOT( slotChanged() ) );

    _ejectOnUnmount = new QCheckBox( i18n( "Eject tape on unmount" ), g1 );
    v7->addWidget( _ejectOnUnmount );
    connect( _ejectOnUnmount, SIGNAL( toggled(bool) ), this, SLOT( slotChanged() ) );

    _variableBlockSize = new QCheckBox( i18n( "Variable block size" ), g1 );
    v7->addWidget( _variableBlockSize );
    connect( _variableBlockSize, SIGNAL( toggled(bool) ), this, SLOT( slotChanged() ) );


    QHBoxLayout *h3 = new QHBoxLayout( ml, KDialog::spacingHint() );
    h3->addStretch( 1 );

    QPushButton* ok     = new QPushButton( i18n( "&OK" )    , this );
    ok->setDefault(TRUE);
    h3->addWidget( ok );

    apply  = new QPushButton( i18n( "&Apply" ) , this );
    h3->addWidget( apply );

    QPushButton* cancel = new QPushButton( i18n( "&Cancel" ), this );
    h3->addWidget( cancel );

    connect( browseTapeDevice, SIGNAL( clicked() ), this, SLOT( slotBrowseTapeDevice() ) );
    connect( browseTarCommand, SIGNAL( clicked() ), this, SLOT( slotBrowseTarCommand() ) );

    connect( ok    , SIGNAL( clicked() ), this, SLOT( slotOK()     ) );
    connect( apply , SIGNAL( clicked() ), this, SLOT( slotApply()  ) );
    connect( cancel, SIGNAL( clicked() ), this, SLOT( slotCancel() ) );

    int size = Options::instance()->getDefaultTapeSize();
    if ( ( size >= 1024*1024 ) && ( size % ( 1024*1024 ) == 0 ) ) {
        // GB
        size /= 1024*1024;
        _defaultTapeSizeUnits->setCurrentItem( 1 );
    } else {
        // MB
        size /= 1024;
        _defaultTapeSizeUnits->setCurrentItem( 0 );
    }
    _defaultTapeSize->setValue( size );

    _tapeBlockSize->setValue( Options::instance()->getTapeBlockSize() );

    _tapeDevice->setText( Options::instance()->getTapeDevice() );
    _tarCommand->setText( Options::instance()->getTarCommand() );
    _loadOnMount->setChecked( Options::instance()->getLoadOnMount() );
    _lockOnMount->setChecked( Options::instance()->getLockOnMount() );
    _ejectOnUnmount->setChecked( Options::instance()->getEjectOnUnmount() );
    _variableBlockSize->setChecked( Options::instance()->getVariableBlockSize() );

    //resize(minimumSize());
    apply->setEnabled( false );
    configChanged = false;
}

OptionsDlg::~OptionsDlg()
{
}

void OptionsDlg::slotBrowseTapeDevice()
{
    KURL url;
    url = KFileDialog::getOpenURL( _tapeDevice->text() );

    if ( !url.isEmpty() )
    {
        if( !url.isLocalFile() )
        {
            KMessageBox::sorry( 0L, i18n( "Only local files are supported" ) );
            return;
        }
        _tapeDevice->setText( url.path() );
    }

}

void OptionsDlg::slotBrowseTarCommand()
{
    KURL url;
    url = KFileDialog::getOpenURL( _tarCommand->text() );

    if ( !url.isEmpty() )
    {
        if( !url.isLocalFile() )
        {
            KMessageBox::sorry( 0L, i18n( "Only local files are currently supported" ) );
            return;
        }
        _tarCommand->setText( url.path() );
    }
}

void OptionsDlg::slotChanged()
{
    apply->setEnabled( true );
    configChanged = true;
}

void OptionsDlg::slotOK()
{
    if( configChanged )
        slotApply();
    accept();
}

void OptionsDlg::slotApply()
{
    int size = _defaultTapeSize->value();
    if ( _defaultTapeSizeUnits->currentItem() == 0 ) {
        // MB
        size *= 1024;
    } else {
        // GB
        size *= 1024*1024;
    }
    Options::instance()->setDefaultTapeSize( size );

    Options::instance()->setTapeBlockSize( _tapeBlockSize->value() );

    Options::instance()->setTapeDevice( _tapeDevice->text() );

    Options::instance()->setTarCommand( _tarCommand->text() );

    Options::instance()->setLoadOnMount( _loadOnMount->isChecked() );

    Options::instance()->setLockOnMount( _lockOnMount->isChecked() );

    Options::instance()->setEjectOnUnmount( _ejectOnUnmount->isChecked() );

    Options::instance()->setVariableBlockSize( _variableBlockSize->isChecked() );

    Options::instance()->sync();
    apply->setEnabled( false );
    configChanged = false;
}

void OptionsDlg::slotCancel()
{
    reject();
}
