#ifndef MSGINPUTDIALOG_H
#define MSGINPUTDIALOG_H

#include <kdialog.h>

#include "bug.h"
#include "package.h"
#include <Q3ListBoxItem>

class KTextEdit;
class QSplitter;
class K3ListBox;

class MsgInputDialog : public KDialog
{
    Q_OBJECT
  public:
    enum MessageType{ Close, Reply, ReplyPrivate };
  
    MsgInputDialog( MessageType, const Bug &, const Package &,
                    const QString &, QWidget *parent=0);
    virtual ~MsgInputDialog();

    QString message() const;

  protected slots:
    void slotOk();
    void slotCancel();

  private slots:
    void editPresets();
    void updatePresets();
    void slotPresetSelected( Q3ListBoxItem * );
    void clearMessage();
    void queueCommand();
  
  private:
    void createButtons();
    void createLayout();
  
    void readConfig();
    void writeConfig();
  
    void insertQuotedMessage( const QString &quotedMsg );

    QComboBox *mRecipient;
    KTextEdit *mMessageEdit;
    QSplitter *mSplitter;
    K3ListBox *mPresets;

    Bug mBug;
    Package mPackage;
    MessageType mType;
};

#endif
