//
// C++ Interface: chunk
//
// Description: 
//
//
// Author: Andrea Rizzi <rizzi@kde.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef DBSE2_CHUNK_H
#define DBSE2_CHUNK_H
#include <qstring.h>
//Added by qt3to4:
#include <Q3PtrList>
#include "database.h"

/**
  * Abstract class for text chunks. 
  * Examples of chunks are "Words" or "Sentences"
  * This abstraction allow to use generic algorithm on chunks,
  * like chunkByChunk translation or chunk indexing.
  */
class AbstractChunk
{
    public:
    explicit AbstractChunk(DataBaseInterface *_di) {di=_di;}
    virtual ~AbstractChunk();
    /**
      * This function should return a list of translation for the current chunk.
      */
    virtual QList<QueryResult> translations()=0;
    
    //FIXME: is this in the right place, better in factory? check that stuff
    //virtual QValueList<QueryResult> translationsFromReference(uint reference)=0;
    virtual QList<uint> locationReferences()=0;
    virtual void setLocationReferences(QList<uint>)=0;
    virtual QString chunkString()=0;
    
    protected:
    DataBaseInterface *di;
};

/**
  * Concrete impl of Chunk, in this case chunks are words.
  */
class WordChunk : public AbstractChunk
{
    public:
    WordChunk(DataBaseInterface *di,QString _word);
    virtual QList<QueryResult> translations();
    //virtual QValueList<QueryResult> translationsFromReference(uint reference);
    virtual QList<uint> locationReferences();
    virtual void setLocationReferences(QList<uint>);
    virtual QString chunkString(){return word;}

    //static QValueList<WordChunk> divide(QString);
    private:
    QString word;
};

/**
  * Concrete impl of Chunk, in this case chunks are sentences.
  */
class SentenceChunk : public AbstractChunk
{
    public:
    SentenceChunk(DataBaseInterface *di,QString _sentence);
    virtual QList<QueryResult> translations();
    //virtual QValueList<QueryResult> translationsFromReference(uint reference);
    virtual QList<uint> locationReferences();
    virtual void setLocationReferences(QList<uint>);
    virtual QString chunkString(){return sentence;}

   // static QValueList<SentenceChunk> divide(QString);
    
    private:
    QString sentence;    
};


/**********************************
  CHUNK FACTORIES
**********************************/


class AbstractChunkFactory 
{
  public:
    AbstractChunkFactory(DataBaseInterface *_di)
    {
	di=_di;
    }
    virtual ~AbstractChunkFactory(){}
    virtual  Q3PtrList<AbstractChunk> chunks()=0;
    /**
      Change th string and return the chunks
      */
    virtual  Q3PtrList<AbstractChunk> chunks(const QString& s)
    {
	string=s;
	return chunks();
    }
    /**
      * Returns the list of separators of last @ref chunks() call
      */
    
    virtual  QStringList separators(){ return _separators;}
    void setQuery(const QString& s)
    {
	string=s;
    }
  protected:
    QString string;
    QStringList _separators;
    DataBaseInterface *di;
};

class WordChunkFactory : public AbstractChunkFactory
{
  public:
    explicit WordChunkFactory(DataBaseInterface *_di);
    /**
      YOU SHOULD DELETE THE CHUNKS!!
      */
    virtual  Q3PtrList<AbstractChunk> chunks();
};

class CaseBasedWordChunkFactory : public AbstractChunkFactory
{
  public:
    CaseBasedWordChunkFactory(DataBaseInterface *_di);
    /**
      YOU SHOULD DELETE THE CHUNKS!!
      */
    virtual  Q3PtrList<AbstractChunk> chunks();
};

class SentenceChunkFactory : public AbstractChunkFactory
{
  public:
    explicit SentenceChunkFactory(DataBaseInterface *_di);
    
    /**
      YOU SHOULD DELETE THE CHUNKS!!
      */
    virtual  Q3PtrList<AbstractChunk> chunks();
};


#endif //_CHUNK_H_
