/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2004 by Stanislav Visnovsky <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the Qt library by Trolltech AS, Norway (or with modified versions
  of Qt that use the same license as Qt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  Qt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.

**************************************************************************** */

#include "kbprojectmanager.h"

#include <kdebug.h>
#include <kstandarddirs.h>

#include <Q3PtrList>

namespace KBabel
{

Q3PtrList<Project> ProjectManager::p_list;
QString ProjectManager::strDefaultProjectName = QString();

QString ProjectManager::defaultProjectName()
{
    if (strDefaultProjectName.isEmpty())
        strDefaultProjectName = KStandardDirs::locateLocal("config", "kbabel.defaultproject");

    return strDefaultProjectName;
}


Project::Ptr ProjectManager::open(const QString & file)
{
    kDebug() << " " << file << endl;

    // TODO: ensure full path
    // TODO: isn't a map better?

    for (Q3PtrList<Project>::ConstIterator it = p_list.constBegin(); it != p_list.constEnd(); ++it) {
        if ((*it)->filename() == file) {
            kDebug() << " returning existing project " << (void *)it << endl;
            return Project::Ptr(*it);
        }
    }

    Project::Ptr f(new Project(file));

    if (!f->valid()) {
        kWarning() << "New invalid project for " << file << endl;
        return Project::Ptr();
    }

    kDebug() << " creating new project for " << file << endl;
    p_list.append(f.data());
    return f;
}

void ProjectManager::close(Project::Ptr project)
{
    // this does nothing, we don't really close projects ATM, just sync the configuration
    kDebug() << " closing project " << endl;
    project->config()->sync();
}

Project::Ptr ProjectManager::create()
{
    kWarning() << " was called!" << endl;
    // TODO:
    return Project::Ptr();
}

void ProjectManager::remove(Project *ref)
{
    kDebug() << " Final remove of project " << endl;
    p_list.remove(ref);
}

} // KBabel

// kate: space-indent on; indent-width 4; replace-tabs on;
