#include "serverconfigdialog.h"

#include "bugserverconfig.h"

#include <klineedit.h>
#include <kdebug.h>
#include <klocale.h>

#include <qlayout.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <q3vbox.h>
#include <qcombobox.h>
//Added by qt3to4:
#include <QGridLayout>

ServerConfigDialog::ServerConfigDialog( QWidget *parent, const char *name ) :
  KDialog( parent)
{
    setCaption( i18n("Edit Bugzilla Server") );
    setButtons( Ok|Cancel );
    setDefaultButton( Ok );
    setModal( true );

  QWidget *topFrame = new QWidget( this );
  setMainWidget( topFrame );

  QGridLayout *topLayout = new QGridLayout( topFrame );
  topLayout->setSpacing( spacingHint() );

  QLabel *label;

  mServerName = new QLineEdit( topFrame );
  label = new QLabel( i18n("Name:"), topFrame );
  label->setBuddy( mServerName );
  topLayout->addWidget( label, 0, 0 );
  topLayout->addWidget( mServerName, 0, 1 );
  mServerName->setFocus();

  mServerUrl = new QLineEdit( topFrame );
  label = new QLabel( i18n("URL:"), topFrame );
  label->setBuddy( mServerUrl );
  topLayout->addWidget( label, 1, 0 );
  topLayout->addWidget( mServerUrl, 1, 1 );

  mUser = new QLineEdit( topFrame );
  label = new QLabel( i18n("User:"), topFrame );
  label->setBuddy( mUser );
  topLayout->addWidget( label, 2, 0 );
  topLayout->addWidget( mUser, 2, 1 );

  mPassword = new KLineEdit( topFrame );
  mPassword->setPasswordMode(true);
  label = new QLabel( i18n("Password:"), topFrame );
  label->setBuddy( mPassword );
  topLayout->addWidget( label, 3, 0 );
  topLayout->addWidget( mPassword, 3, 1 );

  mVersion = new QComboBox( topFrame );
  label = new QLabel( i18n("Bugzilla version:"), topFrame );
  label->setBuddy( mVersion );
  topLayout->addWidget( label, 4, 0 );
  topLayout->addWidget( mVersion, 4, 1 );
  mVersion->addItems( BugServerConfig::bugzillaVersions() );
}

void ServerConfigDialog::setServerConfig( const BugServerConfig &cfg )
{
  mServerName->setText( cfg.name() );
  mServerUrl->setText( cfg.baseUrl().url() );
  mUser->setText( cfg.user() );
  mPassword->setText( cfg.password() );

  int i;
  for( i = 0; i < mVersion->count(); ++i ) {
    if ( mVersion->text( i ) == cfg.bugzillaVersion() ) {
      mVersion->setCurrentIndex( i );
      break;
    }
  }
}

BugServerConfig ServerConfigDialog::serverConfig()
{
  BugServerConfig cfg;

  cfg.setName( mServerName->text() );
  cfg.setBaseUrl( KUrl( mServerUrl->text() ) );
  cfg.setUser( mUser->text() );
  cfg.setPassword( mPassword->text() );
  cfg.setBugzillaVersion( mVersion->currentText() );

  return cfg;
}

#include "serverconfigdialog.moc"
