/* This file is part of KBabel
   Copyright (C) 2002 Stanislav Visnovsky <visnovsky@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the Qt library by Trolltech AS, Norway (or with modified versions
  of Qt that use the same license as Qt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  Qt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.

*/

#ifndef TOOLSELECTIONWIDGET_H
#define TOOLSELECTIONWIDGET_H

#include "kactionselector.h"
#include <kbabel_export.h>
//Added by qt3to4:
#include <Q3ValueList>

class KDataToolInfo;

class KBABELCOMMONUI_EXPORT ToolSelectionWidget : public KActionSelector
{
    Q_OBJECT
public:
    ToolSelectionWidget(QWidget* parent=0, const char* name=0 );
	
    QStringList selectedTools();
    
    void loadTools (const QStringList& commands, const Q3ValueList<KDataToolInfo> & tools);

public slots:
    void setSelectedTools( const QStringList& tools );
    
private:
    Q3ValueList<KDataToolInfo> _allTools;
};

#endif
