#!/bin/sh
#
# Install APIDOX tools. The API documentation tools are packaged in SVN
# as src/ and as data/ (to distinguish what's what) but are installed
# into a single directory.
#
# Usage:
#    install [--prefix=/dir]
 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA


# change TOP to whatever you like for your top-level installation directory
if ( test `hostname | egrep -c englishbreakfast` -gt 0 ) then
  EBN=1
  TOP=/usr/local/www/data-ebn/apidox
else
  EBN=0
  TOP=/usr/local/EBN
fi

# check command-line argument
case "$1" in
--prefix=*)
  TOP=`echo "$1" | sed -e 's+--prefix=++'`
  ;;
*)
  ;;
esac

# install the programs
cd src
perl Makefile.PL PREFIX=$TOP && \
make && \
make install && \
make realclean
#don't need the dust bunnies laying around
rm -rf $TOP/lib
cd ..

# install the templates
cd data
cp capacity-footer.html capacity-header.html \
   capacity-toplevel-footer.html capacity-toplevel-header.html \
   $TOP/bin

cp kde3-footer.html kde3-header.html \
   kde3-toplevel-footer.html kde3-toplevel-header.html \
   $TOP/bin
cd ..

chmod 755 $TOP/bin
chmod 755 $TOP/bin/nudox.pl
chmod 755 $TOP/bin/doxylog2html.pl

#EBN-specific post-installation stuff
if ( test $EBN -eq 1 ) then
  chmod ug+w $TOP/bin
  chmod ug+w $TOP/bin/nudox.pl
  chmod ug+w $TOP/bin/doxylog2html.pl
fi
