<tagfile>
  <compound kind="class">
    <name>QAccel</name>
    <filename>qaccel.html</filename>
    <member kind="function">
      <name>QAccel</name>
      <anchor>QAccel</anchor>
      <arglist>( QWidget * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QAccel</name>
      <anchor>QAccel</anchor>
      <arglist>( QWidget * watch, QObject * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QAccel</name>
      <anchor>QAccel</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>isEnabled</name>
      <anchor>isEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setEnabled</name>
      <anchor>setEnabled</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QKeySequence &amp; key, int id = -1 )</arglist>
    </member>
    <member kind="function">
      <name>removeItem</name>
      <anchor>removeItem</anchor>
      <arglist>( int id )</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>key</name>
      <anchor>key</anchor>
      <arglist>( int id )</arglist>
    </member>
    <member kind="function">
      <name>findKey</name>
      <anchor>findKey</anchor>
      <arglist>( const QKeySequence &amp; key ) const</arglist>
    </member>
    <member kind="function">
      <name>isItemEnabled</name>
      <anchor>isItemEnabled</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>setItemEnabled</name>
      <anchor>setItemEnabled</anchor>
      <arglist>( int id, bool enable )</arglist>
    </member>
    <member kind="function">
      <name>connectItem</name>
      <anchor>connectItem</anchor>
      <arglist>( int id, const QObject * receiver, const char * member )</arglist>
    </member>
    <member kind="function">
      <name>disconnectItem</name>
      <anchor>disconnectItem</anchor>
      <arglist>( int id, const QObject * receiver, const char * member )</arglist>
    </member>
    <member kind="function">
      <name>setWhatsThis</name>
      <anchor>setWhatsThis</anchor>
      <arglist>( int id, const QString &amp; text )</arglist>
    </member>
    <member kind="function">
      <name>whatsThis</name>
      <anchor>whatsThis</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>activated</name>
      <anchor>activated</anchor>
      <arglist>( int id )</arglist>
    </member>
    <member kind="function">
      <name>activatedAmbiguously</name>
      <anchor>activatedAmbiguously</anchor>
      <arglist>( int id )</arglist>
    </member>
    <member kind="function">
      <name>shortcutKey</name>
      <anchor>shortcutKey</anchor>
      <arglist>( const QString &amp; str )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QAccessible</name>
    <filename>qaccessible.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>Event</anchor>
      <arglist>{ SoundPlayed = 0x0001, Alert = 0x0002, ForegroundChanged = 0x0003, MenuStart = 0x0004, MenuEnd = 0x0005, PopupMenuStart = 0x0006, PopupMenuEnd = 0x0007, ContextHelpStart = 0x000C, ContextHelpEnd = 0x000D, DragDropStart = 0x000E, DragDropEnd = 0x000F, DialogStart = 0x0010, DialogEnd = 0x0011, ScrollingStart = 0x0012, ScrollingEnd = 0x0013, MenuCommand = 0x0018, ObjectCreated = 0x8000, ObjectDestroyed = 0x8001, ObjectShow = 0x8002, ObjectHide = 0x8003, ObjectReorder = 0x8004, Focus = 0x8005, Selection = 0x8006, SelectionAdd = 0x8007, SelectionRemove = 0x8008, SelectionWithin = 0x8009, StateChanged = 0x800A, LocationChanged = 0x800B, NameChanged = 0x800C, DescriptionChanged = 0x800D, ValueChanged = 0x800E, ParentChanged = 0x800F, HelpChanged = 0x80A0, DefaultActionChanged = 0x80B0, AcceleratorChanged = 0x80C0 }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>State</anchor>
      <arglist>{ Normal = 0x00000000, Unavailable = 0x00000001, Selected = 0x00000002, Focused = 0x00000004, Pressed = 0x00000008, Checked = 0x00000010, Mixed = 0x00000020, ReadOnly = 0x00000040, HotTracked = 0x00000080, Default = 0x00000100, Expanded = 0x00000200, Collapsed = 0x00000400, Busy = 0x00000800, Floating = 0x00001000, Marqueed = 0x00002000, Animated = 0x00004000, Invisible = 0x00008000, Offscreen = 0x00010000, Sizeable = 0x00020000, Moveable = 0x00040000, SelfVoicing = 0x00080000, Focusable = 0x00100000, Selectable = 0x00200000, Linked = 0x00400000, Traversed = 0x00800000, MultiSelectable = 0x01000000, ExtSelectable = 0x02000000, AlertLow = 0x04000000, AlertMedium = 0x08000000, AlertHigh = 0x10000000, Protected = 0x20000000, Valid = 0x3fffffff }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Role</anchor>
      <arglist>{ NoRole = 0x00000000, TitleBar = 0x00000001, MenuBar = 0x00000002, ScrollBar = 0x00000003, Grip = 0x00000004, Sound = 0x00000005, Cursor = 0x00000006, Caret = 0x00000007, AlertMessage = 0x00000008, Window = 0x00000009, Client = 0x0000000A, PopupMenu = 0x0000000B, MenuItem = 0x0000000C, ToolTip = 0x0000000D, Application = 0x0000000E, Document = 0x0000000F, Pane = 0x00000010, Chart = 0x00000011, Dialog = 0x00000012, Border = 0x00000013, Grouping = 0x00000014, Separator = 0x00000015, ToolBar = 0x00000016, StatusBar = 0x00000017, Table = 0x00000018, ColumnHeader = 0x00000019, RowHeader = 0x0000001A, Column = 0x0000001B, Row = 0x0000001C, Cell = 0x0000001D, Link = 0x0000001E, HelpBalloon = 0x0000001F, Character = 0x00000020, List = 0x00000021, ListItem = 0x00000022, Outline = 0x00000023, OutlineItem = 0x00000024, PageTab = 0x00000025, PropertyPage = 0x00000026, Indicator = 0x00000027, Graphic = 0x00000028, StaticText = 0x00000029, EditableText = 0x0000002A, PushButton = 0x0000002B, CheckBox = 0x0000002C, RadioButton = 0x0000002D, ComboBox = 0x0000002E, DropLest = 0x0000002F, ProgressBar = 0x00000030, Dial = 0x00000031, HotkeyField = 0x00000032, Slider = 0x00000033, SpinBox = 0x00000034, Diagram = 0x00000035, Animation = 0x00000036, Equation = 0x00000037, ButtonDropDown = 0x00000038, ButtonMenu = 0x00000039, ButtonDropGrid = 0x0000003A, Whitespace = 0x0000003B, PageTabList = 0x0000003C, Clock = 0x0000003D }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>NavDirection</anchor>
      <arglist>{ NavUp = 0x00000001, NavDown = 0x00000002, NavLeft = 0x00000003, NavRight = 0x00000004, NavNext = 0x00000005, NavPrevious = 0x00000006, NavFirstChild = 0x00000007, NavLastChild = 0x00000008, NavFocusChild = 0x00000009 }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Text</anchor>
      <arglist>{ Name = 0, Description, Value, Help, Accelerator, DefaultAction }</arglist>
    </member>
    <member kind="function">
      <name>queryAccessibleInterface</name>
      <anchor>queryAccessibleInterface</anchor>
      <arglist>( QObject * object, QAccessibleInterface ** iface )</arglist>
    </member>
    <member kind="function">
      <name>updateAccessibility</name>
      <anchor>updateAccessibility</anchor>
      <arglist>( QObject * object, int control, Event reason )</arglist>
    </member>
    <member kind="function">
      <name>isActive</name>
      <anchor>isActive</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QAccessibleInterface</name>
    <filename>qaccessibleinterface.html</filename>
    <member kind="function">
      <name>isValid</name>
      <anchor>isValid</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>childCount</name>
      <anchor>childCount</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>queryChild</name>
      <anchor>queryChild</anchor>
      <arglist>( int control, QAccessibleInterface ** iface ) const = 0</arglist>
    </member>
    <member kind="function">
      <name>queryParent</name>
      <anchor>queryParent</anchor>
      <arglist>( QAccessibleInterface ** iface ) const = 0</arglist>
    </member>
    <member kind="function">
      <name>controlAt</name>
      <anchor>controlAt</anchor>
      <arglist>( int x, int y ) const = 0</arglist>
    </member>
    <member kind="function">
      <name>rect</name>
      <anchor>rect</anchor>
      <arglist>( int control ) const = 0</arglist>
    </member>
    <member kind="function">
      <name>navigate</name>
      <anchor>navigate</anchor>
      <arglist>( NavDirection direction, int startControl ) const = 0</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>( Text t, int control ) const = 0</arglist>
    </member>
    <member kind="function">
      <name>setText</name>
      <anchor>setText</anchor>
      <arglist>( Text t, int control, const QString &amp; text ) = 0</arglist>
    </member>
    <member kind="function">
      <name>role</name>
      <anchor>role</anchor>
      <arglist>( int control ) const = 0</arglist>
    </member>
    <member kind="function">
      <name>state</name>
      <anchor>state</anchor>
      <arglist>( int control ) const = 0</arglist>
    </member>
    <member kind="function">
      <name>selection</name>
      <anchor>selection</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>doDefaultAction</name>
      <anchor>doDefaultAction</anchor>
      <arglist>( int control ) = 0</arglist>
    </member>
    <member kind="function">
      <name>setFocus</name>
      <anchor>setFocus</anchor>
      <arglist>( int control ) = 0</arglist>
    </member>
    <member kind="function">
      <name>setSelected</name>
      <anchor>setSelected</anchor>
      <arglist>( int control, bool on, bool extend ) = 0</arglist>
    </member>
    <member kind="function">
      <name>clearSelection</name>
      <anchor>clearSelection</anchor>
      <arglist>() = 0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QAccessibleObject</name>
    <filename>qaccessibleobject.html</filename>
    <member kind="function">
      <name>QAccessibleObject</name>
      <anchor>QAccessibleObject</anchor>
      <arglist>( QObject * object )</arglist>
    </member>
    <member kind="function">
      <name>QAccessibleObject</name>
      <anchor>QAccessibleObject</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>object</name>
      <anchor>object</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QAction</name>
    <filename>qaction.html</filename>
    <member kind="function">
      <name>QAction</name>
      <anchor>QAction</anchor>
      <arglist>( QObject * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QAction</name>
      <anchor>QAction</anchor>
      <arglist>( const QString &amp; menuText, QKeySequence accel, QObject * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QAction</name>
      <anchor>QAction</anchor>
      <arglist>( const QIconSet &amp; icon, const QString &amp; menuText, QKeySequence accel, QObject * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QAction</name>
      <anchor>QAction</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setIconSet</name>
      <anchor>setIconSet</anchor>
      <arglist>( const QIconSet &amp; )</arglist>
    </member>
    <member kind="function">
      <name>iconSet</name>
      <anchor>iconSet</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setText</name>
      <anchor>setText</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMenuText</name>
      <anchor>setMenuText</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>menuText</name>
      <anchor>menuText</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setToolTip</name>
      <anchor>setToolTip</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>toolTip</name>
      <anchor>toolTip</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setStatusTip</name>
      <anchor>setStatusTip</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>statusTip</name>
      <anchor>statusTip</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setWhatsThis</name>
      <anchor>setWhatsThis</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>whatsThis</name>
      <anchor>whatsThis</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAccel</name>
      <anchor>setAccel</anchor>
      <arglist>( const QKeySequence &amp; key )</arglist>
    </member>
    <member kind="function">
      <name>accel</name>
      <anchor>accel</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setToggleAction</name>
      <anchor>setToggleAction</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>isToggleAction</name>
      <anchor>isToggleAction</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isOn</name>
      <anchor>isOn</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEnabled</name>
      <anchor>isEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isVisible</name>
      <anchor>isVisible</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>addTo</name>
      <anchor>addTo</anchor>
      <arglist>( QWidget * w )</arglist>
    </member>
    <member kind="function">
      <name>removeFrom</name>
      <anchor>removeFrom</anchor>
      <arglist>( QWidget * w )</arglist>
    </member>
    <member kind="function">
      <name>toggle</name>
      <anchor>toggle</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setOn</name>
      <anchor>setOn</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>setEnabled</name>
      <anchor>setEnabled</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>setVisible</name>
      <anchor>setVisible</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>activated</name>
      <anchor>activated</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toggled</name>
      <anchor>toggled</anchor>
      <arglist>( bool on )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>accel</anchor>
      <arglist>- the action&apos;s accelerator key</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>enabled</anchor>
      <arglist>- whether the action is enabled</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>iconSet</anchor>
      <arglist>- the action&apos;s icon</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>menuText</anchor>
      <arglist>- the action&apos;s menu text</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>on</anchor>
      <arglist>- whether a toggle action is on</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>statusTip</anchor>
      <arglist>- the action&apos;s status tip</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>text</anchor>
      <arglist>- the action&apos;s descriptive text</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>toggleAction</anchor>
      <arglist>- whether the action is a toggle action</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>toolTip</anchor>
      <arglist>- the action&apos;s tool tip</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>visible</anchor>
      <arglist>- whether the action can be seen (e.g. in menus and toolbars)</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>whatsThis</anchor>
      <arglist>- the action&apos;s &quot;What&apos;s This?&quot; help text</arglist>
    </member>
    <member kind="function">
      <name>addedTo</name>
      <anchor>addedTo</anchor>
      <arglist>( QWidget * actionWidget, QWidget * container )</arglist>
    </member>
    <member kind="function">
      <name>addedTo</name>
      <anchor>addedTo</anchor>
      <arglist>( int index, QPopupMenu * menu )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QActionGroup</name>
    <filename>qactiongroup.html</filename>
    <member kind="function">
      <name>QActionGroup</name>
      <anchor>QActionGroup</anchor>
      <arglist>( QObject * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QActionGroup</name>
      <anchor>QActionGroup</anchor>
      <arglist>( QObject * parent, const char * name, bool exclusive )</arglist>
    </member>
    <member kind="function">
      <name>QActionGroup</name>
      <anchor>QActionGroup</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setExclusive</name>
      <anchor>setExclusive</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>isExclusive</name>
      <anchor>isExclusive</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>add</name>
      <anchor>add</anchor>
      <arglist>( QAction * action )</arglist>
    </member>
    <member kind="function">
      <name>addSeparator</name>
      <anchor>addSeparator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>addTo</name>
      <anchor>addTo</anchor>
      <arglist>( QWidget * w )</arglist>
    </member>
    <member kind="function">
      <name>setUsesDropDown</name>
      <anchor>setUsesDropDown</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>usesDropDown</name>
      <anchor>usesDropDown</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>selected</name>
      <anchor>selected</anchor>
      <arglist>( QAction * )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>exclusive</anchor>
      <arglist>- whether the action group does exclusive toggling</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>usesDropDown</anchor>
      <arglist>- whether the group&apos;s actions are displayed in a subwidget of the widgets the action group is added to</arglist>
    </member>
    <member kind="function">
      <name>addedTo</name>
      <anchor>addedTo</anchor>
      <arglist>( QWidget * actionWidget, QWidget * container, QAction * a )</arglist>
    </member>
    <member kind="function">
      <name>addedTo</name>
      <anchor>addedTo</anchor>
      <arglist>( int index, QPopupMenu * menu, QAction * a )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QApplication</name>
    <filename>qapplication.html</filename>
    <member kind="function">
      <name>QApplication</name>
      <anchor>QApplication</anchor>
      <arglist>( int &amp; argc, char ** argv )</arglist>
    </member>
    <member kind="function">
      <name>QApplication</name>
      <anchor>QApplication</anchor>
      <arglist>( int &amp; argc, char ** argv, bool GUIenabled )</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Type</anchor>
      <arglist>{ Tty, GuiClient, GuiServer }</arglist>
    </member>
    <member kind="function">
      <name>QApplication</name>
      <anchor>QApplication</anchor>
      <arglist>( int &amp; argc, char ** argv, Type type )</arglist>
    </member>
    <member kind="function">
      <name>QApplication</name>
      <anchor>QApplication</anchor>
      <arglist>( Display * dpy, HANDLE visual = 0, HANDLE colormap = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QApplication</name>
      <anchor>QApplication</anchor>
      <arglist>( Display * dpy, int argc, char ** argv, HANDLE visual = 0, HANDLE colormap = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QApplication</name>
      <anchor>QApplication</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>argc</name>
      <anchor>argc</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>argv</name>
      <anchor>argv</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>type</name>
      <anchor>type</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ColorSpec</anchor>
      <arglist>{ NormalColor = 0, CustomColor = 1, ManyColor = 2 }</arglist>
    </member>
    <member kind="function">
      <name>mainWidget</name>
      <anchor>mainWidget</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMainWidget</name>
      <anchor>setMainWidget</anchor>
      <arglist>( QWidget * mainWidget )</arglist>
    </member>
    <member kind="function">
      <name>polish</name>
      <anchor>polish</anchor>
      <arglist>( QWidget * w )</arglist>
    </member>
    <member kind="function">
      <name>focusWidget</name>
      <anchor>focusWidget</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>activeWindow</name>
      <anchor>activeWindow</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>exec</name>
      <anchor>exec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>processEvents</name>
      <anchor>processEvents</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>processEvents</name>
      <anchor>processEvents</anchor>
      <arglist>( int maxtime )</arglist>
    </member>
    <member kind="function">
      <name>hasPendingEvents</name>
      <anchor>hasPendingEvents</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>notify</name>
      <anchor>notify</anchor>
      <arglist>( QObject * receiver, QEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>installTranslator</name>
      <anchor>installTranslator</anchor>
      <arglist>( QTranslator * mf )</arglist>
    </member>
    <member kind="function">
      <name>removeTranslator</name>
      <anchor>removeTranslator</anchor>
      <arglist>( QTranslator * mf )</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Encoding</anchor>
      <arglist>{ DefaultCodec, UnicodeUTF8 }</arglist>
    </member>
    <member kind="function">
      <name>translate</name>
      <anchor>translate</anchor>
      <arglist>( const char * context, const char * sourceText, const char * comment = 0, Encoding encoding = DefaultCodec ) const</arglist>
    </member>
    <member kind="function">
      <name>applicationDirPath</name>
      <anchor>applicationDirPath</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>applicationFilePath</name>
      <anchor>applicationFilePath</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>macEventFilter</name>
      <anchor>macEventFilter</anchor>
      <arglist>( EventHandlerCallRef, EventRef )</arglist>
    </member>
    <member kind="function">
      <name>winEventFilter</name>
      <anchor>winEventFilter</anchor>
      <arglist>( MSG * )</arglist>
    </member>
    <member kind="function">
      <name>x11EventFilter</name>
      <anchor>x11EventFilter</anchor>
      <arglist>( XEvent * )</arglist>
    </member>
    <member kind="function">
      <name>x11ProcessEvent</name>
      <anchor>x11ProcessEvent</anchor>
      <arglist>( XEvent * event )</arglist>
    </member>
    <member kind="function">
      <name>qwsEventFilter</name>
      <anchor>qwsEventFilter</anchor>
      <arglist>( QWSEvent * )</arglist>
    </member>
    <member kind="function">
      <name>qwsSetCustomColors</name>
      <anchor>qwsSetCustomColors</anchor>
      <arglist>( QRgb * colorTable, int start, int numColors )</arglist>
    </member>
    <member kind="function">
      <name>winFocus</name>
      <anchor>winFocus</anchor>
      <arglist>( QWidget * widget, bool gotFocus )</arglist>
    </member>
    <member kind="function">
      <name>isSessionRestored</name>
      <anchor>isSessionRestored</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>sessionId</name>
      <anchor>sessionId</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>sessionKey</name>
      <anchor>sessionKey</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>commitData</name>
      <anchor>commitData</anchor>
      <arglist>( QSessionManager &amp; sm )</arglist>
    </member>
    <member kind="function">
      <name>saveState</name>
      <anchor>saveState</anchor>
      <arglist>( QSessionManager &amp; sm )</arglist>
    </member>
    <member kind="function">
      <name>wakeUpGuiThread</name>
      <anchor>wakeUpGuiThread</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>lock</name>
      <anchor>lock</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>unlock</name>
      <anchor>unlock</anchor>
      <arglist>( bool wakeUpGui = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>locked</name>
      <anchor>locked</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>tryLock</name>
      <anchor>tryLock</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>quit</name>
      <anchor>quit</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>closeAllWindows</name>
      <anchor>closeAllWindows</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>aboutQt</name>
      <anchor>aboutQt</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>lastWindowClosed</name>
      <anchor>lastWindowClosed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>aboutToQuit</name>
      <anchor>aboutToQuit</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>guiThreadAwake</name>
      <anchor>guiThreadAwake</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>style</name>
      <anchor>style</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setStyle</name>
      <anchor>setStyle</anchor>
      <arglist>( QStyle * style )</arglist>
    </member>
    <member kind="function">
      <name>setStyle</name>
      <anchor>setStyle</anchor>
      <arglist>( const QString &amp; style )</arglist>
    </member>
    <member kind="function">
      <name>colorSpec</name>
      <anchor>colorSpec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setColorSpec</name>
      <anchor>setColorSpec</anchor>
      <arglist>( int spec )</arglist>
    </member>
    <member kind="function">
      <name>overrideCursor</name>
      <anchor>overrideCursor</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setOverrideCursor</name>
      <anchor>setOverrideCursor</anchor>
      <arglist>( const QCursor &amp; cursor, bool replace = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>restoreOverrideCursor</name>
      <anchor>restoreOverrideCursor</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>hasGlobalMouseTracking</name>
      <anchor>hasGlobalMouseTracking</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setGlobalMouseTracking</name>
      <anchor>setGlobalMouseTracking</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>palette</name>
      <anchor>palette</anchor>
      <arglist>( const QWidget * w = 0 )</arglist>
    </member>
    <member kind="function">
      <name>setPalette</name>
      <anchor>setPalette</anchor>
      <arglist>( const QPalette &amp; palette, bool informWidgets = FALSE, const char * className = 0 )</arglist>
    </member>
    <member kind="function">
      <name>font</name>
      <anchor>font</anchor>
      <arglist>( const QWidget * w = 0 )</arglist>
    </member>
    <member kind="function">
      <name>setFont</name>
      <anchor>setFont</anchor>
      <arglist>( const QFont &amp; font, bool informWidgets = FALSE, const char * className = 0 )</arglist>
    </member>
    <member kind="function">
      <name>fontMetrics</name>
      <anchor>fontMetrics</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>allWidgets</name>
      <anchor>allWidgets</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>topLevelWidgets</name>
      <anchor>topLevelWidgets</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>desktop</name>
      <anchor>desktop</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>activePopupWidget</name>
      <anchor>activePopupWidget</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>activeModalWidget</name>
      <anchor>activeModalWidget</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>clipboard</name>
      <anchor>clipboard</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>widgetAt</name>
      <anchor>widgetAt</anchor>
      <arglist>( int x, int y, bool child = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>widgetAt</name>
      <anchor>widgetAt</anchor>
      <arglist>( const QPoint &amp; pos, bool child = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>eventLoop</name>
      <anchor>eventLoop</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>exit</name>
      <anchor>exit</anchor>
      <arglist>( int retcode = 0 )</arglist>
    </member>
    <member kind="function">
      <name>sendEvent</name>
      <anchor>sendEvent</anchor>
      <arglist>( QObject * receiver, QEvent * event )</arglist>
    </member>
    <member kind="function">
      <name>postEvent</name>
      <anchor>postEvent</anchor>
      <arglist>( QObject * receiver, QEvent * event )</arglist>
    </member>
    <member kind="function">
      <name>sendPostedEvents</name>
      <anchor>sendPostedEvents</anchor>
      <arglist>( QObject * receiver, int event_type )</arglist>
    </member>
    <member kind="function">
      <name>sendPostedEvents</name>
      <anchor>sendPostedEvents</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>removePostedEvents</name>
      <anchor>removePostedEvents</anchor>
      <arglist>( QObject * receiver )</arglist>
    </member>
    <member kind="function">
      <name>startingUp</name>
      <anchor>startingUp</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>closingDown</name>
      <anchor>closingDown</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>flushX</name>
      <anchor>flushX</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>flush</name>
      <anchor>flush</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>syncX</name>
      <anchor>syncX</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>beep</name>
      <anchor>beep</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setDesktopSettingsAware</name>
      <anchor>setDesktopSettingsAware</anchor>
      <arglist>( bool on )</arglist>
    </member>
    <member kind="function">
      <name>desktopSettingsAware</name>
      <anchor>desktopSettingsAware</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setCursorFlashTime</name>
      <anchor>setCursorFlashTime</anchor>
      <arglist>( int msecs )</arglist>
    </member>
    <member kind="function">
      <name>cursorFlashTime</name>
      <anchor>cursorFlashTime</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setDoubleClickInterval</name>
      <anchor>setDoubleClickInterval</anchor>
      <arglist>( int ms )</arglist>
    </member>
    <member kind="function">
      <name>doubleClickInterval</name>
      <anchor>doubleClickInterval</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setWheelScrollLines</name>
      <anchor>setWheelScrollLines</anchor>
      <arglist>( int n )</arglist>
    </member>
    <member kind="function">
      <name>wheelScrollLines</name>
      <anchor>wheelScrollLines</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setGlobalStrut</name>
      <anchor>setGlobalStrut</anchor>
      <arglist>( const QSize &amp; strut )</arglist>
    </member>
    <member kind="function">
      <name>globalStrut</name>
      <anchor>globalStrut</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setLibraryPaths</name>
      <anchor>setLibraryPaths</anchor>
      <arglist>( const QStringList &amp; paths )</arglist>
    </member>
    <member kind="function">
      <name>libraryPaths</name>
      <anchor>libraryPaths</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>addLibraryPath</name>
      <anchor>addLibraryPath</anchor>
      <arglist>( const QString &amp; path )</arglist>
    </member>
    <member kind="function">
      <name>removeLibraryPath</name>
      <anchor>removeLibraryPath</anchor>
      <arglist>( const QString &amp; path )</arglist>
    </member>
    <member kind="function">
      <name>setStartDragTime</name>
      <anchor>setStartDragTime</anchor>
      <arglist>( int ms )</arglist>
    </member>
    <member kind="function">
      <name>startDragTime</name>
      <anchor>startDragTime</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setStartDragDistance</name>
      <anchor>setStartDragDistance</anchor>
      <arglist>( int l )</arglist>
    </member>
    <member kind="function">
      <name>startDragDistance</name>
      <anchor>startDragDistance</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setReverseLayout</name>
      <anchor>setReverseLayout</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>reverseLayout</name>
      <anchor>reverseLayout</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>horizontalAlignment</name>
      <anchor>horizontalAlignment</anchor>
      <arglist>( int align )</arglist>
    </member>
    <member kind="function">
      <name>isEffectEnabled</name>
      <anchor>isEffectEnabled</anchor>
      <arglist>( Qt::UIEffect effect )</arglist>
    </member>
    <member kind="function">
      <name>setEffectEnabled</name>
      <anchor>setEffectEnabled</anchor>
      <arglist>( Qt::UIEffect effect, bool enable = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>qwsDecoration</name>
      <anchor>qwsDecoration</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>qwsSetDecoration</name>
      <anchor>qwsSetDecoration</anchor>
      <arglist>( QWSDecoration * d )</arglist>
    </member>
    <member kind="function">
      <name>qAddPostRoutine</name>
      <anchor>qAddPostRoutine</anchor>
      <arglist>( QtCleanUpFunction p )</arglist>
    </member>
    <member kind="function">
      <name>qVersion</name>
      <anchor>qVersion</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>qSysInfo</name>
      <anchor>qSysInfo</anchor>
      <arglist>( int * wordSize, bool * bigEndian )</arglist>
    </member>
    <member kind="function">
      <name>qDebug</name>
      <anchor>qDebug</anchor>
      <arglist>( const char * msg, ... )</arglist>
    </member>
    <member kind="function">
      <name>qWarning</name>
      <anchor>qWarning</anchor>
      <arglist>( const char * msg, ... )</arglist>
    </member>
    <member kind="function">
      <name>qFatal</name>
      <anchor>qFatal</anchor>
      <arglist>( const char * msg, ... )</arglist>
    </member>
    <member kind="function">
      <name>qSystemWarning</name>
      <anchor>qSystemWarning</anchor>
      <arglist>( const char * msg, int code )</arglist>
    </member>
    <member kind="function">
      <name>Q_ASSERT</name>
      <anchor>Q_ASSERT</anchor>
      <arglist>( bool test )</arglist>
    </member>
    <member kind="function">
      <name>Q_CHECK_PTR</name>
      <anchor>Q_CHECK_PTR</anchor>
      <arglist>( void * p )</arglist>
    </member>
    <member kind="function">
      <name>qInstallMsgHandler</name>
      <anchor>qInstallMsgHandler</anchor>
      <arglist>( QtMsgHandler h )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QArray</name>
    <filename>qarray.html</filename>
  </compound>
  <compound kind="class">
    <name>QAsciiCache</name>
    <filename>qasciicache.html</filename>
    <member kind="function">
      <name>QAsciiCache</name>
      <anchor>QAsciiCache</anchor>
      <arglist>( int maxCost = 100, int size = 17, bool caseSensitive = TRUE, bool copyKeys = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>QAsciiCache</name>
      <anchor>QAsciiCache</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>maxCost</name>
      <anchor>maxCost</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>totalCost</name>
      <anchor>totalCost</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMaxCost</name>
      <anchor>setMaxCost</anchor>
      <arglist>( int m )</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>insert</name>
      <anchor>insert</anchor>
      <arglist>( const char * k, const type * d, int c = 1, int p = 0 )</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>( const char * k )</arglist>
    </member>
    <member kind="function">
      <name>take</name>
      <anchor>take</anchor>
      <arglist>( const char * k )</arglist>
    </member>
    <member kind="function">
      <name>find</name>
      <anchor>find</anchor>
      <arglist>( const char * k, bool ref = TRUE ) const</arglist>
    </member>
    <member kind="function">
      <name>operator[]</name>
      <anchor>operator</anchor>
      <arglist>( const char * k ) const</arglist>
    </member>
    <member kind="function">
      <name>statistics</name>
      <anchor>statistics</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QAsciiCacheIterator</name>
    <filename>qasciicacheiterator.html</filename>
    <member kind="function">
      <name>QAsciiCacheIterator</name>
      <anchor>QAsciiCacheIterator</anchor>
      <arglist>( const QAsciiCache&lt;type&gt; &amp; cache )</arglist>
    </member>
    <member kind="function">
      <name>QAsciiCacheIterator</name>
      <anchor>QAsciiCacheIterator</anchor>
      <arglist>( const QAsciiCacheIterator&lt;type&gt; &amp; ci )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QAsciiCacheIterator&lt;type&gt; &amp; ci )</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>atFirst</name>
      <anchor>atFirst</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>atLast</name>
      <anchor>atLast</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>toFirst</name>
      <anchor>toFirst</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toLast</name>
      <anchor>toLast</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>type</name>
      <anchor>operator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>current</name>
      <anchor>current</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>currentKey</name>
      <anchor>currentKey</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>operator()</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>operator++</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( uint jump )</arglist>
    </member>
    <member kind="function">
      <name>operator--</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( uint jump )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QAsciiDict</name>
    <filename>qasciidict.html</filename>
    <member kind="function">
      <name>QAsciiDict</name>
      <anchor>QAsciiDict</anchor>
      <arglist>( int size = 17, bool caseSensitive = TRUE, bool copyKeys = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>QAsciiDict</name>
      <anchor>QAsciiDict</anchor>
      <arglist>( const QAsciiDict&lt;type&gt; &amp; dict )</arglist>
    </member>
    <member kind="function">
      <name>QAsciiDict</name>
      <anchor>QAsciiDict</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QAsciiDict&lt;type&gt; &amp; dict )</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>insert</name>
      <anchor>insert</anchor>
      <arglist>( const char * key, const type * item )</arglist>
    </member>
    <member kind="function">
      <name>replace</name>
      <anchor>replace</anchor>
      <arglist>( const char * key, const type * item )</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>( const char * key )</arglist>
    </member>
    <member kind="function">
      <name>take</name>
      <anchor>take</anchor>
      <arglist>( const char * key )</arglist>
    </member>
    <member kind="function">
      <name>find</name>
      <anchor>find</anchor>
      <arglist>( const char * key ) const</arglist>
    </member>
    <member kind="function">
      <name>operator[]</name>
      <anchor>operator</anchor>
      <arglist>( const char * key ) const</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>resize</name>
      <anchor>resize</anchor>
      <arglist>( uint newsize )</arglist>
    </member>
    <member kind="function">
      <name>statistics</name>
      <anchor>statistics</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>autoDelete</name>
      <anchor>autoDelete</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoDelete</name>
      <anchor>setAutoDelete</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>read</name>
      <anchor>read</anchor>
      <arglist>( QDataStream &amp; s, QPtrCollection::Item &amp; item )</arglist>
    </member>
    <member kind="function">
      <name>write</name>
      <anchor>write</anchor>
      <arglist>( QDataStream &amp; s, QPtrCollection::Item ) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QAsciiDictIterator</name>
    <filename>qasciidictiterator.html</filename>
    <member kind="function">
      <name>QAsciiDictIterator</name>
      <anchor>QAsciiDictIterator</anchor>
      <arglist>( const QAsciiDict&lt;type&gt; &amp; dict )</arglist>
    </member>
    <member kind="function">
      <name>QAsciiDictIterator</name>
      <anchor>QAsciiDictIterator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>toFirst</name>
      <anchor>toFirst</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>type</name>
      <anchor>operator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>current</name>
      <anchor>current</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>currentKey</name>
      <anchor>currentKey</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>operator()</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>operator++</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( uint jump )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QAssistantClient</name>
    <filename>qassistantclient.html</filename>
    <member kind="function">
      <name>QAssistantClient</name>
      <anchor>QAssistantClient</anchor>
      <arglist>( const QString &amp; path, QObject * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QAssistantClient</name>
      <anchor>QAssistantClient</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>isOpen</name>
      <anchor>isOpen</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setArguments</name>
      <anchor>setArguments</anchor>
      <arglist>( const QStringList &amp; args )</arglist>
    </member>
    <member kind="function">
      <name>openAssistant</name>
      <anchor>openAssistant</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>closeAssistant</name>
      <anchor>closeAssistant</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>showPage</name>
      <anchor>showPage</anchor>
      <arglist>( const QString &amp; page )</arglist>
    </member>
    <member kind="function">
      <name>assistantOpened</name>
      <anchor>assistantOpened</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>assistantClosed</name>
      <anchor>assistantClosed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>error</name>
      <anchor>error</anchor>
      <arglist>( const QString &amp; msg )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>open</anchor>
      <arglist>- whether Qt Assistant is open</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QAsyncIO</name>
    <filename>qasyncio.html</filename>
    <member kind="function">
      <name>QAsyncIO</name>
      <anchor>QAsyncIO</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>connect</name>
      <anchor>connect</anchor>
      <arglist>( QObject * obj, const char * member )</arglist>
    </member>
    <member kind="function">
      <name>ready</name>
      <anchor>ready</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QBig5Codec</name>
    <filename>qbig5codec.html</filename>
  </compound>
  <compound kind="class">
    <name>QBig5hkscsCodec</name>
    <filename>qbig5hkscscodec.html</filename>
  </compound>
  <compound kind="class">
    <name>QBitArray</name>
    <filename>qbitarray.html</filename>
    <member kind="function">
      <name>QBitArray</name>
      <anchor>QBitArray</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QBitArray</name>
      <anchor>QBitArray</anchor>
      <arglist>( uint size )</arglist>
    </member>
    <member kind="function">
      <name>QBitArray</name>
      <anchor>QBitArray</anchor>
      <arglist>( const QBitArray &amp; a )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QBitArray &amp; a )</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>resize</name>
      <anchor>resize</anchor>
      <arglist>( uint size )</arglist>
    </member>
    <member kind="function">
      <name>fill</name>
      <anchor>fill</anchor>
      <arglist>( bool v, int size = -1 )</arglist>
    </member>
    <member kind="function">
      <name>detach</name>
      <anchor>detach</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>copy</name>
      <anchor>copy</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>testBit</name>
      <anchor>testBit</anchor>
      <arglist>( uint index ) const</arglist>
    </member>
    <member kind="function">
      <name>setBit</name>
      <anchor>setBit</anchor>
      <arglist>( uint index )</arglist>
    </member>
    <member kind="function">
      <name>setBit</name>
      <anchor>setBit</anchor>
      <arglist>( uint index, bool value )</arglist>
    </member>
    <member kind="function">
      <name>clearBit</name>
      <anchor>clearBit</anchor>
      <arglist>( uint index )</arglist>
    </member>
    <member kind="function">
      <name>toggleBit</name>
      <anchor>toggleBit</anchor>
      <arglist>( uint index )</arglist>
    </member>
    <member kind="function">
      <name>at</name>
      <anchor>at</anchor>
      <arglist>( uint index ) const</arglist>
    </member>
    <member kind="function">
      <name>operator[]</name>
      <anchor>operator</anchor>
      <arglist>( int index )</arglist>
    </member>
    <member kind="function">
      <name>operator[]</name>
      <anchor>operator</anchor>
      <arglist>( int index ) const</arglist>
    </member>
    <member kind="function">
      <name>and</name>
      <anchor>operator</anchor>
      <arglist>( const QBitArray &amp; a )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QBitArray &amp; a )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QBitArray &amp; a )</arglist>
    </member>
    <member kind="function">
      <name>b</name>
      <anchor>operator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>and</name>
      <anchor>operator</anchor>
      <arglist>( const QBitArray &amp; a1, const QBitArray &amp; a2 )</arglist>
    </member>
    <member kind="function">
      <name>operator|</name>
      <anchor>operator</anchor>
      <arglist>( const QBitArray &amp; a1, const QBitArray &amp; a2 )</arglist>
    </member>
    <member kind="function">
      <name>operator^</name>
      <anchor>operator</anchor>
      <arglist>( const QBitArray &amp; a1, const QBitArray &amp; a2 )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QBitArray &amp; a )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QBitArray &amp; a )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QBitmap</name>
    <filename>qbitmap.html</filename>
    <member kind="function">
      <name>QBitmap</name>
      <anchor>QBitmap</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QBitmap</name>
      <anchor>QBitmap</anchor>
      <arglist>( int w, int h, bool clear = FALSE, QPixmap::Optimization optimization = QPixmap::DefaultOptim )</arglist>
    </member>
    <member kind="function">
      <name>QBitmap</name>
      <anchor>QBitmap</anchor>
      <arglist>( const QSize &amp; size, bool clear = FALSE, QPixmap::Optimization optimization = QPixmap::DefaultOptim )</arglist>
    </member>
    <member kind="function">
      <name>QBitmap</name>
      <anchor>QBitmap</anchor>
      <arglist>( int w, int h, const uchar * bits, bool isXbitmap = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>QBitmap</name>
      <anchor>QBitmap</anchor>
      <arglist>( const QSize &amp; size, const uchar * bits, bool isXbitmap = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>QBitmap</name>
      <anchor>QBitmap</anchor>
      <arglist>( const QBitmap &amp; bitmap )</arglist>
    </member>
    <member kind="function">
      <name>QBitmap</name>
      <anchor>QBitmap</anchor>
      <arglist>( const QString &amp; fileName, const char * format = 0 )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QBitmap &amp; bitmap )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPixmap &amp; pixmap )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QImage &amp; image )</arglist>
    </member>
    <member kind="function">
      <name>xForm</name>
      <anchor>xForm</anchor>
      <arglist>( const QWMatrix &amp; matrix ) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QBitVal</name>
    <filename>qbitval.html</filename>
    <member kind="function">
      <name>QBitVal</name>
      <anchor>QBitVal</anchor>
      <arglist>( QBitArray * a, uint i )</arglist>
    </member>
    <member kind="function">
      <name>int</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QBitVal &amp; v )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( bool v )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QBoxLayout</name>
    <filename>qboxlayout.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>Direction</anchor>
      <arglist>{ LeftToRight, RightToLeft, TopToBottom, BottomToTop, Down = TopToBottom, Up = BottomToTop }</arglist>
    </member>
    <member kind="function">
      <name>QBoxLayout</name>
      <anchor>QBoxLayout</anchor>
      <arglist>( QWidget * parent, Direction d, int margin = 0, int spacing = -1, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QBoxLayout</name>
      <anchor>QBoxLayout</anchor>
      <arglist>( QLayout * parentLayout, Direction d, int spacing = -1, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QBoxLayout</name>
      <anchor>QBoxLayout</anchor>
      <arglist>( Direction d, int spacing = -1, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QBoxLayout</name>
      <anchor>QBoxLayout</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>addItem</name>
      <anchor>addItem</anchor>
      <arglist>( QLayoutItem * item )</arglist>
    </member>
    <member kind="function">
      <name>direction</name>
      <anchor>direction</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setDirection</name>
      <anchor>setDirection</anchor>
      <arglist>( Direction direction )</arglist>
    </member>
    <member kind="function">
      <name>addSpacing</name>
      <anchor>addSpacing</anchor>
      <arglist>( int size )</arglist>
    </member>
    <member kind="function">
      <name>addStretch</name>
      <anchor>addStretch</anchor>
      <arglist>( int stretch = 0 )</arglist>
    </member>
    <member kind="function">
      <name>addWidget</name>
      <anchor>addWidget</anchor>
      <arglist>( QWidget * widget, int stretch = 0, int alignment = 0 )</arglist>
    </member>
    <member kind="function">
      <name>addLayout</name>
      <anchor>addLayout</anchor>
      <arglist>( QLayout * layout, int stretch = 0 )</arglist>
    </member>
    <member kind="function">
      <name>addStrut</name>
      <anchor>addStrut</anchor>
      <arglist>( int size )</arglist>
    </member>
    <member kind="function">
      <name>insertSpacing</name>
      <anchor>insertSpacing</anchor>
      <arglist>( int index, int size )</arglist>
    </member>
    <member kind="function">
      <name>insertStretch</name>
      <anchor>insertStretch</anchor>
      <arglist>( int index, int stretch = 0 )</arglist>
    </member>
    <member kind="function">
      <name>insertWidget</name>
      <anchor>insertWidget</anchor>
      <arglist>( int index, QWidget * widget, int stretch = 0, int alignment = 0 )</arglist>
    </member>
    <member kind="function">
      <name>insertLayout</name>
      <anchor>insertLayout</anchor>
      <arglist>( int index, QLayout * layout, int stretch = 0 )</arglist>
    </member>
    <member kind="function">
      <name>setStretchFactor</name>
      <anchor>setStretchFactor</anchor>
      <arglist>( QWidget * w, int stretch )</arglist>
    </member>
    <member kind="function">
      <name>setStretchFactor</name>
      <anchor>setStretchFactor</anchor>
      <arglist>( QLayout * l, int stretch )</arglist>
    </member>
    <member kind="function">
      <name>sizeHint</name>
      <anchor>sizeHint</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>minimumSize</name>
      <anchor>minimumSize</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>maximumSize</name>
      <anchor>maximumSize</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>hasHeightForWidth</name>
      <anchor>hasHeightForWidth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>heightForWidth</name>
      <anchor>heightForWidth</anchor>
      <arglist>( int w ) const</arglist>
    </member>
    <member kind="function">
      <name>expanding</name>
      <anchor>expanding</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>invalidate</name>
      <anchor>invalidate</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setGeometry</name>
      <anchor>setGeometry</anchor>
      <arglist>( const QRect &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>findWidget</name>
      <anchor>findWidget</anchor>
      <arglist>( QWidget * w )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( int index, QLayoutItem * item )</arglist>
    </member>
    <member kind="function">
      <name>addWidget</name>
      <anchor>addWidget</anchor>
      <arglist>() to add a widget to the QBoxLayout and set the</arglist>
    </member>
    <member kind="function">
      <name>setMargin</name>
      <anchor>setMargin</anchor>
      <arglist>() sets the width of the outer border. This is the width</arglist>
    </member>
    <member kind="function">
      <name>setSpacing</name>
      <anchor>setSpacing</anchor>
      <arglist>() sets the width between neighboring boxes. (You</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Direction</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Direction</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QBrush</name>
    <filename>qbrush.html</filename>
    <member kind="function">
      <name>QBrush</name>
      <anchor>QBrush</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QBrush</name>
      <anchor>QBrush</anchor>
      <arglist>( BrushStyle style )</arglist>
    </member>
    <member kind="function">
      <name>QBrush</name>
      <anchor>QBrush</anchor>
      <arglist>( const QColor &amp; color, BrushStyle style = SolidPattern )</arglist>
    </member>
    <member kind="function">
      <name>QBrush</name>
      <anchor>QBrush</anchor>
      <arglist>( const QColor &amp; color, const QPixmap &amp; pixmap )</arglist>
    </member>
    <member kind="function">
      <name>QBrush</name>
      <anchor>QBrush</anchor>
      <arglist>( const QBrush &amp; b )</arglist>
    </member>
    <member kind="function">
      <name>QBrush</name>
      <anchor>QBrush</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QBrush &amp; b )</arglist>
    </member>
    <member kind="function">
      <name>style</name>
      <anchor>style</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setStyle</name>
      <anchor>setStyle</anchor>
      <arglist>( BrushStyle s )</arglist>
    </member>
    <member kind="function">
      <name>color</name>
      <anchor>color</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setColor</name>
      <anchor>setColor</anchor>
      <arglist>( const QColor &amp; c )</arglist>
    </member>
    <member kind="function">
      <name>pixmap</name>
      <anchor>pixmap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPixmap</name>
      <anchor>setPixmap</anchor>
      <arglist>( const QPixmap &amp; pixmap )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QBrush &amp; b ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QBrush &amp; b ) const</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QBrush &amp; b )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QBrush &amp; b )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QBuffer</name>
    <filename>qbuffer.html</filename>
    <member kind="function">
      <name>QBuffer</name>
      <anchor>QBuffer</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QBuffer</name>
      <anchor>QBuffer</anchor>
      <arglist>( QByteArray buf )</arglist>
    </member>
    <member kind="function">
      <name>QBuffer</name>
      <anchor>QBuffer</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>buffer</name>
      <anchor>buffer</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setBuffer</name>
      <anchor>setBuffer</anchor>
      <arglist>( QByteArray buf )</arglist>
    </member>
    <member kind="function">
      <name>writeBlock</name>
      <anchor>writeBlock</anchor>
      <arglist>( const char * p, Q_ULONG len )</arglist>
    </member>
    <member kind="function">
      <name>writeBlock</name>
      <anchor>writeBlock</anchor>
      <arglist>( const QByteArray &amp; data )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QButton</name>
    <filename>qbutton.html</filename>
    <member kind="function">
      <name>QButton</name>
      <anchor>QButton</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QButton</name>
      <anchor>QButton</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setText</name>
      <anchor>setText</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>pixmap</name>
      <anchor>pixmap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPixmap</name>
      <anchor>setPixmap</anchor>
      <arglist>( const QPixmap &amp; )</arglist>
    </member>
    <member kind="function">
      <name>accel</name>
      <anchor>accel</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAccel</name>
      <anchor>setAccel</anchor>
      <arglist>( const QKeySequence &amp; )</arglist>
    </member>
    <member kind="function">
      <name>isToggleButton</name>
      <anchor>isToggleButton</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ToggleType</anchor>
      <arglist>{ SingleShot, Toggle, Tristate }</arglist>
    </member>
    <member kind="function">
      <name>toggleType</name>
      <anchor>toggleType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setDown</name>
      <anchor>setDown</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>isDown</name>
      <anchor>isDown</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isOn</name>
      <anchor>isOn</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ToggleState</anchor>
      <arglist>{ Off, NoChange, On }</arglist>
    </member>
    <member kind="function">
      <name>state</name>
      <anchor>state</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>autoRepeat</name>
      <anchor>autoRepeat</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoRepeat</name>
      <anchor>setAutoRepeat</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>isExclusiveToggle</name>
      <anchor>isExclusiveToggle</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>group</name>
      <anchor>group</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>animateClick</name>
      <anchor>animateClick</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toggle</name>
      <anchor>toggle</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>pressed</name>
      <anchor>pressed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>released</name>
      <anchor>released</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>clicked</name>
      <anchor>clicked</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toggled</name>
      <anchor>toggled</anchor>
      <arglist>( bool on )</arglist>
    </member>
    <member kind="function">
      <name>stateChanged</name>
      <anchor>stateChanged</anchor>
      <arglist>( int state )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>accel</anchor>
      <arglist>- the accelerator associated with the button</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>autoRepeat</anchor>
      <arglist>- whether autoRepeat is enabled</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>down</anchor>
      <arglist>- whether the button is pressed</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>exclusiveToggle</anchor>
      <arglist>- whether the button is an exclusive toggle</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>on</anchor>
      <arglist>- whether the button is toggled</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>pixmap</anchor>
      <arglist>- the pixmap shown on the button</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>text</anchor>
      <arglist>- the text shown on the button</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>toggleButton</anchor>
      <arglist>- whether the button is a toggle button</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>toggleState</anchor>
      <arglist>- the state of the toggle button</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>toggleType</anchor>
      <arglist>- the type of toggle on the button</arglist>
    </member>
    <member kind="function">
      <name>setToggleButton</name>
      <anchor>setToggleButton</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>setToggleType</name>
      <anchor>setToggleType</anchor>
      <arglist>( ToggleType type )</arglist>
    </member>
    <member kind="function">
      <name>setOn</name>
      <anchor>setOn</anchor>
      <arglist>( bool on )</arglist>
    </member>
    <member kind="function">
      <name>setState</name>
      <anchor>setState</anchor>
      <arglist>( ToggleState s )</arglist>
    </member>
    <member kind="function">
      <name>hitButton</name>
      <anchor>hitButton</anchor>
      <arglist>( const QPoint &amp; pos ) const</arglist>
    </member>
    <member kind="function">
      <name>drawButton</name>
      <anchor>drawButton</anchor>
      <arglist>( QPainter * )</arglist>
    </member>
    <member kind="function">
      <name>drawButtonLabel</name>
      <anchor>drawButtonLabel</anchor>
      <arglist>( QPainter * )</arglist>
    </member>
    <member kind="function">
      <name>paintEvent</name>
      <anchor>paintEvent</anchor>
      <arglist>( QPaintEvent * )</arglist>
    </member>
    <member kind="function">
      <name>isDown</name>
      <anchor>isDown</anchor>
      <arglist>() indicates whether the button is</arglist>
    </member>
    <member kind="function">
      <name>isOn</name>
      <anchor>isOn</anchor>
      <arglist>() indicates whether the button is</arglist>
    </member>
    <member kind="function">
      <name>isEnabled</name>
      <anchor>isEnabled</anchor>
      <arglist>() indicates whether the button can be pressed by the</arglist>
    </member>
    <member kind="function">
      <name>setAutoRepeat</name>
      <anchor>setAutoRepeat</anchor>
      <arglist>() sets whether the button will auto-repeat</arglist>
    </member>
    <member kind="function">
      <name>setToggleButton</name>
      <anchor>setToggleButton</anchor>
      <arglist>() sets whether the button is a toggle</arglist>
    </member>
    <member kind="function">
      <name>pressed</name>
      <anchor>pressed</anchor>
      <arglist>() is emitted when the left mouse button is pressed while</arglist>
    </member>
    <member kind="function">
      <name>released</name>
      <anchor>released</anchor>
      <arglist>() is emitted when the left mouse button is released.</arglist>
    </member>
    <member kind="function">
      <name>clicked</name>
      <anchor>clicked</anchor>
      <arglist>() is emitted when the button is first pressed and then</arglist>
    </member>
    <member kind="function">
      <name>toggled</name>
      <anchor>toggled</anchor>
      <arglist>(bool) is emitted when the state of a toggle button changes.</arglist>
    </member>
    <member kind="function">
      <name>stateChanged</name>
      <anchor>stateChanged</anchor>
      <arglist>(int) is emitted when the state of a tristate</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ToggleState</anchor>
      <arglist>and</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QButtonGroup</name>
    <filename>qbuttongroup.html</filename>
    <member kind="function">
      <name>QButtonGroup</name>
      <anchor>QButtonGroup</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QButtonGroup</name>
      <anchor>QButtonGroup</anchor>
      <arglist>( const QString &amp; title, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QButtonGroup</name>
      <anchor>QButtonGroup</anchor>
      <arglist>( int strips, Orientation orientation, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QButtonGroup</name>
      <anchor>QButtonGroup</anchor>
      <arglist>( int strips, Orientation orientation, const QString &amp; title, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>isExclusive</name>
      <anchor>isExclusive</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isRadioButtonExclusive</name>
      <anchor>isRadioButtonExclusive</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setExclusive</name>
      <anchor>setExclusive</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>setRadioButtonExclusive</name>
      <anchor>setRadioButtonExclusive</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>insert</name>
      <anchor>insert</anchor>
      <arglist>( QButton * button, int id = -1 )</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>( QButton * button )</arglist>
    </member>
    <member kind="function">
      <name>find</name>
      <anchor>find</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>id</name>
      <anchor>id</anchor>
      <arglist>( QButton * button ) const</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setButton</name>
      <anchor>setButton</anchor>
      <arglist>( int id )</arglist>
    </member>
    <member kind="function">
      <name>moveFocus</name>
      <anchor>moveFocus</anchor>
      <arglist>( int key )</arglist>
    </member>
    <member kind="function">
      <name>selected</name>
      <anchor>selected</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>selectedId</name>
      <anchor>selectedId</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>pressed</name>
      <anchor>pressed</anchor>
      <arglist>( int id )</arglist>
    </member>
    <member kind="function">
      <name>released</name>
      <anchor>released</anchor>
      <arglist>( int id )</arglist>
    </member>
    <member kind="function">
      <name>clicked</name>
      <anchor>clicked</anchor>
      <arglist>( int id )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>exclusive</anchor>
      <arglist>- whether the button group is exclusive</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>radioButtonExclusive</anchor>
      <arglist>- whether the radio buttons in the group are exclusive</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QByteArray</name>
    <filename>qbytearray.html</filename>
    <member kind="function">
      <name>QByteArray</name>
      <anchor>QByteArray</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QByteArray</name>
      <anchor>QByteArray</anchor>
      <arglist>( int size )</arglist>
    </member>
    <member kind="function">
      <name>qCompress</name>
      <anchor>qCompress</anchor>
      <arglist>( const QByteArray &amp; data )</arglist>
    </member>
    <member kind="function">
      <name>qCompress</name>
      <anchor>qCompress</anchor>
      <arglist>( const uchar * data, int nbytes )</arglist>
    </member>
    <member kind="function">
      <name>qUncompress</name>
      <anchor>qUncompress</anchor>
      <arglist>( const QByteArray &amp; data )</arglist>
    </member>
    <member kind="function">
      <name>qUncompress</name>
      <anchor>qUncompress</anchor>
      <arglist>( const uchar * data, int nbytes )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCache</name>
    <filename>qcache.html</filename>
    <member kind="function">
      <name>QCache</name>
      <anchor>QCache</anchor>
      <arglist>( int maxCost = 100, int size = 17, bool caseSensitive = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>QCache</name>
      <anchor>QCache</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>maxCost</name>
      <anchor>maxCost</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>totalCost</name>
      <anchor>totalCost</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMaxCost</name>
      <anchor>setMaxCost</anchor>
      <arglist>( int m )</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>insert</name>
      <anchor>insert</anchor>
      <arglist>( const QString &amp; k, const type * d, int c = 1, int p = 0 )</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>( const QString &amp; k )</arglist>
    </member>
    <member kind="function">
      <name>take</name>
      <anchor>take</anchor>
      <arglist>( const QString &amp; k )</arglist>
    </member>
    <member kind="function">
      <name>find</name>
      <anchor>find</anchor>
      <arglist>( const QString &amp; k, bool ref = TRUE ) const</arglist>
    </member>
    <member kind="function">
      <name>operator[]</name>
      <anchor>operator</anchor>
      <arglist>( const QString &amp; k ) const</arglist>
    </member>
    <member kind="function">
      <name>statistics</name>
      <anchor>statistics</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>autoDelete</name>
      <anchor>autoDelete</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoDelete</name>
      <anchor>setAutoDelete</anchor>
      <arglist>( bool enable )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCacheIterator</name>
    <filename>qcacheiterator.html</filename>
    <member kind="function">
      <name>QCacheIterator</name>
      <anchor>QCacheIterator</anchor>
      <arglist>( const QCache&lt;type&gt; &amp; cache )</arglist>
    </member>
    <member kind="function">
      <name>QCacheIterator</name>
      <anchor>QCacheIterator</anchor>
      <arglist>( const QCacheIterator&lt;type&gt; &amp; ci )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QCacheIterator&lt;type&gt; &amp; ci )</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>atFirst</name>
      <anchor>atFirst</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>atLast</name>
      <anchor>atLast</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>toFirst</name>
      <anchor>toFirst</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toLast</name>
      <anchor>toLast</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>type</name>
      <anchor>operator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>current</name>
      <anchor>current</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>currentKey</name>
      <anchor>currentKey</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>operator()</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>operator++</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( uint jump )</arglist>
    </member>
    <member kind="function">
      <name>operator--</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( uint jump )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCanvas</name>
    <filename>qcanvas.html</filename>
    <member kind="function">
      <name>QCanvas</name>
      <anchor>QCanvas</anchor>
      <arglist>( QObject * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QCanvas</name>
      <anchor>QCanvas</anchor>
      <arglist>( int w, int h )</arglist>
    </member>
    <member kind="function">
      <name>QCanvas</name>
      <anchor>QCanvas</anchor>
      <arglist>( QPixmap p, int h, int v, int tilewidth, int tileheight )</arglist>
    </member>
    <member kind="function">
      <name>QCanvas</name>
      <anchor>QCanvas</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setTiles</name>
      <anchor>setTiles</anchor>
      <arglist>( QPixmap p, int h, int v, int tilewidth, int tileheight )</arglist>
    </member>
    <member kind="function">
      <name>setBackgroundPixmap</name>
      <anchor>setBackgroundPixmap</anchor>
      <arglist>( const QPixmap &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>backgroundPixmap</name>
      <anchor>backgroundPixmap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setBackgroundColor</name>
      <anchor>setBackgroundColor</anchor>
      <arglist>( const QColor &amp; c )</arglist>
    </member>
    <member kind="function">
      <name>backgroundColor</name>
      <anchor>backgroundColor</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setTile</name>
      <anchor>setTile</anchor>
      <arglist>( int x, int y, int tilenum )</arglist>
    </member>
    <member kind="function">
      <name>tile</name>
      <anchor>tile</anchor>
      <arglist>( int x, int y ) const</arglist>
    </member>
    <member kind="function">
      <name>tilesHorizontally</name>
      <anchor>tilesHorizontally</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>tilesVertically</name>
      <anchor>tilesVertically</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>tileWidth</name>
      <anchor>tileWidth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>tileHeight</name>
      <anchor>tileHeight</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>resize</name>
      <anchor>resize</anchor>
      <arglist>( int w, int h )</arglist>
    </member>
    <member kind="function">
      <name>width</name>
      <anchor>width</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>height</name>
      <anchor>height</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rect</name>
      <anchor>rect</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>onCanvas</name>
      <anchor>onCanvas</anchor>
      <arglist>( int x, int y ) const</arglist>
    </member>
    <member kind="function">
      <name>onCanvas</name>
      <anchor>onCanvas</anchor>
      <arglist>( const QPoint &amp; p ) const</arglist>
    </member>
    <member kind="function">
      <name>validChunk</name>
      <anchor>validChunk</anchor>
      <arglist>( int x, int y ) const</arglist>
    </member>
    <member kind="function">
      <name>validChunk</name>
      <anchor>validChunk</anchor>
      <arglist>( const QPoint &amp; p ) const</arglist>
    </member>
    <member kind="function">
      <name>chunkSize</name>
      <anchor>chunkSize</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>retune</name>
      <anchor>retune</anchor>
      <arglist>( int chunksze, int mxclusters = 100 )</arglist>
    </member>
    <member kind="function">
      <name>setAllChanged</name>
      <anchor>setAllChanged</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setChanged</name>
      <anchor>setChanged</anchor>
      <arglist>( const QRect &amp; area )</arglist>
    </member>
    <member kind="function">
      <name>setUnchanged</name>
      <anchor>setUnchanged</anchor>
      <arglist>( const QRect &amp; area )</arglist>
    </member>
    <member kind="function">
      <name>allItems</name>
      <anchor>allItems</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>collisions</name>
      <anchor>collisions</anchor>
      <arglist>( const QPoint &amp; p ) const</arglist>
    </member>
    <member kind="function">
      <name>collisions</name>
      <anchor>collisions</anchor>
      <arglist>( const QRect &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>collisions</name>
      <anchor>collisions</anchor>
      <arglist>( const QPointArray &amp; chunklist, const QCanvasItem * item, bool exact ) const</arglist>
    </member>
    <member kind="function">
      <name>drawArea</name>
      <anchor>drawArea</anchor>
      <arglist>( const QRect &amp; clip, QPainter * painter, bool dbuf = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>setAdvancePeriod</name>
      <anchor>setAdvancePeriod</anchor>
      <arglist>( int ms )</arglist>
    </member>
    <member kind="function">
      <name>setUpdatePeriod</name>
      <anchor>setUpdatePeriod</anchor>
      <arglist>( int ms )</arglist>
    </member>
    <member kind="function">
      <name>setDoubleBuffering</name>
      <anchor>setDoubleBuffering</anchor>
      <arglist>( bool y )</arglist>
    </member>
    <member kind="function">
      <name>advance</name>
      <anchor>advance</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>update</name>
      <anchor>update</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>resized</name>
      <anchor>resized</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>drawBackground</name>
      <anchor>drawBackground</anchor>
      <arglist>( QPainter &amp; painter, const QRect &amp; clip )</arglist>
    </member>
    <member kind="function">
      <name>drawForeground</name>
      <anchor>drawForeground</anchor>
      <arglist>( QPainter &amp; painter, const QRect &amp; clip )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCanvasEllipse</name>
    <filename>qcanvasellipse.html</filename>
    <member kind="function">
      <name>QCanvasEllipse</name>
      <anchor>QCanvasEllipse</anchor>
      <arglist>( QCanvas * canvas )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasEllipse</name>
      <anchor>QCanvasEllipse</anchor>
      <arglist>( int width, int height, QCanvas * canvas )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasEllipse</name>
      <anchor>QCanvasEllipse</anchor>
      <arglist>( int width, int height, int startangle, int angle, QCanvas * canvas )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasEllipse</name>
      <anchor>QCanvasEllipse</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>width</name>
      <anchor>width</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>height</name>
      <anchor>height</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSize</name>
      <anchor>setSize</anchor>
      <arglist>( int width, int height )</arglist>
    </member>
    <member kind="function">
      <name>setAngles</name>
      <anchor>setAngles</anchor>
      <arglist>( int start, int length )</arglist>
    </member>
    <member kind="function">
      <name>angleStart</name>
      <anchor>angleStart</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>angleLength</name>
      <anchor>angleLength</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rtti</name>
      <anchor>rtti</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>drawShape</name>
      <anchor>drawShape</anchor>
      <arglist>( QPainter &amp; p )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCanvasItem</name>
    <filename>qcanvasitem.html</filename>
    <member kind="function">
      <name>QCanvasItem</name>
      <anchor>QCanvasItem</anchor>
      <arglist>( QCanvas * canvas )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasItem</name>
      <anchor>QCanvasItem</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>x</name>
      <anchor>x</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>y</name>
      <anchor>y</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>z</name>
      <anchor>z</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>moveBy</name>
      <anchor>moveBy</anchor>
      <arglist>( double dx, double dy )</arglist>
    </member>
    <member kind="function">
      <name>move</name>
      <anchor>move</anchor>
      <arglist>( double x, double y )</arglist>
    </member>
    <member kind="function">
      <name>setX</name>
      <anchor>setX</anchor>
      <arglist>( double x )</arglist>
    </member>
    <member kind="function">
      <name>setY</name>
      <anchor>setY</anchor>
      <arglist>( double y )</arglist>
    </member>
    <member kind="function">
      <name>setZ</name>
      <anchor>setZ</anchor>
      <arglist>( double z )</arglist>
    </member>
    <member kind="function">
      <name>animated</name>
      <anchor>animated</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAnimated</name>
      <anchor>setAnimated</anchor>
      <arglist>( bool y )</arglist>
    </member>
    <member kind="function">
      <name>setVelocity</name>
      <anchor>setVelocity</anchor>
      <arglist>( double vx, double vy )</arglist>
    </member>
    <member kind="function">
      <name>setXVelocity</name>
      <anchor>setXVelocity</anchor>
      <arglist>( double vx )</arglist>
    </member>
    <member kind="function">
      <name>setYVelocity</name>
      <anchor>setYVelocity</anchor>
      <arglist>( double vy )</arglist>
    </member>
    <member kind="function">
      <name>xVelocity</name>
      <anchor>xVelocity</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>yVelocity</name>
      <anchor>yVelocity</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>advance</name>
      <anchor>advance</anchor>
      <arglist>( int phase )</arglist>
    </member>
    <member kind="function">
      <name>collidesWith</name>
      <anchor>collidesWith</anchor>
      <arglist>( const QCanvasItem * other ) const = 0</arglist>
    </member>
    <member kind="function">
      <name>collisions</name>
      <anchor>collisions</anchor>
      <arglist>( bool exact ) const</arglist>
    </member>
    <member kind="function">
      <name>setCanvas</name>
      <anchor>setCanvas</anchor>
      <arglist>( QCanvas * c )</arglist>
    </member>
    <member kind="function">
      <name>draw</name>
      <anchor>draw</anchor>
      <arglist>( QPainter &amp; painter ) = 0</arglist>
    </member>
    <member kind="function">
      <name>show</name>
      <anchor>show</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>hide</name>
      <anchor>hide</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setVisible</name>
      <anchor>setVisible</anchor>
      <arglist>( bool yes )</arglist>
    </member>
    <member kind="function">
      <name>isVisible</name>
      <anchor>isVisible</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSelected</name>
      <anchor>setSelected</anchor>
      <arglist>( bool yes )</arglist>
    </member>
    <member kind="function">
      <name>isSelected</name>
      <anchor>isSelected</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setEnabled</name>
      <anchor>setEnabled</anchor>
      <arglist>( bool yes )</arglist>
    </member>
    <member kind="function">
      <name>isEnabled</name>
      <anchor>isEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setActive</name>
      <anchor>setActive</anchor>
      <arglist>( bool yes )</arglist>
    </member>
    <member kind="function">
      <name>isActive</name>
      <anchor>isActive</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>RttiValues</anchor>
      <arglist>{ Rtti_Item = 0, Rtti_Sprite = 1, Rtti_PolygonalItem = 2, Rtti_Text = 3, Rtti_Polygon = 4, Rtti_Rectangle = 5, Rtti_Ellipse = 6, Rtti_Line = 7, Rtti_Spline = 8 }</arglist>
    </member>
    <member kind="function">
      <name>rtti</name>
      <anchor>rtti</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>boundingRect</name>
      <anchor>boundingRect</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>boundingRectAdvanced</name>
      <anchor>boundingRectAdvanced</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>canvas</name>
      <anchor>canvas</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>update</name>
      <anchor>update</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCanvasItemList</name>
    <filename>qcanvasitemlist.html</filename>
  </compound>
  <compound kind="class">
    <name>QCanvasLine</name>
    <filename>qcanvasline.html</filename>
    <member kind="function">
      <name>QCanvasLine</name>
      <anchor>QCanvasLine</anchor>
      <arglist>( QCanvas * canvas )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasLine</name>
      <anchor>QCanvasLine</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setPoints</name>
      <anchor>setPoints</anchor>
      <arglist>( int xa, int ya, int xb, int yb )</arglist>
    </member>
    <member kind="function">
      <name>startPoint</name>
      <anchor>startPoint</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>endPoint</name>
      <anchor>endPoint</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rtti</name>
      <anchor>rtti</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCanvasPixmap</name>
    <filename>qcanvaspixmap.html</filename>
    <member kind="function">
      <name>QCanvasPixmap</name>
      <anchor>QCanvasPixmap</anchor>
      <arglist>( const QString &amp; datafilename )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasPixmap</name>
      <anchor>QCanvasPixmap</anchor>
      <arglist>( const QImage &amp; image )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasPixmap</name>
      <anchor>QCanvasPixmap</anchor>
      <arglist>( const QPixmap &amp; pm, const QPoint &amp; offset )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasPixmap</name>
      <anchor>QCanvasPixmap</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>offsetX</name>
      <anchor>offsetX</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>offsetY</name>
      <anchor>offsetY</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setOffset</name>
      <anchor>setOffset</anchor>
      <arglist>( int x, int y )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCanvasPixmapArray</name>
    <filename>qcanvaspixmaparray.html</filename>
    <member kind="function">
      <name>QCanvasPixmapArray</name>
      <anchor>QCanvasPixmapArray</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QCanvasPixmapArray</name>
      <anchor>QCanvasPixmapArray</anchor>
      <arglist>( const QString &amp; datafilenamepattern, int fc = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasPixmapArray</name>
      <anchor>QCanvasPixmapArray</anchor>
      <arglist>( QValueList&lt;QPixmap&gt; list, QPointArray hotspots = QPointArray ( ) )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasPixmapArray</name>
      <anchor>QCanvasPixmapArray</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>readPixmaps</name>
      <anchor>readPixmaps</anchor>
      <arglist>( const QString &amp; filenamepattern, int fc = 0 )</arglist>
    </member>
    <member kind="function">
      <name>readCollisionMasks</name>
      <anchor>readCollisionMasks</anchor>
      <arglist>( const QString &amp; filename )</arglist>
    </member>
    <member kind="function">
      <name>isValid</name>
      <anchor>isValid</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>image</name>
      <anchor>image</anchor>
      <arglist>( int i ) const</arglist>
    </member>
    <member kind="function">
      <name>setImage</name>
      <anchor>setImage</anchor>
      <arglist>( int i, QCanvasPixmap * p )</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCanvasPolygon</name>
    <filename>qcanvaspolygon.html</filename>
    <member kind="function">
      <name>QCanvasPolygon</name>
      <anchor>QCanvasPolygon</anchor>
      <arglist>( QCanvas * canvas )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasPolygon</name>
      <anchor>QCanvasPolygon</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setPoints</name>
      <anchor>setPoints</anchor>
      <arglist>( QPointArray pa )</arglist>
    </member>
    <member kind="function">
      <name>points</name>
      <anchor>points</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>areaPoints</name>
      <anchor>areaPoints</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rtti</name>
      <anchor>rtti</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>drawShape</name>
      <anchor>drawShape</anchor>
      <arglist>( QPainter &amp; p )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCanvasPolygonalItem</name>
    <filename>qcanvaspolygonalitem.html</filename>
    <member kind="function">
      <name>QCanvasPolygonalItem</name>
      <anchor>QCanvasPolygonalItem</anchor>
      <arglist>( QCanvas * canvas )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasPolygonalItem</name>
      <anchor>QCanvasPolygonalItem</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setPen</name>
      <anchor>setPen</anchor>
      <arglist>( QPen p )</arglist>
    </member>
    <member kind="function">
      <name>setBrush</name>
      <anchor>setBrush</anchor>
      <arglist>( QBrush b )</arglist>
    </member>
    <member kind="function">
      <name>pen</name>
      <anchor>pen</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>brush</name>
      <anchor>brush</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>areaPoints</name>
      <anchor>areaPoints</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>areaPointsAdvanced</name>
      <anchor>areaPointsAdvanced</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>boundingRect</name>
      <anchor>boundingRect</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rtti</name>
      <anchor>rtti</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>draw</name>
      <anchor>draw</anchor>
      <arglist>( QPainter &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>drawShape</name>
      <anchor>drawShape</anchor>
      <arglist>( QPainter &amp; p ) = 0</arglist>
    </member>
    <member kind="function">
      <name>winding</name>
      <anchor>winding</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setWinding</name>
      <anchor>setWinding</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>invalidate</name>
      <anchor>invalidate</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>isValid</name>
      <anchor>isValid</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCanvasRectangle</name>
    <filename>qcanvasrectangle.html</filename>
    <member kind="function">
      <name>QCanvasRectangle</name>
      <anchor>QCanvasRectangle</anchor>
      <arglist>( QCanvas * canvas )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasRectangle</name>
      <anchor>QCanvasRectangle</anchor>
      <arglist>( const QRect &amp; r, QCanvas * canvas )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasRectangle</name>
      <anchor>QCanvasRectangle</anchor>
      <arglist>( int x, int y, int width, int height, QCanvas * canvas )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasRectangle</name>
      <anchor>QCanvasRectangle</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>width</name>
      <anchor>width</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>height</name>
      <anchor>height</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSize</name>
      <anchor>setSize</anchor>
      <arglist>( int width, int height )</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rect</name>
      <anchor>rect</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rtti</name>
      <anchor>rtti</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>drawShape</name>
      <anchor>drawShape</anchor>
      <arglist>( QPainter &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>chunks</name>
      <anchor>chunks</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCanvasSpline</name>
    <filename>qcanvasspline.html</filename>
    <member kind="function">
      <name>QCanvasSpline</name>
      <anchor>QCanvasSpline</anchor>
      <arglist>( QCanvas * canvas )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasSpline</name>
      <anchor>QCanvasSpline</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setControlPoints</name>
      <anchor>setControlPoints</anchor>
      <arglist>( QPointArray ctrl, bool close = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>controlPoints</name>
      <anchor>controlPoints</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>closed</name>
      <anchor>closed</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rtti</name>
      <anchor>rtti</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCanvasSprite</name>
    <filename>qcanvassprite.html</filename>
    <member kind="function">
      <name>QCanvasSprite</name>
      <anchor>QCanvasSprite</anchor>
      <arglist>( QCanvasPixmapArray * a, QCanvas * canvas )</arglist>
    </member>
    <member kind="function">
      <name>setSequence</name>
      <anchor>setSequence</anchor>
      <arglist>( QCanvasPixmapArray * a )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasSprite</name>
      <anchor>QCanvasSprite</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>move</name>
      <anchor>move</anchor>
      <arglist>( double nx, double ny, int nf )</arglist>
    </member>
    <member kind="function">
      <name>setFrame</name>
      <anchor>setFrame</anchor>
      <arglist>( int f )</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>FrameAnimationType</anchor>
      <arglist>{ Cycle, Oscillate }</arglist>
    </member>
    <member kind="function">
      <name>setFrameAnimation</name>
      <anchor>setFrameAnimation</anchor>
      <arglist>( FrameAnimationType type = Cycle, int step = 1, int state = 0 )</arglist>
    </member>
    <member kind="function">
      <name>frame</name>
      <anchor>frame</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>frameCount</name>
      <anchor>frameCount</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rtti</name>
      <anchor>rtti</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>boundingRect</name>
      <anchor>boundingRect</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>width</name>
      <anchor>width</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>height</name>
      <anchor>height</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>leftEdge</name>
      <anchor>leftEdge</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>topEdge</name>
      <anchor>topEdge</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rightEdge</name>
      <anchor>rightEdge</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>bottomEdge</name>
      <anchor>bottomEdge</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>leftEdge</name>
      <anchor>leftEdge</anchor>
      <arglist>( int nx ) const</arglist>
    </member>
    <member kind="function">
      <name>topEdge</name>
      <anchor>topEdge</anchor>
      <arglist>( int ny ) const</arglist>
    </member>
    <member kind="function">
      <name>rightEdge</name>
      <anchor>rightEdge</anchor>
      <arglist>( int nx ) const</arglist>
    </member>
    <member kind="function">
      <name>bottomEdge</name>
      <anchor>bottomEdge</anchor>
      <arglist>( int ny ) const</arglist>
    </member>
    <member kind="function">
      <name>image</name>
      <anchor>image</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>imageAdvanced</name>
      <anchor>imageAdvanced</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>image</name>
      <anchor>image</anchor>
      <arglist>( int f ) const</arglist>
    </member>
    <member kind="function">
      <name>advance</name>
      <anchor>advance</anchor>
      <arglist>( int phase )</arglist>
    </member>
    <member kind="function">
      <name>draw</name>
      <anchor>draw</anchor>
      <arglist>( QPainter &amp; painter )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCanvasText</name>
    <filename>qcanvastext.html</filename>
    <member kind="function">
      <name>QCanvasText</name>
      <anchor>QCanvasText</anchor>
      <arglist>( QCanvas * canvas )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasText</name>
      <anchor>QCanvasText</anchor>
      <arglist>( const QString &amp; t, QCanvas * canvas )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasText</name>
      <anchor>QCanvasText</anchor>
      <arglist>( const QString &amp; t, QFont f, QCanvas * canvas )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasText</name>
      <anchor>QCanvasText</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setText</name>
      <anchor>setText</anchor>
      <arglist>( const QString &amp; t )</arglist>
    </member>
    <member kind="function">
      <name>setFont</name>
      <anchor>setFont</anchor>
      <arglist>( const QFont &amp; f )</arglist>
    </member>
    <member kind="function">
      <name>setColor</name>
      <anchor>setColor</anchor>
      <arglist>( const QColor &amp; c )</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>font</name>
      <anchor>font</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>color</name>
      <anchor>color</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>textFlags</name>
      <anchor>textFlags</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setTextFlags</name>
      <anchor>setTextFlags</anchor>
      <arglist>( int f )</arglist>
    </member>
    <member kind="function">
      <name>boundingRect</name>
      <anchor>boundingRect</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rtti</name>
      <anchor>rtti</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>draw</name>
      <anchor>draw</anchor>
      <arglist>( QPainter &amp; painter )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCanvasView</name>
    <filename>qcanvasview.html</filename>
    <member kind="function">
      <name>QCanvasView</name>
      <anchor>QCanvasView</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasView</name>
      <anchor>QCanvasView</anchor>
      <arglist>( QCanvas * canvas, QWidget * parent = 0, const char * name = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QCanvasView</name>
      <anchor>QCanvasView</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>canvas</name>
      <anchor>canvas</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setCanvas</name>
      <anchor>setCanvas</anchor>
      <arglist>( QCanvas * canvas )</arglist>
    </member>
    <member kind="function">
      <name>worldMatrix</name>
      <anchor>worldMatrix</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>inverseWorldMatrix</name>
      <anchor>inverseWorldMatrix</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setWorldMatrix</name>
      <anchor>setWorldMatrix</anchor>
      <arglist>( const QWMatrix &amp; wm )</arglist>
    </member>
    <member kind="function">
      <name>drawContents</name>
      <anchor>drawContents</anchor>
      <arglist>( QPainter * p, int cx, int cy, int cw, int ch )</arglist>
    </member>
    <member kind="function">
      <name>sizeHint</name>
      <anchor>sizeHint</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCDEStyle</name>
    <filename>qcdestyle.html</filename>
    <member kind="function">
      <name>QCDEStyle</name>
      <anchor>QCDEStyle</anchor>
      <arglist>( bool useHighlightCols = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>QCDEStyle</name>
      <anchor>QCDEStyle</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QChar</name>
    <filename>qchar.html</filename>
    <member kind="function">
      <name>QChar</name>
      <anchor>QChar</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QChar</name>
      <anchor>QChar</anchor>
      <arglist>( char c )</arglist>
    </member>
    <member kind="function">
      <name>QChar</name>
      <anchor>QChar</anchor>
      <arglist>( uchar c )</arglist>
    </member>
    <member kind="function">
      <name>QChar</name>
      <anchor>QChar</anchor>
      <arglist>( uchar c, uchar r )</arglist>
    </member>
    <member kind="function">
      <name>QChar</name>
      <anchor>QChar</anchor>
      <arglist>( const QChar &amp; c )</arglist>
    </member>
    <member kind="function">
      <name>QChar</name>
      <anchor>QChar</anchor>
      <arglist>( ushort rc )</arglist>
    </member>
    <member kind="function">
      <name>QChar</name>
      <anchor>QChar</anchor>
      <arglist>( short rc )</arglist>
    </member>
    <member kind="function">
      <name>QChar</name>
      <anchor>QChar</anchor>
      <arglist>( uint rc )</arglist>
    </member>
    <member kind="function">
      <name>QChar</name>
      <anchor>QChar</anchor>
      <arglist>( int rc )</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Category</anchor>
      <arglist>{ NoCategory, Mark_NonSpacing, Mark_SpacingCombining, Mark_Enclosing, Number_DecimalDigit, Number_Letter, Number_Other, Separator_Space, Separator_Line, Separator_Paragraph, Other_Control, Other_Format, Other_Surrogate, Other_PrivateUse, Other_NotAssigned, Letter_Uppercase, Letter_Lowercase, Letter_Titlecase, Letter_Modifier, Letter_Other, Punctuation_Connector, Punctuation_Dash, Punctuation_Dask = Punctuation_Dash, Punctuation_Open, Punctuation_Close, Punctuation_InitialQuote, Punctuation_FinalQuote, Punctuation_Other, Symbol_Math, Symbol_Currency, Symbol_Modifier, Symbol_Other }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Direction</anchor>
      <arglist>{ DirL, DirR, DirEN, DirES, DirET, DirAN, DirCS, DirB, DirS, DirWS, DirON, DirLRE, DirLRO, DirAL, DirRLE, DirRLO, DirPDF, DirNSM, DirBN }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Decomposition</anchor>
      <arglist>{ Single, Canonical, Font, NoBreak, Initial, Medial, Final, Isolated, Circle, Super, Sub, Vertical, Wide, Narrow, Small, Square, Compat, Fraction }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Joining</anchor>
      <arglist>{ OtherJoining, Dual, Right, Center }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>CombiningClass</anchor>
      <arglist>{ Combining_BelowLeftAttached = 200, Combining_BelowAttached = 202, Combining_BelowRightAttached = 204, Combining_LeftAttached = 208, Combining_RightAttached = 210, Combining_AboveLeftAttached = 212, Combining_AboveAttached = 214, Combining_AboveRightAttached = 216, Combining_BelowLeft = 218, Combining_Below = 220, Combining_BelowRight = 222, Combining_Left = 224, Combining_Right = 226, Combining_AboveLeft = 228, Combining_Above = 230, Combining_AboveRight = 232, Combining_DoubleBelow = 233, Combining_DoubleAbove = 234, Combining_IotaSubscript = 240 }</arglist>
    </member>
    <member kind="function">
      <name>digitValue</name>
      <anchor>digitValue</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>lower</name>
      <anchor>lower</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>upper</name>
      <anchor>upper</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>category</name>
      <anchor>category</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>direction</name>
      <anchor>direction</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>joining</name>
      <anchor>joining</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>mirrored</name>
      <anchor>mirrored</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>mirroredChar</name>
      <anchor>mirroredChar</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>decomposition</name>
      <anchor>decomposition</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>decompositionTag</name>
      <anchor>decompositionTag</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>combiningClass</name>
      <anchor>combiningClass</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>latin1</name>
      <anchor>latin1</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>unicode</name>
      <anchor>unicode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>unicode</name>
      <anchor>unicode</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>char</name>
      <anchor>operator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isNull</name>
      <anchor>isNull</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isPrint</name>
      <anchor>isPrint</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isPunct</name>
      <anchor>isPunct</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isSpace</name>
      <anchor>isSpace</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isMark</name>
      <anchor>isMark</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isLetter</name>
      <anchor>isLetter</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isNumber</name>
      <anchor>isNumber</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isLetterOrNumber</name>
      <anchor>isLetterOrNumber</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isDigit</name>
      <anchor>isDigit</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isSymbol</name>
      <anchor>isSymbol</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>cell</name>
      <anchor>cell</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>row</name>
      <anchor>row</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( QChar c1, QChar c2 )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( char ch, QChar c )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( QChar c, char ch )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( QChar c1, QChar c2 )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( char ch, QChar c )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( QChar c, char ch )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QChar c1, QChar c2 )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QChar c, char ch )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( char ch, QChar c )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QChar c1, QChar c2 )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QChar c, char ch )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( char ch, QChar c )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QChar c1, QChar c2 )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QChar c, char ch )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( char ch, QChar c )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QChar c1, QChar c2 )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QChar c, char ch )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( char ch, QChar c )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCharRef</name>
    <filename>qcharref.html</filename>
  </compound>
  <compound kind="class">
    <name>QCheckBox</name>
    <filename>qcheckbox.html</filename>
    <member kind="function">
      <name>QCheckBox</name>
      <anchor>QCheckBox</anchor>
      <arglist>( QWidget * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QCheckBox</name>
      <anchor>QCheckBox</anchor>
      <arglist>( const QString &amp; text, QWidget * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>isChecked</name>
      <anchor>isChecked</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setNoChange</name>
      <anchor>setNoChange</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setTristate</name>
      <anchor>setTristate</anchor>
      <arglist>( bool y = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>isTristate</name>
      <anchor>isTristate</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setChecked</name>
      <anchor>setChecked</anchor>
      <arglist>( bool check )</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setText</name>
      <anchor>setText</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>pixmap</name>
      <anchor>pixmap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPixmap</name>
      <anchor>setPixmap</anchor>
      <arglist>( const QPixmap &amp; )</arglist>
    </member>
    <member kind="function">
      <name>accel</name>
      <anchor>accel</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAccel</name>
      <anchor>setAccel</anchor>
      <arglist>( const QKeySequence &amp; )</arglist>
    </member>
    <member kind="function">
      <name>isToggleButton</name>
      <anchor>isToggleButton</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setDown</name>
      <anchor>setDown</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>isDown</name>
      <anchor>isDown</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isOn</name>
      <anchor>isOn</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>state</name>
      <anchor>state</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>autoRepeat</name>
      <anchor>autoRepeat</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoRepeat</name>
      <anchor>setAutoRepeat</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>isExclusiveToggle</name>
      <anchor>isExclusiveToggle</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>group</name>
      <anchor>group</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>toggle</name>
      <anchor>toggle</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>pressed</name>
      <anchor>pressed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>released</name>
      <anchor>released</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>clicked</name>
      <anchor>clicked</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toggled</name>
      <anchor>toggled</anchor>
      <arglist>( bool on )</arglist>
    </member>
    <member kind="function">
      <name>stateChanged</name>
      <anchor>stateChanged</anchor>
      <arglist>( int state )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>autoMask</anchor>
      <arglist>- whether the checkbox is automatically masked</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>checked</anchor>
      <arglist>- whether the checkbox is checked</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>tristate</anchor>
      <arglist>- whether the checkbox is a tri-state checkbox</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCheckListItem</name>
    <filename>qchecklistitem.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>Type</anchor>
      <arglist>{ RadioButton, CheckBox, Controller, RadioButtonController = Controller, CheckBoxController }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ToggleState</anchor>
      <arglist>{ Off, NoChange, On }</arglist>
    </member>
    <member kind="function">
      <name>QCheckListItem</name>
      <anchor>QCheckListItem</anchor>
      <arglist>( QCheckListItem * parent, const QString &amp; text, Type tt = RadioButtonController )</arglist>
    </member>
    <member kind="function">
      <name>QCheckListItem</name>
      <anchor>QCheckListItem</anchor>
      <arglist>( QCheckListItem * parent, QListViewItem * after, const QString &amp; text, Type tt = RadioButtonController )</arglist>
    </member>
    <member kind="function">
      <name>QCheckListItem</name>
      <anchor>QCheckListItem</anchor>
      <arglist>( QListViewItem * parent, const QString &amp; text, Type tt = RadioButtonController )</arglist>
    </member>
    <member kind="function">
      <name>QCheckListItem</name>
      <anchor>QCheckListItem</anchor>
      <arglist>( QListViewItem * parent, QListViewItem * after, const QString &amp; text, Type tt = RadioButtonController )</arglist>
    </member>
    <member kind="function">
      <name>QCheckListItem</name>
      <anchor>QCheckListItem</anchor>
      <arglist>( QListView * parent, const QString &amp; text, Type tt = RadioButtonController )</arglist>
    </member>
    <member kind="function">
      <name>QCheckListItem</name>
      <anchor>QCheckListItem</anchor>
      <arglist>( QListView * parent, QListViewItem * after, const QString &amp; text, Type tt = RadioButtonController )</arglist>
    </member>
    <member kind="function">
      <name>QCheckListItem</name>
      <anchor>QCheckListItem</anchor>
      <arglist>( QListViewItem * parent, const QString &amp; text, const QPixmap &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>QCheckListItem</name>
      <anchor>QCheckListItem</anchor>
      <arglist>( QListView * parent, const QString &amp; text, const QPixmap &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>QCheckListItem</name>
      <anchor>QCheckListItem</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>paintCell</name>
      <anchor>paintCell</anchor>
      <arglist>( QPainter * p, const QColorGroup &amp; cg, int column, int width, int align )</arglist>
    </member>
    <member kind="function">
      <name>paintFocus</name>
      <anchor>paintFocus</anchor>
      <arglist>( QPainter * p, const QColorGroup &amp; cg, const QRect &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>setOn</name>
      <anchor>setOn</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>isOn</name>
      <anchor>isOn</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>type</name>
      <anchor>type</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setTristate</name>
      <anchor>setTristate</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>isTristate</name>
      <anchor>isTristate</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>state</name>
      <anchor>state</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setState</name>
      <anchor>setState</anchor>
      <arglist>( ToggleState s )</arglist>
    </member>
    <member kind="function">
      <name>rtti</name>
      <anchor>rtti</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>activate</name>
      <anchor>activate</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>turnOffChild</name>
      <anchor>turnOffChild</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>stateChange</name>
      <anchor>stateChange</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Type</anchor>
      <arglist>instead)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCheckTableItem</name>
    <filename>qchecktableitem.html</filename>
    <member kind="function">
      <name>QCheckTableItem</name>
      <anchor>QCheckTableItem</anchor>
      <arglist>( QTable * table, const QString &amp; txt )</arglist>
    </member>
    <member kind="function">
      <name>setChecked</name>
      <anchor>setChecked</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>isChecked</name>
      <anchor>isChecked</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rtti</name>
      <anchor>rtti</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QChildEvent</name>
    <filename>qchildevent.html</filename>
    <member kind="function">
      <name>QChildEvent</name>
      <anchor>QChildEvent</anchor>
      <arglist>( Type type, QObject * child )</arglist>
    </member>
    <member kind="function">
      <name>child</name>
      <anchor>child</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>inserted</name>
      <anchor>inserted</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>removed</name>
      <anchor>removed</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QClipboard</name>
    <filename>qclipboard.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>Mode</anchor>
      <arglist>{ Clipboard, Selection }</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>( Mode mode )</arglist>
    </member>
    <member kind="function">
      <name>supportsSelection</name>
      <anchor>supportsSelection</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>ownsSelection</name>
      <anchor>ownsSelection</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>ownsClipboard</name>
      <anchor>ownsClipboard</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>( Mode mode ) const</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>( QCString &amp; subtype, Mode mode ) const</arglist>
    </member>
    <member kind="function">
      <name>setText</name>
      <anchor>setText</anchor>
      <arglist>( const QString &amp; text, Mode mode )</arglist>
    </member>
    <member kind="function">
      <name>data</name>
      <anchor>data</anchor>
      <arglist>( Mode mode ) const</arglist>
    </member>
    <member kind="function">
      <name>setData</name>
      <anchor>setData</anchor>
      <arglist>( QMimeSource * src, Mode mode )</arglist>
    </member>
    <member kind="function">
      <name>image</name>
      <anchor>image</anchor>
      <arglist>( Mode mode ) const</arglist>
    </member>
    <member kind="function">
      <name>pixmap</name>
      <anchor>pixmap</anchor>
      <arglist>( Mode mode ) const</arglist>
    </member>
    <member kind="function">
      <name>setImage</name>
      <anchor>setImage</anchor>
      <arglist>( const QImage &amp; image, Mode mode )</arglist>
    </member>
    <member kind="function">
      <name>setPixmap</name>
      <anchor>setPixmap</anchor>
      <arglist>( const QPixmap &amp; pixmap, Mode mode )</arglist>
    </member>
    <member kind="function">
      <name>selectionChanged</name>
      <anchor>selectionChanged</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>dataChanged</name>
      <anchor>dataChanged</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCloseEvent</name>
    <filename>qcloseevent.html</filename>
    <member kind="function">
      <name>QCloseEvent</name>
      <anchor>QCloseEvent</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>isAccepted</name>
      <anchor>isAccepted</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>accept</name>
      <anchor>accept</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>ignore</name>
      <anchor>ignore</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCollection</name>
    <filename>qcollection.html</filename>
  </compound>
  <compound kind="class">
    <name>QColor</name>
    <filename>qcolor.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>Spec</anchor>
      <arglist>{ Rgb, Hsv }</arglist>
    </member>
    <member kind="function">
      <name>QColor</name>
      <anchor>QColor</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QColor</name>
      <anchor>QColor</anchor>
      <arglist>( int r, int g, int b )</arglist>
    </member>
    <member kind="function">
      <name>QColor</name>
      <anchor>QColor</anchor>
      <arglist>( int x, int y, int z, Spec colorSpec )</arglist>
    </member>
    <member kind="function">
      <name>QColor</name>
      <anchor>QColor</anchor>
      <arglist>( QRgb rgb, uint pixel = 0xffffffff )</arglist>
    </member>
    <member kind="function">
      <name>QColor</name>
      <anchor>QColor</anchor>
      <arglist>( const QString &amp; name )</arglist>
    </member>
    <member kind="function">
      <name>QColor</name>
      <anchor>QColor</anchor>
      <arglist>( const char * name )</arglist>
    </member>
    <member kind="function">
      <name>QColor</name>
      <anchor>QColor</anchor>
      <arglist>( const QColor &amp; c )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QColor &amp; c )</arglist>
    </member>
    <member kind="function">
      <name>isValid</name>
      <anchor>isValid</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>name</name>
      <anchor>name</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setNamedColor</name>
      <anchor>setNamedColor</anchor>
      <arglist>( const QString &amp; name )</arglist>
    </member>
    <member kind="function">
      <name>rgb</name>
      <anchor>rgb</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setRgb</name>
      <anchor>setRgb</anchor>
      <arglist>( int r, int g, int b )</arglist>
    </member>
    <member kind="function">
      <name>setRgb</name>
      <anchor>setRgb</anchor>
      <arglist>( QRgb rgb )</arglist>
    </member>
    <member kind="function">
      <name>getRgb</name>
      <anchor>getRgb</anchor>
      <arglist>( int * r, int * g, int * b ) const</arglist>
    </member>
    <member kind="function">
      <name>red</name>
      <anchor>red</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>green</name>
      <anchor>green</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>blue</name>
      <anchor>blue</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setHsv</name>
      <anchor>setHsv</anchor>
      <arglist>( int h, int s, int v )</arglist>
    </member>
    <member kind="function">
      <name>getHsv</name>
      <anchor>getHsv</anchor>
      <arglist>( int * h, int * s, int * v ) const</arglist>
    </member>
    <member kind="function">
      <name>light</name>
      <anchor>light</anchor>
      <arglist>( int factor = 150 ) const</arglist>
    </member>
    <member kind="function">
      <name>dark</name>
      <anchor>dark</anchor>
      <arglist>( int factor = 200 ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QColor &amp; c ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QColor &amp; c ) const</arglist>
    </member>
    <member kind="function">
      <name>alloc</name>
      <anchor>alloc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>pixel</name>
      <anchor>pixel</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>pixel</name>
      <anchor>pixel</anchor>
      <arglist>( int screen ) const</arglist>
    </member>
    <member kind="function">
      <name>maxColors</name>
      <anchor>maxColors</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>numBitPlanes</name>
      <anchor>numBitPlanes</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>enterAllocContext</name>
      <anchor>enterAllocContext</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>leaveAllocContext</name>
      <anchor>leaveAllocContext</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>currentAllocContext</name>
      <anchor>currentAllocContext</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>destroyAllocContext</name>
      <anchor>destroyAllocContext</anchor>
      <arglist>( int context )</arglist>
    </member>
    <member kind="function">
      <name>initialize</name>
      <anchor>initialize</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>cleanup</name>
      <anchor>cleanup</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>colorNames</name>
      <anchor>colorNames</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QColor &amp; c )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QColor &amp; c )</arglist>
    </member>
    <member kind="function">
      <name>qRed</name>
      <anchor>qRed</anchor>
      <arglist>( QRgb rgb )</arglist>
    </member>
    <member kind="function">
      <name>qGreen</name>
      <anchor>qGreen</anchor>
      <arglist>( QRgb rgb )</arglist>
    </member>
    <member kind="function">
      <name>qBlue</name>
      <anchor>qBlue</anchor>
      <arglist>( QRgb rgb )</arglist>
    </member>
    <member kind="function">
      <name>qAlpha</name>
      <anchor>qAlpha</anchor>
      <arglist>( QRgb rgba )</arglist>
    </member>
    <member kind="function">
      <name>qRgb</name>
      <anchor>qRgb</anchor>
      <arglist>( int r, int g, int b )</arglist>
    </member>
    <member kind="function">
      <name>qRgba</name>
      <anchor>qRgba</anchor>
      <arglist>( int r, int g, int b, int a )</arglist>
    </member>
    <member kind="function">
      <name>qGray</name>
      <anchor>qGray</anchor>
      <arglist>( int r, int g, int b )</arglist>
    </member>
    <member kind="function">
      <name>qGray</name>
      <anchor>qGray</anchor>
      <arglist>( qRgb rgb )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QColorDialog</name>
    <filename>qcolordialog.html</filename>
    <member kind="function">
      <name>getColor</name>
      <anchor>getColor</anchor>
      <arglist>( const QColor &amp; initial = white, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>getRgba</name>
      <anchor>getRgba</anchor>
      <arglist>( QRgb initial, bool * ok = 0, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>customCount</name>
      <anchor>customCount</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>customColor</name>
      <anchor>customColor</anchor>
      <arglist>( int i )</arglist>
    </member>
    <member kind="function">
      <name>setCustomColor</name>
      <anchor>setCustomColor</anchor>
      <arglist>( int i, QRgb c )</arglist>
    </member>
    <member kind="function">
      <name>setStandardColor</name>
      <anchor>setStandardColor</anchor>
      <arglist>( int i, QRgb c )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QColorDrag</name>
    <filename>qcolordrag.html</filename>
    <member kind="function">
      <name>QColorDrag</name>
      <anchor>QColorDrag</anchor>
      <arglist>( const QColor &amp; col, QWidget * dragsource = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QColorDrag</name>
      <anchor>QColorDrag</anchor>
      <arglist>( QWidget * dragsource = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>setColor</name>
      <anchor>setColor</anchor>
      <arglist>( const QColor &amp; col )</arglist>
    </member>
    <member kind="function">
      <name>canDecode</name>
      <anchor>canDecode</anchor>
      <arglist>( QMimeSource * e )</arglist>
    </member>
    <member kind="function">
      <name>decode</name>
      <anchor>decode</anchor>
      <arglist>( QMimeSource * e, QColor &amp; col )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QColorGroup</name>
    <filename>qcolorgroup.html</filename>
    <member kind="function">
      <name>QColorGroup</name>
      <anchor>QColorGroup</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QColorGroup</name>
      <anchor>QColorGroup</anchor>
      <arglist>( const QBrush &amp; foreground, const QBrush &amp; button, const QBrush &amp; light, const QBrush &amp; dark, const QBrush &amp; mid, const QBrush &amp; text, const QBrush &amp; bright_text, const QBrush &amp; base, const QBrush &amp; background )</arglist>
    </member>
    <member kind="function">
      <name>QColorGroup</name>
      <anchor>QColorGroup</anchor>
      <arglist>( const QColorGroup &amp; other )</arglist>
    </member>
    <member kind="function">
      <name>QColorGroup</name>
      <anchor>QColorGroup</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QColorGroup &amp; other )</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ColorRole</anchor>
      <arglist>{ Foreground, Button, Light, Midlight, Dark, Mid, Text, BrightText, ButtonText, Base, Background, Shadow, Highlight, HighlightedText, Link, LinkVisited, NColorRoles }</arglist>
    </member>
    <member kind="function">
      <name>color</name>
      <anchor>color</anchor>
      <arglist>( ColorRole r ) const</arglist>
    </member>
    <member kind="function">
      <name>brush</name>
      <anchor>brush</anchor>
      <arglist>( ColorRole r ) const</arglist>
    </member>
    <member kind="function">
      <name>setColor</name>
      <anchor>setColor</anchor>
      <arglist>( ColorRole r, const QColor &amp; c )</arglist>
    </member>
    <member kind="function">
      <name>setBrush</name>
      <anchor>setBrush</anchor>
      <arglist>( ColorRole r, const QBrush &amp; b )</arglist>
    </member>
    <member kind="function">
      <name>foreground</name>
      <anchor>foreground</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>button</name>
      <anchor>button</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>light</name>
      <anchor>light</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>dark</name>
      <anchor>dark</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>mid</name>
      <anchor>mid</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>base</name>
      <anchor>base</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>background</name>
      <anchor>background</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>midlight</name>
      <anchor>midlight</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>brightText</name>
      <anchor>brightText</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>buttonText</name>
      <anchor>buttonText</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>shadow</name>
      <anchor>shadow</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>highlight</name>
      <anchor>highlight</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>highlightedText</name>
      <anchor>highlightedText</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>link</name>
      <anchor>link</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>linkVisited</name>
      <anchor>linkVisited</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QColorGroup &amp; g ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QColorGroup &amp; g ) const</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QColorGroup &amp; g )</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ColorRole</anchor>
      <arglist>. Usually this</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ColorRole</anchor>
      <arglist>color.</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ColorRole</anchor>
      <arglist>color.</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ColorRole</anchor>
      <arglist>and</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ColorRole</anchor>
      <arglist>.</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ColorRole</anchor>
      <arglist>and</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ColorRole</anchor>
      <arglist>.</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ColorRole</anchor>
      <arglist>and contrasts well with e.g.</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QComboBox</name>
    <filename>qcombobox.html</filename>
    <member kind="function">
      <name>QComboBox</name>
      <anchor>QComboBox</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QComboBox</name>
      <anchor>QComboBox</anchor>
      <arglist>( bool rw, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QComboBox</name>
      <anchor>QComboBox</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>insertStringList</name>
      <anchor>insertStringList</anchor>
      <arglist>( const QStringList &amp; list, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertStrList</name>
      <anchor>insertStrList</anchor>
      <arglist>( const QStrList &amp; list, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertStrList</name>
      <anchor>insertStrList</anchor>
      <arglist>( const QStrList * list, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertStrList</name>
      <anchor>insertStrList</anchor>
      <arglist>( const char ** strings, int numStrings = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QString &amp; t, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QPixmap &amp; pixmap, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QPixmap &amp; pixmap, const QString &amp; text, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>removeItem</name>
      <anchor>removeItem</anchor>
      <arglist>( int index )</arglist>
    </member>
    <member kind="function">
      <name>currentItem</name>
      <anchor>currentItem</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setCurrentItem</name>
      <anchor>setCurrentItem</anchor>
      <arglist>( int index )</arglist>
    </member>
    <member kind="function">
      <name>currentText</name>
      <anchor>currentText</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setCurrentText</name>
      <anchor>setCurrentText</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>( int index ) const</arglist>
    </member>
    <member kind="function">
      <name>pixmap</name>
      <anchor>pixmap</anchor>
      <arglist>( int index ) const</arglist>
    </member>
    <member kind="function">
      <name>changeItem</name>
      <anchor>changeItem</anchor>
      <arglist>( const QString &amp; t, int index )</arglist>
    </member>
    <member kind="function">
      <name>changeItem</name>
      <anchor>changeItem</anchor>
      <arglist>( const QPixmap &amp; im, int index )</arglist>
    </member>
    <member kind="function">
      <name>changeItem</name>
      <anchor>changeItem</anchor>
      <arglist>( const QPixmap &amp; im, const QString &amp; t, int index )</arglist>
    </member>
    <member kind="function">
      <name>setPalette</name>
      <anchor>setPalette</anchor>
      <arglist>( const QPalette &amp; palette )</arglist>
    </member>
    <member kind="function">
      <name>setFont</name>
      <anchor>setFont</anchor>
      <arglist>( const QFont &amp; font )</arglist>
    </member>
    <member kind="function">
      <name>setSizeLimit</name>
      <anchor>setSizeLimit</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>sizeLimit</name>
      <anchor>sizeLimit</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMaxCount</name>
      <anchor>setMaxCount</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>maxCount</name>
      <anchor>maxCount</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Policy</anchor>
      <arglist>{ NoInsertion, AtTop, AtCurrent, AtBottom, AfterCurrent, BeforeCurrent }</arglist>
    </member>
    <member kind="function">
      <name>setInsertionPolicy</name>
      <anchor>setInsertionPolicy</anchor>
      <arglist>( Policy policy )</arglist>
    </member>
    <member kind="function">
      <name>insertionPolicy</name>
      <anchor>insertionPolicy</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setValidator</name>
      <anchor>setValidator</anchor>
      <arglist>( const QValidator * v )</arglist>
    </member>
    <member kind="function">
      <name>validator</name>
      <anchor>validator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setListBox</name>
      <anchor>setListBox</anchor>
      <arglist>( QListBox * newListBox )</arglist>
    </member>
    <member kind="function">
      <name>listBox</name>
      <anchor>listBox</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setLineEdit</name>
      <anchor>setLineEdit</anchor>
      <arglist>( QLineEdit * edit )</arglist>
    </member>
    <member kind="function">
      <name>lineEdit</name>
      <anchor>lineEdit</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoCompletion</name>
      <anchor>setAutoCompletion</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>autoCompletion</name>
      <anchor>autoCompletion</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setDuplicatesEnabled</name>
      <anchor>setDuplicatesEnabled</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>duplicatesEnabled</name>
      <anchor>duplicatesEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>editable</name>
      <anchor>editable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setEditable</name>
      <anchor>setEditable</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>popup</name>
      <anchor>popup</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>clearValidator</name>
      <anchor>clearValidator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>clearEdit</name>
      <anchor>clearEdit</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setEditText</name>
      <anchor>setEditText</anchor>
      <arglist>( const QString &amp; newText )</arglist>
    </member>
    <member kind="function">
      <name>activated</name>
      <anchor>activated</anchor>
      <arglist>( int index )</arglist>
    </member>
    <member kind="function">
      <name>highlighted</name>
      <anchor>highlighted</anchor>
      <arglist>( int index )</arglist>
    </member>
    <member kind="function">
      <name>activated</name>
      <anchor>activated</anchor>
      <arglist>( const QString &amp; string )</arglist>
    </member>
    <member kind="function">
      <name>highlighted</name>
      <anchor>highlighted</anchor>
      <arglist>( const QString &amp; string )</arglist>
    </member>
    <member kind="function">
      <name>textChanged</name>
      <anchor>textChanged</anchor>
      <arglist>( const QString &amp; string )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>autoCompletion</anchor>
      <arglist>- whether auto-completion is enabled</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>autoMask</anchor>
      <arglist>- whether the combobox is automatically masked</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>count</anchor>
      <arglist>- the number of items in the combobox</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>currentItem</anchor>
      <arglist>- the index of the current item in the combobox</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>currentText</anchor>
      <arglist>- the text of the combobox&apos;s current item</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>duplicatesEnabled</anchor>
      <arglist>- whether duplicates are allowed</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>editable</anchor>
      <arglist>- whether the combobox is editable</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>insertionPolicy</anchor>
      <arglist>- the position of the items inserted by the user</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>maxCount</anchor>
      <arglist>- the maximum number of items allowed in the combobox</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>sizeLimit</anchor>
      <arglist>- the maximum on-screen size of the combobox</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QComboTableItem</name>
    <filename>qcombotableitem.html</filename>
    <member kind="function">
      <name>QComboTableItem</name>
      <anchor>QComboTableItem</anchor>
      <arglist>( QTable * table, const QStringList &amp; list, bool editable = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>setCurrentItem</name>
      <anchor>setCurrentItem</anchor>
      <arglist>( int i )</arglist>
    </member>
    <member kind="function">
      <name>setCurrentItem</name>
      <anchor>setCurrentItem</anchor>
      <arglist>( const QString &amp; s )</arglist>
    </member>
    <member kind="function">
      <name>currentItem</name>
      <anchor>currentItem</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>currentText</name>
      <anchor>currentText</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>( int i ) const</arglist>
    </member>
    <member kind="function">
      <name>setEditable</name>
      <anchor>setEditable</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>isEditable</name>
      <anchor>isEditable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setStringList</name>
      <anchor>setStringList</anchor>
      <arglist>( const QStringList &amp; l )</arglist>
    </member>
    <member kind="function">
      <name>rtti</name>
      <anchor>rtti</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCommonStyle</name>
    <filename>qcommonstyle.html</filename>
    <member kind="function">
      <name>QCommonStyle</name>
      <anchor>QCommonStyle</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QConstString</name>
    <filename>qconststring.html</filename>
    <member kind="function">
      <name>QConstString</name>
      <anchor>QConstString</anchor>
      <arglist>( const QChar * unicode, uint length )</arglist>
    </member>
    <member kind="function">
      <name>QConstString</name>
      <anchor>QConstString</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>string</name>
      <anchor>string</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QContextMenuEvent</name>
    <filename>qcontextmenuevent.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>Reason</anchor>
      <arglist>{ Mouse, Keyboard, Other }</arglist>
    </member>
    <member kind="function">
      <name>QContextMenuEvent</name>
      <anchor>QContextMenuEvent</anchor>
      <arglist>( Reason reason, const QPoint &amp; pos, const QPoint &amp; globalPos, int state )</arglist>
    </member>
    <member kind="function">
      <name>QContextMenuEvent</name>
      <anchor>QContextMenuEvent</anchor>
      <arglist>( Reason reason, const QPoint &amp; pos, int state )</arglist>
    </member>
    <member kind="function">
      <name>x</name>
      <anchor>x</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>y</name>
      <anchor>y</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>globalX</name>
      <anchor>globalX</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>globalY</name>
      <anchor>globalY</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>pos</name>
      <anchor>pos</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>globalPos</name>
      <anchor>globalPos</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>state</name>
      <anchor>state</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isAccepted</name>
      <anchor>isAccepted</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isConsumed</name>
      <anchor>isConsumed</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>consume</name>
      <anchor>consume</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>accept</name>
      <anchor>accept</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>ignore</name>
      <anchor>ignore</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>reason</name>
      <anchor>reason</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCopChannel</name>
    <filename>qcopchannel.html</filename>
    <member kind="function">
      <name>QCopChannel</name>
      <anchor>QCopChannel</anchor>
      <arglist>( const QCString &amp; channel, QObject * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QCopChannel</name>
      <anchor>QCopChannel</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>channel</name>
      <anchor>channel</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>receive</name>
      <anchor>receive</anchor>
      <arglist>( const QCString &amp; msg, const QByteArray &amp; data )</arglist>
    </member>
    <member kind="function">
      <name>received</name>
      <anchor>received</anchor>
      <arglist>( const QCString &amp; msg, const QByteArray &amp; data )</arglist>
    </member>
    <member kind="function">
      <name>isRegistered</name>
      <anchor>isRegistered</anchor>
      <arglist>( const QCString &amp; channel )</arglist>
    </member>
    <member kind="function">
      <name>send</name>
      <anchor>send</anchor>
      <arglist>( const QCString &amp; channel, const QCString &amp; msg )</arglist>
    </member>
    <member kind="function">
      <name>send</name>
      <anchor>send</anchor>
      <arglist>( const QCString &amp; channel, const QCString &amp; msg, const QByteArray &amp; data )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCString</name>
    <filename>qcstring.html</filename>
    <member kind="function">
      <name>QCString</name>
      <anchor>QCString</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QCString</name>
      <anchor>QCString</anchor>
      <arglist>( int size )</arglist>
    </member>
    <member kind="function">
      <name>QCString</name>
      <anchor>QCString</anchor>
      <arglist>( const QCString &amp; s )</arglist>
    </member>
    <member kind="function">
      <name>QCString</name>
      <anchor>QCString</anchor>
      <arglist>( const char * str )</arglist>
    </member>
    <member kind="function">
      <name>QCString</name>
      <anchor>QCString</anchor>
      <arglist>( const char * str, uint maxsize )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QCString &amp; s )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const char * str )</arglist>
    </member>
    <member kind="function">
      <name>isNull</name>
      <anchor>isNull</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>length</name>
      <anchor>length</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>resize</name>
      <anchor>resize</anchor>
      <arglist>( uint len )</arglist>
    </member>
    <member kind="function">
      <name>truncate</name>
      <anchor>truncate</anchor>
      <arglist>( uint pos )</arglist>
    </member>
    <member kind="function">
      <name>fill</name>
      <anchor>fill</anchor>
      <arglist>( char c, int len = -1 )</arglist>
    </member>
    <member kind="function">
      <name>copy</name>
      <anchor>copy</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>sprintf</name>
      <anchor>sprintf</anchor>
      <arglist>( const char * format, ... )</arglist>
    </member>
    <member kind="function">
      <name>find</name>
      <anchor>find</anchor>
      <arglist>( char c, int index = 0, bool cs = TRUE ) const</arglist>
    </member>
    <member kind="function">
      <name>find</name>
      <anchor>find</anchor>
      <arglist>( const char * str, int index = 0, bool cs = TRUE ) const</arglist>
    </member>
    <member kind="function">
      <name>find</name>
      <anchor>find</anchor>
      <arglist>( const QRegExp &amp; rx, int index = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>findRev</name>
      <anchor>findRev</anchor>
      <arglist>( char c, int index = -1, bool cs = TRUE ) const</arglist>
    </member>
    <member kind="function">
      <name>findRev</name>
      <anchor>findRev</anchor>
      <arglist>( const char * str, int index = -1, bool cs = TRUE ) const</arglist>
    </member>
    <member kind="function">
      <name>findRev</name>
      <anchor>findRev</anchor>
      <arglist>( const QRegExp &amp; rx, int index = -1 ) const</arglist>
    </member>
    <member kind="function">
      <name>contains</name>
      <anchor>contains</anchor>
      <arglist>( char c, bool cs = TRUE ) const</arglist>
    </member>
    <member kind="function">
      <name>contains</name>
      <anchor>contains</anchor>
      <arglist>( const char * str, bool cs = TRUE ) const</arglist>
    </member>
    <member kind="function">
      <name>contains</name>
      <anchor>contains</anchor>
      <arglist>( const QRegExp &amp; rx ) const</arglist>
    </member>
    <member kind="function">
      <name>left</name>
      <anchor>left</anchor>
      <arglist>( uint len ) const</arglist>
    </member>
    <member kind="function">
      <name>right</name>
      <anchor>right</anchor>
      <arglist>( uint len ) const</arglist>
    </member>
    <member kind="function">
      <name>mid</name>
      <anchor>mid</anchor>
      <arglist>( uint index, uint len = 0xffffffff ) const</arglist>
    </member>
    <member kind="function">
      <name>leftJustify</name>
      <anchor>leftJustify</anchor>
      <arglist>( uint width, char fill = &apos; &apos;, bool truncate = FALSE ) const</arglist>
    </member>
    <member kind="function">
      <name>rightJustify</name>
      <anchor>rightJustify</anchor>
      <arglist>( uint width, char fill = &apos; &apos;, bool truncate = FALSE ) const</arglist>
    </member>
    <member kind="function">
      <name>lower</name>
      <anchor>lower</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>upper</name>
      <anchor>upper</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>stripWhiteSpace</name>
      <anchor>stripWhiteSpace</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>simplifyWhiteSpace</name>
      <anchor>simplifyWhiteSpace</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>insert</name>
      <anchor>insert</anchor>
      <arglist>( uint index, const char * s )</arglist>
    </member>
    <member kind="function">
      <name>insert</name>
      <anchor>insert</anchor>
      <arglist>( uint index, char c )</arglist>
    </member>
    <member kind="function">
      <name>append</name>
      <anchor>append</anchor>
      <arglist>( const char * str )</arglist>
    </member>
    <member kind="function">
      <name>prepend</name>
      <anchor>prepend</anchor>
      <arglist>( const char * s )</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>( uint index, uint len )</arglist>
    </member>
    <member kind="function">
      <name>replace</name>
      <anchor>replace</anchor>
      <arglist>( uint index, uint len, const char * str )</arglist>
    </member>
    <member kind="function">
      <name>replace</name>
      <anchor>replace</anchor>
      <arglist>( const QRegExp &amp; rx, const char * str )</arglist>
    </member>
    <member kind="function">
      <name>replace</name>
      <anchor>replace</anchor>
      <arglist>( char c, const char * after )</arglist>
    </member>
    <member kind="function">
      <name>replace</name>
      <anchor>replace</anchor>
      <arglist>( const char * before, const char * after )</arglist>
    </member>
    <member kind="function">
      <name>replace</name>
      <anchor>replace</anchor>
      <arglist>( char c1, char c2 )</arglist>
    </member>
    <member kind="function">
      <name>toShort</name>
      <anchor>toShort</anchor>
      <arglist>( bool * ok = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>toUShort</name>
      <anchor>toUShort</anchor>
      <arglist>( bool * ok = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>toInt</name>
      <anchor>toInt</anchor>
      <arglist>( bool * ok = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>toUInt</name>
      <anchor>toUInt</anchor>
      <arglist>( bool * ok = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>toLong</name>
      <anchor>toLong</anchor>
      <arglist>( bool * ok = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>toULong</name>
      <anchor>toULong</anchor>
      <arglist>( bool * ok = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>toFloat</name>
      <anchor>toFloat</anchor>
      <arglist>( bool * ok = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>toDouble</name>
      <anchor>toDouble</anchor>
      <arglist>( bool * ok = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>setStr</name>
      <anchor>setStr</anchor>
      <arglist>( const char * str )</arglist>
    </member>
    <member kind="function">
      <name>setNum</name>
      <anchor>setNum</anchor>
      <arglist>( short n )</arglist>
    </member>
    <member kind="function">
      <name>setNum</name>
      <anchor>setNum</anchor>
      <arglist>( ushort n )</arglist>
    </member>
    <member kind="function">
      <name>setNum</name>
      <anchor>setNum</anchor>
      <arglist>( int n )</arglist>
    </member>
    <member kind="function">
      <name>setNum</name>
      <anchor>setNum</anchor>
      <arglist>( uint n )</arglist>
    </member>
    <member kind="function">
      <name>setNum</name>
      <anchor>setNum</anchor>
      <arglist>( long n )</arglist>
    </member>
    <member kind="function">
      <name>setNum</name>
      <anchor>setNum</anchor>
      <arglist>( ulong n )</arglist>
    </member>
    <member kind="function">
      <name>setNum</name>
      <anchor>setNum</anchor>
      <arglist>( float n, char f = &apos;g&apos;, int prec = 6 )</arglist>
    </member>
    <member kind="function">
      <name>setNum</name>
      <anchor>setNum</anchor>
      <arglist>( double n, char f = &apos;g&apos;, int prec = 6 )</arglist>
    </member>
    <member kind="function">
      <name>setExpand</name>
      <anchor>setExpand</anchor>
      <arglist>( uint index, char c )</arglist>
    </member>
    <member kind="function">
      <name>const</name>
      <anchor>operator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const char * str )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( char c )</arglist>
    </member>
    <member kind="function">
      <name>qmemmove</name>
      <anchor>qmemmove</anchor>
      <arglist>( void * dst, const void * src, uint len )</arglist>
    </member>
    <member kind="function">
      <name>qstrdup</name>
      <anchor>qstrdup</anchor>
      <arglist>( const char * src )</arglist>
    </member>
    <member kind="function">
      <name>qstrcpy</name>
      <anchor>qstrcpy</anchor>
      <arglist>( char * dst, const char * src )</arglist>
    </member>
    <member kind="function">
      <name>qstrncpy</name>
      <anchor>qstrncpy</anchor>
      <arglist>( char * dst, const char * src, uint len )</arglist>
    </member>
    <member kind="function">
      <name>qstrlen</name>
      <anchor>qstrlen</anchor>
      <arglist>( const char * str )</arglist>
    </member>
    <member kind="function">
      <name>qstrcmp</name>
      <anchor>qstrcmp</anchor>
      <arglist>( const char * str1, const char * str2 )</arglist>
    </member>
    <member kind="function">
      <name>qstrncmp</name>
      <anchor>qstrncmp</anchor>
      <arglist>( const char * str1, const char * str2, uint len )</arglist>
    </member>
    <member kind="function">
      <name>qstricmp</name>
      <anchor>qstricmp</anchor>
      <arglist>( const char * str1, const char * str2 )</arglist>
    </member>
    <member kind="function">
      <name>qstrnicmp</name>
      <anchor>qstrnicmp</anchor>
      <arglist>( const char * str1, const char * str2, uint len )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QCString &amp; str )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QCString &amp; str )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QCString &amp; s1, const QCString &amp; s2 )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QCString &amp; s1, const char * s2 )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const char * s1, const QCString &amp; s2 )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QCString &amp; s1, const QCString &amp; s2 )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QCString &amp; s1, const char * s2 )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const char * s1, const QCString &amp; s2 )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( const QCString &amp; s1, const char * s2 )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( const char * s1, const QCString &amp; s2 )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( const QCString &amp; s1, const char * s2 )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( const char * s1, const QCString &amp; s2 )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( const QCString &amp; s1, const char * s2 )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( const char * s1, const QCString &amp; s2 )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( const QCString &amp; s1, const char * s2 )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( const char * s1, const QCString &amp; s2 )</arglist>
    </member>
    <member kind="function">
      <name>operator+</name>
      <anchor>operator</anchor>
      <arglist>( const QCString &amp; s1, const QCString &amp; s2 )</arglist>
    </member>
    <member kind="function">
      <name>operator+</name>
      <anchor>operator</anchor>
      <arglist>( const QCString &amp; s1, const char * s2 )</arglist>
    </member>
    <member kind="function">
      <name>operator+</name>
      <anchor>operator</anchor>
      <arglist>( const char * s1, const QCString &amp; s2 )</arglist>
    </member>
    <member kind="function">
      <name>operator+</name>
      <anchor>operator</anchor>
      <arglist>( const QCString &amp; s, char c )</arglist>
    </member>
    <member kind="function">
      <name>operator+</name>
      <anchor>operator</anchor>
      <arglist>( char c, const QCString &amp; s )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCursor</name>
    <filename>qcursor.html</filename>
    <member kind="function">
      <name>QCursor</name>
      <anchor>QCursor</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QCursor</name>
      <anchor>QCursor</anchor>
      <arglist>( int shape )</arglist>
    </member>
    <member kind="function">
      <name>QCursor</name>
      <anchor>QCursor</anchor>
      <arglist>( const QBitmap &amp; bitmap, const QBitmap &amp; mask, int hotX = -1, int hotY = -1 )</arglist>
    </member>
    <member kind="function">
      <name>QCursor</name>
      <anchor>QCursor</anchor>
      <arglist>( const QPixmap &amp; pixmap, int hotX = -1, int hotY = -1 )</arglist>
    </member>
    <member kind="function">
      <name>QCursor</name>
      <anchor>QCursor</anchor>
      <arglist>( const QCursor &amp; c )</arglist>
    </member>
    <member kind="function">
      <name>QCursor</name>
      <anchor>QCursor</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QCursor &amp; c )</arglist>
    </member>
    <member kind="function">
      <name>shape</name>
      <anchor>shape</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setShape</name>
      <anchor>setShape</anchor>
      <arglist>( int shape )</arglist>
    </member>
    <member kind="function">
      <name>bitmap</name>
      <anchor>bitmap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>mask</name>
      <anchor>mask</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>hotSpot</name>
      <anchor>hotSpot</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>QCursor</name>
      <anchor>QCursor</anchor>
      <arglist>( HCURSOR handle )</arglist>
    </member>
    <member kind="function">
      <name>handle</name>
      <anchor>handle</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>pos</name>
      <anchor>pos</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setPos</name>
      <anchor>setPos</anchor>
      <arglist>( int x, int y )</arglist>
    </member>
    <member kind="function">
      <name>setPos</name>
      <anchor>setPos</anchor>
      <arglist>( const QPoint &amp; )</arglist>
    </member>
    <member kind="function">
      <name>initialize</name>
      <anchor>initialize</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>cleanup</name>
      <anchor>cleanup</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QCursor &amp; c )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QCursor &amp; c )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCustomEvent</name>
    <filename>qcustomevent.html</filename>
    <member kind="function">
      <name>QCustomEvent</name>
      <anchor>QCustomEvent</anchor>
      <arglist>( int type )</arglist>
    </member>
    <member kind="function">
      <name>QCustomEvent</name>
      <anchor>QCustomEvent</anchor>
      <arglist>( Type type, void * data )</arglist>
    </member>
    <member kind="function">
      <name>data</name>
      <anchor>data</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setData</name>
      <anchor>setData</anchor>
      <arglist>( void * data )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCustomMenuItem</name>
    <filename>qcustommenuitem.html</filename>
    <member kind="function">
      <name>QCustomMenuItem</name>
      <anchor>QCustomMenuItem</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QCustomMenuItem</name>
      <anchor>QCustomMenuItem</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>fullSpan</name>
      <anchor>fullSpan</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isSeparator</name>
      <anchor>isSeparator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setFont</name>
      <anchor>setFont</anchor>
      <arglist>( const QFont &amp; font )</arglist>
    </member>
    <member kind="function">
      <name>paint</name>
      <anchor>paint</anchor>
      <arglist>( QPainter * p, const QColorGroup &amp; cg, bool act, bool enabled, int x, int y, int w, int h ) = 0</arglist>
    </member>
    <member kind="function">
      <name>sizeHint</name>
      <anchor>sizeHint</anchor>
      <arglist>() = 0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDataBrowser</name>
    <filename>qdatabrowser.html</filename>
    <member kind="function">
      <name>QDataBrowser</name>
      <anchor>QDataBrowser</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0, WFlags fl = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QDataBrowser</name>
      <anchor>QDataBrowser</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Boundary</anchor>
      <arglist>{ Unknown, None, BeforeBeginning, Beginning, End, AfterEnd }</arglist>
    </member>
    <member kind="function">
      <name>boundary</name>
      <anchor>boundary</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setBoundaryChecking</name>
      <anchor>setBoundaryChecking</anchor>
      <arglist>( bool active )</arglist>
    </member>
    <member kind="function">
      <name>boundaryChecking</name>
      <anchor>boundaryChecking</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSort</name>
      <anchor>setSort</anchor>
      <arglist>( const QSqlIndex &amp; sort )</arglist>
    </member>
    <member kind="function">
      <name>setSort</name>
      <anchor>setSort</anchor>
      <arglist>( const QStringList &amp; sort )</arglist>
    </member>
    <member kind="function">
      <name>sort</name>
      <anchor>sort</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setFilter</name>
      <anchor>setFilter</anchor>
      <arglist>( const QString &amp; filter )</arglist>
    </member>
    <member kind="function">
      <name>filter</name>
      <anchor>filter</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSqlCursor</name>
      <anchor>setSqlCursor</anchor>
      <arglist>( QSqlCursor * cursor, bool autoDelete = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>sqlCursor</name>
      <anchor>sqlCursor</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setForm</name>
      <anchor>setForm</anchor>
      <arglist>( QSqlForm * form )</arglist>
    </member>
    <member kind="function">
      <name>form</name>
      <anchor>form</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setConfirmEdits</name>
      <anchor>setConfirmEdits</anchor>
      <arglist>( bool confirm )</arglist>
    </member>
    <member kind="function">
      <name>setConfirmInsert</name>
      <anchor>setConfirmInsert</anchor>
      <arglist>( bool confirm )</arglist>
    </member>
    <member kind="function">
      <name>setConfirmUpdate</name>
      <anchor>setConfirmUpdate</anchor>
      <arglist>( bool confirm )</arglist>
    </member>
    <member kind="function">
      <name>setConfirmDelete</name>
      <anchor>setConfirmDelete</anchor>
      <arglist>( bool confirm )</arglist>
    </member>
    <member kind="function">
      <name>setConfirmCancels</name>
      <anchor>setConfirmCancels</anchor>
      <arglist>( bool confirm )</arglist>
    </member>
    <member kind="function">
      <name>confirmEdits</name>
      <anchor>confirmEdits</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>confirmInsert</name>
      <anchor>confirmInsert</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>confirmUpdate</name>
      <anchor>confirmUpdate</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>confirmDelete</name>
      <anchor>confirmDelete</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>confirmCancels</name>
      <anchor>confirmCancels</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setReadOnly</name>
      <anchor>setReadOnly</anchor>
      <arglist>( bool active )</arglist>
    </member>
    <member kind="function">
      <name>isReadOnly</name>
      <anchor>isReadOnly</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoEdit</name>
      <anchor>setAutoEdit</anchor>
      <arglist>( bool autoEdit )</arglist>
    </member>
    <member kind="function">
      <name>autoEdit</name>
      <anchor>autoEdit</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>seek</name>
      <anchor>seek</anchor>
      <arglist>( int i, bool relative = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>refresh</name>
      <anchor>refresh</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>insert</name>
      <anchor>insert</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>update</name>
      <anchor>update</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>del</name>
      <anchor>del</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>first</name>
      <anchor>first</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>last</name>
      <anchor>last</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>next</name>
      <anchor>next</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>prev</name>
      <anchor>prev</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>readFields</name>
      <anchor>readFields</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>writeFields</name>
      <anchor>writeFields</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>clearValues</name>
      <anchor>clearValues</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>updateBoundary</name>
      <anchor>updateBoundary</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>firstRecordAvailable</name>
      <anchor>firstRecordAvailable</anchor>
      <arglist>( bool available )</arglist>
    </member>
    <member kind="function">
      <name>lastRecordAvailable</name>
      <anchor>lastRecordAvailable</anchor>
      <arglist>( bool available )</arglist>
    </member>
    <member kind="function">
      <name>nextRecordAvailable</name>
      <anchor>nextRecordAvailable</anchor>
      <arglist>( bool available )</arglist>
    </member>
    <member kind="function">
      <name>prevRecordAvailable</name>
      <anchor>prevRecordAvailable</anchor>
      <arglist>( bool available )</arglist>
    </member>
    <member kind="function">
      <name>currentChanged</name>
      <anchor>currentChanged</anchor>
      <arglist>( const QSqlRecord * record )</arglist>
    </member>
    <member kind="function">
      <name>primeInsert</name>
      <anchor>primeInsert</anchor>
      <arglist>( QSqlRecord * buf )</arglist>
    </member>
    <member kind="function">
      <name>primeUpdate</name>
      <anchor>primeUpdate</anchor>
      <arglist>( QSqlRecord * buf )</arglist>
    </member>
    <member kind="function">
      <name>primeDelete</name>
      <anchor>primeDelete</anchor>
      <arglist>( QSqlRecord * buf )</arglist>
    </member>
    <member kind="function">
      <name>beforeInsert</name>
      <anchor>beforeInsert</anchor>
      <arglist>( QSqlRecord * buf )</arglist>
    </member>
    <member kind="function">
      <name>beforeUpdate</name>
      <anchor>beforeUpdate</anchor>
      <arglist>( QSqlRecord * buf )</arglist>
    </member>
    <member kind="function">
      <name>beforeDelete</name>
      <anchor>beforeDelete</anchor>
      <arglist>( QSqlRecord * buf )</arglist>
    </member>
    <member kind="function">
      <name>cursorChanged</name>
      <anchor>cursorChanged</anchor>
      <arglist>( QSqlCursor::Mode mode )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>autoEdit</anchor>
      <arglist>- whether the browser automatically applies edits</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>boundaryChecking</anchor>
      <arglist>- whether boundary checking is active</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>confirmCancels</anchor>
      <arglist>- whether the browser confirms cancel operations</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>confirmDelete</anchor>
      <arglist>- whether the browser confirms deletions</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>confirmEdits</anchor>
      <arglist>- whether the browser confirms edits</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>confirmInsert</anchor>
      <arglist>- whether the data browser confirms insertions</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>confirmUpdate</anchor>
      <arglist>- whether the browser confirms updates</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>filter</anchor>
      <arglist>- the data browser&apos;s filter</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>readOnly</anchor>
      <arglist>- whether the browser is read-only</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>sort</anchor>
      <arglist>- the data browser&apos;s sort</arglist>
    </member>
    <member kind="function">
      <name>insertCurrent</name>
      <anchor>insertCurrent</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>updateCurrent</name>
      <anchor>updateCurrent</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>deleteCurrent</name>
      <anchor>deleteCurrent</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>currentEdited</name>
      <anchor>currentEdited</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>confirmEdit</name>
      <anchor>confirmEdit</anchor>
      <arglist>( QSql::Op m )</arglist>
    </member>
    <member kind="function">
      <name>confirmCancel</name>
      <anchor>confirmCancel</anchor>
      <arglist>( QSql::Op m )</arglist>
    </member>
    <member kind="function">
      <name>handleError</name>
      <anchor>handleError</anchor>
      <arglist>( const QSqlError &amp; error )</arglist>
    </member>
    <member kind="function">
      <name>primeUpdate</name>
      <anchor>primeUpdate</anchor>
      <arglist>() signal is emitted when</arglist>
    </member>
    <member kind="function">
      <name>primeDelete</name>
      <anchor>primeDelete</anchor>
      <arglist>() signal is emitted when</arglist>
    </member>
    <member kind="function">
      <name>QSqlCursor</name>
      <anchor>primeInsert</anchor>
      <arglist>().</arglist>
    </member>
    <member kind="function">
      <name>primeInsert</name>
      <anchor>primeInsert</anchor>
      <arglist>() signal is emitted.</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDataPump</name>
    <filename>qdatapump.html</filename>
    <member kind="function">
      <name>QDataPump</name>
      <anchor>QDataPump</anchor>
      <arglist>( QDataSource * data_source, QDataSink * data_sink )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDataSink</name>
    <filename>qdatasink.html</filename>
    <member kind="function">
      <name>readyToReceive</name>
      <anchor>readyToReceive</anchor>
      <arglist>() = 0</arglist>
    </member>
    <member kind="function">
      <name>receive</name>
      <anchor>receive</anchor>
      <arglist>( const uchar *, int count ) = 0</arglist>
    </member>
    <member kind="function">
      <name>eof</name>
      <anchor>eof</anchor>
      <arglist>() = 0</arglist>
    </member>
    <member kind="function">
      <name>maybeReady</name>
      <anchor>maybeReady</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDataSource</name>
    <filename>qdatasource.html</filename>
    <member kind="function">
      <name>readyToSend</name>
      <anchor>readyToSend</anchor>
      <arglist>() = 0</arglist>
    </member>
    <member kind="function">
      <name>sendTo</name>
      <anchor>sendTo</anchor>
      <arglist>( QDataSink *, int count ) = 0</arglist>
    </member>
    <member kind="function">
      <name>maybeReady</name>
      <anchor>maybeReady</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>rewindable</name>
      <anchor>rewindable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>enableRewind</name>
      <anchor>enableRewind</anchor>
      <arglist>( bool on )</arglist>
    </member>
    <member kind="function">
      <name>rewind</name>
      <anchor>rewind</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDataStream</name>
    <filename>qdatastream.html</filename>
    <member kind="function">
      <name>QDataStream</name>
      <anchor>QDataStream</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDataStream</name>
      <anchor>QDataStream</anchor>
      <arglist>( QIODevice * d )</arglist>
    </member>
    <member kind="function">
      <name>QDataStream</name>
      <anchor>QDataStream</anchor>
      <arglist>( QByteArray a, int mode )</arglist>
    </member>
    <member kind="function">
      <name>QDataStream</name>
      <anchor>QDataStream</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>device</name>
      <anchor>device</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setDevice</name>
      <anchor>setDevice</anchor>
      <arglist>( QIODevice * d )</arglist>
    </member>
    <member kind="function">
      <name>unsetDevice</name>
      <anchor>unsetDevice</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>atEnd</name>
      <anchor>atEnd</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ByteOrder</anchor>
      <arglist>{ BigEndian, LittleEndian }</arglist>
    </member>
    <member kind="function">
      <name>byteOrder</name>
      <anchor>byteOrder</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setByteOrder</name>
      <anchor>setByteOrder</anchor>
      <arglist>( int bo )</arglist>
    </member>
    <member kind="function">
      <name>isPrintableData</name>
      <anchor>isPrintableData</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPrintableData</name>
      <anchor>setPrintableData</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>version</name>
      <anchor>version</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setVersion</name>
      <anchor>setVersion</anchor>
      <arglist>( int v )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( Q_INT8 &amp; i )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( Q_UINT8 &amp; i )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( Q_INT16 &amp; i )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( Q_UINT16 &amp; i )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( Q_INT32 &amp; i )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( Q_UINT32 &amp; i )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( Q_INT64 &amp; i )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( Q_UINT64 &amp; i )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( Q_LONG &amp; i )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( Q_ULONG &amp; i )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( float &amp; f )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( double &amp; f )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( char *&amp; s )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( Q_INT8 i )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( Q_UINT8 i )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( Q_INT16 i )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( Q_UINT16 i )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( Q_INT32 i )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( Q_UINT32 i )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( Q_INT64 i )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( Q_UINT64 i )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( Q_LONG i )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( Q_ULONG i )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( float f )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( double f )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( const char * s )</arglist>
    </member>
    <member kind="function">
      <name>readBytes</name>
      <anchor>readBytes</anchor>
      <arglist>( char *&amp; s, uint &amp; l )</arglist>
    </member>
    <member kind="function">
      <name>readRawBytes</name>
      <anchor>readRawBytes</anchor>
      <arglist>( char * s, uint len )</arglist>
    </member>
    <member kind="function">
      <name>writeBytes</name>
      <anchor>writeBytes</anchor>
      <arglist>( const char * s, uint len )</arglist>
    </member>
    <member kind="function">
      <name>writeRawBytes</name>
      <anchor>writeRawBytes</anchor>
      <arglist>( const char * s, uint len )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDataTable</name>
    <filename>qdatatable.html</filename>
    <member kind="function">
      <name>QDataTable</name>
      <anchor>QDataTable</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QDataTable</name>
      <anchor>QDataTable</anchor>
      <arglist>( QSqlCursor * cursor, bool autoPopulate = FALSE, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QDataTable</name>
      <anchor>QDataTable</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>addColumn</name>
      <anchor>addColumn</anchor>
      <arglist>( const QString &amp; fieldName, const QString &amp; label = QString::null, int width = -1, const QIconSet &amp; iconset = QIconSet ( ) )</arglist>
    </member>
    <member kind="function">
      <name>removeColumn</name>
      <anchor>removeColumn</anchor>
      <arglist>( uint col )</arglist>
    </member>
    <member kind="function">
      <name>setColumn</name>
      <anchor>setColumn</anchor>
      <arglist>( uint col, const QString &amp; fieldName, const QString &amp; label = QString::null, int width = -1, const QIconSet &amp; iconset = QIconSet ( ) )</arglist>
    </member>
    <member kind="function">
      <name>nullText</name>
      <anchor>nullText</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>trueText</name>
      <anchor>trueText</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>falseText</name>
      <anchor>falseText</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>dateFormat</name>
      <anchor>dateFormat</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>confirmEdits</name>
      <anchor>confirmEdits</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>confirmInsert</name>
      <anchor>confirmInsert</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>confirmUpdate</name>
      <anchor>confirmUpdate</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>confirmDelete</name>
      <anchor>confirmDelete</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>confirmCancels</name>
      <anchor>confirmCancels</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>autoDelete</name>
      <anchor>autoDelete</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>autoEdit</name>
      <anchor>autoEdit</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>filter</name>
      <anchor>filter</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>sort</name>
      <anchor>sort</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSqlCursor</name>
      <anchor>setSqlCursor</anchor>
      <arglist>( QSqlCursor * cursor = 0, bool autoPopulate = FALSE, bool autoDelete = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>sqlCursor</name>
      <anchor>sqlCursor</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setNullText</name>
      <anchor>setNullText</anchor>
      <arglist>( const QString &amp; nullText )</arglist>
    </member>
    <member kind="function">
      <name>setTrueText</name>
      <anchor>setTrueText</anchor>
      <arglist>( const QString &amp; trueText )</arglist>
    </member>
    <member kind="function">
      <name>setFalseText</name>
      <anchor>setFalseText</anchor>
      <arglist>( const QString &amp; falseText )</arglist>
    </member>
    <member kind="function">
      <name>setDateFormat</name>
      <anchor>setDateFormat</anchor>
      <arglist>( const DateFormat f )</arglist>
    </member>
    <member kind="function">
      <name>setConfirmEdits</name>
      <anchor>setConfirmEdits</anchor>
      <arglist>( bool confirm )</arglist>
    </member>
    <member kind="function">
      <name>setConfirmInsert</name>
      <anchor>setConfirmInsert</anchor>
      <arglist>( bool confirm )</arglist>
    </member>
    <member kind="function">
      <name>setConfirmUpdate</name>
      <anchor>setConfirmUpdate</anchor>
      <arglist>( bool confirm )</arglist>
    </member>
    <member kind="function">
      <name>setConfirmDelete</name>
      <anchor>setConfirmDelete</anchor>
      <arglist>( bool confirm )</arglist>
    </member>
    <member kind="function">
      <name>setConfirmCancels</name>
      <anchor>setConfirmCancels</anchor>
      <arglist>( bool confirm )</arglist>
    </member>
    <member kind="function">
      <name>setAutoDelete</name>
      <anchor>setAutoDelete</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>setAutoEdit</name>
      <anchor>setAutoEdit</anchor>
      <arglist>( bool autoEdit )</arglist>
    </member>
    <member kind="function">
      <name>setFilter</name>
      <anchor>setFilter</anchor>
      <arglist>( const QString &amp; filter )</arglist>
    </member>
    <member kind="function">
      <name>setSort</name>
      <anchor>setSort</anchor>
      <arglist>( const QStringList &amp; sort )</arglist>
    </member>
    <member kind="function">
      <name>setSort</name>
      <anchor>setSort</anchor>
      <arglist>( const QSqlIndex &amp; sort )</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Refresh</anchor>
      <arglist>{ RefreshData = 1, RefreshColumns = 2, RefreshAll = 3 }</arglist>
    </member>
    <member kind="function">
      <name>refresh</name>
      <anchor>refresh</anchor>
      <arglist>( Refresh mode )</arglist>
    </member>
    <member kind="function">
      <name>sortColumn</name>
      <anchor>sortColumn</anchor>
      <arglist>( int col, bool ascending = TRUE, bool wholeRows = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>( int row, int col ) const</arglist>
    </member>
    <member kind="function">
      <name>value</name>
      <anchor>value</anchor>
      <arglist>( int row, int col ) const</arglist>
    </member>
    <member kind="function">
      <name>currentRecord</name>
      <anchor>currentRecord</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>installEditorFactory</name>
      <anchor>installEditorFactory</anchor>
      <arglist>( QSqlEditorFactory * f )</arglist>
    </member>
    <member kind="function">
      <name>installPropertyMap</name>
      <anchor>installPropertyMap</anchor>
      <arglist>( QSqlPropertyMap * m )</arglist>
    </member>
    <member kind="function">
      <name>numCols</name>
      <anchor>numCols</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>numRows</name>
      <anchor>numRows</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>find</name>
      <anchor>find</anchor>
      <arglist>( const QString &amp; str, bool caseSensitive, bool backwards )</arglist>
    </member>
    <member kind="function">
      <name>sortAscending</name>
      <anchor>sortAscending</anchor>
      <arglist>( int col )</arglist>
    </member>
    <member kind="function">
      <name>sortDescending</name>
      <anchor>sortDescending</anchor>
      <arglist>( int col )</arglist>
    </member>
    <member kind="function">
      <name>refresh</name>
      <anchor>refresh</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setColumnWidth</name>
      <anchor>setColumnWidth</anchor>
      <arglist>( int col, int w )</arglist>
    </member>
    <member kind="function">
      <name>adjustColumn</name>
      <anchor>adjustColumn</anchor>
      <arglist>( int col )</arglist>
    </member>
    <member kind="function">
      <name>currentChanged</name>
      <anchor>currentChanged</anchor>
      <arglist>( QSqlRecord * record )</arglist>
    </member>
    <member kind="function">
      <name>primeInsert</name>
      <anchor>primeInsert</anchor>
      <arglist>( QSqlRecord * buf )</arglist>
    </member>
    <member kind="function">
      <name>primeUpdate</name>
      <anchor>primeUpdate</anchor>
      <arglist>( QSqlRecord * buf )</arglist>
    </member>
    <member kind="function">
      <name>primeDelete</name>
      <anchor>primeDelete</anchor>
      <arglist>( QSqlRecord * buf )</arglist>
    </member>
    <member kind="function">
      <name>beforeInsert</name>
      <anchor>beforeInsert</anchor>
      <arglist>( QSqlRecord * buf )</arglist>
    </member>
    <member kind="function">
      <name>beforeUpdate</name>
      <anchor>beforeUpdate</anchor>
      <arglist>( QSqlRecord * buf )</arglist>
    </member>
    <member kind="function">
      <name>beforeDelete</name>
      <anchor>beforeDelete</anchor>
      <arglist>( QSqlRecord * buf )</arglist>
    </member>
    <member kind="function">
      <name>cursorChanged</name>
      <anchor>cursorChanged</anchor>
      <arglist>( QSql::Op mode )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>autoEdit</anchor>
      <arglist>- whether the data table automatically applies edits</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>confirmCancels</anchor>
      <arglist>- whether the data table confirms cancel operations</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>confirmDelete</anchor>
      <arglist>- whether the data table confirms delete operations</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>confirmEdits</anchor>
      <arglist>- whether the data table confirms edit operations</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>confirmInsert</anchor>
      <arglist>- whether the data table confirms insert operations</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>confirmUpdate</anchor>
      <arglist>- whether the data table confirms update operations</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>dateFormat</anchor>
      <arglist>- the format used for displaying date/time values</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>falseText</anchor>
      <arglist>- the text used to represent false values</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>filter</anchor>
      <arglist>- the data filter for the data table</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>nullText</anchor>
      <arglist>- the text used to represent NULL values</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>numCols</anchor>
      <arglist>- the number of columns in the table</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>numRows</anchor>
      <arglist>- the number of rows in the table</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>sort</anchor>
      <arglist>- the data table&apos;s sort</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>trueText</anchor>
      <arglist>- the text used to represent true values</arglist>
    </member>
    <member kind="function">
      <name>insertCurrent</name>
      <anchor>insertCurrent</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>updateCurrent</name>
      <anchor>updateCurrent</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>deleteCurrent</name>
      <anchor>deleteCurrent</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>confirmEdit</name>
      <anchor>confirmEdit</anchor>
      <arglist>( QSql::Op m )</arglist>
    </member>
    <member kind="function">
      <name>confirmCancel</name>
      <anchor>confirmCancel</anchor>
      <arglist>( QSql::Op m )</arglist>
    </member>
    <member kind="function">
      <name>handleError</name>
      <anchor>handleError</anchor>
      <arglist>( const QSqlError &amp; e )</arglist>
    </member>
    <member kind="function">
      <name>beginInsert</name>
      <anchor>beginInsert</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>beginUpdate</name>
      <anchor>beginUpdate</anchor>
      <arglist>( int row, int col, bool replace )</arglist>
    </member>
    <member kind="function">
      <name>indexOf</name>
      <anchor>indexOf</anchor>
      <arglist>( uint i ) const</arglist>
    </member>
    <member kind="function">
      <name>reset</name>
      <anchor>reset</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setSize</name>
      <anchor>setSize</anchor>
      <arglist>( QSqlCursor * sql )</arglist>
    </member>
    <member kind="function">
      <name>paintField</name>
      <anchor>paintField</anchor>
      <arglist>( QPainter * p, const QSqlField * field, const QRect &amp; cr, bool selected )</arglist>
    </member>
    <member kind="function">
      <name>fieldAlignment</name>
      <anchor>fieldAlignment</anchor>
      <arglist>( const QSqlField * field )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDataView</name>
    <filename>qdataview.html</filename>
    <member kind="function">
      <name>QDataView</name>
      <anchor>QDataView</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0, WFlags fl = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QDataView</name>
      <anchor>QDataView</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setForm</name>
      <anchor>setForm</anchor>
      <arglist>( QSqlForm * form )</arglist>
    </member>
    <member kind="function">
      <name>form</name>
      <anchor>form</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setRecord</name>
      <anchor>setRecord</anchor>
      <arglist>( QSqlRecord * record )</arglist>
    </member>
    <member kind="function">
      <name>record</name>
      <anchor>record</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>refresh</name>
      <anchor>refresh</anchor>
      <arglist>( QSqlRecord * buf )</arglist>
    </member>
    <member kind="function">
      <name>readFields</name>
      <anchor>readFields</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>writeFields</name>
      <anchor>writeFields</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>clearValues</name>
      <anchor>clearValues</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDate</name>
    <filename>qdate.html</filename>
    <member kind="function">
      <name>QDate</name>
      <anchor>QDate</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDate</name>
      <anchor>QDate</anchor>
      <arglist>( int y, int m, int d )</arglist>
    </member>
    <member kind="function">
      <name>isNull</name>
      <anchor>isNull</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isValid</name>
      <anchor>isValid</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>year</name>
      <anchor>year</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>month</name>
      <anchor>month</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>day</name>
      <anchor>day</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>dayOfWeek</name>
      <anchor>dayOfWeek</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>dayOfYear</name>
      <anchor>dayOfYear</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>daysInMonth</name>
      <anchor>daysInMonth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>daysInYear</name>
      <anchor>daysInYear</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>weekNumber</name>
      <anchor>weekNumber</anchor>
      <arglist>( int * yearNumber = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>toString</name>
      <anchor>toString</anchor>
      <arglist>( Qt::DateFormat f = Qt::TextDate ) const</arglist>
    </member>
    <member kind="function">
      <name>toString</name>
      <anchor>toString</anchor>
      <arglist>( const QString &amp; format ) const</arglist>
    </member>
    <member kind="function">
      <name>setYMD</name>
      <anchor>setYMD</anchor>
      <arglist>( int y, int m, int d )</arglist>
    </member>
    <member kind="function">
      <name>addDays</name>
      <anchor>addDays</anchor>
      <arglist>( int ndays ) const</arglist>
    </member>
    <member kind="function">
      <name>addMonths</name>
      <anchor>addMonths</anchor>
      <arglist>( int nmonths ) const</arglist>
    </member>
    <member kind="function">
      <name>addYears</name>
      <anchor>addYears</anchor>
      <arglist>( int nyears ) const</arglist>
    </member>
    <member kind="function">
      <name>daysTo</name>
      <anchor>daysTo</anchor>
      <arglist>( const QDate &amp; d ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDate &amp; d ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDate &amp; d ) const</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( const QDate &amp; d ) const</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( const QDate &amp; d ) const</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( const QDate &amp; d ) const</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( const QDate &amp; d ) const</arglist>
    </member>
    <member kind="function">
      <name>shortMonthName</name>
      <anchor>shortMonthName</anchor>
      <arglist>( int month )</arglist>
    </member>
    <member kind="function">
      <name>shortDayName</name>
      <anchor>shortDayName</anchor>
      <arglist>( int weekday )</arglist>
    </member>
    <member kind="function">
      <name>longMonthName</name>
      <anchor>longMonthName</anchor>
      <arglist>( int month )</arglist>
    </member>
    <member kind="function">
      <name>longDayName</name>
      <anchor>longDayName</anchor>
      <arglist>( int weekday )</arglist>
    </member>
    <member kind="function">
      <name>currentDate</name>
      <anchor>currentDate</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>currentDate</name>
      <anchor>currentDate</anchor>
      <arglist>( Qt::TimeSpec ts )</arglist>
    </member>
    <member kind="function">
      <name>fromString</name>
      <anchor>fromString</anchor>
      <arglist>( const QString &amp; s, Qt::DateFormat f = Qt::TextDate )</arglist>
    </member>
    <member kind="function">
      <name>isValid</name>
      <anchor>isValid</anchor>
      <arglist>( int y, int m, int d )</arglist>
    </member>
    <member kind="function">
      <name>leapYear</name>
      <anchor>leapYear</anchor>
      <arglist>( int y )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QDate &amp; d )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QDate &amp; d )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDateEdit</name>
    <filename>qdateedit.html</filename>
    <member kind="function">
      <name>QDateEdit</name>
      <anchor>QDateEdit</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QDateEdit</name>
      <anchor>QDateEdit</anchor>
      <arglist>( const QDate &amp; date, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QDateEdit</name>
      <anchor>QDateEdit</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Order</anchor>
      <arglist>{ DMY, MDY, YMD, YDM }</arglist>
    </member>
    <member kind="function">
      <name>date</name>
      <anchor>date</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setOrder</name>
      <anchor>setOrder</anchor>
      <arglist>( Order order )</arglist>
    </member>
    <member kind="function">
      <name>order</name>
      <anchor>order</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoAdvance</name>
      <anchor>setAutoAdvance</anchor>
      <arglist>( bool advance )</arglist>
    </member>
    <member kind="function">
      <name>autoAdvance</name>
      <anchor>autoAdvance</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMinValue</name>
      <anchor>setMinValue</anchor>
      <arglist>( const QDate &amp; d )</arglist>
    </member>
    <member kind="function">
      <name>minValue</name>
      <anchor>minValue</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMaxValue</name>
      <anchor>setMaxValue</anchor>
      <arglist>( const QDate &amp; d )</arglist>
    </member>
    <member kind="function">
      <name>maxValue</name>
      <anchor>maxValue</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setRange</name>
      <anchor>setRange</anchor>
      <arglist>( const QDate &amp; min, const QDate &amp; max )</arglist>
    </member>
    <member kind="function">
      <name>separator</name>
      <anchor>separator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSeparator</name>
      <anchor>setSeparator</anchor>
      <arglist>( const QString &amp; s )</arglist>
    </member>
    <member kind="function">
      <name>setDate</name>
      <anchor>setDate</anchor>
      <arglist>( const QDate &amp; date )</arglist>
    </member>
    <member kind="function">
      <name>valueChanged</name>
      <anchor>valueChanged</anchor>
      <arglist>( const QDate &amp; date )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>autoAdvance</anchor>
      <arglist>- whether the editor automatically advances to the next section</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>date</anchor>
      <arglist>- the editor&apos;s date value</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>maxValue</anchor>
      <arglist>- the editor&apos;s maximum value</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>minValue</anchor>
      <arglist>- the editor&apos;s minimum value</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>order</anchor>
      <arglist>- the order in which the year, month and day appear</arglist>
    </member>
    <member kind="function">
      <name>sectionFormattedText</name>
      <anchor>sectionFormattedText</anchor>
      <arglist>( int sec )</arglist>
    </member>
    <member kind="function">
      <name>setYear</name>
      <anchor>setYear</anchor>
      <arglist>( int year )</arglist>
    </member>
    <member kind="function">
      <name>setMonth</name>
      <anchor>setMonth</anchor>
      <arglist>( int month )</arglist>
    </member>
    <member kind="function">
      <name>setDay</name>
      <anchor>setDay</anchor>
      <arglist>( int day )</arglist>
    </member>
    <member kind="function">
      <name>fix</name>
      <anchor>fix</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>updateButtons</name>
      <anchor>updateButtons</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDateTime</name>
    <filename>qdatetime.html</filename>
    <member kind="function">
      <name>QDateTime</name>
      <anchor>QDateTime</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDateTime</name>
      <anchor>QDateTime</anchor>
      <arglist>( const QDate &amp; date )</arglist>
    </member>
    <member kind="function">
      <name>QDateTime</name>
      <anchor>QDateTime</anchor>
      <arglist>( const QDate &amp; date, const QTime &amp; time )</arglist>
    </member>
    <member kind="function">
      <name>isNull</name>
      <anchor>isNull</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isValid</name>
      <anchor>isValid</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>date</name>
      <anchor>date</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>time</name>
      <anchor>time</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>toTime_t</name>
      <anchor>toTime_t</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setDate</name>
      <anchor>setDate</anchor>
      <arglist>( const QDate &amp; date )</arglist>
    </member>
    <member kind="function">
      <name>setTime</name>
      <anchor>setTime</anchor>
      <arglist>( const QTime &amp; time )</arglist>
    </member>
    <member kind="function">
      <name>setTime_t</name>
      <anchor>setTime_t</anchor>
      <arglist>( uint secsSince1Jan1970UTC )</arglist>
    </member>
    <member kind="function">
      <name>setTime_t</name>
      <anchor>setTime_t</anchor>
      <arglist>( uint secsSince1Jan1970UTC, Qt::TimeSpec ts )</arglist>
    </member>
    <member kind="function">
      <name>toString</name>
      <anchor>toString</anchor>
      <arglist>( Qt::DateFormat f = Qt::TextDate ) const</arglist>
    </member>
    <member kind="function">
      <name>toString</name>
      <anchor>toString</anchor>
      <arglist>( const QString &amp; format ) const</arglist>
    </member>
    <member kind="function">
      <name>addDays</name>
      <anchor>addDays</anchor>
      <arglist>( int ndays ) const</arglist>
    </member>
    <member kind="function">
      <name>addMonths</name>
      <anchor>addMonths</anchor>
      <arglist>( int nmonths ) const</arglist>
    </member>
    <member kind="function">
      <name>addYears</name>
      <anchor>addYears</anchor>
      <arglist>( int nyears ) const</arglist>
    </member>
    <member kind="function">
      <name>addSecs</name>
      <anchor>addSecs</anchor>
      <arglist>( int nsecs ) const</arglist>
    </member>
    <member kind="function">
      <name>daysTo</name>
      <anchor>daysTo</anchor>
      <arglist>( const QDateTime &amp; dt ) const</arglist>
    </member>
    <member kind="function">
      <name>secsTo</name>
      <anchor>secsTo</anchor>
      <arglist>( const QDateTime &amp; dt ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDateTime &amp; dt ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDateTime &amp; dt ) const</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( const QDateTime &amp; dt ) const</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( const QDateTime &amp; dt ) const</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( const QDateTime &amp; dt ) const</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( const QDateTime &amp; dt ) const</arglist>
    </member>
    <member kind="function">
      <name>currentDateTime</name>
      <anchor>currentDateTime</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>currentDateTime</name>
      <anchor>currentDateTime</anchor>
      <arglist>( Qt::TimeSpec ts )</arglist>
    </member>
    <member kind="function">
      <name>fromString</name>
      <anchor>fromString</anchor>
      <arglist>( const QString &amp; s, Qt::DateFormat f = Qt::TextDate )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QDateTime &amp; dt )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QDateTime &amp; dt )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDateTimeEdit</name>
    <filename>qdatetimeedit.html</filename>
    <member kind="function">
      <name>QDateTimeEdit</name>
      <anchor>QDateTimeEdit</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QDateTimeEdit</name>
      <anchor>QDateTimeEdit</anchor>
      <arglist>( const QDateTime &amp; datetime, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QDateTimeEdit</name>
      <anchor>QDateTimeEdit</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>dateTime</name>
      <anchor>dateTime</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>dateEdit</name>
      <anchor>dateEdit</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>timeEdit</name>
      <anchor>timeEdit</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setAutoAdvance</name>
      <anchor>setAutoAdvance</anchor>
      <arglist>( bool advance )</arglist>
    </member>
    <member kind="function">
      <name>autoAdvance</name>
      <anchor>autoAdvance</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setDateTime</name>
      <anchor>setDateTime</anchor>
      <arglist>( const QDateTime &amp; dt )</arglist>
    </member>
    <member kind="function">
      <name>valueChanged</name>
      <anchor>valueChanged</anchor>
      <arglist>( const QDateTime &amp; datetime )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>dateTime</anchor>
      <arglist>- the editor&apos;s datetime value</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDeepCopy</name>
    <filename>qdeepcopy.html</filename>
    <member kind="function">
      <name>QDeepCopy</name>
      <anchor>QDeepCopy</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDeepCopy</name>
      <anchor>QDeepCopy</anchor>
      <arglist>( const T &amp; t )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const T &amp; t )</arglist>
    </member>
    <member kind="function">
      <name>T</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDesktopWidget</name>
    <filename>qdesktopwidget.html</filename>
    <member kind="function">
      <name>QDesktopWidget</name>
      <anchor>QDesktopWidget</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDesktopWidget</name>
      <anchor>QDesktopWidget</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>isVirtualDesktop</name>
      <anchor>isVirtualDesktop</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>numScreens</name>
      <anchor>numScreens</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>primaryScreen</name>
      <anchor>primaryScreen</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>screenNumber</name>
      <anchor>screenNumber</anchor>
      <arglist>( QWidget * widget = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>screenNumber</name>
      <anchor>screenNumber</anchor>
      <arglist>( const QPoint &amp; point ) const</arglist>
    </member>
    <member kind="function">
      <name>screen</name>
      <anchor>screen</anchor>
      <arglist>( int screen = -1 )</arglist>
    </member>
    <member kind="function">
      <name>screenGeometry</name>
      <anchor>screenGeometry</anchor>
      <arglist>( int screen = -1 ) const</arglist>
    </member>
    <member kind="function">
      <name>screenGeometry</name>
      <anchor>screenGeometry</anchor>
      <arglist>( QWidget * widget ) const</arglist>
    </member>
    <member kind="function">
      <name>screenGeometry</name>
      <anchor>screenGeometry</anchor>
      <arglist>( const QPoint &amp; p ) const</arglist>
    </member>
    <member kind="function">
      <name>availableGeometry</name>
      <anchor>availableGeometry</anchor>
      <arglist>( int screen = -1 ) const</arglist>
    </member>
    <member kind="function">
      <name>availableGeometry</name>
      <anchor>availableGeometry</anchor>
      <arglist>( QWidget * widget ) const</arglist>
    </member>
    <member kind="function">
      <name>availableGeometry</name>
      <anchor>availableGeometry</anchor>
      <arglist>( const QPoint &amp; p ) const</arglist>
    </member>
    <member kind="function">
      <name>resized</name>
      <anchor>resized</anchor>
      <arglist>( int screen )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDial</name>
    <filename>qdial.html</filename>
    <member kind="function">
      <name>QDial</name>
      <anchor>QDial</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QDial</name>
      <anchor>QDial</anchor>
      <arglist>( int minValue, int maxValue, int pageStep, int value, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QDial</name>
      <anchor>QDial</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>tracking</name>
      <anchor>tracking</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>wrapping</name>
      <anchor>wrapping</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>notchSize</name>
      <anchor>notchSize</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setNotchTarget</name>
      <anchor>setNotchTarget</anchor>
      <arglist>( double )</arglist>
    </member>
    <member kind="function">
      <name>notchTarget</name>
      <anchor>notchTarget</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>notchesVisible</name>
      <anchor>notchesVisible</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>minValue</name>
      <anchor>minValue</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>maxValue</name>
      <anchor>maxValue</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMinValue</name>
      <anchor>setMinValue</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>setMaxValue</name>
      <anchor>setMaxValue</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>lineStep</name>
      <anchor>lineStep</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>pageStep</name>
      <anchor>pageStep</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setLineStep</name>
      <anchor>setLineStep</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>setPageStep</name>
      <anchor>setPageStep</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>value</name>
      <anchor>value</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setValue</name>
      <anchor>setValue</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>addLine</name>
      <anchor>addLine</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>subtractLine</name>
      <anchor>subtractLine</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>addPage</name>
      <anchor>addPage</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>subtractPage</name>
      <anchor>subtractPage</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setNotchesVisible</name>
      <anchor>setNotchesVisible</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>setWrapping</name>
      <anchor>setWrapping</anchor>
      <arglist>( bool on )</arglist>
    </member>
    <member kind="function">
      <name>setTracking</name>
      <anchor>setTracking</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>valueChanged</name>
      <anchor>valueChanged</anchor>
      <arglist>( int value )</arglist>
    </member>
    <member kind="function">
      <name>dialPressed</name>
      <anchor>dialPressed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>dialMoved</name>
      <anchor>dialMoved</anchor>
      <arglist>( int value )</arglist>
    </member>
    <member kind="function">
      <name>dialReleased</name>
      <anchor>dialReleased</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>lineStep</anchor>
      <arglist>- the current line step</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>maxValue</anchor>
      <arglist>- the current maximum value</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>minValue</anchor>
      <arglist>- the current minimum value</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>notchSize</anchor>
      <arglist>- the current notch size</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>notchTarget</anchor>
      <arglist>- the target number of pixels between notches</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>notchesVisible</anchor>
      <arglist>- whether the notches are shown</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>pageStep</anchor>
      <arglist>- the current page step</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>tracking</anchor>
      <arglist>- whether tracking is enabled</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>value</anchor>
      <arglist>- the current dial value</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>wrapping</anchor>
      <arglist>- whether wrapping is enabled</arglist>
    </member>
    <member kind="function">
      <name>valueChange</name>
      <anchor>valueChange</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>rangeChange</name>
      <anchor>rangeChange</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>repaintScreen</name>
      <anchor>repaintScreen</anchor>
      <arglist>( const QRect * cr = 0 )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDialog</name>
    <filename>qdialog.html</filename>
    <member kind="function">
      <name>QDialog</name>
      <anchor>QDialog</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0, bool modal = FALSE, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QDialog</name>
      <anchor>QDialog</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>DialogCode</anchor>
      <arglist>{ Rejected, Accepted }</arglist>
    </member>
    <member kind="function">
      <name>result</name>
      <anchor>result</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>show</name>
      <anchor>show</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setOrientation</name>
      <anchor>setOrientation</anchor>
      <arglist>( Orientation orientation )</arglist>
    </member>
    <member kind="function">
      <name>orientation</name>
      <anchor>orientation</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setExtension</name>
      <anchor>setExtension</anchor>
      <arglist>( QWidget * extension )</arglist>
    </member>
    <member kind="function">
      <name>extension</name>
      <anchor>extension</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSizeGripEnabled</name>
      <anchor>setSizeGripEnabled</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>isSizeGripEnabled</name>
      <anchor>isSizeGripEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setModal</name>
      <anchor>setModal</anchor>
      <arglist>( bool modal )</arglist>
    </member>
    <member kind="function">
      <name>isModal</name>
      <anchor>isModal</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>exec</name>
      <anchor>exec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>modal</anchor>
      <arglist>- whether show() should pop up the dialog as modal or modeless</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>sizeGripEnabled</anchor>
      <arglist>- whether the size grip is enabled</arglist>
    </member>
    <member kind="function">
      <name>setResult</name>
      <anchor>setResult</anchor>
      <arglist>( int i )</arglist>
    </member>
    <member kind="function">
      <name>done</name>
      <anchor>done</anchor>
      <arglist>( int r )</arglist>
    </member>
    <member kind="function">
      <name>accept</name>
      <anchor>accept</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>reject</name>
      <anchor>reject</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>showExtension</name>
      <anchor>showExtension</anchor>
      <arglist>( bool showIt )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDict</name>
    <filename>qdict.html</filename>
    <member kind="function">
      <name>QDict</name>
      <anchor>QDict</anchor>
      <arglist>( int size = 17, bool caseSensitive = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>QDict</name>
      <anchor>QDict</anchor>
      <arglist>( const QDict&lt;type&gt; &amp; dict )</arglist>
    </member>
    <member kind="function">
      <name>QDict</name>
      <anchor>QDict</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDict&lt;type&gt; &amp; dict )</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>insert</name>
      <anchor>insert</anchor>
      <arglist>( const QString &amp; key, const type * item )</arglist>
    </member>
    <member kind="function">
      <name>replace</name>
      <anchor>replace</anchor>
      <arglist>( const QString &amp; key, const type * item )</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>( const QString &amp; key )</arglist>
    </member>
    <member kind="function">
      <name>take</name>
      <anchor>take</anchor>
      <arglist>( const QString &amp; key )</arglist>
    </member>
    <member kind="function">
      <name>find</name>
      <anchor>find</anchor>
      <arglist>( const QString &amp; key ) const</arglist>
    </member>
    <member kind="function">
      <name>operator[]</name>
      <anchor>operator</anchor>
      <arglist>( const QString &amp; key ) const</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>resize</name>
      <anchor>resize</anchor>
      <arglist>( uint newsize )</arglist>
    </member>
    <member kind="function">
      <name>statistics</name>
      <anchor>statistics</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>autoDelete</name>
      <anchor>autoDelete</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoDelete</name>
      <anchor>setAutoDelete</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>read</name>
      <anchor>read</anchor>
      <arglist>( QDataStream &amp; s, QPtrCollection::Item &amp; item )</arglist>
    </member>
    <member kind="function">
      <name>write</name>
      <anchor>write</anchor>
      <arglist>( QDataStream &amp; s, QPtrCollection::Item ) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDictIterator</name>
    <filename>qdictiterator.html</filename>
    <member kind="function">
      <name>QDictIterator</name>
      <anchor>QDictIterator</anchor>
      <arglist>( const QDict&lt;type&gt; &amp; dict )</arglist>
    </member>
    <member kind="function">
      <name>QDictIterator</name>
      <anchor>QDictIterator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>toFirst</name>
      <anchor>toFirst</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>type</name>
      <anchor>operator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>current</name>
      <anchor>current</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>currentKey</name>
      <anchor>currentKey</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>operator()</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>operator++</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDir</name>
    <filename>qdir.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>FilterSpec</anchor>
      <arglist>{ Dirs = 0x001, Files = 0x002, Drives = 0x004, NoSymLinks = 0x008, All = 0x007, TypeMask = 0x00F, Readable = 0x010, Writable = 0x020, Executable = 0x040, RWEMask = 0x070, Modified = 0x080, Hidden = 0x100, System = 0x200, AccessMask = 0x3F0, DefaultFilter = -1 }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>SortSpec</anchor>
      <arglist>{ Name = 0x00, Time = 0x01, Size = 0x02, Unsorted = 0x03, SortByMask = 0x03, DirsFirst = 0x04, Reversed = 0x08, IgnoreCase = 0x10, DefaultSort = -1 }</arglist>
    </member>
    <member kind="function">
      <name>QDir</name>
      <anchor>QDir</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDir</name>
      <anchor>QDir</anchor>
      <arglist>( const QString &amp; path, const QString &amp; nameFilter = QString::null, int sortSpec = Name | IgnoreCase, int filterSpec = All )</arglist>
    </member>
    <member kind="function">
      <name>QDir</name>
      <anchor>QDir</anchor>
      <arglist>( const QDir &amp; d )</arglist>
    </member>
    <member kind="function">
      <name>QDir</name>
      <anchor>QDir</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDir &amp; d )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QString &amp; path )</arglist>
    </member>
    <member kind="function">
      <name>setPath</name>
      <anchor>setPath</anchor>
      <arglist>( const QString &amp; path )</arglist>
    </member>
    <member kind="function">
      <name>path</name>
      <anchor>path</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>absPath</name>
      <anchor>absPath</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>canonicalPath</name>
      <anchor>canonicalPath</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>dirName</name>
      <anchor>dirName</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>filePath</name>
      <anchor>filePath</anchor>
      <arglist>( const QString &amp; fileName, bool acceptAbsPath = TRUE ) const</arglist>
    </member>
    <member kind="function">
      <name>absFilePath</name>
      <anchor>absFilePath</anchor>
      <arglist>( const QString &amp; fileName, bool acceptAbsPath = TRUE ) const</arglist>
    </member>
    <member kind="function">
      <name>cd</name>
      <anchor>cd</anchor>
      <arglist>( const QString &amp; dirName, bool acceptAbsPath = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>cdUp</name>
      <anchor>cdUp</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>nameFilter</name>
      <anchor>nameFilter</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setNameFilter</name>
      <anchor>setNameFilter</anchor>
      <arglist>( const QString &amp; nameFilter )</arglist>
    </member>
    <member kind="function">
      <name>filter</name>
      <anchor>filter</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setFilter</name>
      <anchor>setFilter</anchor>
      <arglist>( int filterSpec )</arglist>
    </member>
    <member kind="function">
      <name>sorting</name>
      <anchor>sorting</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSorting</name>
      <anchor>setSorting</anchor>
      <arglist>( int sortSpec )</arglist>
    </member>
    <member kind="function">
      <name>matchAllDirs</name>
      <anchor>matchAllDirs</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMatchAllDirs</name>
      <anchor>setMatchAllDirs</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>operator[]</name>
      <anchor>operator</anchor>
      <arglist>( int index ) const</arglist>
    </member>
    <member kind="function">
      <name>entryList</name>
      <anchor>entryList</anchor>
      <arglist>( int filterSpec = DefaultFilter, int sortSpec = DefaultSort ) const</arglist>
    </member>
    <member kind="function">
      <name>entryList</name>
      <anchor>entryList</anchor>
      <arglist>( const QString &amp; nameFilter, int filterSpec = DefaultFilter, int sortSpec = DefaultSort ) const</arglist>
    </member>
    <member kind="function">
      <name>entryInfoList</name>
      <anchor>entryInfoList</anchor>
      <arglist>( int filterSpec = DefaultFilter, int sortSpec = DefaultSort ) const</arglist>
    </member>
    <member kind="function">
      <name>entryInfoList</name>
      <anchor>entryInfoList</anchor>
      <arglist>( const QString &amp; nameFilter, int filterSpec = DefaultFilter, int sortSpec = DefaultSort ) const</arglist>
    </member>
    <member kind="function">
      <name>mkdir</name>
      <anchor>mkdir</anchor>
      <arglist>( const QString &amp; dirName, bool acceptAbsPath = TRUE ) const</arglist>
    </member>
    <member kind="function">
      <name>rmdir</name>
      <anchor>rmdir</anchor>
      <arglist>( const QString &amp; dirName, bool acceptAbsPath = TRUE ) const</arglist>
    </member>
    <member kind="function">
      <name>isReadable</name>
      <anchor>isReadable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>exists</name>
      <anchor>exists</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isRoot</name>
      <anchor>isRoot</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isRelative</name>
      <anchor>isRelative</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>convertToAbs</name>
      <anchor>convertToAbs</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDir &amp; d ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDir &amp; d ) const</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>( const QString &amp; fileName, bool acceptAbsPath = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>rename</name>
      <anchor>rename</anchor>
      <arglist>( const QString &amp; oldName, const QString &amp; newName, bool acceptAbsPaths = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>exists</name>
      <anchor>exists</anchor>
      <arglist>( const QString &amp; name, bool acceptAbsPath = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>refresh</name>
      <anchor>refresh</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>convertSeparators</name>
      <anchor>convertSeparators</anchor>
      <arglist>( const QString &amp; pathName )</arglist>
    </member>
    <member kind="function">
      <name>drives</name>
      <anchor>drives</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>separator</name>
      <anchor>separator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setCurrent</name>
      <anchor>setCurrent</anchor>
      <arglist>( const QString &amp; path )</arglist>
    </member>
    <member kind="function">
      <name>current</name>
      <anchor>current</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>home</name>
      <anchor>home</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>root</name>
      <anchor>root</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>currentDirPath</name>
      <anchor>currentDirPath</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>homeDirPath</name>
      <anchor>homeDirPath</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>rootDirPath</name>
      <anchor>rootDirPath</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>match</name>
      <anchor>match</anchor>
      <arglist>( const QStringList &amp; filters, const QString &amp; fileName )</arglist>
    </member>
    <member kind="function">
      <name>match</name>
      <anchor>match</anchor>
      <arglist>( const QString &amp; filter, const QString &amp; fileName )</arglist>
    </member>
    <member kind="function">
      <name>cleanDirPath</name>
      <anchor>cleanDirPath</anchor>
      <arglist>( const QString &amp; filePath )</arglist>
    </member>
    <member kind="function">
      <name>isRelativePath</name>
      <anchor>isRelativePath</anchor>
      <arglist>( const QString &amp; path )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDirectPainter</name>
    <filename>qdirectpainter.html</filename>
    <member kind="function">
      <name>QDirectPainter</name>
      <anchor>QDirectPainter</anchor>
      <arglist>( const QWidget * w )</arglist>
    </member>
    <member kind="function">
      <name>QDirectPainter</name>
      <anchor>QDirectPainter</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>frameBuffer</name>
      <anchor>frameBuffer</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>lineStep</name>
      <anchor>lineStep</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>transformOrientation</name>
      <anchor>transformOrientation</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>numRects</name>
      <anchor>numRects</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rect</name>
      <anchor>rect</anchor>
      <arglist>( int i ) const</arglist>
    </member>
    <member kind="function">
      <name>region</name>
      <anchor>region</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>depth</name>
      <anchor>depth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>width</name>
      <anchor>width</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>height</name>
      <anchor>height</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>xOffset</name>
      <anchor>xOffset</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>yOffset</name>
      <anchor>yOffset</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>offset</name>
      <anchor>offset</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAreaChanged</name>
      <anchor>setAreaChanged</anchor>
      <arglist>( const QRect &amp; r )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDns</name>
    <filename>qdns.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>RecordType</anchor>
      <arglist>{ None, A, Aaaa, Mx, Srv, Cname, Ptr, Txt }</arglist>
    </member>
    <member kind="function">
      <name>QDns</name>
      <anchor>QDns</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDns</name>
      <anchor>QDns</anchor>
      <arglist>( const QString &amp; label, RecordType rr = A )</arglist>
    </member>
    <member kind="function">
      <name>QDns</name>
      <anchor>QDns</anchor>
      <arglist>( const QHostAddress &amp; address, RecordType rr = Ptr )</arglist>
    </member>
    <member kind="function">
      <name>QDns</name>
      <anchor>QDns</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setLabel</name>
      <anchor>setLabel</anchor>
      <arglist>( const QString &amp; label )</arglist>
    </member>
    <member kind="function">
      <name>setLabel</name>
      <anchor>setLabel</anchor>
      <arglist>( const QHostAddress &amp; address )</arglist>
    </member>
    <member kind="function">
      <name>label</name>
      <anchor>label</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setRecordType</name>
      <anchor>setRecordType</anchor>
      <arglist>( RecordType rr = A )</arglist>
    </member>
    <member kind="function">
      <name>recordType</name>
      <anchor>recordType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isWorking</name>
      <anchor>isWorking</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>addresses</name>
      <anchor>addresses</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>mailServers</name>
      <anchor>mailServers</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>servers</name>
      <anchor>servers</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>hostNames</name>
      <anchor>hostNames</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>texts</name>
      <anchor>texts</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>canonicalName</name>
      <anchor>canonicalName</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>qualifiedNames</name>
      <anchor>qualifiedNames</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>resultsReady</name>
      <anchor>resultsReady</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDockArea</name>
    <filename>qdockarea.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>HandlePosition</anchor>
      <arglist>{ Normal, Reverse }</arglist>
    </member>
    <member kind="function">
      <name>QDockArea</name>
      <anchor>QDockArea</anchor>
      <arglist>( Orientation o, HandlePosition h = Normal, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QDockArea</name>
      <anchor>QDockArea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>moveDockWindow</name>
      <anchor>moveDockWindow</anchor>
      <arglist>( QDockWindow * w, const QPoint &amp; p, const QRect &amp; r, bool swap )</arglist>
    </member>
    <member kind="function">
      <name>removeDockWindow</name>
      <anchor>removeDockWindow</anchor>
      <arglist>( QDockWindow * w, bool makeFloating, bool swap, bool fixNewLines = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>moveDockWindow</name>
      <anchor>moveDockWindow</anchor>
      <arglist>( QDockWindow * w, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>hasDockWindow</name>
      <anchor>hasDockWindow</anchor>
      <arglist>( QDockWindow * w, int * index = 0 )</arglist>
    </member>
    <member kind="function">
      <name>orientation</name>
      <anchor>orientation</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>handlePosition</name>
      <anchor>handlePosition</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>dockWindowList</name>
      <anchor>dockWindowList</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isDockWindowAccepted</name>
      <anchor>isDockWindowAccepted</anchor>
      <arglist>( QDockWindow * dw )</arglist>
    </member>
    <member kind="function">
      <name>setAcceptDockWindow</name>
      <anchor>setAcceptDockWindow</anchor>
      <arglist>( QDockWindow * dw, bool accept )</arglist>
    </member>
    <member kind="function">
      <name>lineUp</name>
      <anchor>lineUp</anchor>
      <arglist>( bool keepNewLines )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>count</anchor>
      <arglist>- the number of dock windows in the dock area</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>empty</anchor>
      <arglist>- whether the dock area is empty</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>handlePosition</anchor>
      <arglist>- where the dock window splitter handle is placed in the dock area</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>orientation</anchor>
      <arglist>- the dock area&apos;s orientation</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QTextStream &amp; ts, const QDockArea &amp; dockArea )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QTextStream &amp; ts, QDockArea &amp; dockArea )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDockWindow</name>
    <filename>qdockwindow.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>Place</anchor>
      <arglist>{ InDock, OutsideDock }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>CloseMode</anchor>
      <arglist>{ Never = 0, Docked = 1, Undocked = 2, Always = Docked | Undocked }</arglist>
    </member>
    <member kind="function">
      <name>QDockWindow</name>
      <anchor>QDockWindow</anchor>
      <arglist>( Place p = InDock, QWidget * parent = 0, const char * name = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QDockWindow</name>
      <anchor>QDockWindow</anchor>
      <arglist>( QWidget * parent, const char * name = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>setWidget</name>
      <anchor>setWidget</anchor>
      <arglist>( QWidget * w )</arglist>
    </member>
    <member kind="function">
      <name>widget</name>
      <anchor>widget</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>place</name>
      <anchor>place</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>area</name>
      <anchor>area</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setCloseMode</name>
      <anchor>setCloseMode</anchor>
      <arglist>( int m )</arglist>
    </member>
    <member kind="function">
      <name>isCloseEnabled</name>
      <anchor>isCloseEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>closeMode</name>
      <anchor>closeMode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setResizeEnabled</name>
      <anchor>setResizeEnabled</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>setMovingEnabled</name>
      <anchor>setMovingEnabled</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>isResizeEnabled</name>
      <anchor>isResizeEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isMovingEnabled</name>
      <anchor>isMovingEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setHorizontallyStretchable</name>
      <anchor>setHorizontallyStretchable</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>setVerticallyStretchable</name>
      <anchor>setVerticallyStretchable</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>isHorizontallyStretchable</name>
      <anchor>isHorizontallyStretchable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isVerticallyStretchable</name>
      <anchor>isVerticallyStretchable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isStretchable</name>
      <anchor>isStretchable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setOffset</name>
      <anchor>setOffset</anchor>
      <arglist>( int o )</arglist>
    </member>
    <member kind="function">
      <name>offset</name>
      <anchor>offset</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setFixedExtentWidth</name>
      <anchor>setFixedExtentWidth</anchor>
      <arglist>( int w )</arglist>
    </member>
    <member kind="function">
      <name>setFixedExtentHeight</name>
      <anchor>setFixedExtentHeight</anchor>
      <arglist>( int h )</arglist>
    </member>
    <member kind="function">
      <name>fixedExtent</name>
      <anchor>fixedExtent</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setNewLine</name>
      <anchor>setNewLine</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>newLine</name>
      <anchor>newLine</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>orientation</name>
      <anchor>orientation</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>boxLayout</name>
      <anchor>boxLayout</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setOpaqueMoving</name>
      <anchor>setOpaqueMoving</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>opaqueMoving</name>
      <anchor>opaqueMoving</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>undock</name>
      <anchor>undock</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>dock</name>
      <anchor>dock</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setOrientation</name>
      <anchor>setOrientation</anchor>
      <arglist>( Orientation o )</arglist>
    </member>
    <member kind="function">
      <name>orientationChanged</name>
      <anchor>orientationChanged</anchor>
      <arglist>( Orientation o )</arglist>
    </member>
    <member kind="function">
      <name>placeChanged</name>
      <anchor>placeChanged</anchor>
      <arglist>( QDockWindow::Place p )</arglist>
    </member>
    <member kind="function">
      <name>visibilityChanged</name>
      <anchor>visibilityChanged</anchor>
      <arglist>( bool visible )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>closeMode</anchor>
      <arglist>- the close mode of a dock window</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>horizontallyStretchable</anchor>
      <arglist>- whether the dock window is horizontally stretchable</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>movingEnabled</anchor>
      <arglist>- whether the user can move the dock window within the dock area, move the dock window to another dock area, or float the dock window</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>newLine</anchor>
      <arglist>- whether the dock window prefers to start a new line in the dock area</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>offset</anchor>
      <arglist>- the dock window&apos;s preferred offset from the dock area&apos;s left edge (top edge for vertical dock areas)</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>opaqueMoving</anchor>
      <arglist>- whether the dock window will be shown normally whilst it is being moved</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>place</anchor>
      <arglist>- whether the dock window is in a dock area</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>resizeEnabled</anchor>
      <arglist>- whether the dock window is resizeable</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>stretchable</anchor>
      <arglist>- whether the dock window is stretchable in the current orientation()</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>verticallyStretchable</anchor>
      <arglist>- whether the dock window is vertically stretchable</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDomAttr</name>
    <filename>qdomattr.html</filename>
    <member kind="function">
      <name>QDomAttr</name>
      <anchor>QDomAttr</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDomAttr</name>
      <anchor>QDomAttr</anchor>
      <arglist>( const QDomAttr &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomAttr &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>QDomAttr</name>
      <anchor>QDomAttr</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>name</name>
      <anchor>name</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>specified</name>
      <anchor>specified</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>ownerElement</name>
      <anchor>ownerElement</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>value</name>
      <anchor>value</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setValue</name>
      <anchor>setValue</anchor>
      <arglist>( const QString &amp; v )</arglist>
    </member>
    <member kind="function">
      <name>nodeType</name>
      <anchor>nodeType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isAttr</name>
      <anchor>isAttr</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDomCDATASection</name>
    <filename>qdomcdatasection.html</filename>
    <member kind="function">
      <name>QDomCDATASection</name>
      <anchor>QDomCDATASection</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDomCDATASection</name>
      <anchor>QDomCDATASection</anchor>
      <arglist>( const QDomCDATASection &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomCDATASection &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>QDomCDATASection</name>
      <anchor>QDomCDATASection</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>nodeType</name>
      <anchor>nodeType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isCDATASection</name>
      <anchor>isCDATASection</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDomCharacterData</name>
    <filename>qdomcharacterdata.html</filename>
    <member kind="function">
      <name>QDomCharacterData</name>
      <anchor>QDomCharacterData</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDomCharacterData</name>
      <anchor>QDomCharacterData</anchor>
      <arglist>( const QDomCharacterData &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomCharacterData &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>QDomCharacterData</name>
      <anchor>QDomCharacterData</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>substringData</name>
      <anchor>substringData</anchor>
      <arglist>( unsigned long offset, unsigned long count )</arglist>
    </member>
    <member kind="function">
      <name>appendData</name>
      <anchor>appendData</anchor>
      <arglist>( const QString &amp; arg )</arglist>
    </member>
    <member kind="function">
      <name>insertData</name>
      <anchor>insertData</anchor>
      <arglist>( unsigned long offset, const QString &amp; arg )</arglist>
    </member>
    <member kind="function">
      <name>deleteData</name>
      <anchor>deleteData</anchor>
      <arglist>( unsigned long offset, unsigned long count )</arglist>
    </member>
    <member kind="function">
      <name>replaceData</name>
      <anchor>replaceData</anchor>
      <arglist>( unsigned long offset, unsigned long count, const QString &amp; arg )</arglist>
    </member>
    <member kind="function">
      <name>length</name>
      <anchor>length</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>data</name>
      <anchor>data</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setData</name>
      <anchor>setData</anchor>
      <arglist>( const QString &amp; v )</arglist>
    </member>
    <member kind="function">
      <name>nodeType</name>
      <anchor>nodeType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isCharacterData</name>
      <anchor>isCharacterData</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDomComment</name>
    <filename>qdomcomment.html</filename>
    <member kind="function">
      <name>QDomComment</name>
      <anchor>QDomComment</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDomComment</name>
      <anchor>QDomComment</anchor>
      <arglist>( const QDomComment &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomComment &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>QDomComment</name>
      <anchor>QDomComment</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>nodeType</name>
      <anchor>nodeType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isComment</name>
      <anchor>isComment</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDomDocument</name>
    <filename>qdomdocument.html</filename>
    <member kind="function">
      <name>QDomDocument</name>
      <anchor>QDomDocument</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDomDocument</name>
      <anchor>QDomDocument</anchor>
      <arglist>( const QString &amp; name )</arglist>
    </member>
    <member kind="function">
      <name>QDomDocument</name>
      <anchor>QDomDocument</anchor>
      <arglist>( const QDomDocumentType &amp; doctype )</arglist>
    </member>
    <member kind="function">
      <name>QDomDocument</name>
      <anchor>QDomDocument</anchor>
      <arglist>( const QDomDocument &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomDocument &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>QDomDocument</name>
      <anchor>QDomDocument</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>createElement</name>
      <anchor>createElement</anchor>
      <arglist>( const QString &amp; tagName )</arglist>
    </member>
    <member kind="function">
      <name>createDocumentFragment</name>
      <anchor>createDocumentFragment</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>createTextNode</name>
      <anchor>createTextNode</anchor>
      <arglist>( const QString &amp; value )</arglist>
    </member>
    <member kind="function">
      <name>createComment</name>
      <anchor>createComment</anchor>
      <arglist>( const QString &amp; value )</arglist>
    </member>
    <member kind="function">
      <name>createCDATASection</name>
      <anchor>createCDATASection</anchor>
      <arglist>( const QString &amp; value )</arglist>
    </member>
    <member kind="function">
      <name>createProcessingInstruction</name>
      <anchor>createProcessingInstruction</anchor>
      <arglist>( const QString &amp; target, const QString &amp; data )</arglist>
    </member>
    <member kind="function">
      <name>createAttribute</name>
      <anchor>createAttribute</anchor>
      <arglist>( const QString &amp; name )</arglist>
    </member>
    <member kind="function">
      <name>createEntityReference</name>
      <anchor>createEntityReference</anchor>
      <arglist>( const QString &amp; name )</arglist>
    </member>
    <member kind="function">
      <name>elementsByTagName</name>
      <anchor>elementsByTagName</anchor>
      <arglist>( const QString &amp; tagname ) const</arglist>
    </member>
    <member kind="function">
      <name>importNode</name>
      <anchor>importNode</anchor>
      <arglist>( const QDomNode &amp; importedNode, bool deep )</arglist>
    </member>
    <member kind="function">
      <name>createElementNS</name>
      <anchor>createElementNS</anchor>
      <arglist>( const QString &amp; nsURI, const QString &amp; qName )</arglist>
    </member>
    <member kind="function">
      <name>createAttributeNS</name>
      <anchor>createAttributeNS</anchor>
      <arglist>( const QString &amp; nsURI, const QString &amp; qName )</arglist>
    </member>
    <member kind="function">
      <name>elementsByTagNameNS</name>
      <anchor>elementsByTagNameNS</anchor>
      <arglist>( const QString &amp; nsURI, const QString &amp; localName )</arglist>
    </member>
    <member kind="function">
      <name>elementById</name>
      <anchor>elementById</anchor>
      <arglist>( const QString &amp; elementId )</arglist>
    </member>
    <member kind="function">
      <name>doctype</name>
      <anchor>doctype</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>implementation</name>
      <anchor>implementation</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>documentElement</name>
      <anchor>documentElement</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setContent</name>
      <anchor>setContent</anchor>
      <arglist>( const QCString &amp; buffer, bool namespaceProcessing, QString * errorMsg = 0, int * errorLine = 0, int * errorColumn = 0 )</arglist>
    </member>
    <member kind="function">
      <name>setContent</name>
      <anchor>setContent</anchor>
      <arglist>( const QByteArray &amp; buffer, bool namespaceProcessing, QString * errorMsg = 0, int * errorLine = 0, int * errorColumn = 0 )</arglist>
    </member>
    <member kind="function">
      <name>setContent</name>
      <anchor>setContent</anchor>
      <arglist>( const QString &amp; text, bool namespaceProcessing, QString * errorMsg = 0, int * errorLine = 0, int * errorColumn = 0 )</arglist>
    </member>
    <member kind="function">
      <name>setContent</name>
      <anchor>setContent</anchor>
      <arglist>( QIODevice * dev, bool namespaceProcessing, QString * errorMsg = 0, int * errorLine = 0, int * errorColumn = 0 )</arglist>
    </member>
    <member kind="function">
      <name>setContent</name>
      <anchor>setContent</anchor>
      <arglist>( const QCString &amp; buffer, QString * errorMsg = 0, int * errorLine = 0, int * errorColumn = 0 )</arglist>
    </member>
    <member kind="function">
      <name>setContent</name>
      <anchor>setContent</anchor>
      <arglist>( const QByteArray &amp; buffer, QString * errorMsg = 0, int * errorLine = 0, int * errorColumn = 0 )</arglist>
    </member>
    <member kind="function">
      <name>setContent</name>
      <anchor>setContent</anchor>
      <arglist>( const QString &amp; text, QString * errorMsg = 0, int * errorLine = 0, int * errorColumn = 0 )</arglist>
    </member>
    <member kind="function">
      <name>setContent</name>
      <anchor>setContent</anchor>
      <arglist>( QIODevice * dev, QString * errorMsg = 0, int * errorLine = 0, int * errorColumn = 0 )</arglist>
    </member>
    <member kind="function">
      <name>setContent</name>
      <anchor>setContent</anchor>
      <arglist>( QXmlInputSource * source, QXmlReader * reader, QString * errorMsg = 0, int * errorLine = 0, int * errorColumn = 0 )</arglist>
    </member>
    <member kind="function">
      <name>nodeType</name>
      <anchor>nodeType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isDocument</name>
      <anchor>isDocument</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>toString</name>
      <anchor>toString</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>toString</name>
      <anchor>toString</anchor>
      <arglist>( int indent ) const</arglist>
    </member>
    <member kind="function">
      <name>toCString</name>
      <anchor>toCString</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>toCString</name>
      <anchor>toCString</anchor>
      <arglist>( int indent ) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDomDocumentFragment</name>
    <filename>qdomdocumentfragment.html</filename>
    <member kind="function">
      <name>QDomDocumentFragment</name>
      <anchor>QDomDocumentFragment</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDomDocumentFragment</name>
      <anchor>QDomDocumentFragment</anchor>
      <arglist>( const QDomDocumentFragment &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomDocumentFragment &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>QDomDocumentFragment</name>
      <anchor>QDomDocumentFragment</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>nodeType</name>
      <anchor>nodeType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isDocumentFragment</name>
      <anchor>isDocumentFragment</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDomDocumentType</name>
    <filename>qdomdocumenttype.html</filename>
    <member kind="function">
      <name>QDomDocumentType</name>
      <anchor>QDomDocumentType</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDomDocumentType</name>
      <anchor>QDomDocumentType</anchor>
      <arglist>( const QDomDocumentType &amp; n )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomDocumentType &amp; n )</arglist>
    </member>
    <member kind="function">
      <name>QDomDocumentType</name>
      <anchor>QDomDocumentType</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>name</name>
      <anchor>name</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>entities</name>
      <anchor>entities</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>notations</name>
      <anchor>notations</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>publicId</name>
      <anchor>publicId</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>systemId</name>
      <anchor>systemId</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>internalSubset</name>
      <anchor>internalSubset</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>nodeType</name>
      <anchor>nodeType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isDocumentType</name>
      <anchor>isDocumentType</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDomElement</name>
    <filename>qdomelement.html</filename>
    <member kind="function">
      <name>QDomElement</name>
      <anchor>QDomElement</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDomElement</name>
      <anchor>QDomElement</anchor>
      <arglist>( const QDomElement &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomElement &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>QDomElement</name>
      <anchor>QDomElement</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>attribute</name>
      <anchor>attribute</anchor>
      <arglist>( const QString &amp; name, const QString &amp; defValue = QString::null ) const</arglist>
    </member>
    <member kind="function">
      <name>setAttribute</name>
      <anchor>setAttribute</anchor>
      <arglist>( const QString &amp; name, const QString &amp; value )</arglist>
    </member>
    <member kind="function">
      <name>setAttribute</name>
      <anchor>setAttribute</anchor>
      <arglist>( const QString &amp; name, int value )</arglist>
    </member>
    <member kind="function">
      <name>setAttribute</name>
      <anchor>setAttribute</anchor>
      <arglist>( const QString &amp; name, uint value )</arglist>
    </member>
    <member kind="function">
      <name>setAttribute</name>
      <anchor>setAttribute</anchor>
      <arglist>( const QString &amp; name, long value )</arglist>
    </member>
    <member kind="function">
      <name>setAttribute</name>
      <anchor>setAttribute</anchor>
      <arglist>( const QString &amp; name, ulong value )</arglist>
    </member>
    <member kind="function">
      <name>setAttribute</name>
      <anchor>setAttribute</anchor>
      <arglist>( const QString &amp; name, double value )</arglist>
    </member>
    <member kind="function">
      <name>removeAttribute</name>
      <anchor>removeAttribute</anchor>
      <arglist>( const QString &amp; name )</arglist>
    </member>
    <member kind="function">
      <name>attributeNode</name>
      <anchor>attributeNode</anchor>
      <arglist>( const QString &amp; name )</arglist>
    </member>
    <member kind="function">
      <name>setAttributeNode</name>
      <anchor>setAttributeNode</anchor>
      <arglist>( const QDomAttr &amp; newAttr )</arglist>
    </member>
    <member kind="function">
      <name>removeAttributeNode</name>
      <anchor>removeAttributeNode</anchor>
      <arglist>( const QDomAttr &amp; oldAttr )</arglist>
    </member>
    <member kind="function">
      <name>elementsByTagName</name>
      <anchor>elementsByTagName</anchor>
      <arglist>( const QString &amp; tagname ) const</arglist>
    </member>
    <member kind="function">
      <name>hasAttribute</name>
      <anchor>hasAttribute</anchor>
      <arglist>( const QString &amp; name ) const</arglist>
    </member>
    <member kind="function">
      <name>attributeNS</name>
      <anchor>attributeNS</anchor>
      <arglist>( const QString nsURI, const QString &amp; localName, const QString &amp; defValue ) const</arglist>
    </member>
    <member kind="function">
      <name>setAttributeNS</name>
      <anchor>setAttributeNS</anchor>
      <arglist>( const QString nsURI, const QString &amp; qName, const QString &amp; value )</arglist>
    </member>
    <member kind="function">
      <name>setAttributeNS</name>
      <anchor>setAttributeNS</anchor>
      <arglist>( const QString nsURI, const QString &amp; qName, int value )</arglist>
    </member>
    <member kind="function">
      <name>setAttributeNS</name>
      <anchor>setAttributeNS</anchor>
      <arglist>( const QString nsURI, const QString &amp; qName, uint value )</arglist>
    </member>
    <member kind="function">
      <name>setAttributeNS</name>
      <anchor>setAttributeNS</anchor>
      <arglist>( const QString nsURI, const QString &amp; qName, long value )</arglist>
    </member>
    <member kind="function">
      <name>setAttributeNS</name>
      <anchor>setAttributeNS</anchor>
      <arglist>( const QString nsURI, const QString &amp; qName, ulong value )</arglist>
    </member>
    <member kind="function">
      <name>setAttributeNS</name>
      <anchor>setAttributeNS</anchor>
      <arglist>( const QString nsURI, const QString &amp; qName, double value )</arglist>
    </member>
    <member kind="function">
      <name>removeAttributeNS</name>
      <anchor>removeAttributeNS</anchor>
      <arglist>( const QString &amp; nsURI, const QString &amp; localName )</arglist>
    </member>
    <member kind="function">
      <name>attributeNodeNS</name>
      <anchor>attributeNodeNS</anchor>
      <arglist>( const QString &amp; nsURI, const QString &amp; localName )</arglist>
    </member>
    <member kind="function">
      <name>setAttributeNodeNS</name>
      <anchor>setAttributeNodeNS</anchor>
      <arglist>( const QDomAttr &amp; newAttr )</arglist>
    </member>
    <member kind="function">
      <name>elementsByTagNameNS</name>
      <anchor>elementsByTagNameNS</anchor>
      <arglist>( const QString &amp; nsURI, const QString &amp; localName ) const</arglist>
    </member>
    <member kind="function">
      <name>hasAttributeNS</name>
      <anchor>hasAttributeNS</anchor>
      <arglist>( const QString &amp; nsURI, const QString &amp; localName ) const</arglist>
    </member>
    <member kind="function">
      <name>tagName</name>
      <anchor>tagName</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setTagName</name>
      <anchor>setTagName</anchor>
      <arglist>( const QString &amp; name )</arglist>
    </member>
    <member kind="function">
      <name>attributes</name>
      <anchor>attributes</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>nodeType</name>
      <anchor>nodeType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isElement</name>
      <anchor>isElement</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDomEntity</name>
    <filename>qdomentity.html</filename>
    <member kind="function">
      <name>QDomEntity</name>
      <anchor>QDomEntity</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDomEntity</name>
      <anchor>QDomEntity</anchor>
      <arglist>( const QDomEntity &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomEntity &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>QDomEntity</name>
      <anchor>QDomEntity</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>publicId</name>
      <anchor>publicId</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>systemId</name>
      <anchor>systemId</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>notationName</name>
      <anchor>notationName</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>nodeType</name>
      <anchor>nodeType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEntity</name>
      <anchor>isEntity</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDomEntityReference</name>
    <filename>qdomentityreference.html</filename>
    <member kind="function">
      <name>QDomEntityReference</name>
      <anchor>QDomEntityReference</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDomEntityReference</name>
      <anchor>QDomEntityReference</anchor>
      <arglist>( const QDomEntityReference &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomEntityReference &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>QDomEntityReference</name>
      <anchor>QDomEntityReference</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>nodeType</name>
      <anchor>nodeType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEntityReference</name>
      <anchor>isEntityReference</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDomImplementation</name>
    <filename>qdomimplementation.html</filename>
    <member kind="function">
      <name>QDomImplementation</name>
      <anchor>QDomImplementation</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDomImplementation</name>
      <anchor>QDomImplementation</anchor>
      <arglist>( const QDomImplementation &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>QDomImplementation</name>
      <anchor>QDomImplementation</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomImplementation &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomImplementation &amp; x ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomImplementation &amp; x ) const</arglist>
    </member>
    <member kind="function">
      <name>hasFeature</name>
      <anchor>hasFeature</anchor>
      <arglist>( const QString &amp; feature, const QString &amp; version )</arglist>
    </member>
    <member kind="function">
      <name>createDocumentType</name>
      <anchor>createDocumentType</anchor>
      <arglist>( const QString &amp; qName, const QString &amp; publicId, const QString &amp; systemId )</arglist>
    </member>
    <member kind="function">
      <name>createDocument</name>
      <anchor>createDocument</anchor>
      <arglist>( const QString &amp; nsURI, const QString &amp; qName, const QDomDocumentType &amp; doctype )</arglist>
    </member>
    <member kind="function">
      <name>isNull</name>
      <anchor>isNull</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDomNamedNodeMap</name>
    <filename>qdomnamednodemap.html</filename>
    <member kind="function">
      <name>QDomNamedNodeMap</name>
      <anchor>QDomNamedNodeMap</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDomNamedNodeMap</name>
      <anchor>QDomNamedNodeMap</anchor>
      <arglist>( const QDomNamedNodeMap &amp; n )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomNamedNodeMap &amp; n )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomNamedNodeMap &amp; n ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomNamedNodeMap &amp; n ) const</arglist>
    </member>
    <member kind="function">
      <name>QDomNamedNodeMap</name>
      <anchor>QDomNamedNodeMap</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>namedItem</name>
      <anchor>namedItem</anchor>
      <arglist>( const QString &amp; name ) const</arglist>
    </member>
    <member kind="function">
      <name>setNamedItem</name>
      <anchor>setNamedItem</anchor>
      <arglist>( const QDomNode &amp; newNode )</arglist>
    </member>
    <member kind="function">
      <name>removeNamedItem</name>
      <anchor>removeNamedItem</anchor>
      <arglist>( const QString &amp; name )</arglist>
    </member>
    <member kind="function">
      <name>item</name>
      <anchor>item</anchor>
      <arglist>( int index ) const</arglist>
    </member>
    <member kind="function">
      <name>namedItemNS</name>
      <anchor>namedItemNS</anchor>
      <arglist>( const QString &amp; nsURI, const QString &amp; localName ) const</arglist>
    </member>
    <member kind="function">
      <name>setNamedItemNS</name>
      <anchor>setNamedItemNS</anchor>
      <arglist>( const QDomNode &amp; newNode )</arglist>
    </member>
    <member kind="function">
      <name>removeNamedItemNS</name>
      <anchor>removeNamedItemNS</anchor>
      <arglist>( const QString &amp; nsURI, const QString &amp; localName )</arglist>
    </member>
    <member kind="function">
      <name>length</name>
      <anchor>length</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>contains</name>
      <anchor>contains</anchor>
      <arglist>( const QString &amp; name ) const</arglist>
    </member>
    <member kind="function">
      <name>QDomDocumentType</name>
      <anchor>entities</anchor>
      <arglist>() returns a map of all entities</arglist>
    </member>
    <member kind="function">
      <name>QDomDocumentType</name>
      <anchor>notations</anchor>
      <arglist>() returns a map of all notations</arglist>
    </member>
    <member kind="function">
      <name>QDomNode</name>
      <anchor>attributes</anchor>
      <arglist>() returns a map of all attributes of an</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDomNode</name>
    <filename>qdomnode.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>NodeType</anchor>
      <arglist>{ ElementNode = 1, AttributeNode = 2, TextNode = 3, CDATASectionNode = 4, EntityReferenceNode = 5, EntityNode = 6, ProcessingInstructionNode = 7, CommentNode = 8, DocumentNode = 9, DocumentTypeNode = 10, DocumentFragmentNode = 11, NotationNode = 12, BaseNode = 21, CharacterDataNode = 22 }</arglist>
    </member>
    <member kind="function">
      <name>QDomNode</name>
      <anchor>QDomNode</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDomNode</name>
      <anchor>QDomNode</anchor>
      <arglist>( const QDomNode &amp; n )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomNode &amp; n )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomNode &amp; n ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomNode &amp; n ) const</arglist>
    </member>
    <member kind="function">
      <name>QDomNode</name>
      <anchor>QDomNode</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>insertBefore</name>
      <anchor>insertBefore</anchor>
      <arglist>( const QDomNode &amp; newChild, const QDomNode &amp; refChild )</arglist>
    </member>
    <member kind="function">
      <name>insertAfter</name>
      <anchor>insertAfter</anchor>
      <arglist>( const QDomNode &amp; newChild, const QDomNode &amp; refChild )</arglist>
    </member>
    <member kind="function">
      <name>replaceChild</name>
      <anchor>replaceChild</anchor>
      <arglist>( const QDomNode &amp; newChild, const QDomNode &amp; oldChild )</arglist>
    </member>
    <member kind="function">
      <name>removeChild</name>
      <anchor>removeChild</anchor>
      <arglist>( const QDomNode &amp; oldChild )</arglist>
    </member>
    <member kind="function">
      <name>appendChild</name>
      <anchor>appendChild</anchor>
      <arglist>( const QDomNode &amp; newChild )</arglist>
    </member>
    <member kind="function">
      <name>hasChildNodes</name>
      <anchor>hasChildNodes</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>cloneNode</name>
      <anchor>cloneNode</anchor>
      <arglist>( bool deep = TRUE ) const</arglist>
    </member>
    <member kind="function">
      <name>normalize</name>
      <anchor>normalize</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>isSupported</name>
      <anchor>isSupported</anchor>
      <arglist>( const QString &amp; feature, const QString &amp; version ) const</arglist>
    </member>
    <member kind="function">
      <name>nodeName</name>
      <anchor>nodeName</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>nodeType</name>
      <anchor>nodeType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>parentNode</name>
      <anchor>parentNode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>childNodes</name>
      <anchor>childNodes</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>firstChild</name>
      <anchor>firstChild</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>lastChild</name>
      <anchor>lastChild</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>previousSibling</name>
      <anchor>previousSibling</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>nextSibling</name>
      <anchor>nextSibling</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>attributes</name>
      <anchor>attributes</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>ownerDocument</name>
      <anchor>ownerDocument</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>namespaceURI</name>
      <anchor>namespaceURI</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>localName</name>
      <anchor>localName</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>hasAttributes</name>
      <anchor>hasAttributes</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>nodeValue</name>
      <anchor>nodeValue</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setNodeValue</name>
      <anchor>setNodeValue</anchor>
      <arglist>( const QString &amp; v )</arglist>
    </member>
    <member kind="function">
      <name>prefix</name>
      <anchor>prefix</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPrefix</name>
      <anchor>setPrefix</anchor>
      <arglist>( const QString &amp; pre )</arglist>
    </member>
    <member kind="function">
      <name>isAttr</name>
      <anchor>isAttr</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isCDATASection</name>
      <anchor>isCDATASection</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isDocumentFragment</name>
      <anchor>isDocumentFragment</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isDocument</name>
      <anchor>isDocument</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isDocumentType</name>
      <anchor>isDocumentType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isElement</name>
      <anchor>isElement</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEntityReference</name>
      <anchor>isEntityReference</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isText</name>
      <anchor>isText</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEntity</name>
      <anchor>isEntity</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isNotation</name>
      <anchor>isNotation</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isProcessingInstruction</name>
      <anchor>isProcessingInstruction</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isCharacterData</name>
      <anchor>isCharacterData</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isComment</name>
      <anchor>isComment</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>namedItem</name>
      <anchor>namedItem</anchor>
      <arglist>( const QString &amp; name ) const</arglist>
    </member>
    <member kind="function">
      <name>isNull</name>
      <anchor>isNull</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toAttr</name>
      <anchor>toAttr</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toCDATASection</name>
      <anchor>toCDATASection</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toDocumentFragment</name>
      <anchor>toDocumentFragment</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toDocument</name>
      <anchor>toDocument</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toDocumentType</name>
      <anchor>toDocumentType</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toElement</name>
      <anchor>toElement</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toEntityReference</name>
      <anchor>toEntityReference</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toText</name>
      <anchor>toText</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toEntity</name>
      <anchor>toEntity</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toNotation</name>
      <anchor>toNotation</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toProcessingInstruction</name>
      <anchor>toProcessingInstruction</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toCharacterData</name>
      <anchor>toCharacterData</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toComment</name>
      <anchor>toComment</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>save</name>
      <anchor>save</anchor>
      <arglist>( QTextStream &amp; str, int indent ) const</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QTextStream &amp; str, const QDomNode &amp; node )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDomNodeList</name>
    <filename>qdomnodelist.html</filename>
    <member kind="function">
      <name>QDomNodeList</name>
      <anchor>QDomNodeList</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDomNodeList</name>
      <anchor>QDomNodeList</anchor>
      <arglist>( const QDomNodeList &amp; n )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomNodeList &amp; n )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomNodeList &amp; n ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomNodeList &amp; n ) const</arglist>
    </member>
    <member kind="function">
      <name>QDomNodeList</name>
      <anchor>QDomNodeList</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>item</name>
      <anchor>item</anchor>
      <arglist>( int index ) const</arglist>
    </member>
    <member kind="function">
      <name>length</name>
      <anchor>length</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDomNotation</name>
    <filename>qdomnotation.html</filename>
    <member kind="function">
      <name>QDomNotation</name>
      <anchor>QDomNotation</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDomNotation</name>
      <anchor>QDomNotation</anchor>
      <arglist>( const QDomNotation &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomNotation &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>QDomNotation</name>
      <anchor>QDomNotation</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>publicId</name>
      <anchor>publicId</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>systemId</name>
      <anchor>systemId</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>nodeType</name>
      <anchor>nodeType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isNotation</name>
      <anchor>isNotation</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDomProcessingInstruction</name>
    <filename>qdomprocessinginstruction.html</filename>
    <member kind="function">
      <name>QDomProcessingInstruction</name>
      <anchor>QDomProcessingInstruction</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDomProcessingInstruction</name>
      <anchor>QDomProcessingInstruction</anchor>
      <arglist>( const QDomProcessingInstruction &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomProcessingInstruction &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>QDomProcessingInstruction</name>
      <anchor>QDomProcessingInstruction</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>target</name>
      <anchor>target</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>data</name>
      <anchor>data</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setData</name>
      <anchor>setData</anchor>
      <arglist>( const QString &amp; d )</arglist>
    </member>
    <member kind="function">
      <name>nodeType</name>
      <anchor>nodeType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isProcessingInstruction</name>
      <anchor>isProcessingInstruction</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDomText</name>
    <filename>qdomtext.html</filename>
    <member kind="function">
      <name>QDomText</name>
      <anchor>QDomText</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QDomText</name>
      <anchor>QDomText</anchor>
      <arglist>( const QDomText &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QDomText &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>QDomText</name>
      <anchor>QDomText</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>splitText</name>
      <anchor>splitText</anchor>
      <arglist>( int offset )</arglist>
    </member>
    <member kind="function">
      <name>nodeType</name>
      <anchor>nodeType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isText</name>
      <anchor>isText</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDoubleValidator</name>
    <filename>qdoublevalidator.html</filename>
    <member kind="function">
      <name>QDoubleValidator</name>
      <anchor>QDoubleValidator</anchor>
      <arglist>( QObject * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QDoubleValidator</name>
      <anchor>QDoubleValidator</anchor>
      <arglist>( double bottom, double top, int decimals, QObject * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QDoubleValidator</name>
      <anchor>QDoubleValidator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>validate</name>
      <anchor>validate</anchor>
      <arglist>( QString &amp; input, int &amp; ) const</arglist>
    </member>
    <member kind="function">
      <name>setRange</name>
      <anchor>setRange</anchor>
      <arglist>( double minimum, double maximum, int decimals = 0 )</arglist>
    </member>
    <member kind="function">
      <name>setBottom</name>
      <anchor>setBottom</anchor>
      <arglist>( double )</arglist>
    </member>
    <member kind="function">
      <name>setTop</name>
      <anchor>setTop</anchor>
      <arglist>( double )</arglist>
    </member>
    <member kind="function">
      <name>setDecimals</name>
      <anchor>setDecimals</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>bottom</name>
      <anchor>bottom</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>top</name>
      <anchor>top</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>decimals</name>
      <anchor>decimals</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>bottom</anchor>
      <arglist>- the validator&apos;s minimum acceptable value</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>decimals</anchor>
      <arglist>- the validator&apos;s maximum number of digits after the decimal point</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>top</anchor>
      <arglist>- the validator&apos;s maximum acceptable value</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDragEnterEvent</name>
    <filename>qdragenterevent.html</filename>
    <member kind="function">
      <name>QDragEnterEvent</name>
      <anchor>QDragEnterEvent</anchor>
      <arglist>( const QPoint &amp; pos )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDragLeaveEvent</name>
    <filename>qdragleaveevent.html</filename>
    <member kind="function">
      <name>QDragLeaveEvent</name>
      <anchor>QDragLeaveEvent</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDragMoveEvent</name>
    <filename>qdragmoveevent.html</filename>
    <member kind="function">
      <name>QDragMoveEvent</name>
      <anchor>QDragMoveEvent</anchor>
      <arglist>( const QPoint &amp; pos, Type type = DragMove )</arglist>
    </member>
    <member kind="function">
      <name>answerRect</name>
      <anchor>answerRect</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>accept</name>
      <anchor>accept</anchor>
      <arglist>( const QRect &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>ignore</name>
      <anchor>ignore</anchor>
      <arglist>( const QRect &amp; r )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDragObject</name>
    <filename>qdragobject.html</filename>
    <member kind="function">
      <name>QDragObject</name>
      <anchor>QDragObject</anchor>
      <arglist>( QWidget * dragSource = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QDragObject</name>
      <anchor>QDragObject</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>drag</name>
      <anchor>drag</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>dragMove</name>
      <anchor>dragMove</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>dragCopy</name>
      <anchor>dragCopy</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>dragLink</name>
      <anchor>dragLink</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setPixmap</name>
      <anchor>setPixmap</anchor>
      <arglist>( QPixmap pm )</arglist>
    </member>
    <member kind="function">
      <name>setPixmap</name>
      <anchor>setPixmap</anchor>
      <arglist>( QPixmap pm, const QPoint &amp; hotspot )</arglist>
    </member>
    <member kind="function">
      <name>pixmap</name>
      <anchor>pixmap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>pixmapHotSpot</name>
      <anchor>pixmapHotSpot</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>source</name>
      <anchor>source</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>DragMode</anchor>
      <arglist>{ DragDefault, DragCopy, DragMove, DragLink, DragCopyOrMove }</arglist>
    </member>
    <member kind="function">
      <name>target</name>
      <anchor>target</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>drag</name>
      <anchor>drag</anchor>
      <arglist>( DragMode mode )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDropEvent</name>
    <filename>qdropevent.html</filename>
    <member kind="function">
      <name>QDropEvent</name>
      <anchor>QDropEvent</anchor>
      <arglist>( const QPoint &amp; pos, Type typ = Drop )</arglist>
    </member>
    <member kind="function">
      <name>pos</name>
      <anchor>pos</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isAccepted</name>
      <anchor>isAccepted</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>accept</name>
      <anchor>accept</anchor>
      <arglist>( bool y = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>ignore</name>
      <anchor>ignore</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>isActionAccepted</name>
      <anchor>isActionAccepted</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>acceptAction</name>
      <anchor>acceptAction</anchor>
      <arglist>( bool y = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Action</anchor>
      <arglist>{ Copy, Link, Move, Private, UserAction = 100 }</arglist>
    </member>
    <member kind="function">
      <name>setAction</name>
      <anchor>setAction</anchor>
      <arglist>( Action a )</arglist>
    </member>
    <member kind="function">
      <name>action</name>
      <anchor>action</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>source</name>
      <anchor>source</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>format</name>
      <anchor>format</anchor>
      <arglist>( int n = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>encodedData</name>
      <anchor>encodedData</anchor>
      <arglist>( const char * format ) const</arglist>
    </member>
    <member kind="function">
      <name>provides</name>
      <anchor>provides</anchor>
      <arglist>( const char * mimeType ) const</arglist>
    </member>
    <member kind="function">
      <name>setPoint</name>
      <anchor>setPoint</anchor>
      <arglist>( const QPoint &amp; np )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDropSite</name>
    <filename>qdropsite.html</filename>
    <member kind="function">
      <name>QDropSite</name>
      <anchor>QDropSite</anchor>
      <arglist>( QWidget * self )</arglist>
    </member>
    <member kind="function">
      <name>QDropSite</name>
      <anchor>QDropSite</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QEditorFactory</name>
    <filename>qeditorfactory.html</filename>
    <member kind="function">
      <name>QEditorFactory</name>
      <anchor>QEditorFactory</anchor>
      <arglist>( QObject * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QEditorFactory</name>
      <anchor>QEditorFactory</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>createEditor</name>
      <anchor>createEditor</anchor>
      <arglist>( QWidget * parent, const QVariant &amp; v )</arglist>
    </member>
    <member kind="function">
      <name>defaultFactory</name>
      <anchor>defaultFactory</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>installDefaultFactory</name>
      <anchor>installDefaultFactory</anchor>
      <arglist>( QEditorFactory * factory )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QErrorMessage</name>
    <filename>qerrormessage.html</filename>
    <member kind="function">
      <name>QErrorMessage</name>
      <anchor>QErrorMessage</anchor>
      <arglist>( QWidget * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QErrorMessage</name>
      <anchor>QErrorMessage</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>message</name>
      <anchor>message</anchor>
      <arglist>( const QString &amp; m )</arglist>
    </member>
    <member kind="function">
      <name>qtHandler</name>
      <anchor>qtHandler</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QEucJpCodec</name>
    <filename>qeucjpcodec.html</filename>
    <member kind="function">
      <name>mibEnum</name>
      <anchor>mibEnum</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>mimeName</name>
      <anchor>mimeName</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>QEucJpCodec</name>
      <anchor>QEucJpCodec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QEucJpCodec</name>
      <anchor>QEucJpCodec</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QEucKrCodec</name>
    <filename>qeuckrcodec.html</filename>
    <member kind="function">
      <name>mimeName</name>
      <anchor>mimeName</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QEvent</name>
    <filename>qevent.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>Type</anchor>
      <arglist>{ None = 0, Timer = 1, MouseButtonPress = 2, MouseButtonRelease = 3, MouseButtonDblClick = 4, MouseMove = 5, KeyPress = 6, KeyRelease = 7, FocusIn = 8, FocusOut = 9, Enter = 10, Leave = 11, Paint = 12, Move = 13, Resize = 14, Create = 15, Destroy = 16, Show = 17, Hide = 18, Close = 19, Quit = 20, Reparent = 21, ShowMinimized = 22, ShowNormal = 23, WindowActivate = 24, WindowDeactivate = 25, ShowToParent = 26, HideToParent = 27, ShowMaximized = 28, ShowFullScreen = 29, Accel = 30, Wheel = 31, AccelAvailable = 32, CaptionChange = 33, IconChange = 34, ParentFontChange = 35, ApplicationFontChange = 36, ParentPaletteChange = 37, ApplicationPaletteChange = 38, PaletteChange = 39, Clipboard = 40, Speech = 42, SockAct = 50, AccelOverride = 51, DeferredDelete = 52, DragEnter = 60, DragMove = 61, DragLeave = 62, Drop = 63, DragResponse = 64, ChildInserted = 70, ChildRemoved = 71, LayoutHint = 72, ShowWindowRequest = 73, ActivateControl = 80, DeactivateControl = 81, ContextMenu = 82, IMStart = 83, IMCompose = 84, IMEnd = 85, Accessibility = 86, TabletMove = 87, LocaleChange = 88, LanguageChange = 89, LayoutDirectionChange = 90, Style = 91, TabletPress = 92, TabletRelease = 93, User = 1000, MaxUser = 65535 }</arglist>
    </member>
    <member kind="function">
      <name>QEvent</name>
      <anchor>QEvent</anchor>
      <arglist>( Type type )</arglist>
    </member>
    <member kind="function">
      <name>QEvent</name>
      <anchor>QEvent</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>type</name>
      <anchor>type</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>spontaneous</name>
      <anchor>spontaneous</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>focus</name>
      <anchor>keyboard</anchor>
      <arglist>,</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QEventLoop</name>
    <filename>qeventloop.html</filename>
    <member kind="function">
      <name>QEventLoop</name>
      <anchor>QEventLoop</anchor>
      <arglist>( QObject * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QEventLoop</name>
      <anchor>QEventLoop</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ProcessEvents</anchor>
      <arglist>{ AllEvents = 0x00, ExcludeUserInput = 0x01, ExcludeSocketNotifiers = 0x02, WaitForMore = 0x04 }</arglist>
    </member>
    <member kind="function">
      <name>ProcessEventsFlags</name>
      <anchor>ProcessEventsFlags</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>processEvents</name>
      <anchor>processEvents</anchor>
      <arglist>( ProcessEventsFlags flags, int maxTime )</arglist>
    </member>
    <member kind="function">
      <name>processEvents</name>
      <anchor>processEvents</anchor>
      <arglist>( ProcessEventsFlags flags )</arglist>
    </member>
    <member kind="function">
      <name>hasPendingEvents</name>
      <anchor>hasPendingEvents</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>registerSocketNotifier</name>
      <anchor>registerSocketNotifier</anchor>
      <arglist>( QSocketNotifier * notifier )</arglist>
    </member>
    <member kind="function">
      <name>unregisterSocketNotifier</name>
      <anchor>unregisterSocketNotifier</anchor>
      <arglist>( QSocketNotifier * notifier )</arglist>
    </member>
    <member kind="function">
      <name>setSocketNotifierPending</name>
      <anchor>setSocketNotifierPending</anchor>
      <arglist>( QSocketNotifier * notifier )</arglist>
    </member>
    <member kind="function">
      <name>activateSocketNotifiers</name>
      <anchor>activateSocketNotifiers</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>activateTimers</name>
      <anchor>activateTimers</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>timeToWait</name>
      <anchor>timeToWait</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>exec</name>
      <anchor>exec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>exit</name>
      <anchor>exit</anchor>
      <arglist>( int retcode = 0 )</arglist>
    </member>
    <member kind="function">
      <name>enterLoop</name>
      <anchor>enterLoop</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>exitLoop</name>
      <anchor>exitLoop</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>loopLevel</name>
      <anchor>loopLevel</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>wakeUp</name>
      <anchor>wakeUp</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>awake</name>
      <anchor>awake</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>aboutToBlock</name>
      <anchor>aboutToBlock</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QFile</name>
    <filename>qfile.html</filename>
    <member kind="function">
      <name>QFile</name>
      <anchor>QFile</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QFile</name>
      <anchor>QFile</anchor>
      <arglist>( const QString &amp; name )</arglist>
    </member>
    <member kind="function">
      <name>QFile</name>
      <anchor>QFile</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>name</name>
      <anchor>name</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setName</name>
      <anchor>setName</anchor>
      <arglist>( const QString &amp; name )</arglist>
    </member>
    <member kind="function">
      <name>EncoderFn</name>
      <anchor>EncoderFn</anchor>
      <arglist>) ( const QString &amp; fileName )</arglist>
    </member>
    <member kind="function">
      <name>DecoderFn</name>
      <anchor>DecoderFn</anchor>
      <arglist>) ( const QCString &amp; localfileName )</arglist>
    </member>
    <member kind="function">
      <name>exists</name>
      <anchor>exists</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>open</name>
      <anchor>open</anchor>
      <arglist>( int m )</arglist>
    </member>
    <member kind="function">
      <name>open</name>
      <anchor>open</anchor>
      <arglist>( int m, FILE * f )</arglist>
    </member>
    <member kind="function">
      <name>open</name>
      <anchor>open</anchor>
      <arglist>( int m, int f )</arglist>
    </member>
    <member kind="function">
      <name>close</name>
      <anchor>close</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>flush</name>
      <anchor>flush</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>atEnd</name>
      <anchor>atEnd</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>readLine</name>
      <anchor>readLine</anchor>
      <arglist>( char * p, Q_ULONG maxlen )</arglist>
    </member>
    <member kind="function">
      <name>readLine</name>
      <anchor>readLine</anchor>
      <arglist>( QString &amp; s, Q_ULONG maxlen )</arglist>
    </member>
    <member kind="function">
      <name>getch</name>
      <anchor>getch</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>putch</name>
      <anchor>putch</anchor>
      <arglist>( int ch )</arglist>
    </member>
    <member kind="function">
      <name>ungetch</name>
      <anchor>ungetch</anchor>
      <arglist>( int ch )</arglist>
    </member>
    <member kind="function">
      <name>handle</name>
      <anchor>handle</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>errorString</name>
      <anchor>errorString</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>encodeName</name>
      <anchor>encodeName</anchor>
      <arglist>( const QString &amp; fileName )</arglist>
    </member>
    <member kind="function">
      <name>decodeName</name>
      <anchor>decodeName</anchor>
      <arglist>( const QCString &amp; localFileName )</arglist>
    </member>
    <member kind="function">
      <name>setEncodingFunction</name>
      <anchor>setEncodingFunction</anchor>
      <arglist>( EncoderFn f )</arglist>
    </member>
    <member kind="function">
      <name>setDecodingFunction</name>
      <anchor>setDecodingFunction</anchor>
      <arglist>( DecoderFn f )</arglist>
    </member>
    <member kind="function">
      <name>exists</name>
      <anchor>exists</anchor>
      <arglist>( const QString &amp; fileName )</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>( const QString &amp; fileName )</arglist>
    </member>
    <member kind="function">
      <name>readAll</name>
      <anchor>readAll</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setErrorString</name>
      <anchor>setErrorString</anchor>
      <arglist>( const QString &amp; str )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QFileDialog</name>
    <filename>qfiledialog.html</filename>
    <member kind="function">
      <name>QFileDialog</name>
      <anchor>QFileDialog</anchor>
      <arglist>( const QString &amp; dirName, const QString &amp; filter = QString::null, QWidget * parent = 0, const char * name = 0, bool modal = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>QFileDialog</name>
      <anchor>QFileDialog</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0, bool modal = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>QFileDialog</name>
      <anchor>QFileDialog</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>selectedFile</name>
      <anchor>selectedFile</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>selectedFilter</name>
      <anchor>selectedFilter</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSelectedFilter</name>
      <anchor>setSelectedFilter</anchor>
      <arglist>( const QString &amp; mask )</arglist>
    </member>
    <member kind="function">
      <name>setSelectedFilter</name>
      <anchor>setSelectedFilter</anchor>
      <arglist>( int n )</arglist>
    </member>
    <member kind="function">
      <name>setSelection</name>
      <anchor>setSelection</anchor>
      <arglist>( const QString &amp; filename )</arglist>
    </member>
    <member kind="function">
      <name>selectAll</name>
      <anchor>selectAll</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>selectedFiles</name>
      <anchor>selectedFiles</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>dirPath</name>
      <anchor>dirPath</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setDir</name>
      <anchor>setDir</anchor>
      <arglist>( const QDir &amp; dir )</arglist>
    </member>
    <member kind="function">
      <name>dir</name>
      <anchor>dir</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setShowHiddenFiles</name>
      <anchor>setShowHiddenFiles</anchor>
      <arglist>( bool s )</arglist>
    </member>
    <member kind="function">
      <name>showHiddenFiles</name>
      <anchor>showHiddenFiles</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rereadDir</name>
      <anchor>rereadDir</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>resortDir</name>
      <anchor>resortDir</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Mode</anchor>
      <arglist>{ AnyFile, ExistingFile, Directory, ExistingFiles, DirectoryOnly }</arglist>
    </member>
    <member kind="function">
      <name>setMode</name>
      <anchor>setMode</anchor>
      <arglist>( Mode )</arglist>
    </member>
    <member kind="function">
      <name>mode</name>
      <anchor>mode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ViewMode</anchor>
      <arglist>{ Detail, List }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>PreviewMode</anchor>
      <arglist>{ NoPreview, Contents, Info }</arglist>
    </member>
    <member kind="function">
      <name>setViewMode</name>
      <anchor>setViewMode</anchor>
      <arglist>( ViewMode m )</arglist>
    </member>
    <member kind="function">
      <name>viewMode</name>
      <anchor>viewMode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPreviewMode</name>
      <anchor>setPreviewMode</anchor>
      <arglist>( PreviewMode m )</arglist>
    </member>
    <member kind="function">
      <name>previewMode</name>
      <anchor>previewMode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isInfoPreviewEnabled</name>
      <anchor>isInfoPreviewEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isContentsPreviewEnabled</name>
      <anchor>isContentsPreviewEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setInfoPreviewEnabled</name>
      <anchor>setInfoPreviewEnabled</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>setContentsPreviewEnabled</name>
      <anchor>setContentsPreviewEnabled</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>setInfoPreview</name>
      <anchor>setInfoPreview</anchor>
      <arglist>( QWidget * w, QFilePreview * preview )</arglist>
    </member>
    <member kind="function">
      <name>setContentsPreview</name>
      <anchor>setContentsPreview</anchor>
      <arglist>( QWidget * w, QFilePreview * preview )</arglist>
    </member>
    <member kind="function">
      <name>url</name>
      <anchor>url</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>addFilter</name>
      <anchor>addFilter</anchor>
      <arglist>( const QString &amp; filter )</arglist>
    </member>
    <member kind="function">
      <name>setDir</name>
      <anchor>setDir</anchor>
      <arglist>( const QString &amp; pathstr )</arglist>
    </member>
    <member kind="function">
      <name>setUrl</name>
      <anchor>setUrl</anchor>
      <arglist>( const QUrlOperator &amp; url )</arglist>
    </member>
    <member kind="function">
      <name>setFilter</name>
      <anchor>setFilter</anchor>
      <arglist>( const QString &amp; newFilter )</arglist>
    </member>
    <member kind="function">
      <name>setFilters</name>
      <anchor>setFilters</anchor>
      <arglist>( const QString &amp; filters )</arglist>
    </member>
    <member kind="function">
      <name>setFilters</name>
      <anchor>setFilters</anchor>
      <arglist>( const char ** types )</arglist>
    </member>
    <member kind="function">
      <name>setFilters</name>
      <anchor>setFilters</anchor>
      <arglist>( const QStringList &amp; )</arglist>
    </member>
    <member kind="function">
      <name>fileHighlighted</name>
      <anchor>fileHighlighted</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>fileSelected</name>
      <anchor>fileSelected</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>filesSelected</name>
      <anchor>filesSelected</anchor>
      <arglist>( const QStringList &amp; )</arglist>
    </member>
    <member kind="function">
      <name>dirEntered</name>
      <anchor>dirEntered</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>filterSelected</name>
      <anchor>filterSelected</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>getOpenFileName</name>
      <anchor>getOpenFileName</anchor>
      <arglist>( const QString &amp; startWith = QString::null, const QString &amp; filter = QString::null, QWidget * parent = 0, const char * name = 0, const QString &amp; caption = QString::null, QString * selectedFilter = 0, bool resolveSymlinks = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>getSaveFileName</name>
      <anchor>getSaveFileName</anchor>
      <arglist>( const QString &amp; startWith = QString::null, const QString &amp; filter = QString::null, QWidget * parent = 0, const char * name = 0, const QString &amp; caption = QString::null, QString * selectedFilter = 0, bool resolveSymlinks = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>getExistingDirectory</name>
      <anchor>getExistingDirectory</anchor>
      <arglist>( const QString &amp; dir = QString::null, QWidget * parent = 0, const char * name = 0, const QString &amp; caption = QString::null, bool dirOnly = TRUE, bool resolveSymlinks = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>getOpenFileNames</name>
      <anchor>getOpenFileNames</anchor>
      <arglist>( const QString &amp; filter = QString::null, const QString &amp; dir = QString::null, QWidget * parent = 0, const char * name = 0, const QString &amp; caption = QString::null, QString * selectedFilter = 0, bool resolveSymlinks = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>setIconProvider</name>
      <anchor>setIconProvider</anchor>
      <arglist>( QFileIconProvider * provider )</arglist>
    </member>
    <member kind="function">
      <name>iconProvider</name>
      <anchor>iconProvider</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>contentsPreview</anchor>
      <arglist>- whether the file dialog can provide a contents preview of the currently selected file</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>dirPath</anchor>
      <arglist>- the file dialog&apos;s working directory</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>infoPreview</anchor>
      <arglist>- whether the file dialog can provide preview information about the currently selected file</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>mode</anchor>
      <arglist>- the file dialog&apos;s mode</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>previewMode</anchor>
      <arglist>- the preview mode for the file dialog</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>selectedFile</anchor>
      <arglist>- the name of the selected file</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>selectedFiles</anchor>
      <arglist>- the list of selected files</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>selectedFilter</anchor>
      <arglist>- the filter which the user has selected in the file dialog</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>showHiddenFiles</anchor>
      <arglist>- whether hidden files are shown in the file dialog</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>viewMode</anchor>
      <arglist>- the file dialog&apos;s view mode</arglist>
    </member>
    <member kind="function">
      <name>addWidgets</name>
      <anchor>addWidgets</anchor>
      <arglist>( QLabel * l, QWidget * w, QPushButton * b )</arglist>
    </member>
    <member kind="function">
      <name>addToolButton</name>
      <anchor>addToolButton</anchor>
      <arglist>( QButton * b, bool separator = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>addLeftWidget</name>
      <anchor>addLeftWidget</anchor>
      <arglist>( QWidget * w )</arglist>
    </member>
    <member kind="function">
      <name>addRightWidget</name>
      <anchor>addRightWidget</anchor>
      <arglist>( QWidget * w )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QFileIconProvider</name>
    <filename>qfileiconprovider.html</filename>
    <member kind="function">
      <name>QFileIconProvider</name>
      <anchor>QFileIconProvider</anchor>
      <arglist>( QObject * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>pixmap</name>
      <anchor>pixmap</anchor>
      <arglist>( const QFileInfo &amp; info )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QFileInfo</name>
    <filename>qfileinfo.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>PermissionSpec</anchor>
      <arglist>{ ReadOwner = 04000, WriteOwner = 02000, ExeOwner = 01000, ReadUser = 00400, WriteUser = 00200, ExeUser = 00100, ReadGroup = 00040, WriteGroup = 00020, ExeGroup = 00010, ReadOther = 00004, WriteOther = 00002, ExeOther = 00001 }</arglist>
    </member>
    <member kind="function">
      <name>QFileInfo</name>
      <anchor>QFileInfo</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QFileInfo</name>
      <anchor>QFileInfo</anchor>
      <arglist>( const QString &amp; file )</arglist>
    </member>
    <member kind="function">
      <name>QFileInfo</name>
      <anchor>QFileInfo</anchor>
      <arglist>( const QFile &amp; file )</arglist>
    </member>
    <member kind="function">
      <name>QFileInfo</name>
      <anchor>QFileInfo</anchor>
      <arglist>( const QDir &amp; d, const QString &amp; fileName )</arglist>
    </member>
    <member kind="function">
      <name>QFileInfo</name>
      <anchor>QFileInfo</anchor>
      <arglist>( const QFileInfo &amp; fi )</arglist>
    </member>
    <member kind="function">
      <name>QFileInfo</name>
      <anchor>QFileInfo</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QFileInfo &amp; fi )</arglist>
    </member>
    <member kind="function">
      <name>setFile</name>
      <anchor>setFile</anchor>
      <arglist>( const QString &amp; file )</arglist>
    </member>
    <member kind="function">
      <name>setFile</name>
      <anchor>setFile</anchor>
      <arglist>( const QFile &amp; file )</arglist>
    </member>
    <member kind="function">
      <name>setFile</name>
      <anchor>setFile</anchor>
      <arglist>( const QDir &amp; d, const QString &amp; fileName )</arglist>
    </member>
    <member kind="function">
      <name>exists</name>
      <anchor>exists</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>refresh</name>
      <anchor>refresh</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>caching</name>
      <anchor>caching</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setCaching</name>
      <anchor>setCaching</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>filePath</name>
      <anchor>filePath</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>fileName</name>
      <anchor>fileName</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>absFilePath</name>
      <anchor>absFilePath</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>baseName</name>
      <anchor>baseName</anchor>
      <arglist>( bool complete = FALSE ) const</arglist>
    </member>
    <member kind="function">
      <name>extension</name>
      <anchor>extension</anchor>
      <arglist>( bool complete = TRUE ) const</arglist>
    </member>
    <member kind="function">
      <name>dirPath</name>
      <anchor>dirPath</anchor>
      <arglist>( bool absPath = FALSE ) const</arglist>
    </member>
    <member kind="function">
      <name>dir</name>
      <anchor>dir</anchor>
      <arglist>( bool absPath = FALSE ) const</arglist>
    </member>
    <member kind="function">
      <name>isReadable</name>
      <anchor>isReadable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isWritable</name>
      <anchor>isWritable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isExecutable</name>
      <anchor>isExecutable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isHidden</name>
      <anchor>isHidden</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isRelative</name>
      <anchor>isRelative</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>convertToAbs</name>
      <anchor>convertToAbs</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>isFile</name>
      <anchor>isFile</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isDir</name>
      <anchor>isDir</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isSymLink</name>
      <anchor>isSymLink</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>readLink</name>
      <anchor>readLink</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>owner</name>
      <anchor>owner</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>ownerId</name>
      <anchor>ownerId</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>group</name>
      <anchor>group</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>groupId</name>
      <anchor>groupId</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>permission</name>
      <anchor>permission</anchor>
      <arglist>( int permissionSpec ) const</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>created</name>
      <anchor>created</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>lastModified</name>
      <anchor>lastModified</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>lastRead</name>
      <anchor>lastRead</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QFilePreview</name>
    <filename>qfilepreview.html</filename>
    <member kind="function">
      <name>QFilePreview</name>
      <anchor>QFilePreview</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>previewUrl</name>
      <anchor>previewUrl</anchor>
      <arglist>( const QUrl &amp; url ) = 0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QFocusData</name>
    <filename>qfocusdata.html</filename>
    <member kind="function">
      <name>focusWidget</name>
      <anchor>focusWidget</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>home</name>
      <anchor>home</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>next</name>
      <anchor>next</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>prev</name>
      <anchor>prev</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>first</name>
      <anchor>first</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>last</name>
      <anchor>last</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QFocusEvent</name>
    <filename>qfocusevent.html</filename>
    <member kind="function">
      <name>QFocusEvent</name>
      <anchor>QFocusEvent</anchor>
      <arglist>( Type type )</arglist>
    </member>
    <member kind="function">
      <name>gotFocus</name>
      <anchor>gotFocus</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>lostFocus</name>
      <anchor>lostFocus</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Reason</anchor>
      <arglist>{ Mouse, Tab, Backtab, ActiveWindow, Popup, Shortcut, Other }</arglist>
    </member>
    <member kind="function">
      <name>reason</name>
      <anchor>reason</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setReason</name>
      <anchor>setReason</anchor>
      <arglist>( Reason reason )</arglist>
    </member>
    <member kind="function">
      <name>resetReason</name>
      <anchor>resetReason</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QFont</name>
    <filename>qfont.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>StyleHint</anchor>
      <arglist>{ Helvetica, SansSerif = Helvetica, Times, Serif = Times, Courier, TypeWriter = Courier, OldEnglish, Decorative = OldEnglish, System, AnyStyle }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>StyleStrategy</anchor>
      <arglist>{ PreferDefault = 0x0001, PreferBitmap = 0x0002, PreferDevice = 0x0004, PreferOutline = 0x0008, ForceOutline = 0x0010, PreferMatch = 0x0020, PreferQuality = 0x0040, PreferAntialias = 0x0080, NoAntialias = 0x0100, OpenGLCompatible = 0x0200 }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Weight</anchor>
      <arglist>{ Light = 25, Normal = 50, DemiBold = 63, Bold = 75, Black = 87 }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Stretch</anchor>
      <arglist>{ UltraCondensed = 50, ExtraCondensed = 62, Condensed = 75, SemiCondensed = 87, Unstretched = 100, SemiExpanded = 112, Expanded = 125, ExtraExpanded = 150, UltraExpanded = 200 }</arglist>
    </member>
    <member kind="function">
      <name>QFont</name>
      <anchor>QFont</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QFont</name>
      <anchor>QFont</anchor>
      <arglist>( const QString &amp; family, int pointSize = 12, int weight = Normal, bool italic = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>QFont</name>
      <anchor>QFont</anchor>
      <arglist>( const QFont &amp; font )</arglist>
    </member>
    <member kind="function">
      <name>QFont</name>
      <anchor>QFont</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>family</name>
      <anchor>family</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setFamily</name>
      <anchor>setFamily</anchor>
      <arglist>( const QString &amp; family )</arglist>
    </member>
    <member kind="function">
      <name>pointSize</name>
      <anchor>pointSize</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>pointSizeFloat</name>
      <anchor>pointSizeFloat</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPointSize</name>
      <anchor>setPointSize</anchor>
      <arglist>( int pointSize )</arglist>
    </member>
    <member kind="function">
      <name>setPointSizeFloat</name>
      <anchor>setPointSizeFloat</anchor>
      <arglist>( float pointSize )</arglist>
    </member>
    <member kind="function">
      <name>pixelSize</name>
      <anchor>pixelSize</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPixelSize</name>
      <anchor>setPixelSize</anchor>
      <arglist>( int pixelSize )</arglist>
    </member>
    <member kind="function">
      <name>weight</name>
      <anchor>weight</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setWeight</name>
      <anchor>setWeight</anchor>
      <arglist>( int weight )</arglist>
    </member>
    <member kind="function">
      <name>bold</name>
      <anchor>bold</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setBold</name>
      <anchor>setBold</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>italic</name>
      <anchor>italic</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setItalic</name>
      <anchor>setItalic</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>underline</name>
      <anchor>underline</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setUnderline</name>
      <anchor>setUnderline</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>overline</name>
      <anchor>overline</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setOverline</name>
      <anchor>setOverline</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>strikeOut</name>
      <anchor>strikeOut</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setStrikeOut</name>
      <anchor>setStrikeOut</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>fixedPitch</name>
      <anchor>fixedPitch</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setFixedPitch</name>
      <anchor>setFixedPitch</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>styleHint</name>
      <anchor>styleHint</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>styleStrategy</name>
      <anchor>styleStrategy</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setStyleHint</name>
      <anchor>setStyleHint</anchor>
      <arglist>( StyleHint hint, StyleStrategy strategy = PreferDefault )</arglist>
    </member>
    <member kind="function">
      <name>setStyleStrategy</name>
      <anchor>setStyleStrategy</anchor>
      <arglist>( StyleStrategy s )</arglist>
    </member>
    <member kind="function">
      <name>stretch</name>
      <anchor>stretch</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setStretch</name>
      <anchor>setStretch</anchor>
      <arglist>( int factor )</arglist>
    </member>
    <member kind="function">
      <name>rawMode</name>
      <anchor>rawMode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setRawMode</name>
      <anchor>setRawMode</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>exactMatch</name>
      <anchor>exactMatch</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QFont &amp; font )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QFont &amp; f ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QFont &amp; f ) const</arglist>
    </member>
    <member kind="function">
      <name>isCopyOf</name>
      <anchor>isCopyOf</anchor>
      <arglist>( const QFont &amp; f ) const</arglist>
    </member>
    <member kind="function">
      <name>handle</name>
      <anchor>handle</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setRawName</name>
      <anchor>setRawName</anchor>
      <arglist>( const QString &amp; name )</arglist>
    </member>
    <member kind="function">
      <name>rawName</name>
      <anchor>rawName</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>key</name>
      <anchor>key</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>toString</name>
      <anchor>toString</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>fromString</name>
      <anchor>fromString</anchor>
      <arglist>( const QString &amp; descrip )</arglist>
    </member>
    <member kind="function">
      <name>qwsRenderToDisk</name>
      <anchor>qwsRenderToDisk</anchor>
      <arglist>( bool all = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Script</anchor>
      <arglist>{ Latin, Greek, Cyrillic, Armenian, Georgian, Runic, Ogham, SpacingModifiers, CombiningMarks, Hebrew, Arabic, Syriac, Thaana, Devanagari, Bengali, Gurmukhi, Gujarati, Oriya, Tamil, Telugu, Kannada, Malayalam, Sinhala, Thai, Lao, Tibetan, Myanmar, Khmer, Han, Hiragana, Katakana, Hangul, Bopomofo, Yi, Ethiopic, Cherokee, CanadianAboriginal, Mongolian, CurrencySymbols, LetterlikeSymbols, NumberForms, MathematicalOperators, TechnicalSymbols, GeometricSymbols, MiscellaneousSymbols, EnclosedAndSquare, Braille, Unicode, Tagalog, Hanunoo, Buhid, Tagbanwa, KatakanaHalfWidth }</arglist>
    </member>
    <member kind="function">
      <name>defaultFamily</name>
      <anchor>defaultFamily</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>lastResortFamily</name>
      <anchor>lastResortFamily</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>lastResortFont</name>
      <anchor>lastResortFont</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>resolve</name>
      <anchor>resolve</anchor>
      <arglist>( const QFont &amp; other ) const</arglist>
    </member>
    <member kind="function">
      <name>substitute</name>
      <anchor>substitute</anchor>
      <arglist>( const QString &amp; familyName )</arglist>
    </member>
    <member kind="function">
      <name>substitutes</name>
      <anchor>substitutes</anchor>
      <arglist>( const QString &amp; familyName )</arglist>
    </member>
    <member kind="function">
      <name>substitutions</name>
      <anchor>substitutions</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>insertSubstitution</name>
      <anchor>insertSubstitution</anchor>
      <arglist>( const QString &amp; familyName, const QString &amp; substituteName )</arglist>
    </member>
    <member kind="function">
      <name>insertSubstitutions</name>
      <anchor>insertSubstitutions</anchor>
      <arglist>( const QString &amp; familyName, const QStringList &amp; substituteNames )</arglist>
    </member>
    <member kind="function">
      <name>removeSubstitution</name>
      <anchor>removeSubstitution</anchor>
      <arglist>( const QString &amp; familyName )</arglist>
    </member>
    <member kind="function">
      <name>dirty</name>
      <anchor>dirty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>deciPointSize</name>
      <anchor>deciPointSize</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QFont &amp; font )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QFont &amp; font )</arglist>
    </member>
    <member kind="function">
      <name>styleHint</name>
      <anchor>styleHint</anchor>
      <arglist>() is used to select a replacement</arglist>
    </member>
    <member kind="function">
      <name>lastResortFamily</name>
      <anchor>lastResortFamily</anchor>
      <arglist>().</arglist>
    </member>
    <member kind="function">
      <name>fixedPitch</name>
      <anchor>fixedPitch</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>pointSize</name>
      <anchor>pointSize</anchor>
      <arglist>() (see below)</arglist>
    </member>
    <member kind="function">
      <name>weight</name>
      <anchor>weight</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>italic</name>
      <anchor>italic</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>StyleHint</anchor>
      <arglist>.</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>StyleHint</anchor>
      <arglist>.</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>StyleHint</anchor>
      <arglist>.</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>StyleHint</anchor>
      <arglist>.</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QFontDatabase</name>
    <filename>qfontdatabase.html</filename>
    <member kind="function">
      <name>QFontDatabase</name>
      <anchor>QFontDatabase</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>families</name>
      <anchor>families</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>families</name>
      <anchor>families</anchor>
      <arglist>( QFont::Script script ) const</arglist>
    </member>
    <member kind="function">
      <name>styles</name>
      <anchor>styles</anchor>
      <arglist>( const QString &amp; family ) const</arglist>
    </member>
    <member kind="function">
      <name>pointSizes</name>
      <anchor>pointSizes</anchor>
      <arglist>( const QString &amp; family, const QString &amp; style = QString::null )</arglist>
    </member>
    <member kind="function">
      <name>smoothSizes</name>
      <anchor>smoothSizes</anchor>
      <arglist>( const QString &amp; family, const QString &amp; style )</arglist>
    </member>
    <member kind="function">
      <name>styleString</name>
      <anchor>styleString</anchor>
      <arglist>( const QFont &amp; f )</arglist>
    </member>
    <member kind="function">
      <name>font</name>
      <anchor>font</anchor>
      <arglist>( const QString &amp; family, const QString &amp; style, int pointSize )</arglist>
    </member>
    <member kind="function">
      <name>isBitmapScalable</name>
      <anchor>isBitmapScalable</anchor>
      <arglist>( const QString &amp; family, const QString &amp; style = QString::null ) const</arglist>
    </member>
    <member kind="function">
      <name>isSmoothlyScalable</name>
      <anchor>isSmoothlyScalable</anchor>
      <arglist>( const QString &amp; family, const QString &amp; style = QString::null ) const</arglist>
    </member>
    <member kind="function">
      <name>isScalable</name>
      <anchor>isScalable</anchor>
      <arglist>( const QString &amp; family, const QString &amp; style = QString::null ) const</arglist>
    </member>
    <member kind="function">
      <name>isFixedPitch</name>
      <anchor>isFixedPitch</anchor>
      <arglist>( const QString &amp; family, const QString &amp; style = QString::null ) const</arglist>
    </member>
    <member kind="function">
      <name>italic</name>
      <anchor>italic</anchor>
      <arglist>( const QString &amp; family, const QString &amp; style ) const</arglist>
    </member>
    <member kind="function">
      <name>bold</name>
      <anchor>bold</anchor>
      <arglist>( const QString &amp; family, const QString &amp; style ) const</arglist>
    </member>
    <member kind="function">
      <name>weight</name>
      <anchor>weight</anchor>
      <arglist>( const QString &amp; family, const QString &amp; style ) const</arglist>
    </member>
    <member kind="function">
      <name>standardSizes</name>
      <anchor>standardSizes</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>scriptName</name>
      <anchor>scriptName</anchor>
      <arglist>( QFont::Script script )</arglist>
    </member>
    <member kind="function">
      <name>scriptSample</name>
      <anchor>scriptSample</anchor>
      <arglist>( QFont::Script script )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QFontDialog</name>
    <filename>qfontdialog.html</filename>
    <member kind="function">
      <name>getFont</name>
      <anchor>getFont</anchor>
      <arglist>( bool * ok, const QFont &amp; initial, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>getFont</name>
      <anchor>getFont</anchor>
      <arglist>( bool * ok, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QFontInfo</name>
    <filename>qfontinfo.html</filename>
    <member kind="function">
      <name>QFontInfo</name>
      <anchor>QFontInfo</anchor>
      <arglist>( const QFont &amp; font )</arglist>
    </member>
    <member kind="function">
      <name>QFontInfo</name>
      <anchor>QFontInfo</anchor>
      <arglist>( const QFont &amp; font, QFont::Script script )</arglist>
    </member>
    <member kind="function">
      <name>QFontInfo</name>
      <anchor>QFontInfo</anchor>
      <arglist>( const QFontInfo &amp; fi )</arglist>
    </member>
    <member kind="function">
      <name>QFontInfo</name>
      <anchor>QFontInfo</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QFontInfo &amp; fi )</arglist>
    </member>
    <member kind="function">
      <name>family</name>
      <anchor>family</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>pixelSize</name>
      <anchor>pixelSize</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>pointSize</name>
      <anchor>pointSize</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>italic</name>
      <anchor>italic</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>weight</name>
      <anchor>weight</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>bold</name>
      <anchor>bold</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>fixedPitch</name>
      <anchor>fixedPitch</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>styleHint</name>
      <anchor>styleHint</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rawMode</name>
      <anchor>rawMode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>exactMatch</name>
      <anchor>exactMatch</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QFontManager</name>
    <filename>qfontmanager.html</filename>
    <member kind="function">
      <name>QFontManager</name>
      <anchor>QFontManager</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QFontManager</name>
      <anchor>QFontManager</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>get</name>
      <anchor>get</anchor>
      <arglist>( const QFontDef &amp; f )</arglist>
    </member>
    <member kind="function">
      <name>initialize</name>
      <anchor>initialize</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>cleanup</name>
      <anchor>cleanup</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QFontMetrics</name>
    <filename>qfontmetrics.html</filename>
    <member kind="function">
      <name>QFontMetrics</name>
      <anchor>QFontMetrics</anchor>
      <arglist>( const QFont &amp; font )</arglist>
    </member>
    <member kind="function">
      <name>QFontMetrics</name>
      <anchor>QFontMetrics</anchor>
      <arglist>( const QFont &amp; font, QFont::Script script )</arglist>
    </member>
    <member kind="function">
      <name>QFontMetrics</name>
      <anchor>QFontMetrics</anchor>
      <arglist>( const QFontMetrics &amp; fm )</arglist>
    </member>
    <member kind="function">
      <name>QFontMetrics</name>
      <anchor>QFontMetrics</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QFontMetrics &amp; fm )</arglist>
    </member>
    <member kind="function">
      <name>ascent</name>
      <anchor>ascent</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>descent</name>
      <anchor>descent</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>height</name>
      <anchor>height</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>leading</name>
      <anchor>leading</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>lineSpacing</name>
      <anchor>lineSpacing</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>minLeftBearing</name>
      <anchor>minLeftBearing</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>minRightBearing</name>
      <anchor>minRightBearing</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>maxWidth</name>
      <anchor>maxWidth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>inFont</name>
      <anchor>inFont</anchor>
      <arglist>( QChar ch ) const</arglist>
    </member>
    <member kind="function">
      <name>leftBearing</name>
      <anchor>leftBearing</anchor>
      <arglist>( QChar ch ) const</arglist>
    </member>
    <member kind="function">
      <name>rightBearing</name>
      <anchor>rightBearing</anchor>
      <arglist>( QChar ch ) const</arglist>
    </member>
    <member kind="function">
      <name>width</name>
      <anchor>width</anchor>
      <arglist>( const QString &amp; str, int len = -1 ) const</arglist>
    </member>
    <member kind="function">
      <name>width</name>
      <anchor>width</anchor>
      <arglist>( QChar ch ) const</arglist>
    </member>
    <member kind="function">
      <name>charWidth</name>
      <anchor>charWidth</anchor>
      <arglist>( const QString &amp; str, int pos ) const</arglist>
    </member>
    <member kind="function">
      <name>boundingRect</name>
      <anchor>boundingRect</anchor>
      <arglist>( const QString &amp; str, int len = -1 ) const</arglist>
    </member>
    <member kind="function">
      <name>boundingRect</name>
      <anchor>boundingRect</anchor>
      <arglist>( QChar ch ) const</arglist>
    </member>
    <member kind="function">
      <name>boundingRect</name>
      <anchor>boundingRect</anchor>
      <arglist>( int x, int y, int w, int h, int flgs, const QString &amp; str, int len = -1, int tabstops = 0, int * tabarray = 0, QTextParag ** intern = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>( int flgs, const QString &amp; str, int len = -1, int tabstops = 0, int * tabarray = 0, QTextParag ** intern = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>underlinePos</name>
      <anchor>underlinePos</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>overlinePos</name>
      <anchor>overlinePos</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>strikeOutPos</name>
      <anchor>strikeOutPos</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>lineWidth</name>
      <anchor>lineWidth</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QFrame</name>
    <filename>qframe.html</filename>
    <member kind="function">
      <name>QFrame</name>
      <anchor>QFrame</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>frameStyle</name>
      <anchor>frameStyle</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setFrameStyle</name>
      <anchor>setFrameStyle</anchor>
      <arglist>( int style )</arglist>
    </member>
    <member kind="function">
      <name>frameWidth</name>
      <anchor>frameWidth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>contentsRect</name>
      <anchor>contentsRect</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Shape</anchor>
      <arglist>{ NoFrame = 0, Box = 0x0001, Panel = 0x0002, WinPanel = 0x0003, HLine = 0x0004, VLine = 0x0005, StyledPanel = 0x0006, PopupPanel = 0x0007, MenuBarPanel = 0x0008, ToolBarPanel = 0x0009, LineEditPanel = 0x000a, TabWidgetPanel = 0x000b, GroupBoxPanel = 0x000c, MShape = 0x000f }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Shadow</anchor>
      <arglist>{ Plain = 0x0010, Raised = 0x0020, Sunken = 0x0030, MShadow = 0x00f0 }</arglist>
    </member>
    <member kind="function">
      <name>frameShape</name>
      <anchor>frameShape</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setFrameShape</name>
      <anchor>setFrameShape</anchor>
      <arglist>( Shape )</arglist>
    </member>
    <member kind="function">
      <name>frameShadow</name>
      <anchor>frameShadow</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setFrameShadow</name>
      <anchor>setFrameShadow</anchor>
      <arglist>( Shadow )</arglist>
    </member>
    <member kind="function">
      <name>lineWidth</name>
      <anchor>lineWidth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setLineWidth</name>
      <anchor>setLineWidth</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>margin</name>
      <anchor>margin</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMargin</name>
      <anchor>setMargin</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>midLineWidth</name>
      <anchor>midLineWidth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMidLineWidth</name>
      <anchor>setMidLineWidth</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>frameRect</name>
      <anchor>frameRect</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setFrameRect</name>
      <anchor>setFrameRect</anchor>
      <arglist>( const QRect &amp; )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>contentsRect</anchor>
      <arglist>- the rectangle inside the frame</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>frameRect</anchor>
      <arglist>- the frame rectangle</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>frameShadow</anchor>
      <arglist>- the frame shadow value from the frame style</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>frameShape</anchor>
      <arglist>- the frame shape value from the frame style</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>frameWidth</anchor>
      <arglist>- the width of the frame that is drawn</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>lineWidth</anchor>
      <arglist>- the line width</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>margin</anchor>
      <arglist>- the width of the margin</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>midLineWidth</anchor>
      <arglist>- the width of the mid-line</arglist>
    </member>
    <member kind="function">
      <name>paintEvent</name>
      <anchor>paintEvent</anchor>
      <arglist>( QPaintEvent * event )</arglist>
    </member>
    <member kind="function">
      <name>resizeEvent</name>
      <anchor>resizeEvent</anchor>
      <arglist>( QResizeEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>drawFrame</name>
      <anchor>drawFrame</anchor>
      <arglist>( QPainter * p )</arglist>
    </member>
    <member kind="function">
      <name>drawContents</name>
      <anchor>drawContents</anchor>
      <arglist>( QPainter * )</arglist>
    </member>
    <member kind="function">
      <name>frameChanged</name>
      <anchor>frameChanged</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QFtp</name>
    <filename>qftp.html</filename>
    <member kind="function">
      <name>QFtp</name>
      <anchor>QFtp</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QFtp</name>
      <anchor>QFtp</anchor>
      <arglist>( QObject * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QFtp</name>
      <anchor>QFtp</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>State</anchor>
      <arglist>{ Unconnected, HostLookup, Connecting, Connected, LoggedIn, Closing }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Error</anchor>
      <arglist>{ NoError, UnknownError, HostNotFound, ConnectionRefused, NotConnected }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Command</anchor>
      <arglist>{ None, ConnectToHost, Login, Close, List, Cd, Get, Put, Remove, Mkdir, Rmdir, Rename, RawCommand }</arglist>
    </member>
    <member kind="function">
      <name>connectToHost</name>
      <anchor>connectToHost</anchor>
      <arglist>( const QString &amp; host, Q_UINT16 port = 21 )</arglist>
    </member>
    <member kind="function">
      <name>login</name>
      <anchor>login</anchor>
      <arglist>( const QString &amp; user = QString::null, const QString &amp; password = QString::null )</arglist>
    </member>
    <member kind="function">
      <name>close</name>
      <anchor>close</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>list</name>
      <anchor>list</anchor>
      <arglist>( const QString &amp; dir = QString::null )</arglist>
    </member>
    <member kind="function">
      <name>cd</name>
      <anchor>cd</anchor>
      <arglist>( const QString &amp; dir )</arglist>
    </member>
    <member kind="function">
      <name>get</name>
      <anchor>get</anchor>
      <arglist>( const QString &amp; file, QIODevice * dev = 0 )</arglist>
    </member>
    <member kind="function">
      <name>put</name>
      <anchor>put</anchor>
      <arglist>( const QByteArray &amp; data, const QString &amp; file )</arglist>
    </member>
    <member kind="function">
      <name>put</name>
      <anchor>put</anchor>
      <arglist>( QIODevice * dev, const QString &amp; file )</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>( const QString &amp; file )</arglist>
    </member>
    <member kind="function">
      <name>mkdir</name>
      <anchor>mkdir</anchor>
      <arglist>( const QString &amp; dir )</arglist>
    </member>
    <member kind="function">
      <name>rmdir</name>
      <anchor>rmdir</anchor>
      <arglist>( const QString &amp; dir )</arglist>
    </member>
    <member kind="function">
      <name>rename</name>
      <anchor>rename</anchor>
      <arglist>( const QString &amp; oldname, const QString &amp; newname )</arglist>
    </member>
    <member kind="function">
      <name>rawCommand</name>
      <anchor>rawCommand</anchor>
      <arglist>( const QString &amp; command )</arglist>
    </member>
    <member kind="function">
      <name>bytesAvailable</name>
      <anchor>bytesAvailable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>readBlock</name>
      <anchor>readBlock</anchor>
      <arglist>( char * data, Q_ULONG maxlen )</arglist>
    </member>
    <member kind="function">
      <name>readAll</name>
      <anchor>readAll</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>currentId</name>
      <anchor>currentId</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>currentDevice</name>
      <anchor>currentDevice</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>currentCommand</name>
      <anchor>currentCommand</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>hasPendingCommands</name>
      <anchor>hasPendingCommands</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>clearPendingCommands</name>
      <anchor>clearPendingCommands</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>state</name>
      <anchor>state</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>error</name>
      <anchor>error</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>errorString</name>
      <anchor>errorString</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>abort</name>
      <anchor>abort</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>stateChanged</name>
      <anchor>stateChanged</anchor>
      <arglist>( int state )</arglist>
    </member>
    <member kind="function">
      <name>listInfo</name>
      <anchor>listInfo</anchor>
      <arglist>( const QUrlInfo &amp; i )</arglist>
    </member>
    <member kind="function">
      <name>readyRead</name>
      <anchor>readyRead</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>dataTransferProgress</name>
      <anchor>dataTransferProgress</anchor>
      <arglist>( int done, int total )</arglist>
    </member>
    <member kind="function">
      <name>rawCommandReply</name>
      <anchor>rawCommandReply</anchor>
      <arglist>( int replyCode, const QString &amp; detail )</arglist>
    </member>
    <member kind="function">
      <name>commandStarted</name>
      <anchor>commandStarted</anchor>
      <arglist>( int id )</arglist>
    </member>
    <member kind="function">
      <name>commandFinished</name>
      <anchor>commandFinished</anchor>
      <arglist>( int id, bool error )</arglist>
    </member>
    <member kind="function">
      <name>done</name>
      <anchor>done</anchor>
      <arglist>( bool error )</arglist>
    </member>
    <member kind="function">
      <name>connectToHost</name>
      <anchor>connectToHost</anchor>
      <arglist>() is being executed.</arglist>
    </member>
    <member kind="function">
      <name>login</name>
      <anchor>login</anchor>
      <arglist>() is being executed.</arglist>
    </member>
    <member kind="function">
      <name>close</name>
      <anchor>close</anchor>
      <arglist>() is being executed.</arglist>
    </member>
    <member kind="function">
      <name>cd</name>
      <anchor>cd</anchor>
      <arglist>() is being executed.</arglist>
    </member>
    <member kind="function">
      <name>get</name>
      <anchor>get</anchor>
      <arglist>() is being executed.</arglist>
    </member>
    <member kind="function">
      <name>put</name>
      <anchor>put</anchor>
      <arglist>() is being executed.</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>() is being executed.</arglist>
    </member>
    <member kind="function">
      <name>mkdir</name>
      <anchor>mkdir</anchor>
      <arglist>() is being executed.</arglist>
    </member>
    <member kind="function">
      <name>rmdir</name>
      <anchor>rmdir</anchor>
      <arglist>() is being executed.</arglist>
    </member>
    <member kind="function">
      <name>rename</name>
      <anchor>rename</anchor>
      <arglist>() is being executed.</arglist>
    </member>
    <member kind="function">
      <name>rawCommand</name>
      <anchor>rawCommand</anchor>
      <arglist>() is being executed.</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QGb18030Codec</name>
    <filename>qgb18030codec.html</filename>
  </compound>
  <compound kind="class">
    <name>QGb2312Codec</name>
    <filename>qgb2312codec.html</filename>
    <member kind="function">
      <name>QGb2312Codec</name>
      <anchor>QGb2312Codec</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QGbkCodec</name>
    <filename>qgbkcodec.html</filename>
    <member kind="function">
      <name>QGbkCodec</name>
      <anchor>QGbkCodec</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QGfxDriverFactory</name>
    <filename>qgfxdriverfactory.html</filename>
    <member kind="function">
      <name>keys</name>
      <anchor>keys</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>create</name>
      <anchor>create</anchor>
      <arglist>( const QString &amp; key, int displayId )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QGfxDriverPlugin</name>
    <filename>qgfxdriverplugin.html</filename>
    <member kind="function">
      <name>QGfxDriverPlugin</name>
      <anchor>QGfxDriverPlugin</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QGfxDriverPlugin</name>
      <anchor>QGfxDriverPlugin</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>keys</name>
      <anchor>keys</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>create</name>
      <anchor>create</anchor>
      <arglist>( const QString &amp; driver, int displayId ) = 0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QGL</name>
    <filename>qgl.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>FormatOption</anchor>
      <arglist>{ DoubleBuffer = 0x0001, DepthBuffer = 0x0002, Rgba = 0x0004, AlphaChannel = 0x0008, AccumBuffer = 0x0010, StencilBuffer = 0x0020, StereoBuffers = 0x0040, DirectRendering = 0x0080, HasOverlay = 0x0100, SingleBuffer = DoubleBuffer&lt;&lt;16, NoDepthBuffer = DepthBuffer&lt;&lt;16, ColorIndex = Rgba&lt;&lt;16, NoAlphaChannel = AlphaChannel&lt;&lt;16, NoAccumBuffer = AccumBuffer&lt;&lt;16, NoStencilBuffer = StencilBuffer&lt;&lt;16, NoStereoBuffers = StereoBuffers&lt;&lt;16, IndirectRendering = DirectRendering&lt;&lt;16, NoOverlay = HasOverlay&lt;&lt;16 }</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QGLayoutIterator</name>
    <filename>qglayoutiterator.html</filename>
    <member kind="function">
      <name>QGLayoutIterator</name>
      <anchor>QGLayoutIterator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>next</name>
      <anchor>next</anchor>
      <arglist>() = 0</arglist>
    </member>
    <member kind="function">
      <name>current</name>
      <anchor>current</anchor>
      <arglist>() = 0</arglist>
    </member>
    <member kind="function">
      <name>takeCurrent</name>
      <anchor>takeCurrent</anchor>
      <arglist>() = 0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QGLColormap</name>
    <filename>qglcolormap.html</filename>
    <member kind="function">
      <name>QGLColormap</name>
      <anchor>QGLColormap</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QGLColormap</name>
      <anchor>QGLColormap</anchor>
      <arglist>( const QGLColormap &amp; map )</arglist>
    </member>
    <member kind="function">
      <name>QGLColormap</name>
      <anchor>QGLColormap</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QGLColormap &amp; map )</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>detach</name>
      <anchor>detach</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setEntries</name>
      <anchor>setEntries</anchor>
      <arglist>( int count, const QRgb * colors, int base = 0 )</arglist>
    </member>
    <member kind="function">
      <name>setEntry</name>
      <anchor>setEntry</anchor>
      <arglist>( int idx, QRgb color )</arglist>
    </member>
    <member kind="function">
      <name>setEntry</name>
      <anchor>setEntry</anchor>
      <arglist>( int idx, const QColor &amp; color )</arglist>
    </member>
    <member kind="function">
      <name>entryRgb</name>
      <anchor>entryRgb</anchor>
      <arglist>( int idx ) const</arglist>
    </member>
    <member kind="function">
      <name>entryColor</name>
      <anchor>entryColor</anchor>
      <arglist>( int idx ) const</arglist>
    </member>
    <member kind="function">
      <name>find</name>
      <anchor>find</anchor>
      <arglist>( QRgb color ) const</arglist>
    </member>
    <member kind="function">
      <name>findNearest</name>
      <anchor>findNearest</anchor>
      <arglist>( QRgb color ) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QGLContext</name>
    <filename>qglcontext.html</filename>
    <member kind="function">
      <name>QGLContext</name>
      <anchor>QGLContext</anchor>
      <arglist>( const QGLFormat &amp; format, QPaintDevice * device )</arglist>
    </member>
    <member kind="function">
      <name>QGLContext</name>
      <anchor>QGLContext</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>create</name>
      <anchor>create</anchor>
      <arglist>( const QGLContext * shareContext = 0 )</arglist>
    </member>
    <member kind="function">
      <name>isValid</name>
      <anchor>isValid</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isSharing</name>
      <anchor>isSharing</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>reset</name>
      <anchor>reset</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>format</name>
      <anchor>format</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>requestedFormat</name>
      <anchor>requestedFormat</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setFormat</name>
      <anchor>setFormat</anchor>
      <arglist>( const QGLFormat &amp; format )</arglist>
    </member>
    <member kind="function">
      <name>makeCurrent</name>
      <anchor>makeCurrent</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>swapBuffers</name>
      <anchor>swapBuffers</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>device</name>
      <anchor>device</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>overlayTransparentColor</name>
      <anchor>overlayTransparentColor</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>currentContext</name>
      <anchor>currentContext</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>chooseContext</name>
      <anchor>chooseContext</anchor>
      <arglist>( const QGLContext * shareContext = 0 )</arglist>
    </member>
    <member kind="function">
      <name>doneCurrent</name>
      <anchor>doneCurrent</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>choosePixelFormat</name>
      <anchor>choosePixelFormat</anchor>
      <arglist>( void * dummyPfd, HDC pdc )</arglist>
    </member>
    <member kind="function">
      <name>chooseVisual</name>
      <anchor>chooseVisual</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>chooseMacVisual</name>
      <anchor>chooseMacVisual</anchor>
      <arglist>( GDHandle device )</arglist>
    </member>
    <member kind="function">
      <name>deviceIsPixmap</name>
      <anchor>deviceIsPixmap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>windowCreated</name>
      <anchor>windowCreated</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setWindowCreated</name>
      <anchor>setWindowCreated</anchor>
      <arglist>( bool on )</arglist>
    </member>
    <member kind="function">
      <name>initialized</name>
      <anchor>initialized</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setInitialized</name>
      <anchor>setInitialized</anchor>
      <arglist>( bool on )</arglist>
    </member>
    <member kind="function">
      <name>generateFontDisplayLists</name>
      <anchor>generateFontDisplayLists</anchor>
      <arglist>( const QFont &amp; font, int listBase )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QGLFormat</name>
    <filename>qglformat.html</filename>
    <member kind="function">
      <name>QGLFormat</name>
      <anchor>QGLFormat</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QGLFormat</name>
      <anchor>QGLFormat</anchor>
      <arglist>( int options, int plane = 0 )</arglist>
    </member>
    <member kind="function">
      <name>doubleBuffer</name>
      <anchor>doubleBuffer</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setDoubleBuffer</name>
      <anchor>setDoubleBuffer</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>depth</name>
      <anchor>depth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setDepth</name>
      <anchor>setDepth</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>rgba</name>
      <anchor>rgba</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setRgba</name>
      <anchor>setRgba</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>alpha</name>
      <anchor>alpha</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAlpha</name>
      <anchor>setAlpha</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>accum</name>
      <anchor>accum</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAccum</name>
      <anchor>setAccum</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>stencil</name>
      <anchor>stencil</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setStencil</name>
      <anchor>setStencil</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>stereo</name>
      <anchor>stereo</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setStereo</name>
      <anchor>setStereo</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>directRendering</name>
      <anchor>directRendering</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setDirectRendering</name>
      <anchor>setDirectRendering</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>hasOverlay</name>
      <anchor>hasOverlay</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setOverlay</name>
      <anchor>setOverlay</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>plane</name>
      <anchor>plane</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPlane</name>
      <anchor>setPlane</anchor>
      <arglist>( int plane )</arglist>
    </member>
    <member kind="function">
      <name>setOption</name>
      <anchor>setOption</anchor>
      <arglist>( FormatOption opt )</arglist>
    </member>
    <member kind="function">
      <name>testOption</name>
      <anchor>testOption</anchor>
      <arglist>( FormatOption opt ) const</arglist>
    </member>
    <member kind="function">
      <name>defaultFormat</name>
      <anchor>defaultFormat</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setDefaultFormat</name>
      <anchor>setDefaultFormat</anchor>
      <arglist>( const QGLFormat &amp; f )</arglist>
    </member>
    <member kind="function">
      <name>defaultOverlayFormat</name>
      <anchor>defaultOverlayFormat</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setDefaultOverlayFormat</name>
      <anchor>setDefaultOverlayFormat</anchor>
      <arglist>( const QGLFormat &amp; f )</arglist>
    </member>
    <member kind="function">
      <name>hasOpenGL</name>
      <anchor>hasOpenGL</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>hasOpenGLOverlays</name>
      <anchor>hasOpenGLOverlays</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>Double</name>
      <anchor>setDoubleBuffer</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>Depth</name>
      <anchor>setDepth</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>RGBA</name>
      <anchor>setRgba</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>Alpha</name>
      <anchor>setAlpha</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>Accumulation</name>
      <anchor>setAccum</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>Stencil</name>
      <anchor>setStencil</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>Stereo</name>
      <anchor>setStereo</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>Direct</name>
      <anchor>setDirectRendering</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>Presence</name>
      <anchor>setOverlay</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>The</name>
      <anchor>setPlane</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>Double</name>
      <anchor>setDoubleBuffer</anchor>
      <arglist>Enabled.</arglist>
    </member>
    <member kind="function">
      <name>Depth</name>
      <anchor>setDepth</anchor>
      <arglist>Enabled.</arglist>
    </member>
    <member kind="function">
      <name>RGBA</name>
      <anchor>setRgba</anchor>
      <arglist>Enabled (i.e., color index disabled).</arglist>
    </member>
    <member kind="function">
      <name>Alpha</name>
      <anchor>setAlpha</anchor>
      <arglist>Disabled.</arglist>
    </member>
    <member kind="function">
      <name>Accumulator</name>
      <anchor>setAccum</anchor>
      <arglist>Disabled.</arglist>
    </member>
    <member kind="function">
      <name>Stencil</name>
      <anchor>setStencil</anchor>
      <arglist>Disabled.</arglist>
    </member>
    <member kind="function">
      <name>Stereo</name>
      <anchor>setStereo</anchor>
      <arglist>Disabled.</arglist>
    </member>
    <member kind="function">
      <name>Direct</name>
      <anchor>setDirectRendering</anchor>
      <arglist>Enabled.</arglist>
    </member>
    <member kind="function">
      <name>Overlay</name>
      <anchor>setOverlay</anchor>
      <arglist>Disabled.</arglist>
    </member>
    <member kind="function">
      <name>Plane</name>
      <anchor>setPlane</anchor>
      <arglist>0 (i.e., normal plane).</arglist>
    </member>
    <member kind="function">
      <name>Double</name>
      <anchor>setDoubleBuffer</anchor>
      <arglist>Disabled.</arglist>
    </member>
    <member kind="function">
      <name>Depth</name>
      <anchor>setDepth</anchor>
      <arglist>Disabled.</arglist>
    </member>
    <member kind="function">
      <name>RGBA</name>
      <anchor>setRgba</anchor>
      <arglist>Disabled (i.e., color index enabled).</arglist>
    </member>
    <member kind="function">
      <name>Alpha</name>
      <anchor>setAlpha</anchor>
      <arglist>Disabled.</arglist>
    </member>
    <member kind="function">
      <name>Accumulator</name>
      <anchor>setAccum</anchor>
      <arglist>Disabled.</arglist>
    </member>
    <member kind="function">
      <name>Stencil</name>
      <anchor>setStencil</anchor>
      <arglist>Disabled.</arglist>
    </member>
    <member kind="function">
      <name>Stereo</name>
      <anchor>setStereo</anchor>
      <arglist>Disabled.</arglist>
    </member>
    <member kind="function">
      <name>Direct</name>
      <anchor>setDirectRendering</anchor>
      <arglist>Enabled.</arglist>
    </member>
    <member kind="function">
      <name>Overlay</name>
      <anchor>setOverlay</anchor>
      <arglist>Disabled.</arglist>
    </member>
    <member kind="function">
      <name>Plane</name>
      <anchor>setPlane</anchor>
      <arglist>1 (i.e., first overlay plane).</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QGLWidget</name>
    <filename>qglwidget.html</filename>
    <member kind="function">
      <name>QGLWidget</name>
      <anchor>QGLWidget</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0, const QGLWidget * shareWidget = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QGLWidget</name>
      <anchor>QGLWidget</anchor>
      <arglist>( QGLContext * context, QWidget * parent, const char * name = 0, const QGLWidget * shareWidget = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QGLWidget</name>
      <anchor>QGLWidget</anchor>
      <arglist>( const QGLFormat &amp; format, QWidget * parent = 0, const char * name = 0, const QGLWidget * shareWidget = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QGLWidget</name>
      <anchor>QGLWidget</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>qglColor</name>
      <anchor>qglColor</anchor>
      <arglist>( const QColor &amp; c ) const</arglist>
    </member>
    <member kind="function">
      <name>qglClearColor</name>
      <anchor>qglClearColor</anchor>
      <arglist>( const QColor &amp; c ) const</arglist>
    </member>
    <member kind="function">
      <name>isValid</name>
      <anchor>isValid</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isSharing</name>
      <anchor>isSharing</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>makeCurrent</name>
      <anchor>makeCurrent</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>doneCurrent</name>
      <anchor>doneCurrent</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>doubleBuffer</name>
      <anchor>doubleBuffer</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>swapBuffers</name>
      <anchor>swapBuffers</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>format</name>
      <anchor>format</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>context</name>
      <anchor>context</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>renderPixmap</name>
      <anchor>renderPixmap</anchor>
      <arglist>( int w = 0, int h = 0, bool useContext = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>grabFrameBuffer</name>
      <anchor>grabFrameBuffer</anchor>
      <arglist>( bool withAlpha = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>makeOverlayCurrent</name>
      <anchor>makeOverlayCurrent</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>overlayContext</name>
      <anchor>overlayContext</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>colormap</name>
      <anchor>colormap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setColormap</name>
      <anchor>setColormap</anchor>
      <arglist>( const QGLColormap &amp; cmap )</arglist>
    </member>
    <member kind="function">
      <name>renderText</name>
      <anchor>renderText</anchor>
      <arglist>( int x, int y, const QString &amp; str, const QFont &amp; fnt = QFont ( ), int listBase = 2000 )</arglist>
    </member>
    <member kind="function">
      <name>renderText</name>
      <anchor>renderText</anchor>
      <arglist>( double x, double y, double z, const QString &amp; str, const QFont &amp; fnt = QFont ( ), int listBase = 2000 )</arglist>
    </member>
    <member kind="function">
      <name>updateGL</name>
      <anchor>updateGL</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>updateOverlayGL</name>
      <anchor>updateOverlayGL</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>convertToGLFormat</name>
      <anchor>convertToGLFormat</anchor>
      <arglist>( const QImage &amp; img )</arglist>
    </member>
    <member kind="function">
      <name>initializeGL</name>
      <anchor>initializeGL</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>resizeGL</name>
      <anchor>resizeGL</anchor>
      <arglist>( int width, int height )</arglist>
    </member>
    <member kind="function">
      <name>paintGL</name>
      <anchor>paintGL</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>initializeOverlayGL</name>
      <anchor>initializeOverlayGL</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>resizeOverlayGL</name>
      <anchor>resizeOverlayGL</anchor>
      <arglist>( int width, int height )</arglist>
    </member>
    <member kind="function">
      <name>paintOverlayGL</name>
      <anchor>paintOverlayGL</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setAutoBufferSwap</name>
      <anchor>setAutoBufferSwap</anchor>
      <arglist>( bool on )</arglist>
    </member>
    <member kind="function">
      <name>autoBufferSwap</name>
      <anchor>autoBufferSwap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>paintEvent</name>
      <anchor>paintEvent</anchor>
      <arglist>( QPaintEvent * )</arglist>
    </member>
    <member kind="function">
      <name>resizeEvent</name>
      <anchor>resizeEvent</anchor>
      <arglist>( QResizeEvent * )</arglist>
    </member>
    <member kind="function">
      <name>glInit</name>
      <anchor>glInit</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>glDraw</name>
      <anchor>glDraw</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>paintGL</name>
      <anchor>paintGL</anchor>
      <arglist>() - Renders the OpenGL scene. Gets called whenever the widget</arglist>
    </member>
    <member kind="function">
      <name>resizeGL</name>
      <anchor>resizeGL</anchor>
      <arglist>() - Sets up the OpenGL viewport, projection, etc. Gets</arglist>
    </member>
    <member kind="function">
      <name>initializeGL</name>
      <anchor>initializeGL</anchor>
      <arglist>() - Sets up the OpenGL rendering context, defines display</arglist>
    </member>
    <member kind="function">
      <name>paintOverlayGL</name>
      <anchor>paintOverlayGL</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>resizeOverlayGL</name>
      <anchor>resizeOverlayGL</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>initializeOverlayGL</name>
      <anchor>initializeOverlayGL</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QGrid</name>
    <filename>qgrid.html</filename>
    <member kind="function">
      <name>QGrid</name>
      <anchor>QGrid</anchor>
      <arglist>( int n, QWidget * parent = 0, const char * name = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QGrid</name>
      <anchor>QGrid</anchor>
      <arglist>( int n, Orientation orient, QWidget * parent = 0, const char * name = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>setSpacing</name>
      <anchor>setSpacing</anchor>
      <arglist>( int space )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QGridLayout</name>
    <filename>qgridlayout.html</filename>
    <member kind="function">
      <name>QGridLayout</name>
      <anchor>QGridLayout</anchor>
      <arglist>( QWidget * parent, int nRows = 1, int nCols = 1, int margin = 0, int space = -1, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QGridLayout</name>
      <anchor>QGridLayout</anchor>
      <arglist>( int nRows = 1, int nCols = 1, int spacing = -1, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QGridLayout</name>
      <anchor>QGridLayout</anchor>
      <arglist>( QLayout * parentLayout, int nRows = 1, int nCols = 1, int spacing = -1, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QGridLayout</name>
      <anchor>QGridLayout</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>sizeHint</name>
      <anchor>sizeHint</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>minimumSize</name>
      <anchor>minimumSize</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>maximumSize</name>
      <anchor>maximumSize</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setRowStretch</name>
      <anchor>setRowStretch</anchor>
      <arglist>( int row, int stretch )</arglist>
    </member>
    <member kind="function">
      <name>setColStretch</name>
      <anchor>setColStretch</anchor>
      <arglist>( int col, int stretch )</arglist>
    </member>
    <member kind="function">
      <name>rowStretch</name>
      <anchor>rowStretch</anchor>
      <arglist>( int row ) const</arglist>
    </member>
    <member kind="function">
      <name>colStretch</name>
      <anchor>colStretch</anchor>
      <arglist>( int col ) const</arglist>
    </member>
    <member kind="function">
      <name>setRowSpacing</name>
      <anchor>setRowSpacing</anchor>
      <arglist>( int row, int minSize )</arglist>
    </member>
    <member kind="function">
      <name>setColSpacing</name>
      <anchor>setColSpacing</anchor>
      <arglist>( int col, int minSize )</arglist>
    </member>
    <member kind="function">
      <name>rowSpacing</name>
      <anchor>rowSpacing</anchor>
      <arglist>( int row ) const</arglist>
    </member>
    <member kind="function">
      <name>colSpacing</name>
      <anchor>colSpacing</anchor>
      <arglist>( int col ) const</arglist>
    </member>
    <member kind="function">
      <name>numRows</name>
      <anchor>numRows</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>numCols</name>
      <anchor>numCols</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>cellGeometry</name>
      <anchor>cellGeometry</anchor>
      <arglist>( int row, int col ) const</arglist>
    </member>
    <member kind="function">
      <name>hasHeightForWidth</name>
      <anchor>hasHeightForWidth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>heightForWidth</name>
      <anchor>heightForWidth</anchor>
      <arglist>( int w ) const</arglist>
    </member>
    <member kind="function">
      <name>expanding</name>
      <anchor>expanding</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>invalidate</name>
      <anchor>invalidate</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>addItem</name>
      <anchor>addItem</anchor>
      <arglist>( QLayoutItem * item )</arglist>
    </member>
    <member kind="function">
      <name>addItem</name>
      <anchor>addItem</anchor>
      <arglist>( QLayoutItem * item, int row, int col )</arglist>
    </member>
    <member kind="function">
      <name>addMultiCell</name>
      <anchor>addMultiCell</anchor>
      <arglist>( QLayoutItem * item, int fromRow, int toRow, int fromCol, int toCol, int alignment = 0 )</arglist>
    </member>
    <member kind="function">
      <name>addWidget</name>
      <anchor>addWidget</anchor>
      <arglist>( QWidget * w, int row, int col, int alignment = 0 )</arglist>
    </member>
    <member kind="function">
      <name>addMultiCellWidget</name>
      <anchor>addMultiCellWidget</anchor>
      <arglist>( QWidget * w, int fromRow, int toRow, int fromCol, int toCol, int alignment = 0 )</arglist>
    </member>
    <member kind="function">
      <name>addLayout</name>
      <anchor>addLayout</anchor>
      <arglist>( QLayout * layout, int row, int col )</arglist>
    </member>
    <member kind="function">
      <name>addMultiCellLayout</name>
      <anchor>addMultiCellLayout</anchor>
      <arglist>( QLayout * layout, int fromRow, int toRow, int fromCol, int toCol, int alignment = 0 )</arglist>
    </member>
    <member kind="function">
      <name>expand</name>
      <anchor>expand</anchor>
      <arglist>( int nRows, int nCols )</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Corner</anchor>
      <arglist>{ TopLeft, TopRight, BottomLeft, BottomRight }</arglist>
    </member>
    <member kind="function">
      <name>setOrigin</name>
      <anchor>setOrigin</anchor>
      <arglist>( Corner c )</arglist>
    </member>
    <member kind="function">
      <name>origin</name>
      <anchor>origin</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setGeometry</name>
      <anchor>setGeometry</anchor>
      <arglist>( const QRect &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>findWidget</name>
      <anchor>findWidget</anchor>
      <arglist>( QWidget * w, int * row, int * col )</arglist>
    </member>
    <member kind="function">
      <name>add</name>
      <anchor>add</anchor>
      <arglist>( QLayoutItem * item, int row, int col )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QGridView</name>
    <filename>qgridview.html</filename>
    <member kind="function">
      <name>QGridView</name>
      <anchor>QGridView</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QGridView</name>
      <anchor>QGridView</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>numRows</name>
      <anchor>numRows</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setNumRows</name>
      <anchor>setNumRows</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>numCols</name>
      <anchor>numCols</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setNumCols</name>
      <anchor>setNumCols</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>cellWidth</name>
      <anchor>cellWidth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setCellWidth</name>
      <anchor>setCellWidth</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>cellHeight</name>
      <anchor>cellHeight</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setCellHeight</name>
      <anchor>setCellHeight</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>cellRect</name>
      <anchor>cellRect</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>cellGeometry</name>
      <anchor>cellGeometry</anchor>
      <arglist>( int row, int column )</arglist>
    </member>
    <member kind="function">
      <name>gridSize</name>
      <anchor>gridSize</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rowAt</name>
      <anchor>rowAt</anchor>
      <arglist>( int y ) const</arglist>
    </member>
    <member kind="function">
      <name>columnAt</name>
      <anchor>columnAt</anchor>
      <arglist>( int x ) const</arglist>
    </member>
    <member kind="function">
      <name>repaintCell</name>
      <anchor>repaintCell</anchor>
      <arglist>( int row, int column, bool erase = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>updateCell</name>
      <anchor>updateCell</anchor>
      <arglist>( int row, int column )</arglist>
    </member>
    <member kind="function">
      <name>ensureCellVisible</name>
      <anchor>ensureCellVisible</anchor>
      <arglist>( int row, int column )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>cellHeight</anchor>
      <arglist>- the height of a grid row</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>cellWidth</anchor>
      <arglist>- the width of a grid column</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>numCols</anchor>
      <arglist>- the number of columns in the grid</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>numRows</anchor>
      <arglist>- the number of rows in the grid</arglist>
    </member>
    <member kind="function">
      <name>paintCell</name>
      <anchor>paintCell</anchor>
      <arglist>( QPainter * p, int row, int col ) = 0</arglist>
    </member>
    <member kind="function">
      <name>paintEmptyArea</name>
      <anchor>paintEmptyArea</anchor>
      <arglist>( QPainter * p, int cx, int cy, int cw, int ch )</arglist>
    </member>
    <member kind="function">
      <name>dimensionChange</name>
      <anchor>dimensionChange</anchor>
      <arglist>( int oldNumRows, int oldNumCols )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QGroupBox</name>
    <filename>qgroupbox.html</filename>
    <member kind="function">
      <name>QGroupBox</name>
      <anchor>QGroupBox</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QGroupBox</name>
      <anchor>QGroupBox</anchor>
      <arglist>( const QString &amp; title, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QGroupBox</name>
      <anchor>QGroupBox</anchor>
      <arglist>( int strips, Orientation orientation, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QGroupBox</name>
      <anchor>QGroupBox</anchor>
      <arglist>( int strips, Orientation orientation, const QString &amp; title, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QGroupBox</name>
      <anchor>QGroupBox</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setColumnLayout</name>
      <anchor>setColumnLayout</anchor>
      <arglist>( int strips, Orientation direction )</arglist>
    </member>
    <member kind="function">
      <name>title</name>
      <anchor>title</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setTitle</name>
      <anchor>setTitle</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>alignment</name>
      <anchor>alignment</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAlignment</name>
      <anchor>setAlignment</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>columns</name>
      <anchor>columns</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setColumns</name>
      <anchor>setColumns</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>orientation</name>
      <anchor>orientation</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setOrientation</name>
      <anchor>setOrientation</anchor>
      <arglist>( Orientation )</arglist>
    </member>
    <member kind="function">
      <name>insideMargin</name>
      <anchor>insideMargin</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>insideSpacing</name>
      <anchor>insideSpacing</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setInsideMargin</name>
      <anchor>setInsideMargin</anchor>
      <arglist>( int m )</arglist>
    </member>
    <member kind="function">
      <name>setInsideSpacing</name>
      <anchor>setInsideSpacing</anchor>
      <arglist>( int s )</arglist>
    </member>
    <member kind="function">
      <name>addSpace</name>
      <anchor>addSpace</anchor>
      <arglist>( int size )</arglist>
    </member>
    <member kind="function">
      <name>isFlat</name>
      <anchor>isFlat</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setFlat</name>
      <anchor>setFlat</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>isCheckable</name>
      <anchor>isCheckable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setCheckable</name>
      <anchor>setCheckable</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>isChecked</name>
      <anchor>isChecked</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setChecked</name>
      <anchor>setChecked</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>toggled</name>
      <anchor>toggled</anchor>
      <arglist>( bool on )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>alignment</anchor>
      <arglist>- the alignment of the group box title</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>checkable</anchor>
      <arglist>- whether the group box has a checkbox in its title</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>checked</anchor>
      <arglist>- whether the group box&apos;s checkbox is checked</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>columns</anchor>
      <arglist>- the number of columns or rows (depending on \l QGroupBox::orientation) in the group box</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>flat</anchor>
      <arglist>- whether the group box is painted flat or has a frame around it</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>orientation</anchor>
      <arglist>- the current orientation of the group box</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>title</anchor>
      <arglist>- the group box title text</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>AlignmentFlags</anchor>
      <arglist>aligns the title accroding to the language, usually left.</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>AlignmentFlags</anchor>
      <arglist>aligns the title text to the left.</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>AlignmentFlags</anchor>
      <arglist>aligns the title text to the right.</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>AlignmentFlags</anchor>
      <arglist>aligns the title text centered.</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QGuardedPtr</name>
    <filename>qguardedptr.html</filename>
    <member kind="function">
      <name>QGuardedPtr</name>
      <anchor>QGuardedPtr</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QGuardedPtr</name>
      <anchor>QGuardedPtr</anchor>
      <arglist>( T * p )</arglist>
    </member>
    <member kind="function">
      <name>QGuardedPtr</name>
      <anchor>QGuardedPtr</anchor>
      <arglist>( const QGuardedPtr&lt;T&gt; &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>QGuardedPtr</name>
      <anchor>QGuardedPtr</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QGuardedPtr&lt;T&gt; &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( T * p )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QGuardedPtr&lt;T&gt; &amp; p ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QGuardedPtr&lt;T&gt; &amp; p ) const</arglist>
    </member>
    <member kind="function">
      <name>isNull</name>
      <anchor>isNull</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>operator*</name>
      <anchor>operator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>T</name>
      <anchor>operator</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QHBox</name>
    <filename>qhbox.html</filename>
    <member kind="function">
      <name>QHBox</name>
      <anchor>QHBox</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>setSpacing</name>
      <anchor>setSpacing</anchor>
      <arglist>( int space )</arglist>
    </member>
    <member kind="function">
      <name>setStretchFactor</name>
      <anchor>setStretchFactor</anchor>
      <arglist>( QWidget * w, int stretch )</arglist>
    </member>
    <member kind="function">
      <name>QHBox</name>
      <anchor>QHBox</anchor>
      <arglist>( bool horizontal, QWidget * parent, const char * name, WFlags f = 0 )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QHBoxLayout</name>
    <filename>qhboxlayout.html</filename>
    <member kind="function">
      <name>QHBoxLayout</name>
      <anchor>QHBoxLayout</anchor>
      <arglist>( QWidget * parent, int margin = 0, int spacing = -1, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QHBoxLayout</name>
      <anchor>QHBoxLayout</anchor>
      <arglist>( QLayout * parentLayout, int spacing = -1, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QHBoxLayout</name>
      <anchor>QHBoxLayout</anchor>
      <arglist>( int spacing = -1, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QHBoxLayout</name>
      <anchor>QHBoxLayout</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QHButtonGroup</name>
    <filename>qhbuttongroup.html</filename>
    <member kind="function">
      <name>QHButtonGroup</name>
      <anchor>QHButtonGroup</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QHButtonGroup</name>
      <anchor>QHButtonGroup</anchor>
      <arglist>( const QString &amp; title, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QHButtonGroup</name>
      <anchor>QHButtonGroup</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QHeader</name>
    <filename>qheader.html</filename>
    <member kind="function">
      <name>QHeader</name>
      <anchor>QHeader</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QHeader</name>
      <anchor>QHeader</anchor>
      <arglist>( int n, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QHeader</name>
      <anchor>QHeader</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>addLabel</name>
      <anchor>addLabel</anchor>
      <arglist>( const QString &amp; s, int size = -1 )</arglist>
    </member>
    <member kind="function">
      <name>addLabel</name>
      <anchor>addLabel</anchor>
      <arglist>( const QIconSet &amp; iconset, const QString &amp; s, int size = -1 )</arglist>
    </member>
    <member kind="function">
      <name>removeLabel</name>
      <anchor>removeLabel</anchor>
      <arglist>( int section )</arglist>
    </member>
    <member kind="function">
      <name>setLabel</name>
      <anchor>setLabel</anchor>
      <arglist>( int section, const QString &amp; s, int size = -1 )</arglist>
    </member>
    <member kind="function">
      <name>setLabel</name>
      <anchor>setLabel</anchor>
      <arglist>( int section, const QIconSet &amp; iconset, const QString &amp; s, int size = -1 )</arglist>
    </member>
    <member kind="function">
      <name>label</name>
      <anchor>label</anchor>
      <arglist>( int section ) const</arglist>
    </member>
    <member kind="function">
      <name>iconSet</name>
      <anchor>iconSet</anchor>
      <arglist>( int section ) const</arglist>
    </member>
    <member kind="function">
      <name>setOrientation</name>
      <anchor>setOrientation</anchor>
      <arglist>( Orientation )</arglist>
    </member>
    <member kind="function">
      <name>orientation</name>
      <anchor>orientation</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setTracking</name>
      <anchor>setTracking</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>tracking</name>
      <anchor>tracking</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setClickEnabled</name>
      <anchor>setClickEnabled</anchor>
      <arglist>( bool enable, int section = -1 )</arglist>
    </member>
    <member kind="function">
      <name>setResizeEnabled</name>
      <anchor>setResizeEnabled</anchor>
      <arglist>( bool enable, int section = -1 )</arglist>
    </member>
    <member kind="function">
      <name>setMovingEnabled</name>
      <anchor>setMovingEnabled</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>setStretchEnabled</name>
      <anchor>setStretchEnabled</anchor>
      <arglist>( bool b, int section )</arglist>
    </member>
    <member kind="function">
      <name>setStretchEnabled</name>
      <anchor>setStretchEnabled</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>isClickEnabled</name>
      <anchor>isClickEnabled</anchor>
      <arglist>( int section = -1 ) const</arglist>
    </member>
    <member kind="function">
      <name>isResizeEnabled</name>
      <anchor>isResizeEnabled</anchor>
      <arglist>( int section = -1 ) const</arglist>
    </member>
    <member kind="function">
      <name>isMovingEnabled</name>
      <anchor>isMovingEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isStretchEnabled</name>
      <anchor>isStretchEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isStretchEnabled</name>
      <anchor>isStretchEnabled</anchor>
      <arglist>( int section ) const</arglist>
    </member>
    <member kind="function">
      <name>resizeSection</name>
      <anchor>resizeSection</anchor>
      <arglist>( int section, int s )</arglist>
    </member>
    <member kind="function">
      <name>sectionSize</name>
      <anchor>sectionSize</anchor>
      <arglist>( int section ) const</arglist>
    </member>
    <member kind="function">
      <name>sectionPos</name>
      <anchor>sectionPos</anchor>
      <arglist>( int section ) const</arglist>
    </member>
    <member kind="function">
      <name>sectionAt</name>
      <anchor>sectionAt</anchor>
      <arglist>( int pos ) const</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>headerWidth</name>
      <anchor>headerWidth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>sectionRect</name>
      <anchor>sectionRect</anchor>
      <arglist>( int section ) const</arglist>
    </member>
    <member kind="function">
      <name>offset</name>
      <anchor>offset</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>mapToSection</name>
      <anchor>mapToSection</anchor>
      <arglist>( int index ) const</arglist>
    </member>
    <member kind="function">
      <name>mapToIndex</name>
      <anchor>mapToIndex</anchor>
      <arglist>( int section ) const</arglist>
    </member>
    <member kind="function">
      <name>moveSection</name>
      <anchor>moveSection</anchor>
      <arglist>( int section, int toIndex )</arglist>
    </member>
    <member kind="function">
      <name>setSortIndicator</name>
      <anchor>setSortIndicator</anchor>
      <arglist>( int section, SortOrder order )</arglist>
    </member>
    <member kind="function">
      <name>sortIndicatorSection</name>
      <anchor>sortIndicatorSection</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>sortIndicatorOrder</name>
      <anchor>sortIndicatorOrder</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>adjustHeaderSize</name>
      <anchor>adjustHeaderSize</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setOffset</name>
      <anchor>setOffset</anchor>
      <arglist>( int pos )</arglist>
    </member>
    <member kind="function">
      <name>clicked</name>
      <anchor>clicked</anchor>
      <arglist>( int section )</arglist>
    </member>
    <member kind="function">
      <name>pressed</name>
      <anchor>pressed</anchor>
      <arglist>( int section )</arglist>
    </member>
    <member kind="function">
      <name>released</name>
      <anchor>released</anchor>
      <arglist>( int section )</arglist>
    </member>
    <member kind="function">
      <name>sizeChange</name>
      <anchor>sizeChange</anchor>
      <arglist>( int section, int oldSize, int newSize )</arglist>
    </member>
    <member kind="function">
      <name>indexChange</name>
      <anchor>indexChange</anchor>
      <arglist>( int section, int fromIndex, int toIndex )</arglist>
    </member>
    <member kind="function">
      <name>sectionHandleDoubleClicked</name>
      <anchor>sectionHandleDoubleClicked</anchor>
      <arglist>( int section )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>count</anchor>
      <arglist>- the number of sections in the header</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>moving</anchor>
      <arglist>- whether the header sections can be moved</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>offset</anchor>
      <arglist>- the header&apos;s left-most (or top-most) visible pixel</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>orientation</anchor>
      <arglist>- the header&apos;s orientation</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>stretching</anchor>
      <arglist>- whether the header sections always take up the full width (or height) of the header</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>tracking</anchor>
      <arglist>- whether the sizeChange() signal is emitted continuously</arglist>
    </member>
    <member kind="function">
      <name>sRect</name>
      <anchor>sRect</anchor>
      <arglist>( int index )</arglist>
    </member>
    <member kind="function">
      <name>paintSection</name>
      <anchor>paintSection</anchor>
      <arglist>( QPainter * p, int index, const QRect &amp; fr )</arglist>
    </member>
    <member kind="function">
      <name>paintSectionLabel</name>
      <anchor>paintSectionLabel</anchor>
      <arglist>( QPainter * p, int index, const QRect &amp; fr )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QHebrewCodec</name>
    <filename>qhebrewcodec.html</filename>
    <member kind="function">
      <name>mimeName</name>
      <anchor>mimeName</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>fromUnicode</name>
      <anchor>fromUnicode</anchor>
      <arglist>( const QString &amp; uc, int &amp; lenInOut ) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QHGroupBox</name>
    <filename>qhgroupbox.html</filename>
    <member kind="function">
      <name>QHGroupBox</name>
      <anchor>QHGroupBox</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QHGroupBox</name>
      <anchor>QHGroupBox</anchor>
      <arglist>( const QString &amp; title, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QHGroupBox</name>
      <anchor>QHGroupBox</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QHideEvent</name>
    <filename>qhideevent.html</filename>
    <member kind="function">
      <name>QHideEvent</name>
      <anchor>QHideEvent</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QHostAddress</name>
    <filename>qhostaddress.html</filename>
    <member kind="function">
      <name>QHostAddress</name>
      <anchor>QHostAddress</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QHostAddress</name>
      <anchor>QHostAddress</anchor>
      <arglist>( Q_UINT32 ip4Addr )</arglist>
    </member>
    <member kind="function">
      <name>QHostAddress</name>
      <anchor>QHostAddress</anchor>
      <arglist>( Q_UINT8 * ip6Addr )</arglist>
    </member>
    <member kind="function">
      <name>QHostAddress</name>
      <anchor>QHostAddress</anchor>
      <arglist>( const QHostAddress &amp; address )</arglist>
    </member>
    <member kind="function">
      <name>QHostAddress</name>
      <anchor>QHostAddress</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QHostAddress &amp; address )</arglist>
    </member>
    <member kind="function">
      <name>setAddress</name>
      <anchor>setAddress</anchor>
      <arglist>( Q_UINT32 ip4Addr )</arglist>
    </member>
    <member kind="function">
      <name>setAddress</name>
      <anchor>setAddress</anchor>
      <arglist>( Q_UINT8 * ip6Addr )</arglist>
    </member>
    <member kind="function">
      <name>setAddress</name>
      <anchor>setAddress</anchor>
      <arglist>( const QString &amp; address )</arglist>
    </member>
    <member kind="function">
      <name>isIp4Addr</name>
      <anchor>isIp4Addr</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>ip4Addr</name>
      <anchor>ip4Addr</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>toString</name>
      <anchor>toString</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QHostAddress &amp; other ) const</arglist>
    </member>
    <member kind="function">
      <name>isNull</name>
      <anchor>isNull</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QHttp</name>
    <filename>qhttp.html</filename>
    <member kind="function">
      <name>QHttp</name>
      <anchor>QHttp</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QHttp</name>
      <anchor>QHttp</anchor>
      <arglist>( QObject * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QHttp</name>
      <anchor>QHttp</anchor>
      <arglist>( const QString &amp; hostname, Q_UINT16 port = 80, QObject * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QHttp</name>
      <anchor>QHttp</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>State</anchor>
      <arglist>{ Unconnected, HostLookup, Connecting, Sending, Reading, Connected, Closing }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Error</anchor>
      <arglist>{ NoError, UnknownError, HostNotFound, ConnectionRefused, UnexpectedClose, InvalidResponseHeader, WrongContentLength, Aborted }</arglist>
    </member>
    <member kind="function">
      <name>setHost</name>
      <anchor>setHost</anchor>
      <arglist>( const QString &amp; hostname, Q_UINT16 port = 80 )</arglist>
    </member>
    <member kind="function">
      <name>get</name>
      <anchor>get</anchor>
      <arglist>( const QString &amp; path, QIODevice * to = 0 )</arglist>
    </member>
    <member kind="function">
      <name>post</name>
      <anchor>post</anchor>
      <arglist>( const QString &amp; path, QIODevice * data, QIODevice * to = 0 )</arglist>
    </member>
    <member kind="function">
      <name>post</name>
      <anchor>post</anchor>
      <arglist>( const QString &amp; path, const QByteArray &amp; data, QIODevice * to = 0 )</arglist>
    </member>
    <member kind="function">
      <name>head</name>
      <anchor>head</anchor>
      <arglist>( const QString &amp; path )</arglist>
    </member>
    <member kind="function">
      <name>request</name>
      <anchor>request</anchor>
      <arglist>( const QHttpRequestHeader &amp; header, QIODevice * data = 0, QIODevice * to = 0 )</arglist>
    </member>
    <member kind="function">
      <name>request</name>
      <anchor>request</anchor>
      <arglist>( const QHttpRequestHeader &amp; header, const QByteArray &amp; data, QIODevice * to = 0 )</arglist>
    </member>
    <member kind="function">
      <name>closeConnection</name>
      <anchor>closeConnection</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>bytesAvailable</name>
      <anchor>bytesAvailable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>readBlock</name>
      <anchor>readBlock</anchor>
      <arglist>( char * data, Q_ULONG maxlen )</arglist>
    </member>
    <member kind="function">
      <name>readAll</name>
      <anchor>readAll</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>currentId</name>
      <anchor>currentId</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>currentSourceDevice</name>
      <anchor>currentSourceDevice</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>currentDestinationDevice</name>
      <anchor>currentDestinationDevice</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>currentRequest</name>
      <anchor>currentRequest</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>hasPendingRequests</name>
      <anchor>hasPendingRequests</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>clearPendingRequests</name>
      <anchor>clearPendingRequests</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>state</name>
      <anchor>state</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>error</name>
      <anchor>error</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>errorString</name>
      <anchor>errorString</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>abort</name>
      <anchor>abort</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>stateChanged</name>
      <anchor>stateChanged</anchor>
      <arglist>( int state )</arglist>
    </member>
    <member kind="function">
      <name>responseHeaderReceived</name>
      <anchor>responseHeaderReceived</anchor>
      <arglist>( const QHttpResponseHeader &amp; resp )</arglist>
    </member>
    <member kind="function">
      <name>readyRead</name>
      <anchor>readyRead</anchor>
      <arglist>( const QHttpResponseHeader &amp; resp )</arglist>
    </member>
    <member kind="function">
      <name>dataSendProgress</name>
      <anchor>dataSendProgress</anchor>
      <arglist>( int done, int total )</arglist>
    </member>
    <member kind="function">
      <name>dataReadProgress</name>
      <anchor>dataReadProgress</anchor>
      <arglist>( int done, int total )</arglist>
    </member>
    <member kind="function">
      <name>requestStarted</name>
      <anchor>requestStarted</anchor>
      <arglist>( int id )</arglist>
    </member>
    <member kind="function">
      <name>requestFinished</name>
      <anchor>requestFinished</anchor>
      <arglist>( int id, bool error )</arglist>
    </member>
    <member kind="function">
      <name>done</name>
      <anchor>done</anchor>
      <arglist>( bool error )</arglist>
    </member>
    <member kind="function">
      <name>abort</name>
      <anchor>abort</anchor>
      <arglist>().</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QHttpHeader</name>
    <filename>qhttpheader.html</filename>
    <member kind="function">
      <name>QHttpHeader</name>
      <anchor>QHttpHeader</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QHttpHeader</name>
      <anchor>QHttpHeader</anchor>
      <arglist>( const QHttpHeader &amp; header )</arglist>
    </member>
    <member kind="function">
      <name>QHttpHeader</name>
      <anchor>QHttpHeader</anchor>
      <arglist>( const QString &amp; str )</arglist>
    </member>
    <member kind="function">
      <name>QHttpHeader</name>
      <anchor>QHttpHeader</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QHttpHeader &amp; h )</arglist>
    </member>
    <member kind="function">
      <name>value</name>
      <anchor>value</anchor>
      <arglist>( const QString &amp; key ) const</arglist>
    </member>
    <member kind="function">
      <name>setValue</name>
      <anchor>setValue</anchor>
      <arglist>( const QString &amp; key, const QString &amp; value )</arglist>
    </member>
    <member kind="function">
      <name>removeValue</name>
      <anchor>removeValue</anchor>
      <arglist>( const QString &amp; key )</arglist>
    </member>
    <member kind="function">
      <name>keys</name>
      <anchor>keys</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>hasKey</name>
      <anchor>hasKey</anchor>
      <arglist>( const QString &amp; key ) const</arglist>
    </member>
    <member kind="function">
      <name>hasContentLength</name>
      <anchor>hasContentLength</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>contentLength</name>
      <anchor>contentLength</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setContentLength</name>
      <anchor>setContentLength</anchor>
      <arglist>( int len )</arglist>
    </member>
    <member kind="function">
      <name>hasContentType</name>
      <anchor>hasContentType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>contentType</name>
      <anchor>contentType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setContentType</name>
      <anchor>setContentType</anchor>
      <arglist>( const QString &amp; type )</arglist>
    </member>
    <member kind="function">
      <name>toString</name>
      <anchor>toString</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isValid</name>
      <anchor>isValid</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>majorVersion</name>
      <anchor>majorVersion</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>minorVersion</name>
      <anchor>minorVersion</anchor>
      <arglist>() const = 0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QHttpRequestHeader</name>
    <filename>qhttprequestheader.html</filename>
    <member kind="function">
      <name>QHttpRequestHeader</name>
      <anchor>QHttpRequestHeader</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QHttpRequestHeader</name>
      <anchor>QHttpRequestHeader</anchor>
      <arglist>( const QString &amp; method, const QString &amp; path, int majorVer = 1, int minorVer = 1 )</arglist>
    </member>
    <member kind="function">
      <name>QHttpRequestHeader</name>
      <anchor>QHttpRequestHeader</anchor>
      <arglist>( const QHttpRequestHeader &amp; header )</arglist>
    </member>
    <member kind="function">
      <name>QHttpRequestHeader</name>
      <anchor>QHttpRequestHeader</anchor>
      <arglist>( const QString &amp; str )</arglist>
    </member>
    <member kind="function">
      <name>setRequest</name>
      <anchor>setRequest</anchor>
      <arglist>( const QString &amp; method, const QString &amp; path, int majorVer = 1, int minorVer = 1 )</arglist>
    </member>
    <member kind="function">
      <name>method</name>
      <anchor>method</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>path</name>
      <anchor>path</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>majorVersion</name>
      <anchor>majorVersion</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>minorVersion</name>
      <anchor>minorVersion</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>value</name>
      <anchor>value</anchor>
      <arglist>( const QString &amp; key ) const</arglist>
    </member>
    <member kind="function">
      <name>setValue</name>
      <anchor>setValue</anchor>
      <arglist>( const QString &amp; key, const QString &amp; value )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QHttpResponseHeader</name>
    <filename>qhttpresponseheader.html</filename>
    <member kind="function">
      <name>QHttpResponseHeader</name>
      <anchor>QHttpResponseHeader</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QHttpResponseHeader</name>
      <anchor>QHttpResponseHeader</anchor>
      <arglist>( const QHttpResponseHeader &amp; header )</arglist>
    </member>
    <member kind="function">
      <name>statusCode</name>
      <anchor>statusCode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>reasonPhrase</name>
      <anchor>reasonPhrase</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>majorVersion</name>
      <anchor>majorVersion</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>minorVersion</name>
      <anchor>minorVersion</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QIconDrag</name>
    <filename>qicondrag.html</filename>
    <member kind="function">
      <name>QIconDrag</name>
      <anchor>QIconDrag</anchor>
      <arglist>( QWidget * dragSource, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QIconDrag</name>
      <anchor>QIconDrag</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>append</name>
      <anchor>append</anchor>
      <arglist>( const QIconDragItem &amp; i, const QRect &amp; pr, const QRect &amp; tr )</arglist>
    </member>
    <member kind="function">
      <name>encodedData</name>
      <anchor>encodedData</anchor>
      <arglist>( const char * mime ) const</arglist>
    </member>
    <member kind="function">
      <name>canDecode</name>
      <anchor>canDecode</anchor>
      <arglist>( QMimeSource * e )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QIconDragItem</name>
    <filename>qicondragitem.html</filename>
    <member kind="function">
      <name>QIconDragItem</name>
      <anchor>QIconDragItem</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QIconDragItem</name>
      <anchor>QIconDragItem</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>data</name>
      <anchor>data</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setData</name>
      <anchor>setData</anchor>
      <arglist>( const QByteArray &amp; d )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QIconFactory</name>
    <filename>qiconfactory.html</filename>
    <member kind="function">
      <name>QIconFactory</name>
      <anchor>QIconFactory</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QIconFactory</name>
      <anchor>QIconFactory</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>createPixmap</name>
      <anchor>createPixmap</anchor>
      <arglist>( const QIconSet &amp; iconSet, QIconSet::Size size, QIconSet::Mode mode, QIconSet::State state )</arglist>
    </member>
    <member kind="function">
      <name>setAutoDelete</name>
      <anchor>setAutoDelete</anchor>
      <arglist>( bool autoDelete )</arglist>
    </member>
    <member kind="function">
      <name>autoDelete</name>
      <anchor>autoDelete</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>defaultFactory</name>
      <anchor>defaultFactory</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>installDefaultFactory</name>
      <anchor>installDefaultFactory</anchor>
      <arglist>( QIconFactory * factory )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QIconSet</name>
    <filename>qiconset.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>Size</anchor>
      <arglist>{ Automatic, Small, Large }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Mode</anchor>
      <arglist>{ Normal, Disabled, Active }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>State</anchor>
      <arglist>{ On, Off }</arglist>
    </member>
    <member kind="function">
      <name>QIconSet</name>
      <anchor>QIconSet</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QIconSet</name>
      <anchor>QIconSet</anchor>
      <arglist>( const QPixmap &amp; pixmap, Size size = Automatic )</arglist>
    </member>
    <member kind="function">
      <name>QIconSet</name>
      <anchor>QIconSet</anchor>
      <arglist>( const QPixmap &amp; smallPix, const QPixmap &amp; largePix )</arglist>
    </member>
    <member kind="function">
      <name>QIconSet</name>
      <anchor>QIconSet</anchor>
      <arglist>( const QIconSet &amp; other )</arglist>
    </member>
    <member kind="function">
      <name>QIconSet</name>
      <anchor>QIconSet</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>reset</name>
      <anchor>reset</anchor>
      <arglist>( const QPixmap &amp; pixmap, Size size )</arglist>
    </member>
    <member kind="function">
      <name>setPixmap</name>
      <anchor>setPixmap</anchor>
      <arglist>( const QPixmap &amp; pixmap, Size size, Mode mode = Normal, State state = Off )</arglist>
    </member>
    <member kind="function">
      <name>setPixmap</name>
      <anchor>setPixmap</anchor>
      <arglist>( const QString &amp; fileName, Size size, Mode mode = Normal, State state = Off )</arglist>
    </member>
    <member kind="function">
      <name>pixmap</name>
      <anchor>pixmap</anchor>
      <arglist>( Size size, Mode mode, State state = Off ) const</arglist>
    </member>
    <member kind="function">
      <name>pixmap</name>
      <anchor>pixmap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isGenerated</name>
      <anchor>isGenerated</anchor>
      <arglist>( Size size, Mode mode, State state = Off ) const</arglist>
    </member>
    <member kind="function">
      <name>clearGenerated</name>
      <anchor>clearGenerated</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>installIconFactory</name>
      <anchor>installIconFactory</anchor>
      <arglist>( QIconFactory * factory )</arglist>
    </member>
    <member kind="function">
      <name>isNull</name>
      <anchor>isNull</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>detach</name>
      <anchor>detach</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QIconSet &amp; other )</arglist>
    </member>
    <member kind="function">
      <name>createScaled</name>
      <anchor>createScaled</anchor>
      <arglist>( Size size, const QPixmap * suppliedPix ) const</arglist>
    </member>
    <member kind="function">
      <name>createDisabled</name>
      <anchor>createDisabled</anchor>
      <arglist>( Size size, State state ) const</arglist>
    </member>
    <member kind="function">
      <name>setIconSize</name>
      <anchor>setIconSize</anchor>
      <arglist>( Size which, const QSize &amp; size )</arglist>
    </member>
    <member kind="function">
      <name>iconSize</name>
      <anchor>iconSize</anchor>
      <arglist>( Size which )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QIconView</name>
    <filename>qiconview.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>SelectionMode</anchor>
      <arglist>{ Single = 0, Multi, Extended, NoSelection }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Arrangement</anchor>
      <arglist>{ LeftToRight = 0, TopToBottom }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ResizeMode</anchor>
      <arglist>{ Fixed = 0, Adjust }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ItemTextPos</anchor>
      <arglist>{ Bottom = 0, Right }</arglist>
    </member>
    <member kind="function">
      <name>QIconView</name>
      <anchor>QIconView</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QIconView</name>
      <anchor>QIconView</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( QIconViewItem * item, QIconViewItem * after = 0L )</arglist>
    </member>
    <member kind="function">
      <name>takeItem</name>
      <anchor>takeItem</anchor>
      <arglist>( QIconViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>index</name>
      <anchor>index</anchor>
      <arglist>( const QIconViewItem * item ) const</arglist>
    </member>
    <member kind="function">
      <name>firstItem</name>
      <anchor>firstItem</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>lastItem</name>
      <anchor>lastItem</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>currentItem</name>
      <anchor>currentItem</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setCurrentItem</name>
      <anchor>setCurrentItem</anchor>
      <arglist>( QIconViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>setSelected</name>
      <anchor>setSelected</anchor>
      <arglist>( QIconViewItem * item, bool s, bool cb = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSelectionMode</name>
      <anchor>setSelectionMode</anchor>
      <arglist>( SelectionMode m )</arglist>
    </member>
    <member kind="function">
      <name>selectionMode</name>
      <anchor>selectionMode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>findItem</name>
      <anchor>findItem</anchor>
      <arglist>( const QPoint &amp; pos ) const</arglist>
    </member>
    <member kind="function">
      <name>findItem</name>
      <anchor>findItem</anchor>
      <arglist>( const QString &amp; text, ComparisonFlags compare = BeginsWith ) const</arglist>
    </member>
    <member kind="function">
      <name>selectAll</name>
      <anchor>selectAll</anchor>
      <arglist>( bool select )</arglist>
    </member>
    <member kind="function">
      <name>clearSelection</name>
      <anchor>clearSelection</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>invertSelection</name>
      <anchor>invertSelection</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>repaintItem</name>
      <anchor>repaintItem</anchor>
      <arglist>( QIconViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>repaintSelectedItems</name>
      <anchor>repaintSelectedItems</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>ensureItemVisible</name>
      <anchor>ensureItemVisible</anchor>
      <arglist>( QIconViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>findFirstVisibleItem</name>
      <anchor>findFirstVisibleItem</anchor>
      <arglist>( const QRect &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>findLastVisibleItem</name>
      <anchor>findLastVisibleItem</anchor>
      <arglist>( const QRect &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setGridX</name>
      <anchor>setGridX</anchor>
      <arglist>( int rx )</arglist>
    </member>
    <member kind="function">
      <name>setGridY</name>
      <anchor>setGridY</anchor>
      <arglist>( int ry )</arglist>
    </member>
    <member kind="function">
      <name>gridX</name>
      <anchor>gridX</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>gridY</name>
      <anchor>gridY</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSpacing</name>
      <anchor>setSpacing</anchor>
      <arglist>( int sp )</arglist>
    </member>
    <member kind="function">
      <name>spacing</name>
      <anchor>spacing</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setItemTextPos</name>
      <anchor>setItemTextPos</anchor>
      <arglist>( ItemTextPos pos )</arglist>
    </member>
    <member kind="function">
      <name>itemTextPos</name>
      <anchor>itemTextPos</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setItemTextBackground</name>
      <anchor>setItemTextBackground</anchor>
      <arglist>( const QBrush &amp; b )</arglist>
    </member>
    <member kind="function">
      <name>itemTextBackground</name>
      <anchor>itemTextBackground</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setArrangement</name>
      <anchor>setArrangement</anchor>
      <arglist>( Arrangement am )</arglist>
    </member>
    <member kind="function">
      <name>arrangement</name>
      <anchor>arrangement</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setResizeMode</name>
      <anchor>setResizeMode</anchor>
      <arglist>( ResizeMode am )</arglist>
    </member>
    <member kind="function">
      <name>resizeMode</name>
      <anchor>resizeMode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMaxItemWidth</name>
      <anchor>setMaxItemWidth</anchor>
      <arglist>( int w )</arglist>
    </member>
    <member kind="function">
      <name>maxItemWidth</name>
      <anchor>maxItemWidth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMaxItemTextLength</name>
      <anchor>setMaxItemTextLength</anchor>
      <arglist>( int w )</arglist>
    </member>
    <member kind="function">
      <name>maxItemTextLength</name>
      <anchor>maxItemTextLength</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoArrange</name>
      <anchor>setAutoArrange</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>autoArrange</name>
      <anchor>autoArrange</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setShowToolTips</name>
      <anchor>setShowToolTips</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>showToolTips</name>
      <anchor>showToolTips</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSorting</name>
      <anchor>setSorting</anchor>
      <arglist>( bool sort, bool ascending = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>sorting</name>
      <anchor>sorting</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>sortDirection</name>
      <anchor>sortDirection</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setItemsMovable</name>
      <anchor>setItemsMovable</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>itemsMovable</name>
      <anchor>itemsMovable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setWordWrapIconText</name>
      <anchor>setWordWrapIconText</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>wordWrapIconText</name>
      <anchor>wordWrapIconText</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>sort</name>
      <anchor>sort</anchor>
      <arglist>( bool ascending = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>isRenaming</name>
      <anchor>isRenaming</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>arrangeItemsInGrid</name>
      <anchor>arrangeItemsInGrid</anchor>
      <arglist>( const QSize &amp; grid, bool update = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>arrangeItemsInGrid</name>
      <anchor>arrangeItemsInGrid</anchor>
      <arglist>( bool update = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>selectionChanged</name>
      <anchor>selectionChanged</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>selectionChanged</name>
      <anchor>selectionChanged</anchor>
      <arglist>( QIconViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>currentChanged</name>
      <anchor>currentChanged</anchor>
      <arglist>( QIconViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>clicked</name>
      <anchor>clicked</anchor>
      <arglist>( QIconViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>clicked</name>
      <anchor>clicked</anchor>
      <arglist>( QIconViewItem * item, const QPoint &amp; pos )</arglist>
    </member>
    <member kind="function">
      <name>pressed</name>
      <anchor>pressed</anchor>
      <arglist>( QIconViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>pressed</name>
      <anchor>pressed</anchor>
      <arglist>( QIconViewItem * item, const QPoint &amp; pos )</arglist>
    </member>
    <member kind="function">
      <name>doubleClicked</name>
      <anchor>doubleClicked</anchor>
      <arglist>( QIconViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>returnPressed</name>
      <anchor>returnPressed</anchor>
      <arglist>( QIconViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>rightButtonClicked</name>
      <anchor>rightButtonClicked</anchor>
      <arglist>( QIconViewItem * item, const QPoint &amp; pos )</arglist>
    </member>
    <member kind="function">
      <name>rightButtonPressed</name>
      <anchor>rightButtonPressed</anchor>
      <arglist>( QIconViewItem * item, const QPoint &amp; pos )</arglist>
    </member>
    <member kind="function">
      <name>mouseButtonPressed</name>
      <anchor>mouseButtonPressed</anchor>
      <arglist>( int button, QIconViewItem * item, const QPoint &amp; pos )</arglist>
    </member>
    <member kind="function">
      <name>mouseButtonClicked</name>
      <anchor>mouseButtonClicked</anchor>
      <arglist>( int button, QIconViewItem * item, const QPoint &amp; pos )</arglist>
    </member>
    <member kind="function">
      <name>contextMenuRequested</name>
      <anchor>contextMenuRequested</anchor>
      <arglist>( QIconViewItem * item, const QPoint &amp; pos )</arglist>
    </member>
    <member kind="function">
      <name>dropped</name>
      <anchor>dropped</anchor>
      <arglist>( QDropEvent * e, const QValueList&lt;QIconDragItem&gt; &amp; lst )</arglist>
    </member>
    <member kind="function">
      <name>moved</name>
      <anchor>moved</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>onItem</name>
      <anchor>onItem</anchor>
      <arglist>( QIconViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>onViewport</name>
      <anchor>onViewport</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>itemRenamed</name>
      <anchor>itemRenamed</anchor>
      <arglist>( QIconViewItem * item, const QString &amp; name )</arglist>
    </member>
    <member kind="function">
      <name>itemRenamed</name>
      <anchor>itemRenamed</anchor>
      <arglist>( QIconViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>arrangement</anchor>
      <arglist>- the arrangement mode of the icon view</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>autoArrange</anchor>
      <arglist>- whether the icon view rearranges its items when a new item is inserted</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>count</anchor>
      <arglist>- the number of items in the icon view</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>gridX</anchor>
      <arglist>- the horizontal grid of the icon view</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>gridY</anchor>
      <arglist>- the vertical grid of the icon view</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>itemTextBackground</anchor>
      <arglist>- the brush to use when drawing the background of an item&apos;s text</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>itemTextPos</anchor>
      <arglist>- the position where the text of each item is drawn</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>itemsMovable</anchor>
      <arglist>- whether the user is allowed to move items around in the icon view</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>maxItemTextLength</anchor>
      <arglist>- the maximum length (in characters) that an item&apos;s text may have</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>maxItemWidth</anchor>
      <arglist>- the maximum width that an item may have</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>resizeMode</anchor>
      <arglist>- the resize mode of the icon view</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>selectionMode</anchor>
      <arglist>- the selection mode of the icon view</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>showToolTips</anchor>
      <arglist>- whether the icon view will display a tool tip with the complete text for any truncated item text</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>sortDirection</anchor>
      <arglist>- whether the sort direction for inserting new items is ascending;</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>sorting</anchor>
      <arglist>- whether the icon view sorts on insertion</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>spacing</anchor>
      <arglist>- the space in pixels between icon view items</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>wordWrapIconText</anchor>
      <arglist>- whether the item text will be word-wrapped if it is too long</arglist>
    </member>
    <member kind="function">
      <name>drawRubber</name>
      <anchor>drawRubber</anchor>
      <arglist>( QPainter * p )</arglist>
    </member>
    <member kind="function">
      <name>dragObject</name>
      <anchor>dragObject</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>startDrag</name>
      <anchor>startDrag</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>insertInGrid</name>
      <anchor>insertInGrid</anchor>
      <arglist>( QIconViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>drawBackground</name>
      <anchor>drawBackground</anchor>
      <arglist>( QPainter * p, const QRect &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>emitSelectionChanged</name>
      <anchor>emitSelectionChanged</anchor>
      <arglist>( QIconViewItem * i = 0 )</arglist>
    </member>
    <member kind="function">
      <name>makeRowLayout</name>
      <anchor>makeRowLayout</anchor>
      <arglist>( QIconViewItem * begin, int &amp; y, bool &amp; changed )</arglist>
    </member>
    <member kind="function">
      <name>doAutoScroll</name>
      <anchor>doAutoScroll</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>adjustItems</name>
      <anchor>adjustItems</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>slotUpdate</name>
      <anchor>slotUpdate</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setArrangement</name>
      <anchor>setArrangement</anchor>
      <arglist>(), e.g. with</arglist>
    </member>
    <member kind="function">
      <name>setSorting</name>
      <anchor>setSorting</anchor>
      <arglist>() or</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QIconViewItem</name>
    <filename>qiconviewitem.html</filename>
    <member kind="function">
      <name>QIconViewItem</name>
      <anchor>QIconViewItem</anchor>
      <arglist>( QIconView * parent )</arglist>
    </member>
    <member kind="function">
      <name>QIconViewItem</name>
      <anchor>QIconViewItem</anchor>
      <arglist>( QIconView * parent, QIconViewItem * after )</arglist>
    </member>
    <member kind="function">
      <name>QIconViewItem</name>
      <anchor>QIconViewItem</anchor>
      <arglist>( QIconView * parent, const QString &amp; text )</arglist>
    </member>
    <member kind="function">
      <name>QIconViewItem</name>
      <anchor>QIconViewItem</anchor>
      <arglist>( QIconView * parent, QIconViewItem * after, const QString &amp; text )</arglist>
    </member>
    <member kind="function">
      <name>QIconViewItem</name>
      <anchor>QIconViewItem</anchor>
      <arglist>( QIconView * parent, const QString &amp; text, const QPixmap &amp; icon )</arglist>
    </member>
    <member kind="function">
      <name>QIconViewItem</name>
      <anchor>QIconViewItem</anchor>
      <arglist>( QIconView * parent, QIconViewItem * after, const QString &amp; text, const QPixmap &amp; icon )</arglist>
    </member>
    <member kind="function">
      <name>QIconViewItem</name>
      <anchor>QIconViewItem</anchor>
      <arglist>( QIconView * parent, const QString &amp; text, const QPicture &amp; picture )</arglist>
    </member>
    <member kind="function">
      <name>QIconViewItem</name>
      <anchor>QIconViewItem</anchor>
      <arglist>( QIconView * parent, QIconViewItem * after, const QString &amp; text, const QPicture &amp; picture )</arglist>
    </member>
    <member kind="function">
      <name>QIconViewItem</name>
      <anchor>QIconViewItem</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setRenameEnabled</name>
      <anchor>setRenameEnabled</anchor>
      <arglist>( bool allow )</arglist>
    </member>
    <member kind="function">
      <name>setDragEnabled</name>
      <anchor>setDragEnabled</anchor>
      <arglist>( bool allow )</arglist>
    </member>
    <member kind="function">
      <name>setDropEnabled</name>
      <anchor>setDropEnabled</anchor>
      <arglist>( bool allow )</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>pixmap</name>
      <anchor>pixmap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>picture</name>
      <anchor>picture</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>key</name>
      <anchor>key</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>renameEnabled</name>
      <anchor>renameEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>dragEnabled</name>
      <anchor>dragEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>dropEnabled</name>
      <anchor>dropEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>iconView</name>
      <anchor>iconView</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>prevItem</name>
      <anchor>prevItem</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>nextItem</name>
      <anchor>nextItem</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>index</name>
      <anchor>index</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSelected</name>
      <anchor>setSelected</anchor>
      <arglist>( bool s, bool cb )</arglist>
    </member>
    <member kind="function">
      <name>setSelected</name>
      <anchor>setSelected</anchor>
      <arglist>( bool s )</arglist>
    </member>
    <member kind="function">
      <name>setSelectable</name>
      <anchor>setSelectable</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>isSelected</name>
      <anchor>isSelected</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isSelectable</name>
      <anchor>isSelectable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>repaint</name>
      <anchor>repaint</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>move</name>
      <anchor>move</anchor>
      <arglist>( int x, int y )</arglist>
    </member>
    <member kind="function">
      <name>moveBy</name>
      <anchor>moveBy</anchor>
      <arglist>( int dx, int dy )</arglist>
    </member>
    <member kind="function">
      <name>move</name>
      <anchor>move</anchor>
      <arglist>( const QPoint &amp; pnt )</arglist>
    </member>
    <member kind="function">
      <name>moveBy</name>
      <anchor>moveBy</anchor>
      <arglist>( const QPoint &amp; pnt )</arglist>
    </member>
    <member kind="function">
      <name>rect</name>
      <anchor>rect</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>x</name>
      <anchor>x</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>y</name>
      <anchor>y</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>width</name>
      <anchor>width</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>height</name>
      <anchor>height</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>pos</name>
      <anchor>pos</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>textRect</name>
      <anchor>textRect</anchor>
      <arglist>( bool relative = TRUE ) const</arglist>
    </member>
    <member kind="function">
      <name>pixmapRect</name>
      <anchor>pixmapRect</anchor>
      <arglist>( bool relative = TRUE ) const</arglist>
    </member>
    <member kind="function">
      <name>contains</name>
      <anchor>contains</anchor>
      <arglist>( const QPoint &amp; pnt ) const</arglist>
    </member>
    <member kind="function">
      <name>intersects</name>
      <anchor>intersects</anchor>
      <arglist>( const QRect &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>acceptDrop</name>
      <anchor>acceptDrop</anchor>
      <arglist>( const QMimeSource * mime ) const</arglist>
    </member>
    <member kind="function">
      <name>rename</name>
      <anchor>rename</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>compare</name>
      <anchor>compare</anchor>
      <arglist>( QIconViewItem * i ) const</arglist>
    </member>
    <member kind="function">
      <name>setText</name>
      <anchor>setText</anchor>
      <arglist>( const QString &amp; text )</arglist>
    </member>
    <member kind="function">
      <name>setPixmap</name>
      <anchor>setPixmap</anchor>
      <arglist>( const QPixmap &amp; icon )</arglist>
    </member>
    <member kind="function">
      <name>setPicture</name>
      <anchor>setPicture</anchor>
      <arglist>( const QPicture &amp; icon )</arglist>
    </member>
    <member kind="function">
      <name>setText</name>
      <anchor>setText</anchor>
      <arglist>( const QString &amp; text, bool recalc, bool redraw = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>setPixmap</name>
      <anchor>setPixmap</anchor>
      <arglist>( const QPixmap &amp; icon, bool recalc, bool redraw = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>setKey</name>
      <anchor>setKey</anchor>
      <arglist>( const QString &amp; k )</arglist>
    </member>
    <member kind="function">
      <name>rtti</name>
      <anchor>rtti</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>removeRenameBox</name>
      <anchor>removeRenameBox</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>calcRect</name>
      <anchor>calcRect</anchor>
      <arglist>( const QString &amp; text_ = QString::null )</arglist>
    </member>
    <member kind="function">
      <name>paintItem</name>
      <anchor>paintItem</anchor>
      <arglist>( QPainter * p, const QColorGroup &amp; cg )</arglist>
    </member>
    <member kind="function">
      <name>paintFocus</name>
      <anchor>paintFocus</anchor>
      <arglist>( QPainter * p, const QColorGroup &amp; cg )</arglist>
    </member>
    <member kind="function">
      <name>dropped</name>
      <anchor>dropped</anchor>
      <arglist>( QDropEvent * e, const QValueList&lt;QIconDragItem&gt; &amp; lst )</arglist>
    </member>
    <member kind="function">
      <name>dragEntered</name>
      <anchor>dragEntered</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>dragLeft</name>
      <anchor>dragLeft</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setItemRect</name>
      <anchor>setItemRect</anchor>
      <arglist>( const QRect &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>setTextRect</name>
      <anchor>setTextRect</anchor>
      <arglist>( const QRect &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>setPixmapRect</name>
      <anchor>setPixmapRect</anchor>
      <arglist>( const QRect &amp; r )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QImage</name>
    <filename>qimage.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>Endian</anchor>
      <arglist>{ IgnoreEndian, BigEndian, LittleEndian }</arglist>
    </member>
    <member kind="function">
      <name>QImage</name>
      <anchor>QImage</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QImage</name>
      <anchor>QImage</anchor>
      <arglist>( int w, int h, int depth, int numColors = 0, Endian bitOrder = IgnoreEndian )</arglist>
    </member>
    <member kind="function">
      <name>QImage</name>
      <anchor>QImage</anchor>
      <arglist>( const QSize &amp; size, int depth, int numColors = 0, Endian bitOrder = IgnoreEndian )</arglist>
    </member>
    <member kind="function">
      <name>QImage</name>
      <anchor>QImage</anchor>
      <arglist>( const QString &amp; fileName, const char * format = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QImage</name>
      <anchor>QImage</anchor>
      <arglist>( const char * const xpm[] )</arglist>
    </member>
    <member kind="function">
      <name>QImage</name>
      <anchor>QImage</anchor>
      <arglist>( const QByteArray &amp; array )</arglist>
    </member>
    <member kind="function">
      <name>QImage</name>
      <anchor>QImage</anchor>
      <arglist>( uchar * yourdata, int w, int h, int depth, QRgb * colortable, int numColors, Endian bitOrder )</arglist>
    </member>
    <member kind="function">
      <name>QImage</name>
      <anchor>QImage</anchor>
      <arglist>( uchar * yourdata, int w, int h, int depth, int bpl, QRgb * colortable, int numColors, Endian bitOrder )</arglist>
    </member>
    <member kind="function">
      <name>QImage</name>
      <anchor>QImage</anchor>
      <arglist>( const QImage &amp; image )</arglist>
    </member>
    <member kind="function">
      <name>QImage</name>
      <anchor>QImage</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QImage &amp; image )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPixmap &amp; pixmap )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QImage &amp; i ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QImage &amp; i ) const</arglist>
    </member>
    <member kind="function">
      <name>detach</name>
      <anchor>detach</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>copy</name>
      <anchor>copy</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>copy</name>
      <anchor>copy</anchor>
      <arglist>( int x, int y, int w, int h, int conversion_flags = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>copy</name>
      <anchor>copy</anchor>
      <arglist>( const QRect &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>isNull</name>
      <anchor>isNull</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>width</name>
      <anchor>width</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>height</name>
      <anchor>height</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rect</name>
      <anchor>rect</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>depth</name>
      <anchor>depth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>numColors</name>
      <anchor>numColors</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>bitOrder</name>
      <anchor>bitOrder</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>color</name>
      <anchor>color</anchor>
      <arglist>( int i ) const</arglist>
    </member>
    <member kind="function">
      <name>setColor</name>
      <anchor>setColor</anchor>
      <arglist>( int i, QRgb c )</arglist>
    </member>
    <member kind="function">
      <name>setNumColors</name>
      <anchor>setNumColors</anchor>
      <arglist>( int numColors )</arglist>
    </member>
    <member kind="function">
      <name>hasAlphaBuffer</name>
      <anchor>hasAlphaBuffer</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAlphaBuffer</name>
      <anchor>setAlphaBuffer</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>allGray</name>
      <anchor>allGray</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isGrayscale</name>
      <anchor>isGrayscale</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>bits</name>
      <anchor>bits</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>scanLine</name>
      <anchor>scanLine</anchor>
      <arglist>( int i ) const</arglist>
    </member>
    <member kind="function">
      <name>jumpTable</name>
      <anchor>jumpTable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>colorTable</name>
      <anchor>colorTable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>numBytes</name>
      <anchor>numBytes</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>bytesPerLine</name>
      <anchor>bytesPerLine</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>create</name>
      <anchor>create</anchor>
      <arglist>( int width, int height, int depth, int numColors = 0, Endian bitOrder = IgnoreEndian )</arglist>
    </member>
    <member kind="function">
      <name>create</name>
      <anchor>create</anchor>
      <arglist>( const QSize &amp;, int depth, int numColors = 0, Endian bitOrder = IgnoreEndian )</arglist>
    </member>
    <member kind="function">
      <name>reset</name>
      <anchor>reset</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>fill</name>
      <anchor>fill</anchor>
      <arglist>( uint pixel )</arglist>
    </member>
    <member kind="function">
      <name>invertPixels</name>
      <anchor>invertPixels</anchor>
      <arglist>( bool invertAlpha = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>convertDepth</name>
      <anchor>convertDepth</anchor>
      <arglist>( int depth ) const</arglist>
    </member>
    <member kind="function">
      <name>convertDepthWithPalette</name>
      <anchor>convertDepthWithPalette</anchor>
      <arglist>( int d, QRgb * palette, int palette_count, int conversion_flags = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>convertDepth</name>
      <anchor>convertDepth</anchor>
      <arglist>( int depth, int conversion_flags ) const</arglist>
    </member>
    <member kind="function">
      <name>convertBitOrder</name>
      <anchor>convertBitOrder</anchor>
      <arglist>( Endian bitOrder ) const</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ScaleMode</anchor>
      <arglist>{ ScaleFree, ScaleMin, ScaleMax }</arglist>
    </member>
    <member kind="function">
      <name>smoothScale</name>
      <anchor>smoothScale</anchor>
      <arglist>( int w, int h, ScaleMode mode = ScaleFree ) const</arglist>
    </member>
    <member kind="function">
      <name>smoothScale</name>
      <anchor>smoothScale</anchor>
      <arglist>( const QSize &amp; s, ScaleMode mode = ScaleFree ) const</arglist>
    </member>
    <member kind="function">
      <name>scale</name>
      <anchor>scale</anchor>
      <arglist>( int w, int h, ScaleMode mode = ScaleFree ) const</arglist>
    </member>
    <member kind="function">
      <name>scale</name>
      <anchor>scale</anchor>
      <arglist>( const QSize &amp; s, ScaleMode mode = ScaleFree ) const</arglist>
    </member>
    <member kind="function">
      <name>scaleWidth</name>
      <anchor>scaleWidth</anchor>
      <arglist>( int w ) const</arglist>
    </member>
    <member kind="function">
      <name>scaleHeight</name>
      <anchor>scaleHeight</anchor>
      <arglist>( int h ) const</arglist>
    </member>
    <member kind="function">
      <name>xForm</name>
      <anchor>xForm</anchor>
      <arglist>( const QWMatrix &amp; matrix ) const</arglist>
    </member>
    <member kind="function">
      <name>createAlphaMask</name>
      <anchor>createAlphaMask</anchor>
      <arglist>( int conversion_flags = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>createHeuristicMask</name>
      <anchor>createHeuristicMask</anchor>
      <arglist>( bool clipTight = TRUE ) const</arglist>
    </member>
    <member kind="function">
      <name>mirror</name>
      <anchor>mirror</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>mirror</name>
      <anchor>mirror</anchor>
      <arglist>( bool horizontal, bool vertical ) const</arglist>
    </member>
    <member kind="function">
      <name>swapRGB</name>
      <anchor>swapRGB</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>load</name>
      <anchor>load</anchor>
      <arglist>( const QString &amp; fileName, const char * format = 0 )</arglist>
    </member>
    <member kind="function">
      <name>loadFromData</name>
      <anchor>loadFromData</anchor>
      <arglist>( const uchar * buf, uint len, const char * format = 0 )</arglist>
    </member>
    <member kind="function">
      <name>loadFromData</name>
      <anchor>loadFromData</anchor>
      <arglist>( QByteArray buf, const char * format = 0 )</arglist>
    </member>
    <member kind="function">
      <name>save</name>
      <anchor>save</anchor>
      <arglist>( const QString &amp; fileName, const char * format, int quality = -1 ) const</arglist>
    </member>
    <member kind="function">
      <name>save</name>
      <anchor>save</anchor>
      <arglist>( QIODevice * device, const char * format, int quality = -1 ) const</arglist>
    </member>
    <member kind="function">
      <name>valid</name>
      <anchor>valid</anchor>
      <arglist>( int x, int y ) const</arglist>
    </member>
    <member kind="function">
      <name>pixelIndex</name>
      <anchor>pixelIndex</anchor>
      <arglist>( int x, int y ) const</arglist>
    </member>
    <member kind="function">
      <name>pixel</name>
      <anchor>pixel</anchor>
      <arglist>( int x, int y ) const</arglist>
    </member>
    <member kind="function">
      <name>setPixel</name>
      <anchor>setPixel</anchor>
      <arglist>( int x, int y, uint index_or_rgb )</arglist>
    </member>
    <member kind="function">
      <name>dotsPerMeterX</name>
      <anchor>dotsPerMeterX</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>dotsPerMeterY</name>
      <anchor>dotsPerMeterY</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setDotsPerMeterX</name>
      <anchor>setDotsPerMeterX</anchor>
      <arglist>( int x )</arglist>
    </member>
    <member kind="function">
      <name>setDotsPerMeterY</name>
      <anchor>setDotsPerMeterY</anchor>
      <arglist>( int y )</arglist>
    </member>
    <member kind="function">
      <name>offset</name>
      <anchor>offset</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setOffset</name>
      <anchor>setOffset</anchor>
      <arglist>( const QPoint &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>textList</name>
      <anchor>textList</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>textLanguages</name>
      <anchor>textLanguages</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>textKeys</name>
      <anchor>textKeys</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>( const char * key, const char * lang = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>( const QImageTextKeyLang &amp; kl ) const</arglist>
    </member>
    <member kind="function">
      <name>setText</name>
      <anchor>setText</anchor>
      <arglist>( const char * key, const char * lang, const QString &amp; s )</arglist>
    </member>
    <member kind="function">
      <name>fromMimeSource</name>
      <anchor>fromMimeSource</anchor>
      <arglist>( const QString &amp; abs_name )</arglist>
    </member>
    <member kind="function">
      <name>systemBitOrder</name>
      <anchor>systemBitOrder</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>systemByteOrder</name>
      <anchor>systemByteOrder</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>imageFormat</name>
      <anchor>imageFormat</anchor>
      <arglist>( const QString &amp; fileName )</arglist>
    </member>
    <member kind="function">
      <name>inputFormats</name>
      <anchor>inputFormats</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>outputFormats</name>
      <anchor>outputFormats</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>inputFormatList</name>
      <anchor>inputFormatList</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>outputFormatList</name>
      <anchor>outputFormatList</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QImage &amp; image )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QImage &amp; image )</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ScaleMode</anchor>
      <arglist>, the image is scaled to (</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ScaleMode</anchor>
      <arglist>, the image is scaled to a rectangle</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ScaleMode</anchor>
      <arglist>, the image is scaled to a rectangle</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QImageConsumer</name>
    <filename>qimageconsumer.html</filename>
    <member kind="function">
      <name>end</name>
      <anchor>end</anchor>
      <arglist>() = 0</arglist>
    </member>
    <member kind="function">
      <name>changed</name>
      <anchor>changed</anchor>
      <arglist>( const QRect &amp; ) = 0</arglist>
    </member>
    <member kind="function">
      <name>frameDone</name>
      <anchor>frameDone</anchor>
      <arglist>() = 0</arglist>
    </member>
    <member kind="function">
      <name>frameDone</name>
      <anchor>frameDone</anchor>
      <arglist>( const QPoint &amp; offset, const QRect &amp; rect ) = 0</arglist>
    </member>
    <member kind="function">
      <name>setLooping</name>
      <anchor>setLooping</anchor>
      <arglist>( int n ) = 0</arglist>
    </member>
    <member kind="function">
      <name>setFramePeriod</name>
      <anchor>setFramePeriod</anchor>
      <arglist>( int milliseconds ) = 0</arglist>
    </member>
    <member kind="function">
      <name>setSize</name>
      <anchor>setSize</anchor>
      <arglist>( int, int ) = 0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QImageDecoder</name>
    <filename>qimagedecoder.html</filename>
    <member kind="function">
      <name>QImageDecoder</name>
      <anchor>QImageDecoder</anchor>
      <arglist>( QImageConsumer * c )</arglist>
    </member>
    <member kind="function">
      <name>QImageDecoder</name>
      <anchor>QImageDecoder</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>image</name>
      <anchor>image</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>decode</name>
      <anchor>decode</anchor>
      <arglist>( const uchar * buffer, int length )</arglist>
    </member>
    <member kind="function">
      <name>formatName</name>
      <anchor>formatName</anchor>
      <arglist>( const uchar * buffer, int length )</arglist>
    </member>
    <member kind="function">
      <name>format</name>
      <anchor>format</anchor>
      <arglist>( const char * name )</arglist>
    </member>
    <member kind="function">
      <name>inputFormats</name>
      <anchor>inputFormats</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>registerDecoderFactory</name>
      <anchor>registerDecoderFactory</anchor>
      <arglist>( QImageFormatType * f )</arglist>
    </member>
    <member kind="function">
      <name>unregisterDecoderFactory</name>
      <anchor>unregisterDecoderFactory</anchor>
      <arglist>( QImageFormatType * f )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QImageDrag</name>
    <filename>qimagedrag.html</filename>
    <member kind="function">
      <name>QImageDrag</name>
      <anchor>QImageDrag</anchor>
      <arglist>( QImage image, QWidget * dragSource = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QImageDrag</name>
      <anchor>QImageDrag</anchor>
      <arglist>( QWidget * dragSource = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QImageDrag</name>
      <anchor>QImageDrag</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setImage</name>
      <anchor>setImage</anchor>
      <arglist>( QImage image )</arglist>
    </member>
    <member kind="function">
      <name>canDecode</name>
      <anchor>canDecode</anchor>
      <arglist>( const QMimeSource * e )</arglist>
    </member>
    <member kind="function">
      <name>decode</name>
      <anchor>decode</anchor>
      <arglist>( const QMimeSource * e, QImage &amp; img )</arglist>
    </member>
    <member kind="function">
      <name>decode</name>
      <anchor>decode</anchor>
      <arglist>( const QMimeSource * e, QPixmap &amp; pm )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QImageFormat</name>
    <filename>qimageformat.html</filename>
    <member kind="function">
      <name>decode</name>
      <anchor>decode</anchor>
      <arglist>( QImage &amp; img, QImageConsumer * consumer, const uchar * buffer, int length ) = 0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QImageFormatPlugin</name>
    <filename>qimageformatplugin.html</filename>
    <member kind="function">
      <name>QImageFormatPlugin</name>
      <anchor>QImageFormatPlugin</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QImageFormatPlugin</name>
      <anchor>QImageFormatPlugin</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>keys</name>
      <anchor>keys</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>installIOHandler</name>
      <anchor>installIOHandler</anchor>
      <arglist>( const QString &amp; format ) = 0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QImageFormatType</name>
    <filename>qimageformattype.html</filename>
    <member kind="function">
      <name>QImageFormatType</name>
      <anchor>QImageFormatType</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>decoderFor</name>
      <anchor>decoderFor</anchor>
      <arglist>( const uchar * buffer, int length ) = 0</arglist>
    </member>
    <member kind="function">
      <name>formatName</name>
      <anchor>formatName</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>QImageFormatType</name>
      <anchor>QImageFormatType</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QImageIO</name>
    <filename>qimageio.html</filename>
    <member kind="function">
      <name>QImageIO</name>
      <anchor>QImageIO</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QImageIO</name>
      <anchor>QImageIO</anchor>
      <arglist>( QIODevice * ioDevice, const char * format )</arglist>
    </member>
    <member kind="function">
      <name>QImageIO</name>
      <anchor>QImageIO</anchor>
      <arglist>( const QString &amp; fileName, const char * format )</arglist>
    </member>
    <member kind="function">
      <name>QImageIO</name>
      <anchor>QImageIO</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>image</name>
      <anchor>image</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>status</name>
      <anchor>status</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>format</name>
      <anchor>format</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>ioDevice</name>
      <anchor>ioDevice</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>fileName</name>
      <anchor>fileName</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>quality</name>
      <anchor>quality</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>description</name>
      <anchor>description</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>parameters</name>
      <anchor>parameters</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>gamma</name>
      <anchor>gamma</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setImage</name>
      <anchor>setImage</anchor>
      <arglist>( const QImage &amp; image )</arglist>
    </member>
    <member kind="function">
      <name>setStatus</name>
      <anchor>setStatus</anchor>
      <arglist>( int status )</arglist>
    </member>
    <member kind="function">
      <name>setFormat</name>
      <anchor>setFormat</anchor>
      <arglist>( const char * format )</arglist>
    </member>
    <member kind="function">
      <name>setIODevice</name>
      <anchor>setIODevice</anchor>
      <arglist>( QIODevice * ioDevice )</arglist>
    </member>
    <member kind="function">
      <name>setFileName</name>
      <anchor>setFileName</anchor>
      <arglist>( const QString &amp; fileName )</arglist>
    </member>
    <member kind="function">
      <name>setQuality</name>
      <anchor>setQuality</anchor>
      <arglist>( int q )</arglist>
    </member>
    <member kind="function">
      <name>setDescription</name>
      <anchor>setDescription</anchor>
      <arglist>( const QString &amp; description )</arglist>
    </member>
    <member kind="function">
      <name>setParameters</name>
      <anchor>setParameters</anchor>
      <arglist>( const char * parameters )</arglist>
    </member>
    <member kind="function">
      <name>setGamma</name>
      <anchor>setGamma</anchor>
      <arglist>( float gamma )</arglist>
    </member>
    <member kind="function">
      <name>read</name>
      <anchor>read</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>write</name>
      <anchor>write</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>imageFormat</name>
      <anchor>imageFormat</anchor>
      <arglist>( const QString &amp; fileName )</arglist>
    </member>
    <member kind="function">
      <name>imageFormat</name>
      <anchor>imageFormat</anchor>
      <arglist>( QIODevice * d )</arglist>
    </member>
    <member kind="function">
      <name>inputFormats</name>
      <anchor>inputFormats</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>outputFormats</name>
      <anchor>outputFormats</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>defineIOHandler</name>
      <anchor>defineIOHandler</anchor>
      <arglist>( const char * format, const char * header, const char * flags, image_io_handler readImage, image_io_handler writeImage )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QIMEvent</name>
    <filename>qimevent.html</filename>
    <member kind="function">
      <name>QIMEvent</name>
      <anchor>QIMEvent</anchor>
      <arglist>( Type type, const QString &amp; text, int cursorPosition )</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>cursorPos</name>
      <anchor>cursorPos</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isAccepted</name>
      <anchor>isAccepted</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>accept</name>
      <anchor>accept</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>ignore</name>
      <anchor>ignore</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>selectionLength</name>
      <anchor>selectionLength</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QInputDialog</name>
    <filename>qinputdialog.html</filename>
    <member kind="function">
      <name>getText</name>
      <anchor>getText</anchor>
      <arglist>( const QString &amp; caption, const QString &amp; label, QLineEdit::EchoMode mode = QLineEdit::Normal, const QString &amp; text = QString::null, bool * ok = 0, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>getInteger</name>
      <anchor>getInteger</anchor>
      <arglist>( const QString &amp; caption, const QString &amp; label, int value = 0, int minValue = -2147483647, int maxValue = 2147483647, int step = 1, bool * ok = 0, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>getDouble</name>
      <anchor>getDouble</anchor>
      <arglist>( const QString &amp; caption, const QString &amp; label, double value = 0, double minValue = -2147483647, double maxValue = 2147483647, int decimals = 1, bool * ok = 0, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>getItem</name>
      <anchor>getItem</anchor>
      <arglist>( const QString &amp; caption, const QString &amp; label, const QStringList &amp; list, int current = 0, bool editable = TRUE, bool * ok = 0, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QIntCache</name>
    <filename>qintcache.html</filename>
    <member kind="function">
      <name>QIntCache</name>
      <anchor>QIntCache</anchor>
      <arglist>( int maxCost = 100, int size = 17 )</arglist>
    </member>
    <member kind="function">
      <name>QIntCache</name>
      <anchor>QIntCache</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>maxCost</name>
      <anchor>maxCost</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>totalCost</name>
      <anchor>totalCost</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMaxCost</name>
      <anchor>setMaxCost</anchor>
      <arglist>( int m )</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>insert</name>
      <anchor>insert</anchor>
      <arglist>( long k, const type * d, int c = 1, int p = 0 )</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>( long k )</arglist>
    </member>
    <member kind="function">
      <name>take</name>
      <anchor>take</anchor>
      <arglist>( long k )</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>find</name>
      <anchor>find</anchor>
      <arglist>( long k, bool ref = TRUE ) const</arglist>
    </member>
    <member kind="function">
      <name>operator[]</name>
      <anchor>operator</anchor>
      <arglist>( long k ) const</arglist>
    </member>
    <member kind="function">
      <name>statistics</name>
      <anchor>statistics</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QIntCacheIterator</name>
    <filename>qintcacheiterator.html</filename>
    <member kind="function">
      <name>QIntCacheIterator</name>
      <anchor>QIntCacheIterator</anchor>
      <arglist>( const QIntCache&lt;type&gt; &amp; cache )</arglist>
    </member>
    <member kind="function">
      <name>QIntCacheIterator</name>
      <anchor>QIntCacheIterator</anchor>
      <arglist>( const QIntCacheIterator&lt;type&gt; &amp; ci )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QIntCacheIterator&lt;type&gt; &amp; ci )</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>atFirst</name>
      <anchor>atFirst</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>atLast</name>
      <anchor>atLast</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>toFirst</name>
      <anchor>toFirst</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toLast</name>
      <anchor>toLast</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>type</name>
      <anchor>operator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>current</name>
      <anchor>current</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>currentKey</name>
      <anchor>currentKey</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>operator()</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>operator++</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( uint jump )</arglist>
    </member>
    <member kind="function">
      <name>operator--</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( uint jump )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QIntDict</name>
    <filename>qintdict.html</filename>
    <member kind="function">
      <name>QIntDict</name>
      <anchor>QIntDict</anchor>
      <arglist>( int size = 17 )</arglist>
    </member>
    <member kind="function">
      <name>QIntDict</name>
      <anchor>QIntDict</anchor>
      <arglist>( const QIntDict&lt;type&gt; &amp; dict )</arglist>
    </member>
    <member kind="function">
      <name>QIntDict</name>
      <anchor>QIntDict</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QIntDict&lt;type&gt; &amp; dict )</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>insert</name>
      <anchor>insert</anchor>
      <arglist>( long key, const type * item )</arglist>
    </member>
    <member kind="function">
      <name>replace</name>
      <anchor>replace</anchor>
      <arglist>( long key, const type * item )</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>( long key )</arglist>
    </member>
    <member kind="function">
      <name>take</name>
      <anchor>take</anchor>
      <arglist>( long key )</arglist>
    </member>
    <member kind="function">
      <name>find</name>
      <anchor>find</anchor>
      <arglist>( long key ) const</arglist>
    </member>
    <member kind="function">
      <name>operator[]</name>
      <anchor>operator</anchor>
      <arglist>( long key ) const</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>resize</name>
      <anchor>resize</anchor>
      <arglist>( uint newsize )</arglist>
    </member>
    <member kind="function">
      <name>statistics</name>
      <anchor>statistics</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>autoDelete</name>
      <anchor>autoDelete</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoDelete</name>
      <anchor>setAutoDelete</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>read</name>
      <anchor>read</anchor>
      <arglist>( QDataStream &amp; s, QPtrCollection::Item &amp; item )</arglist>
    </member>
    <member kind="function">
      <name>write</name>
      <anchor>write</anchor>
      <arglist>( QDataStream &amp; s, QPtrCollection::Item ) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QIntDictIterator</name>
    <filename>qintdictiterator.html</filename>
    <member kind="function">
      <name>QIntDictIterator</name>
      <anchor>QIntDictIterator</anchor>
      <arglist>( const QIntDict&lt;type&gt; &amp; dict )</arglist>
    </member>
    <member kind="function">
      <name>QIntDictIterator</name>
      <anchor>QIntDictIterator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>toFirst</name>
      <anchor>toFirst</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>type</name>
      <anchor>operator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>current</name>
      <anchor>current</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>currentKey</name>
      <anchor>currentKey</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>operator()</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>operator++</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( uint jump )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QIntValidator</name>
    <filename>qintvalidator.html</filename>
    <member kind="function">
      <name>QIntValidator</name>
      <anchor>QIntValidator</anchor>
      <arglist>( QObject * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QIntValidator</name>
      <anchor>QIntValidator</anchor>
      <arglist>( int minimum, int maximum, QObject * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QIntValidator</name>
      <anchor>QIntValidator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>validate</name>
      <anchor>validate</anchor>
      <arglist>( QString &amp; input, int &amp; ) const</arglist>
    </member>
    <member kind="function">
      <name>setBottom</name>
      <anchor>setBottom</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>setTop</name>
      <anchor>setTop</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>setRange</name>
      <anchor>setRange</anchor>
      <arglist>( int bottom, int top )</arglist>
    </member>
    <member kind="function">
      <name>bottom</name>
      <anchor>bottom</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>top</name>
      <anchor>top</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>bottom</anchor>
      <arglist>- the validator&apos;s lowest acceptable value</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>top</anchor>
      <arglist>- the validator&apos;s highest acceptable value</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QIODevice</name>
    <filename>qiodevice.html</filename>
    <member kind="function">
      <name>Offset</name>
      <anchor>Offset</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>QIODevice</name>
      <anchor>QIODevice</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QIODevice</name>
      <anchor>QIODevice</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>flags</name>
      <anchor>flags</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>mode</name>
      <anchor>mode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>state</name>
      <anchor>state</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isDirectAccess</name>
      <anchor>isDirectAccess</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isSequentialAccess</name>
      <anchor>isSequentialAccess</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isCombinedAccess</name>
      <anchor>isCombinedAccess</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isBuffered</name>
      <anchor>isBuffered</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isRaw</name>
      <anchor>isRaw</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isSynchronous</name>
      <anchor>isSynchronous</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isAsynchronous</name>
      <anchor>isAsynchronous</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isTranslated</name>
      <anchor>isTranslated</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isReadable</name>
      <anchor>isReadable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isWritable</name>
      <anchor>isWritable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isReadWrite</name>
      <anchor>isReadWrite</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isInactive</name>
      <anchor>isInactive</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isOpen</name>
      <anchor>isOpen</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>status</name>
      <anchor>status</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>resetStatus</name>
      <anchor>resetStatus</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>open</name>
      <anchor>open</anchor>
      <arglist>( int mode ) = 0</arglist>
    </member>
    <member kind="function">
      <name>close</name>
      <anchor>close</anchor>
      <arglist>() = 0</arglist>
    </member>
    <member kind="function">
      <name>flush</name>
      <anchor>flush</anchor>
      <arglist>() = 0</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>at</name>
      <anchor>at</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>at</name>
      <anchor>at</anchor>
      <arglist>( Offset pos )</arglist>
    </member>
    <member kind="function">
      <name>atEnd</name>
      <anchor>atEnd</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>reset</name>
      <anchor>reset</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>readBlock</name>
      <anchor>readBlock</anchor>
      <arglist>( char * data, Q_ULONG maxlen ) = 0</arglist>
    </member>
    <member kind="function">
      <name>writeBlock</name>
      <anchor>writeBlock</anchor>
      <arglist>( const char * data, Q_ULONG len ) = 0</arglist>
    </member>
    <member kind="function">
      <name>readLine</name>
      <anchor>readLine</anchor>
      <arglist>( char * data, Q_ULONG maxlen )</arglist>
    </member>
    <member kind="function">
      <name>writeBlock</name>
      <anchor>writeBlock</anchor>
      <arglist>( const QByteArray &amp; data )</arglist>
    </member>
    <member kind="function">
      <name>readAll</name>
      <anchor>readAll</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>getch</name>
      <anchor>getch</anchor>
      <arglist>() = 0</arglist>
    </member>
    <member kind="function">
      <name>putch</name>
      <anchor>putch</anchor>
      <arglist>( int ch ) = 0</arglist>
    </member>
    <member kind="function">
      <name>ungetch</name>
      <anchor>ungetch</anchor>
      <arglist>( int ch ) = 0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QIODeviceSource</name>
    <filename>qiodevicesource.html</filename>
    <member kind="function">
      <name>QIODeviceSource</name>
      <anchor>QIODeviceSource</anchor>
      <arglist>( QIODevice * device, int buffer_size = 4096 )</arglist>
    </member>
    <member kind="function">
      <name>QIODeviceSource</name>
      <anchor>QIODeviceSource</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>readyToSend</name>
      <anchor>readyToSend</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>sendTo</name>
      <anchor>sendTo</anchor>
      <arglist>( QDataSink * sink, int n )</arglist>
    </member>
    <member kind="function">
      <name>rewindable</name>
      <anchor>rewindable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>enableRewind</name>
      <anchor>enableRewind</anchor>
      <arglist>( bool on )</arglist>
    </member>
    <member kind="function">
      <name>rewind</name>
      <anchor>rewind</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QJisCodec</name>
    <filename>qjiscodec.html</filename>
    <member kind="function">
      <name>mimeName</name>
      <anchor>mimeName</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QKbdDriverFactory</name>
    <filename>qkbddriverfactory.html</filename>
    <member kind="function">
      <name>keys</name>
      <anchor>keys</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>create</name>
      <anchor>create</anchor>
      <arglist>( const QString &amp; key, const QString &amp; device )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QKbdDriverPlugin</name>
    <filename>qkbddriverplugin.html</filename>
    <member kind="function">
      <name>QKbdDriverPlugin</name>
      <anchor>QKbdDriverPlugin</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QKbdDriverPlugin</name>
      <anchor>QKbdDriverPlugin</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>keys</name>
      <anchor>keys</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>create</name>
      <anchor>create</anchor>
      <arglist>( const QString &amp; driver, const QString &amp; device ) = 0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QKeyEvent</name>
    <filename>qkeyevent.html</filename>
    <member kind="function">
      <name>QKeyEvent</name>
      <anchor>QKeyEvent</anchor>
      <arglist>( Type type, int key, int ascii, int state, const QString &amp; text = QString::null, bool autorep = FALSE, ushort count = 1 )</arglist>
    </member>
    <member kind="function">
      <name>key</name>
      <anchor>key</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>ascii</name>
      <anchor>ascii</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>state</name>
      <anchor>state</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>stateAfter</name>
      <anchor>stateAfter</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isAccepted</name>
      <anchor>isAccepted</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isAutoRepeat</name>
      <anchor>isAutoRepeat</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>accept</name>
      <anchor>accept</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>ignore</name>
      <anchor>ignore</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QKeySequence</name>
    <filename>qkeysequence.html</filename>
    <member kind="function">
      <name>QKeySequence</name>
      <anchor>QKeySequence</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QKeySequence</name>
      <anchor>QKeySequence</anchor>
      <arglist>( const QString &amp; key )</arglist>
    </member>
    <member kind="function">
      <name>QKeySequence</name>
      <anchor>QKeySequence</anchor>
      <arglist>( int key )</arglist>
    </member>
    <member kind="function">
      <name>QKeySequence</name>
      <anchor>QKeySequence</anchor>
      <arglist>( int k1, int k2, int k3 = 0, int k4 = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QKeySequence</name>
      <anchor>QKeySequence</anchor>
      <arglist>( const QKeySequence &amp; keysequence )</arglist>
    </member>
    <member kind="function">
      <name>QKeySequence</name>
      <anchor>QKeySequence</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>matches</name>
      <anchor>matches</anchor>
      <arglist>( const QKeySequence &amp; seq ) const</arglist>
    </member>
    <member kind="function">
      <name>QString</name>
      <anchor>operator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>operator[]</name>
      <anchor>operator</anchor>
      <arglist>( uint index ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QKeySequence &amp; keysequence )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QKeySequence &amp; keysequence ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QKeySequence &amp; keysequence ) const</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QKeySequence &amp; keysequence )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QKeySequence &amp; keysequence )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QLabel</name>
    <filename>qlabel.html</filename>
    <member kind="function">
      <name>QLabel</name>
      <anchor>QLabel</anchor>
      <arglist>( QWidget * parent, const char * name = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QLabel</name>
      <anchor>QLabel</anchor>
      <arglist>( const QString &amp; text, QWidget * parent, const char * name = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QLabel</name>
      <anchor>QLabel</anchor>
      <arglist>( QWidget * buddy, const QString &amp; text, QWidget * parent, const char * name = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QLabel</name>
      <anchor>QLabel</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>pixmap</name>
      <anchor>pixmap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>picture</name>
      <anchor>picture</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>movie</name>
      <anchor>movie</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>textFormat</name>
      <anchor>textFormat</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setTextFormat</name>
      <anchor>setTextFormat</anchor>
      <arglist>( TextFormat )</arglist>
    </member>
    <member kind="function">
      <name>alignment</name>
      <anchor>alignment</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAlignment</name>
      <anchor>setAlignment</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>indent</name>
      <anchor>indent</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setIndent</name>
      <anchor>setIndent</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>hasScaledContents</name>
      <anchor>hasScaledContents</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setScaledContents</name>
      <anchor>setScaledContents</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>setBuddy</name>
      <anchor>setBuddy</anchor>
      <arglist>( QWidget * buddy )</arglist>
    </member>
    <member kind="function">
      <name>buddy</name>
      <anchor>buddy</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setFont</name>
      <anchor>setFont</anchor>
      <arglist>( const QFont &amp; f )</arglist>
    </member>
    <member kind="function">
      <name>setText</name>
      <anchor>setText</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>setPixmap</name>
      <anchor>setPixmap</anchor>
      <arglist>( const QPixmap &amp; )</arglist>
    </member>
    <member kind="function">
      <name>setPicture</name>
      <anchor>setPicture</anchor>
      <arglist>( const QPicture &amp; picture )</arglist>
    </member>
    <member kind="function">
      <name>setMovie</name>
      <anchor>setMovie</anchor>
      <arglist>( const QMovie &amp; movie )</arglist>
    </member>
    <member kind="function">
      <name>setNum</name>
      <anchor>setNum</anchor>
      <arglist>( int num )</arglist>
    </member>
    <member kind="function">
      <name>setNum</name>
      <anchor>setNum</anchor>
      <arglist>( double num )</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>alignment</anchor>
      <arglist>- the alignment of the label&apos;s contents</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>indent</anchor>
      <arglist>- the label&apos;s text indent in pixels</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>pixmap</anchor>
      <arglist>- the label&apos;s pixmap</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>scaledContents</anchor>
      <arglist>- whether the label will scale its contents to fill all available space</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>text</anchor>
      <arglist>- the label&apos;s text</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>textFormat</anchor>
      <arglist>- the label&apos;s text format</arglist>
    </member>
    <member kind="function">
      <name>drawContents</name>
      <anchor>drawContents</anchor>
      <arglist>( QPainter * p )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QLayout</name>
    <filename>qlayout.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>ResizeMode</anchor>
      <arglist>{ FreeResize, Minimum, Fixed, Auto }</arglist>
    </member>
    <member kind="function">
      <name>QLayout</name>
      <anchor>QLayout</anchor>
      <arglist>( QWidget * parent, int margin = 0, int spacing = -1, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QLayout</name>
      <anchor>QLayout</anchor>
      <arglist>( QLayout * parentLayout, int spacing = -1, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QLayout</name>
      <anchor>QLayout</anchor>
      <arglist>( int spacing = -1, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>margin</name>
      <anchor>margin</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>spacing</name>
      <anchor>spacing</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMargin</name>
      <anchor>setMargin</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>setSpacing</name>
      <anchor>setSpacing</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>setResizeMode</name>
      <anchor>setResizeMode</anchor>
      <arglist>( ResizeMode )</arglist>
    </member>
    <member kind="function">
      <name>resizeMode</name>
      <anchor>resizeMode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMenuBar</name>
      <anchor>setMenuBar</anchor>
      <arglist>( QMenuBar * w )</arglist>
    </member>
    <member kind="function">
      <name>menuBar</name>
      <anchor>menuBar</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>mainWidget</name>
      <anchor>mainWidget</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>isTopLevel</name>
      <anchor>isTopLevel</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoAdd</name>
      <anchor>setAutoAdd</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>autoAdd</name>
      <anchor>autoAdd</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>invalidate</name>
      <anchor>invalidate</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>activate</name>
      <anchor>activate</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>add</name>
      <anchor>add</anchor>
      <arglist>( QWidget * w )</arglist>
    </member>
    <member kind="function">
      <name>addItem</name>
      <anchor>addItem</anchor>
      <arglist>( QLayoutItem * item ) = 0</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>( QWidget * widget )</arglist>
    </member>
    <member kind="function">
      <name>removeItem</name>
      <anchor>removeItem</anchor>
      <arglist>( QLayoutItem * item )</arglist>
    </member>
    <member kind="function">
      <name>expanding</name>
      <anchor>expanding</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>minimumSize</name>
      <anchor>minimumSize</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>maximumSize</name>
      <anchor>maximumSize</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setGeometry</name>
      <anchor>setGeometry</anchor>
      <arglist>( const QRect &amp; r ) = 0</arglist>
    </member>
    <member kind="function">
      <name>iterator</name>
      <anchor>iterator</anchor>
      <arglist>() = 0</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>supportsMargin</name>
      <anchor>supportsMargin</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setEnabled</name>
      <anchor>setEnabled</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>isEnabled</name>
      <anchor>isEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>margin</anchor>
      <arglist>- the width of the outside border of the layout</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>resizeMode</anchor>
      <arglist>- the resize mode of the layout</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>spacing</anchor>
      <arglist>- the spacing between widgets inside the layout</arglist>
    </member>
    <member kind="function">
      <name>addChildLayout</name>
      <anchor>addChildLayout</anchor>
      <arglist>( QLayout * l )</arglist>
    </member>
    <member kind="function">
      <name>deleteAllItems</name>
      <anchor>deleteAllItems</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setSupportsMargin</name>
      <anchor>setSupportsMargin</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>alignmentRect</name>
      <anchor>alignmentRect</anchor>
      <arglist>( const QRect &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>sizeHint</name>
      <anchor>sizeHint</anchor>
      <arglist>(); it</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QLayoutItem</name>
    <filename>qlayoutitem.html</filename>
    <member kind="function">
      <name>QLayoutItem</name>
      <anchor>QLayoutItem</anchor>
      <arglist>( int alignment = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QLayoutItem</name>
      <anchor>QLayoutItem</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>sizeHint</name>
      <anchor>sizeHint</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>minimumSize</name>
      <anchor>minimumSize</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>maximumSize</name>
      <anchor>maximumSize</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>expanding</name>
      <anchor>expanding</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>setGeometry</name>
      <anchor>setGeometry</anchor>
      <arglist>( const QRect &amp; r ) = 0</arglist>
    </member>
    <member kind="function">
      <name>geometry</name>
      <anchor>geometry</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>hasHeightForWidth</name>
      <anchor>hasHeightForWidth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>heightForWidth</name>
      <anchor>heightForWidth</anchor>
      <arglist>( int w ) const</arglist>
    </member>
    <member kind="function">
      <name>invalidate</name>
      <anchor>invalidate</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>widget</name>
      <anchor>widget</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>iterator</name>
      <anchor>iterator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>layout</name>
      <anchor>layout</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>spacerItem</name>
      <anchor>spacerItem</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>alignment</name>
      <anchor>alignment</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAlignment</name>
      <anchor>setAlignment</anchor>
      <arglist>( int a )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QLayoutIterator</name>
    <filename>qlayoutiterator.html</filename>
    <member kind="function">
      <name>QLayoutIterator</name>
      <anchor>QLayoutIterator</anchor>
      <arglist>( QGLayoutIterator * gi )</arglist>
    </member>
    <member kind="function">
      <name>QLayoutIterator</name>
      <anchor>QLayoutIterator</anchor>
      <arglist>( const QLayoutIterator &amp; i )</arglist>
    </member>
    <member kind="function">
      <name>QLayoutIterator</name>
      <anchor>QLayoutIterator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QLayoutIterator &amp; i )</arglist>
    </member>
    <member kind="function">
      <name>operator++</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>current</name>
      <anchor>current</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>takeCurrent</name>
      <anchor>takeCurrent</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>deleteCurrent</name>
      <anchor>deleteCurrent</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QLCDNumber</name>
    <filename>qlcdnumber.html</filename>
    <member kind="function">
      <name>QLCDNumber</name>
      <anchor>QLCDNumber</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QLCDNumber</name>
      <anchor>QLCDNumber</anchor>
      <arglist>( uint numDigits, QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QLCDNumber</name>
      <anchor>QLCDNumber</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Mode</anchor>
      <arglist>{ Hex, Dec, Oct, Bin, HEX = Hex, DEC = Dec, OCT = Oct, BIN = Bin }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>SegmentStyle</anchor>
      <arglist>{ Outline, Filled, Flat }</arglist>
    </member>
    <member kind="function">
      <name>smallDecimalPoint</name>
      <anchor>smallDecimalPoint</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>numDigits</name>
      <anchor>numDigits</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setNumDigits</name>
      <anchor>setNumDigits</anchor>
      <arglist>( int nDigits )</arglist>
    </member>
    <member kind="function">
      <name>checkOverflow</name>
      <anchor>checkOverflow</anchor>
      <arglist>( double num ) const</arglist>
    </member>
    <member kind="function">
      <name>checkOverflow</name>
      <anchor>checkOverflow</anchor>
      <arglist>( int num ) const</arglist>
    </member>
    <member kind="function">
      <name>mode</name>
      <anchor>mode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMode</name>
      <anchor>setMode</anchor>
      <arglist>( Mode )</arglist>
    </member>
    <member kind="function">
      <name>segmentStyle</name>
      <anchor>segmentStyle</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSegmentStyle</name>
      <anchor>setSegmentStyle</anchor>
      <arglist>( SegmentStyle )</arglist>
    </member>
    <member kind="function">
      <name>value</name>
      <anchor>value</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>intValue</name>
      <anchor>intValue</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>display</name>
      <anchor>display</anchor>
      <arglist>( const QString &amp; s )</arglist>
    </member>
    <member kind="function">
      <name>display</name>
      <anchor>display</anchor>
      <arglist>( int num )</arglist>
    </member>
    <member kind="function">
      <name>display</name>
      <anchor>display</anchor>
      <arglist>( double num )</arglist>
    </member>
    <member kind="function">
      <name>setHexMode</name>
      <anchor>setHexMode</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setDecMode</name>
      <anchor>setDecMode</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setOctMode</name>
      <anchor>setOctMode</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setBinMode</name>
      <anchor>setBinMode</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setSmallDecimalPoint</name>
      <anchor>setSmallDecimalPoint</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>overflow</name>
      <anchor>overflow</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>intValue</anchor>
      <arglist>- the displayed value rounded to the nearest integer</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>mode</anchor>
      <arglist>- the current display mode (number base)</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>numDigits</anchor>
      <arglist>- the current number of digits displayed</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>segmentStyle</anchor>
      <arglist>- the style of the LCDNumber</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>smallDecimalPoint</anchor>
      <arglist>- the style of the decimal point</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>value</anchor>
      <arglist>- the displayed value</arglist>
    </member>
    <member kind="function">
      <name>drawContents</name>
      <anchor>drawContents</anchor>
      <arglist>( QPainter * p )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QLibrary</name>
    <filename>qlibrary.html</filename>
    <member kind="function">
      <name>QLibrary</name>
      <anchor>QLibrary</anchor>
      <arglist>( const QString &amp; filename )</arglist>
    </member>
    <member kind="function">
      <name>QLibrary</name>
      <anchor>QLibrary</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>resolve</name>
      <anchor>resolve</anchor>
      <arglist>( const char * symb )</arglist>
    </member>
    <member kind="function">
      <name>load</name>
      <anchor>load</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>unload</name>
      <anchor>unload</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>isLoaded</name>
      <anchor>isLoaded</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>autoUnload</name>
      <anchor>autoUnload</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoUnload</name>
      <anchor>setAutoUnload</anchor>
      <arglist>( bool enabled )</arglist>
    </member>
    <member kind="function">
      <name>library</name>
      <anchor>library</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>resolve</name>
      <anchor>resolve</anchor>
      <arglist>( const QString &amp; filename, const char * symb )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QLineEdit</name>
    <filename>qlineedit.html</filename>
    <member kind="function">
      <name>QLineEdit</name>
      <anchor>QLineEdit</anchor>
      <arglist>( QWidget * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QLineEdit</name>
      <anchor>QLineEdit</anchor>
      <arglist>( const QString &amp; contents, QWidget * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QLineEdit</name>
      <anchor>QLineEdit</anchor>
      <arglist>( const QString &amp; contents, const QString &amp; inputMask, QWidget * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QLineEdit</name>
      <anchor>QLineEdit</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>displayText</name>
      <anchor>displayText</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>maxLength</name>
      <anchor>maxLength</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>frame</name>
      <anchor>frame</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>EchoMode</anchor>
      <arglist>{ Normal, NoEcho, Password }</arglist>
    </member>
    <member kind="function">
      <name>echoMode</name>
      <anchor>echoMode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isReadOnly</name>
      <anchor>isReadOnly</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>validator</name>
      <anchor>validator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>sizeHint</name>
      <anchor>sizeHint</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>minimumSizeHint</name>
      <anchor>minimumSizeHint</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>cursorPosition</name>
      <anchor>cursorPosition</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>alignment</name>
      <anchor>alignment</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>cursorForward</name>
      <anchor>cursorForward</anchor>
      <arglist>( bool mark, int steps = 1 )</arglist>
    </member>
    <member kind="function">
      <name>cursorBackward</name>
      <anchor>cursorBackward</anchor>
      <arglist>( bool mark, int steps = 1 )</arglist>
    </member>
    <member kind="function">
      <name>cursorWordForward</name>
      <anchor>cursorWordForward</anchor>
      <arglist>( bool mark )</arglist>
    </member>
    <member kind="function">
      <name>cursorWordBackward</name>
      <anchor>cursorWordBackward</anchor>
      <arglist>( bool mark )</arglist>
    </member>
    <member kind="function">
      <name>backspace</name>
      <anchor>backspace</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>del</name>
      <anchor>del</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>home</name>
      <anchor>home</anchor>
      <arglist>( bool mark )</arglist>
    </member>
    <member kind="function">
      <name>end</name>
      <anchor>end</anchor>
      <arglist>( bool mark )</arglist>
    </member>
    <member kind="function">
      <name>isModified</name>
      <anchor>isModified</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>clearModified</name>
      <anchor>clearModified</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>hasSelectedText</name>
      <anchor>hasSelectedText</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>selectedText</name>
      <anchor>selectedText</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>selectionStart</name>
      <anchor>selectionStart</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isUndoAvailable</name>
      <anchor>isUndoAvailable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isRedoAvailable</name>
      <anchor>isRedoAvailable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>dragEnabled</name>
      <anchor>dragEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>inputMask</name>
      <anchor>inputMask</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setInputMask</name>
      <anchor>setInputMask</anchor>
      <arglist>( const QString &amp; inputMask )</arglist>
    </member>
    <member kind="function">
      <name>hasAcceptableInput</name>
      <anchor>hasAcceptableInput</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setText</name>
      <anchor>setText</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>selectAll</name>
      <anchor>selectAll</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>deselect</name>
      <anchor>deselect</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>clearValidator</name>
      <anchor>clearValidator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>insert</name>
      <anchor>insert</anchor>
      <arglist>( const QString &amp; newText )</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>undo</name>
      <anchor>undo</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>redo</name>
      <anchor>redo</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setMaxLength</name>
      <anchor>setMaxLength</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>setFrame</name>
      <anchor>setFrame</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>setEchoMode</name>
      <anchor>setEchoMode</anchor>
      <arglist>( EchoMode )</arglist>
    </member>
    <member kind="function">
      <name>setReadOnly</name>
      <anchor>setReadOnly</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>setValidator</name>
      <anchor>setValidator</anchor>
      <arglist>( const QValidator * v )</arglist>
    </member>
    <member kind="function">
      <name>setSelection</name>
      <anchor>setSelection</anchor>
      <arglist>( int start, int length )</arglist>
    </member>
    <member kind="function">
      <name>setCursorPosition</name>
      <anchor>setCursorPosition</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>setAlignment</name>
      <anchor>setAlignment</anchor>
      <arglist>( int flag )</arglist>
    </member>
    <member kind="function">
      <name>cut</name>
      <anchor>cut</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>copy</name>
      <anchor>copy</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>paste</name>
      <anchor>paste</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setDragEnabled</name>
      <anchor>setDragEnabled</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>textChanged</name>
      <anchor>textChanged</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>returnPressed</name>
      <anchor>returnPressed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>lostFocus</name>
      <anchor>lostFocus</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>selectionChanged</name>
      <anchor>selectionChanged</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>acceptableInput</anchor>
      <arglist>- holds whether the input satisfies the inputMask and the validator</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>alignment</anchor>
      <arglist>- the alignment of the line edit</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>cursorPosition</anchor>
      <arglist>- the current cursor position for this line edit</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>displayText</anchor>
      <arglist>- the displayed text</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>dragEnabled</anchor>
      <arglist>- whether the lineedit starts a drag if the user presses and moves the mouse on some selected text</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>echoMode</anchor>
      <arglist>- the line edit&apos;s echo mode</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>frame</anchor>
      <arglist>- whether the line edit draws itself with a frame</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>hasSelectedText</anchor>
      <arglist>- whether there is any text selected</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>inputMask</anchor>
      <arglist>- the validation input mask</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>maxLength</anchor>
      <arglist>- the maximum permitted length of the text</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>modified</anchor>
      <arglist>- whether the line edit&apos;s content has been modified by the user</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>readOnly</anchor>
      <arglist>- whether the line edit is read only</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>redoAvailable</anchor>
      <arglist>- whether redo is available</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>selectedText</anchor>
      <arglist>- the selected text</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>text</anchor>
      <arglist>- the line edit&apos;s text</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>undoAvailable</anchor>
      <arglist>- whether undo is available</arglist>
    </member>
    <member kind="function">
      <name>keyPressEvent</name>
      <anchor>keyPressEvent</anchor>
      <arglist>( QKeyEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>createPopupMenu</name>
      <anchor>createPopupMenu</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QList</name>
    <filename>qlist.html</filename>
  </compound>
  <compound kind="class">
    <name>QListBox</name>
    <filename>qlistbox.html</filename>
    <member kind="function">
      <name>QListBox</name>
      <anchor>QListBox</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QListBox</name>
      <anchor>QListBox</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>insertStringList</name>
      <anchor>insertStringList</anchor>
      <arglist>( const QStringList &amp; list, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertStrList</name>
      <anchor>insertStrList</anchor>
      <arglist>( const QStrList * list, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertStrList</name>
      <anchor>insertStrList</anchor>
      <arglist>( const QStrList &amp; list, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertStrList</name>
      <anchor>insertStrList</anchor>
      <arglist>( const char ** strings, int numStrings = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QListBoxItem * lbi, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QListBoxItem * lbi, const QListBoxItem * after )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QString &amp; text, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QPixmap &amp; pixmap, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QPixmap &amp; pixmap, const QString &amp; text, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>removeItem</name>
      <anchor>removeItem</anchor>
      <arglist>( int index )</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>( int index ) const</arglist>
    </member>
    <member kind="function">
      <name>pixmap</name>
      <anchor>pixmap</anchor>
      <arglist>( int index ) const</arglist>
    </member>
    <member kind="function">
      <name>changeItem</name>
      <anchor>changeItem</anchor>
      <arglist>( const QListBoxItem * lbi, int index )</arglist>
    </member>
    <member kind="function">
      <name>changeItem</name>
      <anchor>changeItem</anchor>
      <arglist>( const QString &amp; text, int index )</arglist>
    </member>
    <member kind="function">
      <name>changeItem</name>
      <anchor>changeItem</anchor>
      <arglist>( const QPixmap &amp; pixmap, int index )</arglist>
    </member>
    <member kind="function">
      <name>changeItem</name>
      <anchor>changeItem</anchor>
      <arglist>( const QPixmap &amp; pixmap, const QString &amp; text, int index )</arglist>
    </member>
    <member kind="function">
      <name>takeItem</name>
      <anchor>takeItem</anchor>
      <arglist>( const QListBoxItem * item )</arglist>
    </member>
    <member kind="function">
      <name>numItemsVisible</name>
      <anchor>numItemsVisible</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>currentItem</name>
      <anchor>currentItem</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>currentText</name>
      <anchor>currentText</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setCurrentItem</name>
      <anchor>setCurrentItem</anchor>
      <arglist>( int index )</arglist>
    </member>
    <member kind="function">
      <name>setCurrentItem</name>
      <anchor>setCurrentItem</anchor>
      <arglist>( QListBoxItem * i )</arglist>
    </member>
    <member kind="function">
      <name>centerCurrentItem</name>
      <anchor>centerCurrentItem</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>topItem</name>
      <anchor>topItem</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setTopItem</name>
      <anchor>setTopItem</anchor>
      <arglist>( int index )</arglist>
    </member>
    <member kind="function">
      <name>setBottomItem</name>
      <anchor>setBottomItem</anchor>
      <arglist>( int index )</arglist>
    </member>
    <member kind="function">
      <name>maxItemWidth</name>
      <anchor>maxItemWidth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>SelectionMode</anchor>
      <arglist>{ Single, Multi, Extended, NoSelection }</arglist>
    </member>
    <member kind="function">
      <name>setSelectionMode</name>
      <anchor>setSelectionMode</anchor>
      <arglist>( SelectionMode )</arglist>
    </member>
    <member kind="function">
      <name>selectionMode</name>
      <anchor>selectionMode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSelected</name>
      <anchor>setSelected</anchor>
      <arglist>( QListBoxItem * item, bool select )</arglist>
    </member>
    <member kind="function">
      <name>setSelected</name>
      <anchor>setSelected</anchor>
      <arglist>( int index, bool select )</arglist>
    </member>
    <member kind="function">
      <name>isSelected</name>
      <anchor>isSelected</anchor>
      <arglist>( int i ) const</arglist>
    </member>
    <member kind="function">
      <name>isSelected</name>
      <anchor>isSelected</anchor>
      <arglist>( const QListBoxItem * i ) const</arglist>
    </member>
    <member kind="function">
      <name>selectedItem</name>
      <anchor>selectedItem</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>item</name>
      <anchor>item</anchor>
      <arglist>( int index ) const</arglist>
    </member>
    <member kind="function">
      <name>index</name>
      <anchor>index</anchor>
      <arglist>( const QListBoxItem * lbi ) const</arglist>
    </member>
    <member kind="function">
      <name>findItem</name>
      <anchor>findItem</anchor>
      <arglist>( const QString &amp; text, ComparisonFlags compare = BeginsWith ) const</arglist>
    </member>
    <member kind="function">
      <name>triggerUpdate</name>
      <anchor>triggerUpdate</anchor>
      <arglist>( bool doLayout )</arglist>
    </member>
    <member kind="function">
      <name>itemVisible</name>
      <anchor>itemVisible</anchor>
      <arglist>( int index )</arglist>
    </member>
    <member kind="function">
      <name>itemVisible</name>
      <anchor>itemVisible</anchor>
      <arglist>( const QListBoxItem * item )</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>LayoutMode</anchor>
      <arglist>{ FixedNumber, FitToWidth, FitToHeight = FitToWidth, Variable }</arglist>
    </member>
    <member kind="function">
      <name>setColumnMode</name>
      <anchor>setColumnMode</anchor>
      <arglist>( LayoutMode )</arglist>
    </member>
    <member kind="function">
      <name>setColumnMode</name>
      <anchor>setColumnMode</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>setRowMode</name>
      <anchor>setRowMode</anchor>
      <arglist>( LayoutMode )</arglist>
    </member>
    <member kind="function">
      <name>setRowMode</name>
      <anchor>setRowMode</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>columnMode</name>
      <anchor>columnMode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rowMode</name>
      <anchor>rowMode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>numColumns</name>
      <anchor>numColumns</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>numRows</name>
      <anchor>numRows</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>variableWidth</name>
      <anchor>variableWidth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setVariableWidth</name>
      <anchor>setVariableWidth</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>variableHeight</name>
      <anchor>variableHeight</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setVariableHeight</name>
      <anchor>setVariableHeight</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>autoScrollBar</name>
      <anchor>autoScrollBar</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoScrollBar</name>
      <anchor>setAutoScrollBar</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>scrollBar</name>
      <anchor>scrollBar</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setScrollBar</name>
      <anchor>setScrollBar</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>autoBottomScrollBar</name>
      <anchor>autoBottomScrollBar</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoBottomScrollBar</name>
      <anchor>setAutoBottomScrollBar</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>bottomScrollBar</name>
      <anchor>bottomScrollBar</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setBottomScrollBar</name>
      <anchor>setBottomScrollBar</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>itemHeight</name>
      <anchor>itemHeight</anchor>
      <arglist>( int index = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>itemAt</name>
      <anchor>itemAt</anchor>
      <arglist>( const QPoint &amp; p ) const</arglist>
    </member>
    <member kind="function">
      <name>itemRect</name>
      <anchor>itemRect</anchor>
      <arglist>( QListBoxItem * item ) const</arglist>
    </member>
    <member kind="function">
      <name>firstItem</name>
      <anchor>firstItem</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>sort</name>
      <anchor>sort</anchor>
      <arglist>( bool ascending = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>ensureCurrentVisible</name>
      <anchor>ensureCurrentVisible</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>clearSelection</name>
      <anchor>clearSelection</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>selectAll</name>
      <anchor>selectAll</anchor>
      <arglist>( bool select )</arglist>
    </member>
    <member kind="function">
      <name>invertSelection</name>
      <anchor>invertSelection</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>highlighted</name>
      <anchor>highlighted</anchor>
      <arglist>( int index )</arglist>
    </member>
    <member kind="function">
      <name>selected</name>
      <anchor>selected</anchor>
      <arglist>( int index )</arglist>
    </member>
    <member kind="function">
      <name>highlighted</name>
      <anchor>highlighted</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>selected</name>
      <anchor>selected</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>highlighted</name>
      <anchor>highlighted</anchor>
      <arglist>( QListBoxItem * )</arglist>
    </member>
    <member kind="function">
      <name>selected</name>
      <anchor>selected</anchor>
      <arglist>( QListBoxItem * )</arglist>
    </member>
    <member kind="function">
      <name>selectionChanged</name>
      <anchor>selectionChanged</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>selectionChanged</name>
      <anchor>selectionChanged</anchor>
      <arglist>( QListBoxItem * item )</arglist>
    </member>
    <member kind="function">
      <name>currentChanged</name>
      <anchor>currentChanged</anchor>
      <arglist>( QListBoxItem * item )</arglist>
    </member>
    <member kind="function">
      <name>clicked</name>
      <anchor>clicked</anchor>
      <arglist>( QListBoxItem * item )</arglist>
    </member>
    <member kind="function">
      <name>clicked</name>
      <anchor>clicked</anchor>
      <arglist>( QListBoxItem * item, const QPoint &amp; pnt )</arglist>
    </member>
    <member kind="function">
      <name>pressed</name>
      <anchor>pressed</anchor>
      <arglist>( QListBoxItem * item )</arglist>
    </member>
    <member kind="function">
      <name>pressed</name>
      <anchor>pressed</anchor>
      <arglist>( QListBoxItem * item, const QPoint &amp; pnt )</arglist>
    </member>
    <member kind="function">
      <name>doubleClicked</name>
      <anchor>doubleClicked</anchor>
      <arglist>( QListBoxItem * item )</arglist>
    </member>
    <member kind="function">
      <name>returnPressed</name>
      <anchor>returnPressed</anchor>
      <arglist>( QListBoxItem * )</arglist>
    </member>
    <member kind="function">
      <name>rightButtonClicked</name>
      <anchor>rightButtonClicked</anchor>
      <arglist>( QListBoxItem *, const QPoint &amp; )</arglist>
    </member>
    <member kind="function">
      <name>rightButtonPressed</name>
      <anchor>rightButtonPressed</anchor>
      <arglist>( QListBoxItem *, const QPoint &amp; )</arglist>
    </member>
    <member kind="function">
      <name>mouseButtonPressed</name>
      <anchor>mouseButtonPressed</anchor>
      <arglist>( int button, QListBoxItem * item, const QPoint &amp; pos )</arglist>
    </member>
    <member kind="function">
      <name>mouseButtonClicked</name>
      <anchor>mouseButtonClicked</anchor>
      <arglist>( int button, QListBoxItem * item, const QPoint &amp; pos )</arglist>
    </member>
    <member kind="function">
      <name>contextMenuRequested</name>
      <anchor>contextMenuRequested</anchor>
      <arglist>( QListBoxItem * item, const QPoint &amp; pos )</arglist>
    </member>
    <member kind="function">
      <name>onItem</name>
      <anchor>onItem</anchor>
      <arglist>( QListBoxItem * i )</arglist>
    </member>
    <member kind="function">
      <name>onViewport</name>
      <anchor>onViewport</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>columnMode</anchor>
      <arglist>- the column layout mode for this list box</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>count</anchor>
      <arglist>- the number of items in the list box</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>currentItem</anchor>
      <arglist>- the current highlighted item</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>currentText</anchor>
      <arglist>- the text of the current item</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>numColumns</anchor>
      <arglist>- the number of columns in the list box</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>numItemsVisible</anchor>
      <arglist>- the number of visible items</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>numRows</anchor>
      <arglist>- the number of rows in the list box</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>rowMode</anchor>
      <arglist>- the row layout mode for this list box</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>selectionMode</anchor>
      <arglist>- the selection mode of the list box</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>topItem</anchor>
      <arglist>- the index of an item at the top of the screen</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>variableHeight</anchor>
      <arglist>- whether this list box has variable-height rows</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>variableWidth</anchor>
      <arglist>- whether this list box has variable-width columns</arglist>
    </member>
    <member kind="function">
      <name>updateItem</name>
      <anchor>updateItem</anchor>
      <arglist>( int index )</arglist>
    </member>
    <member kind="function">
      <name>updateItem</name>
      <anchor>updateItem</anchor>
      <arglist>( QListBoxItem * i )</arglist>
    </member>
    <member kind="function">
      <name>paintCell</name>
      <anchor>paintCell</anchor>
      <arglist>( QPainter * p, int row, int col )</arglist>
    </member>
    <member kind="function">
      <name>toggleCurrentItem</name>
      <anchor>toggleCurrentItem</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>isRubberSelecting</name>
      <anchor>isRubberSelecting</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>doLayout</name>
      <anchor>doLayout</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QListBoxItem</name>
    <filename>qlistboxitem.html</filename>
    <member kind="function">
      <name>QListBoxItem</name>
      <anchor>QListBoxItem</anchor>
      <arglist>( QListBox * listbox = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QListBoxItem</name>
      <anchor>QListBoxItem</anchor>
      <arglist>( QListBox * listbox, QListBoxItem * after )</arglist>
    </member>
    <member kind="function">
      <name>QListBoxItem</name>
      <anchor>QListBoxItem</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>pixmap</name>
      <anchor>pixmap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>height</name>
      <anchor>height</anchor>
      <arglist>( const QListBox * lb ) const</arglist>
    </member>
    <member kind="function">
      <name>width</name>
      <anchor>width</anchor>
      <arglist>( const QListBox * lb ) const</arglist>
    </member>
    <member kind="function">
      <name>isSelected</name>
      <anchor>isSelected</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isCurrent</name>
      <anchor>isCurrent</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>listBox</name>
      <anchor>listBox</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSelectable</name>
      <anchor>setSelectable</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>isSelectable</name>
      <anchor>isSelectable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>next</name>
      <anchor>next</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>prev</name>
      <anchor>prev</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rtti</name>
      <anchor>rtti</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>paint</name>
      <anchor>paint</anchor>
      <arglist>( QPainter * p ) = 0</arglist>
    </member>
    <member kind="function">
      <name>setText</name>
      <anchor>setText</anchor>
      <arglist>( const QString &amp; text )</arglist>
    </member>
    <member kind="function">
      <name>setCustomHighlighting</name>
      <anchor>setCustomHighlighting</anchor>
      <arglist>( bool b )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QListBoxPixmap</name>
    <filename>qlistboxpixmap.html</filename>
    <member kind="function">
      <name>QListBoxPixmap</name>
      <anchor>QListBoxPixmap</anchor>
      <arglist>( QListBox * listbox, const QPixmap &amp; pixmap )</arglist>
    </member>
    <member kind="function">
      <name>QListBoxPixmap</name>
      <anchor>QListBoxPixmap</anchor>
      <arglist>( const QPixmap &amp; pixmap )</arglist>
    </member>
    <member kind="function">
      <name>QListBoxPixmap</name>
      <anchor>QListBoxPixmap</anchor>
      <arglist>( QListBox * listbox, const QPixmap &amp; pixmap, QListBoxItem * after )</arglist>
    </member>
    <member kind="function">
      <name>QListBoxPixmap</name>
      <anchor>QListBoxPixmap</anchor>
      <arglist>( QListBox * listbox, const QPixmap &amp; pix, const QString &amp; text )</arglist>
    </member>
    <member kind="function">
      <name>QListBoxPixmap</name>
      <anchor>QListBoxPixmap</anchor>
      <arglist>( const QPixmap &amp; pix, const QString &amp; text )</arglist>
    </member>
    <member kind="function">
      <name>QListBoxPixmap</name>
      <anchor>QListBoxPixmap</anchor>
      <arglist>( QListBox * listbox, const QPixmap &amp; pix, const QString &amp; text, QListBoxItem * after )</arglist>
    </member>
    <member kind="function">
      <name>QListBoxPixmap</name>
      <anchor>QListBoxPixmap</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>pixmap</name>
      <anchor>pixmap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>height</name>
      <anchor>height</anchor>
      <arglist>( const QListBox * lb ) const</arglist>
    </member>
    <member kind="function">
      <name>width</name>
      <anchor>width</anchor>
      <arglist>( const QListBox * lb ) const</arglist>
    </member>
    <member kind="function">
      <name>paint</name>
      <anchor>paint</anchor>
      <arglist>( QPainter * painter )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QListBoxText</name>
    <filename>qlistboxtext.html</filename>
    <member kind="function">
      <name>QListBoxText</name>
      <anchor>QListBoxText</anchor>
      <arglist>( QListBox * listbox, const QString &amp; text = QString::null )</arglist>
    </member>
    <member kind="function">
      <name>QListBoxText</name>
      <anchor>QListBoxText</anchor>
      <arglist>( const QString &amp; text = QString::null )</arglist>
    </member>
    <member kind="function">
      <name>QListBoxText</name>
      <anchor>QListBoxText</anchor>
      <arglist>( QListBox * listbox, const QString &amp; text, QListBoxItem * after )</arglist>
    </member>
    <member kind="function">
      <name>QListBoxText</name>
      <anchor>QListBoxText</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>height</name>
      <anchor>height</anchor>
      <arglist>( const QListBox * lb ) const</arglist>
    </member>
    <member kind="function">
      <name>width</name>
      <anchor>width</anchor>
      <arglist>( const QListBox * lb ) const</arglist>
    </member>
    <member kind="function">
      <name>paint</name>
      <anchor>paint</anchor>
      <arglist>( QPainter * painter )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QListIterator</name>
    <filename>qlistiterator.html</filename>
  </compound>
  <compound kind="class">
    <name>QListView</name>
    <filename>qlistview.html</filename>
    <member kind="function">
      <name>QListView</name>
      <anchor>QListView</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QListView</name>
      <anchor>QListView</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>treeStepSize</name>
      <anchor>treeStepSize</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setTreeStepSize</name>
      <anchor>setTreeStepSize</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( QListViewItem * i )</arglist>
    </member>
    <member kind="function">
      <name>takeItem</name>
      <anchor>takeItem</anchor>
      <arglist>( QListViewItem * i )</arglist>
    </member>
    <member kind="function">
      <name>header</name>
      <anchor>header</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>addColumn</name>
      <anchor>addColumn</anchor>
      <arglist>( const QString &amp; label, int width = -1 )</arglist>
    </member>
    <member kind="function">
      <name>addColumn</name>
      <anchor>addColumn</anchor>
      <arglist>( const QIconSet &amp; iconset, const QString &amp; label, int width = -1 )</arglist>
    </member>
    <member kind="function">
      <name>removeColumn</name>
      <anchor>removeColumn</anchor>
      <arglist>( int index )</arglist>
    </member>
    <member kind="function">
      <name>setColumnText</name>
      <anchor>setColumnText</anchor>
      <arglist>( int column, const QString &amp; label )</arglist>
    </member>
    <member kind="function">
      <name>setColumnText</name>
      <anchor>setColumnText</anchor>
      <arglist>( int column, const QIconSet &amp; iconset, const QString &amp; label )</arglist>
    </member>
    <member kind="function">
      <name>columnText</name>
      <anchor>columnText</anchor>
      <arglist>( int c ) const</arglist>
    </member>
    <member kind="function">
      <name>setColumnWidth</name>
      <anchor>setColumnWidth</anchor>
      <arglist>( int column, int w )</arglist>
    </member>
    <member kind="function">
      <name>columnWidth</name>
      <anchor>columnWidth</anchor>
      <arglist>( int c ) const</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>WidthMode</anchor>
      <arglist>{ Manual, Maximum }</arglist>
    </member>
    <member kind="function">
      <name>setColumnWidthMode</name>
      <anchor>setColumnWidthMode</anchor>
      <arglist>( int c, WidthMode mode )</arglist>
    </member>
    <member kind="function">
      <name>columnWidthMode</name>
      <anchor>columnWidthMode</anchor>
      <arglist>( int c ) const</arglist>
    </member>
    <member kind="function">
      <name>columns</name>
      <anchor>columns</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setColumnAlignment</name>
      <anchor>setColumnAlignment</anchor>
      <arglist>( int column, int align )</arglist>
    </member>
    <member kind="function">
      <name>columnAlignment</name>
      <anchor>columnAlignment</anchor>
      <arglist>( int column ) const</arglist>
    </member>
    <member kind="function">
      <name>itemAt</name>
      <anchor>itemAt</anchor>
      <arglist>( const QPoint &amp; viewPos ) const</arglist>
    </member>
    <member kind="function">
      <name>itemRect</name>
      <anchor>itemRect</anchor>
      <arglist>( const QListViewItem * i ) const</arglist>
    </member>
    <member kind="function">
      <name>itemPos</name>
      <anchor>itemPos</anchor>
      <arglist>( const QListViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>ensureItemVisible</name>
      <anchor>ensureItemVisible</anchor>
      <arglist>( const QListViewItem * i )</arglist>
    </member>
    <member kind="function">
      <name>repaintItem</name>
      <anchor>repaintItem</anchor>
      <arglist>( const QListViewItem * item ) const</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>SelectionMode</anchor>
      <arglist>{ Single, Multi, Extended, NoSelection }</arglist>
    </member>
    <member kind="function">
      <name>setSelectionMode</name>
      <anchor>setSelectionMode</anchor>
      <arglist>( SelectionMode mode )</arglist>
    </member>
    <member kind="function">
      <name>selectionMode</name>
      <anchor>selectionMode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>clearSelection</name>
      <anchor>clearSelection</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setSelected</name>
      <anchor>setSelected</anchor>
      <arglist>( QListViewItem * item, bool selected )</arglist>
    </member>
    <member kind="function">
      <name>setSelectionAnchor</name>
      <anchor>setSelectionAnchor</anchor>
      <arglist>( QListViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>isSelected</name>
      <anchor>isSelected</anchor>
      <arglist>( const QListViewItem * i ) const</arglist>
    </member>
    <member kind="function">
      <name>selectedItem</name>
      <anchor>selectedItem</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setOpen</name>
      <anchor>setOpen</anchor>
      <arglist>( QListViewItem * item, bool open )</arglist>
    </member>
    <member kind="function">
      <name>isOpen</name>
      <anchor>isOpen</anchor>
      <arglist>( const QListViewItem * item ) const</arglist>
    </member>
    <member kind="function">
      <name>setCurrentItem</name>
      <anchor>setCurrentItem</anchor>
      <arglist>( QListViewItem * i )</arglist>
    </member>
    <member kind="function">
      <name>currentItem</name>
      <anchor>currentItem</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>firstChild</name>
      <anchor>firstChild</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>lastItem</name>
      <anchor>lastItem</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>childCount</name>
      <anchor>childCount</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAllColumnsShowFocus</name>
      <anchor>setAllColumnsShowFocus</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>allColumnsShowFocus</name>
      <anchor>allColumnsShowFocus</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setItemMargin</name>
      <anchor>setItemMargin</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>itemMargin</name>
      <anchor>itemMargin</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setRootIsDecorated</name>
      <anchor>setRootIsDecorated</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>rootIsDecorated</name>
      <anchor>rootIsDecorated</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSorting</name>
      <anchor>setSorting</anchor>
      <arglist>( int column, bool ascending = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>sortColumn</name>
      <anchor>sortColumn</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSortColumn</name>
      <anchor>setSortColumn</anchor>
      <arglist>( int column )</arglist>
    </member>
    <member kind="function">
      <name>sortOrder</name>
      <anchor>sortOrder</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSortOrder</name>
      <anchor>setSortOrder</anchor>
      <arglist>( SortOrder order )</arglist>
    </member>
    <member kind="function">
      <name>sort</name>
      <anchor>sort</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eventFilter</name>
      <anchor>eventFilter</anchor>
      <arglist>( QObject * o, QEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>setShowSortIndicator</name>
      <anchor>setShowSortIndicator</anchor>
      <arglist>( bool show )</arglist>
    </member>
    <member kind="function">
      <name>showSortIndicator</name>
      <anchor>showSortIndicator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setShowToolTips</name>
      <anchor>setShowToolTips</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>showToolTips</name>
      <anchor>showToolTips</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ResizeMode</anchor>
      <arglist>{ NoColumn, AllColumns, LastColumn }</arglist>
    </member>
    <member kind="function">
      <name>setResizeMode</name>
      <anchor>setResizeMode</anchor>
      <arglist>( ResizeMode m )</arglist>
    </member>
    <member kind="function">
      <name>resizeMode</name>
      <anchor>resizeMode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>findItem</name>
      <anchor>findItem</anchor>
      <arglist>( const QString &amp; text, int column, ComparisonFlags compare = ExactMatch | CaseSensitive ) const</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>RenameAction</anchor>
      <arglist>{ Accept, Reject }</arglist>
    </member>
    <member kind="function">
      <name>setDefaultRenameAction</name>
      <anchor>setDefaultRenameAction</anchor>
      <arglist>( RenameAction a )</arglist>
    </member>
    <member kind="function">
      <name>defaultRenameAction</name>
      <anchor>defaultRenameAction</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isRenaming</name>
      <anchor>isRenaming</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>hideColumn</name>
      <anchor>hideColumn</anchor>
      <arglist>( int column )</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>invertSelection</name>
      <anchor>invertSelection</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>selectAll</name>
      <anchor>selectAll</anchor>
      <arglist>( bool select )</arglist>
    </member>
    <member kind="function">
      <name>triggerUpdate</name>
      <anchor>triggerUpdate</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>adjustColumn</name>
      <anchor>adjustColumn</anchor>
      <arglist>( int col )</arglist>
    </member>
    <member kind="function">
      <name>selectionChanged</name>
      <anchor>selectionChanged</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>selectionChanged</name>
      <anchor>selectionChanged</anchor>
      <arglist>( QListViewItem * )</arglist>
    </member>
    <member kind="function">
      <name>currentChanged</name>
      <anchor>currentChanged</anchor>
      <arglist>( QListViewItem * )</arglist>
    </member>
    <member kind="function">
      <name>clicked</name>
      <anchor>clicked</anchor>
      <arglist>( QListViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>clicked</name>
      <anchor>clicked</anchor>
      <arglist>( QListViewItem * item, const QPoint &amp; pnt, int c )</arglist>
    </member>
    <member kind="function">
      <name>pressed</name>
      <anchor>pressed</anchor>
      <arglist>( QListViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>pressed</name>
      <anchor>pressed</anchor>
      <arglist>( QListViewItem * item, const QPoint &amp; pnt, int c )</arglist>
    </member>
    <member kind="function">
      <name>doubleClicked</name>
      <anchor>doubleClicked</anchor>
      <arglist>( QListViewItem *, const QPoint &amp;, int )</arglist>
    </member>
    <member kind="function">
      <name>returnPressed</name>
      <anchor>returnPressed</anchor>
      <arglist>( QListViewItem * )</arglist>
    </member>
    <member kind="function">
      <name>spacePressed</name>
      <anchor>spacePressed</anchor>
      <arglist>( QListViewItem * )</arglist>
    </member>
    <member kind="function">
      <name>rightButtonClicked</name>
      <anchor>rightButtonClicked</anchor>
      <arglist>( QListViewItem *, const QPoint &amp;, int )</arglist>
    </member>
    <member kind="function">
      <name>rightButtonPressed</name>
      <anchor>rightButtonPressed</anchor>
      <arglist>( QListViewItem *, const QPoint &amp;, int )</arglist>
    </member>
    <member kind="function">
      <name>mouseButtonPressed</name>
      <anchor>mouseButtonPressed</anchor>
      <arglist>( int button, QListViewItem * item, const QPoint &amp; pos, int c )</arglist>
    </member>
    <member kind="function">
      <name>mouseButtonClicked</name>
      <anchor>mouseButtonClicked</anchor>
      <arglist>( int button, QListViewItem * item, const QPoint &amp; pos, int c )</arglist>
    </member>
    <member kind="function">
      <name>contextMenuRequested</name>
      <anchor>contextMenuRequested</anchor>
      <arglist>( QListViewItem * item, const QPoint &amp; pos, int col )</arglist>
    </member>
    <member kind="function">
      <name>onItem</name>
      <anchor>onItem</anchor>
      <arglist>( QListViewItem * i )</arglist>
    </member>
    <member kind="function">
      <name>onViewport</name>
      <anchor>onViewport</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>expanded</name>
      <anchor>expanded</anchor>
      <arglist>( QListViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>collapsed</name>
      <anchor>collapsed</anchor>
      <arglist>( QListViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>dropped</name>
      <anchor>dropped</anchor>
      <arglist>( QDropEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>itemRenamed</name>
      <anchor>itemRenamed</anchor>
      <arglist>( QListViewItem * item, int col, const QString &amp; text )</arglist>
    </member>
    <member kind="function">
      <name>itemRenamed</name>
      <anchor>itemRenamed</anchor>
      <arglist>( QListViewItem * item, int col )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>allColumnsShowFocus</anchor>
      <arglist>- whether items should show keyboard focus using all columns</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>childCount</anchor>
      <arglist>- the number of parentless (top-level) QListViewItem objects in this QListView</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>columns</anchor>
      <arglist>- the number of columns in this list view</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>defaultRenameAction</anchor>
      <arglist>- whether the list view accepts the rename operation by default</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>itemMargin</anchor>
      <arglist>- the advisory item margin that list items may use</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>resizeMode</anchor>
      <arglist>- whether all, none or the only the last column should be resized</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>rootIsDecorated</anchor>
      <arglist>- whether the list view shows open/close signs on root items</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>selectionMode</anchor>
      <arglist>- the list view&apos;s selection mode</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>showSortIndicator</anchor>
      <arglist>- whether the list view header should display a sort indicator</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>showToolTips</anchor>
      <arglist>- whether this list view should show tooltips for truncated column texts</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>treeStepSize</anchor>
      <arglist>- the number of pixels a child is offset from its parent</arglist>
    </member>
    <member kind="function">
      <name>contentsMousePressEvent</name>
      <anchor>contentsMousePressEvent</anchor>
      <arglist>( QMouseEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>contentsMouseReleaseEvent</name>
      <anchor>contentsMouseReleaseEvent</anchor>
      <arglist>( QMouseEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>contentsMouseMoveEvent</name>
      <anchor>contentsMouseMoveEvent</anchor>
      <arglist>( QMouseEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>contentsMouseDoubleClickEvent</name>
      <anchor>contentsMouseDoubleClickEvent</anchor>
      <arglist>( QMouseEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>dragObject</name>
      <anchor>dragObject</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>startDrag</name>
      <anchor>startDrag</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>resizeEvent</name>
      <anchor>resizeEvent</anchor>
      <arglist>( QResizeEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>drawContentsOffset</name>
      <anchor>drawContentsOffset</anchor>
      <arglist>( QPainter * p, int ox, int oy, int cx, int cy, int cw, int ch )</arglist>
    </member>
    <member kind="function">
      <name>paintEmptyArea</name>
      <anchor>paintEmptyArea</anchor>
      <arglist>( QPainter * p, const QRect &amp; rect )</arglist>
    </member>
    <member kind="function">
      <name>updateContents</name>
      <anchor>updateContents</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>doAutoScroll</name>
      <anchor>doAutoScroll</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QListViewItem</name>
    <filename>qlistviewitem.html</filename>
    <member kind="function">
      <name>QListViewItem</name>
      <anchor>QListViewItem</anchor>
      <arglist>( QListView * parent )</arglist>
    </member>
    <member kind="function">
      <name>QListViewItem</name>
      <anchor>QListViewItem</anchor>
      <arglist>( QListViewItem * parent )</arglist>
    </member>
    <member kind="function">
      <name>QListViewItem</name>
      <anchor>QListViewItem</anchor>
      <arglist>( QListView * parent, QListViewItem * after )</arglist>
    </member>
    <member kind="function">
      <name>QListViewItem</name>
      <anchor>QListViewItem</anchor>
      <arglist>( QListViewItem * parent, QListViewItem * after )</arglist>
    </member>
    <member kind="function">
      <name>QListViewItem</name>
      <anchor>QListViewItem</anchor>
      <arglist>( QListView * parent, QString label1, QString label2 = QString::null, QString label3 = QString::null, QString label4 = QString::null, QString label5 = QString::null, QString label6 = QString::null, QString label7 = QString::null, QString label8 = QString::null )</arglist>
    </member>
    <member kind="function">
      <name>QListViewItem</name>
      <anchor>QListViewItem</anchor>
      <arglist>( QListViewItem * parent, QString label1, QString label2 = QString::null, QString label3 = QString::null, QString label4 = QString::null, QString label5 = QString::null, QString label6 = QString::null, QString label7 = QString::null, QString label8 = QString::null )</arglist>
    </member>
    <member kind="function">
      <name>QListViewItem</name>
      <anchor>QListViewItem</anchor>
      <arglist>( QListView * parent, QListViewItem * after, QString label1, QString label2 = QString::null, QString label3 = QString::null, QString label4 = QString::null, QString label5 = QString::null, QString label6 = QString::null, QString label7 = QString::null, QString label8 = QString::null )</arglist>
    </member>
    <member kind="function">
      <name>QListViewItem</name>
      <anchor>QListViewItem</anchor>
      <arglist>( QListViewItem * parent, QListViewItem * after, QString label1, QString label2 = QString::null, QString label3 = QString::null, QString label4 = QString::null, QString label5 = QString::null, QString label6 = QString::null, QString label7 = QString::null, QString label8 = QString::null )</arglist>
    </member>
    <member kind="function">
      <name>QListViewItem</name>
      <anchor>QListViewItem</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( QListViewItem * newChild )</arglist>
    </member>
    <member kind="function">
      <name>takeItem</name>
      <anchor>takeItem</anchor>
      <arglist>( QListViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>height</name>
      <anchor>height</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>invalidateHeight</name>
      <anchor>invalidateHeight</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>totalHeight</name>
      <anchor>totalHeight</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>width</name>
      <anchor>width</anchor>
      <arglist>( const QFontMetrics &amp; fm, const QListView * lv, int c ) const</arglist>
    </member>
    <member kind="function">
      <name>widthChanged</name>
      <anchor>widthChanged</anchor>
      <arglist>( int c = -1 ) const</arglist>
    </member>
    <member kind="function">
      <name>depth</name>
      <anchor>depth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setText</name>
      <anchor>setText</anchor>
      <arglist>( int column, const QString &amp; text )</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>( int column ) const</arglist>
    </member>
    <member kind="function">
      <name>setPixmap</name>
      <anchor>setPixmap</anchor>
      <arglist>( int column, const QPixmap &amp; pm )</arglist>
    </member>
    <member kind="function">
      <name>pixmap</name>
      <anchor>pixmap</anchor>
      <arglist>( int column ) const</arglist>
    </member>
    <member kind="function">
      <name>key</name>
      <anchor>key</anchor>
      <arglist>( int column, bool ascending ) const</arglist>
    </member>
    <member kind="function">
      <name>compare</name>
      <anchor>compare</anchor>
      <arglist>( QListViewItem * i, int col, bool ascending ) const</arglist>
    </member>
    <member kind="function">
      <name>sortChildItems</name>
      <anchor>sortChildItems</anchor>
      <arglist>( int column, bool ascending )</arglist>
    </member>
    <member kind="function">
      <name>childCount</name>
      <anchor>childCount</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isOpen</name>
      <anchor>isOpen</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setOpen</name>
      <anchor>setOpen</anchor>
      <arglist>( bool o )</arglist>
    </member>
    <member kind="function">
      <name>setup</name>
      <anchor>setup</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setSelected</name>
      <anchor>setSelected</anchor>
      <arglist>( bool s )</arglist>
    </member>
    <member kind="function">
      <name>isSelected</name>
      <anchor>isSelected</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>paintCell</name>
      <anchor>paintCell</anchor>
      <arglist>( QPainter * p, const QColorGroup &amp; cg, int column, int width, int align )</arglist>
    </member>
    <member kind="function">
      <name>paintBranches</name>
      <anchor>paintBranches</anchor>
      <arglist>( QPainter * p, const QColorGroup &amp; cg, int w, int y, int h )</arglist>
    </member>
    <member kind="function">
      <name>paintFocus</name>
      <anchor>paintFocus</anchor>
      <arglist>( QPainter * p, const QColorGroup &amp; cg, const QRect &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>firstChild</name>
      <anchor>firstChild</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>nextSibling</name>
      <anchor>nextSibling</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>parent</name>
      <anchor>parent</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>itemAbove</name>
      <anchor>itemAbove</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>itemBelow</name>
      <anchor>itemBelow</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>itemPos</name>
      <anchor>itemPos</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>listView</name>
      <anchor>listView</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSelectable</name>
      <anchor>setSelectable</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>isSelectable</name>
      <anchor>isSelectable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setExpandable</name>
      <anchor>setExpandable</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>isExpandable</name>
      <anchor>isExpandable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>repaint</name>
      <anchor>repaint</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>sort</name>
      <anchor>sort</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>moveItem</name>
      <anchor>moveItem</anchor>
      <arglist>( QListViewItem * after )</arglist>
    </member>
    <member kind="function">
      <name>setDragEnabled</name>
      <anchor>setDragEnabled</anchor>
      <arglist>( bool allow )</arglist>
    </member>
    <member kind="function">
      <name>setDropEnabled</name>
      <anchor>setDropEnabled</anchor>
      <arglist>( bool allow )</arglist>
    </member>
    <member kind="function">
      <name>dragEnabled</name>
      <anchor>dragEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>dropEnabled</name>
      <anchor>dropEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>acceptDrop</name>
      <anchor>acceptDrop</anchor>
      <arglist>( const QMimeSource * mime ) const</arglist>
    </member>
    <member kind="function">
      <name>setVisible</name>
      <anchor>setVisible</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>isVisible</name>
      <anchor>isVisible</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setRenameEnabled</name>
      <anchor>setRenameEnabled</anchor>
      <arglist>( int col, bool b )</arglist>
    </member>
    <member kind="function">
      <name>renameEnabled</name>
      <anchor>renameEnabled</anchor>
      <arglist>( int col ) const</arglist>
    </member>
    <member kind="function">
      <name>startRename</name>
      <anchor>startRename</anchor>
      <arglist>( int col )</arglist>
    </member>
    <member kind="function">
      <name>setEnabled</name>
      <anchor>setEnabled</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>isEnabled</name>
      <anchor>isEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rtti</name>
      <anchor>rtti</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMultiLinesEnabled</name>
      <anchor>setMultiLinesEnabled</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>multiLinesEnabled</name>
      <anchor>multiLinesEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>enforceSortOrder</name>
      <anchor>enforceSortOrder</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setHeight</name>
      <anchor>setHeight</anchor>
      <arglist>( int height )</arglist>
    </member>
    <member kind="function">
      <name>activate</name>
      <anchor>activate</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>activatedPos</name>
      <anchor>activatedPos</anchor>
      <arglist>( QPoint &amp; pos )</arglist>
    </member>
    <member kind="function">
      <name>dropped</name>
      <anchor>dropped</anchor>
      <arglist>( QDropEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>dragEntered</name>
      <anchor>dragEntered</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>dragLeft</name>
      <anchor>dragLeft</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>okRename</name>
      <anchor>okRename</anchor>
      <arglist>( int col )</arglist>
    </member>
    <member kind="function">
      <name>cancelRename</name>
      <anchor>cancelRename</anchor>
      <arglist>( int col )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QListViewItemIterator</name>
    <filename>qlistviewitemiterator.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>IteratorFlag</anchor>
      <arglist>{ Visible = 0x00000001, Invisible = 0x00000002, Selected = 0x00000004, Unselected = 0x00000008, Selectable = 0x00000010, NotSelectable = 0x00000020, DragEnabled = 0x00000040, DragDisabled = 0x00000080, DropEnabled = 0x00000100, DropDisabled = 0x00000200, Expandable = 0x00000400, NotExpandable = 0x00000800, Checked = 0x00001000, NotChecked = 0x00002000 }</arglist>
    </member>
    <member kind="function">
      <name>QListViewItemIterator</name>
      <anchor>QListViewItemIterator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QListViewItemIterator</name>
      <anchor>QListViewItemIterator</anchor>
      <arglist>( QListViewItem * item )</arglist>
    </member>
    <member kind="function">
      <name>QListViewItemIterator</name>
      <anchor>QListViewItemIterator</anchor>
      <arglist>( QListViewItem * item, int iteratorFlags )</arglist>
    </member>
    <member kind="function">
      <name>QListViewItemIterator</name>
      <anchor>QListViewItemIterator</anchor>
      <arglist>( const QListViewItemIterator &amp; it )</arglist>
    </member>
    <member kind="function">
      <name>QListViewItemIterator</name>
      <anchor>QListViewItemIterator</anchor>
      <arglist>( QListView * lv )</arglist>
    </member>
    <member kind="function">
      <name>QListViewItemIterator</name>
      <anchor>QListViewItemIterator</anchor>
      <arglist>( QListView * lv, int iteratorFlags )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QListViewItemIterator &amp; it )</arglist>
    </member>
    <member kind="function">
      <name>QListViewItemIterator</name>
      <anchor>QListViewItemIterator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>operator++</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>operator++</name>
      <anchor>operator</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( int j )</arglist>
    </member>
    <member kind="function">
      <name>operator--</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>operator--</name>
      <anchor>operator</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( int j )</arglist>
    </member>
    <member kind="function">
      <name>operator*</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>current</name>
      <anchor>current</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QLocalFs</name>
    <filename>qlocalfs.html</filename>
    <member kind="function">
      <name>QLocalFs</name>
      <anchor>QLocalFs</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMacMime</name>
    <filename>qmacmime.html</filename>
    <member kind="function">
      <name>QMacMime</name>
      <anchor>QMacMime</anchor>
      <arglist>( char t )</arglist>
    </member>
    <member kind="function">
      <name>QMacMime</name>
      <anchor>QMacMime</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>convertorName</name>
      <anchor>convertorName</anchor>
      <arglist>() = 0</arglist>
    </member>
    <member kind="function">
      <name>countFlavors</name>
      <anchor>countFlavors</anchor>
      <arglist>() = 0</arglist>
    </member>
    <member kind="function">
      <name>flavor</name>
      <anchor>flavor</anchor>
      <arglist>( int index ) = 0</arglist>
    </member>
    <member kind="function">
      <name>canConvert</name>
      <anchor>canConvert</anchor>
      <arglist>( const char * mime, int flav ) = 0</arglist>
    </member>
    <member kind="function">
      <name>mimeFor</name>
      <anchor>mimeFor</anchor>
      <arglist>( int flav ) = 0</arglist>
    </member>
    <member kind="function">
      <name>flavorFor</name>
      <anchor>flavorFor</anchor>
      <arglist>( const char * mime ) = 0</arglist>
    </member>
    <member kind="function">
      <name>convertToMime</name>
      <anchor>convertToMime</anchor>
      <arglist>( QValueList&lt;QByteArray&gt; data, const char * mime, int flav ) = 0</arglist>
    </member>
    <member kind="function">
      <name>convertFromMime</name>
      <anchor>convertFromMime</anchor>
      <arglist>( QByteArray data, const char * mime, int flav ) = 0</arglist>
    </member>
    <member kind="function">
      <name>all</name>
      <anchor>all</anchor>
      <arglist>( QMacMimeType t )</arglist>
    </member>
    <member kind="function">
      <name>convertor</name>
      <anchor>convertor</anchor>
      <arglist>( QMacMimeType t, const char * mime, int flav )</arglist>
    </member>
    <member kind="function">
      <name>flavorToMime</name>
      <anchor>flavorToMime</anchor>
      <arglist>( QMacMimeType t, int flav )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMacStyle</name>
    <filename>qmacstyle.html</filename>
    <member kind="function">
      <name>QMacStyle</name>
      <anchor>QMacStyle</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QMacStyle</name>
      <anchor>QMacStyle</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>FocusRectPolicy</anchor>
      <arglist>{ FocusEnabled, FocusDisabled, FocusDefault }</arglist>
    </member>
    <member kind="function">
      <name>setFocusRectPolicy</name>
      <anchor>setFocusRectPolicy</anchor>
      <arglist>( QWidget * w, FocusRectPolicy policy )</arglist>
    </member>
    <member kind="function">
      <name>focusRectPolicy</name>
      <anchor>focusRectPolicy</anchor>
      <arglist>( QWidget * w )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMainWindow</name>
    <filename>qmainwindow.html</filename>
    <member kind="function">
      <name>QMainWindow</name>
      <anchor>QMainWindow</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0, WFlags f = WType_TopLevel )</arglist>
    </member>
    <member kind="function">
      <name>QMainWindow</name>
      <anchor>QMainWindow</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>menuBar</name>
      <anchor>menuBar</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>statusBar</name>
      <anchor>statusBar</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>toolTipGroup</name>
      <anchor>toolTipGroup</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setCentralWidget</name>
      <anchor>setCentralWidget</anchor>
      <arglist>( QWidget * w )</arglist>
    </member>
    <member kind="function">
      <name>centralWidget</name>
      <anchor>centralWidget</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setDockEnabled</name>
      <anchor>setDockEnabled</anchor>
      <arglist>( Dock dock, bool enable )</arglist>
    </member>
    <member kind="function">
      <name>isDockEnabled</name>
      <anchor>isDockEnabled</anchor>
      <arglist>( Dock dock ) const</arglist>
    </member>
    <member kind="function">
      <name>isDockEnabled</name>
      <anchor>isDockEnabled</anchor>
      <arglist>( QDockArea * area ) const</arglist>
    </member>
    <member kind="function">
      <name>setDockEnabled</name>
      <anchor>setDockEnabled</anchor>
      <arglist>( QDockWindow * dw, Dock dock, bool enable )</arglist>
    </member>
    <member kind="function">
      <name>isDockEnabled</name>
      <anchor>isDockEnabled</anchor>
      <arglist>( QDockWindow * tb, Dock dock ) const</arglist>
    </member>
    <member kind="function">
      <name>isDockEnabled</name>
      <anchor>isDockEnabled</anchor>
      <arglist>( QDockWindow * dw, QDockArea * area ) const</arglist>
    </member>
    <member kind="function">
      <name>addDockWindow</name>
      <anchor>addDockWindow</anchor>
      <arglist>( QDockWindow * dockWindow, Dock edge = DockTop, bool newLine = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>addDockWindow</name>
      <anchor>addDockWindow</anchor>
      <arglist>( QDockWindow * dockWindow, const QString &amp; label, Dock edge = DockTop, bool newLine = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>moveDockWindow</name>
      <anchor>moveDockWindow</anchor>
      <arglist>( QDockWindow * dockWindow, Dock edge = DockTop )</arglist>
    </member>
    <member kind="function">
      <name>moveDockWindow</name>
      <anchor>moveDockWindow</anchor>
      <arglist>( QDockWindow * dockWindow, Dock edge, bool nl, int index, int extraOffset = -1 )</arglist>
    </member>
    <member kind="function">
      <name>removeDockWindow</name>
      <anchor>removeDockWindow</anchor>
      <arglist>( QDockWindow * dockWindow )</arglist>
    </member>
    <member kind="function">
      <name>usesBigPixmaps</name>
      <anchor>usesBigPixmaps</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>usesTextLabel</name>
      <anchor>usesTextLabel</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>dockWindowsMovable</name>
      <anchor>dockWindowsMovable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>opaqueMoving</name>
      <anchor>opaqueMoving</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>getLocation</name>
      <anchor>getLocation</anchor>
      <arglist>( QDockWindow * dw, Dock &amp; dock, int &amp; index, bool &amp; nl, int &amp; extraOffset ) const</arglist>
    </member>
    <member kind="function">
      <name>dockWindows</name>
      <anchor>dockWindows</anchor>
      <arglist>( Dock dock ) const</arglist>
    </member>
    <member kind="function">
      <name>dockWindows</name>
      <anchor>dockWindows</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>lineUpDockWindows</name>
      <anchor>lineUpDockWindows</anchor>
      <arglist>( bool keepNewLines = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>isDockMenuEnabled</name>
      <anchor>isDockMenuEnabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>hasDockWindow</name>
      <anchor>hasDockWindow</anchor>
      <arglist>( QDockWindow * dw )</arglist>
    </member>
    <member kind="function">
      <name>toolBars</name>
      <anchor>toolBars</anchor>
      <arglist>( Dock dock ) const</arglist>
    </member>
    <member kind="function">
      <name>leftDock</name>
      <anchor>leftDock</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rightDock</name>
      <anchor>rightDock</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>topDock</name>
      <anchor>topDock</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>bottomDock</name>
      <anchor>bottomDock</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isCustomizable</name>
      <anchor>isCustomizable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>appropriate</name>
      <anchor>appropriate</anchor>
      <arglist>( QDockWindow * dw ) const</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>DockWindows</anchor>
      <arglist>{ OnlyToolBars, NoToolBars, AllDockWindows }</arglist>
    </member>
    <member kind="function">
      <name>createDockWindowMenu</name>
      <anchor>createDockWindowMenu</anchor>
      <arglist>( DockWindows dockWindows = AllDockWindows ) const</arglist>
    </member>
    <member kind="function">
      <name>setUsesBigPixmaps</name>
      <anchor>setUsesBigPixmaps</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>setUsesTextLabel</name>
      <anchor>setUsesTextLabel</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>setDockWindowsMovable</name>
      <anchor>setDockWindowsMovable</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>setOpaqueMoving</name>
      <anchor>setOpaqueMoving</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>setDockMenuEnabled</name>
      <anchor>setDockMenuEnabled</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>whatsThis</name>
      <anchor>whatsThis</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setAppropriate</name>
      <anchor>setAppropriate</anchor>
      <arglist>( QDockWindow * dw, bool a )</arglist>
    </member>
    <member kind="function">
      <name>customize</name>
      <anchor>customize</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>pixmapSizeChanged</name>
      <anchor>pixmapSizeChanged</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>usesTextLabelChanged</name>
      <anchor>usesTextLabelChanged</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>dockWindowPositionChanged</name>
      <anchor>dockWindowPositionChanged</anchor>
      <arglist>( QDockWindow * dockWindow )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>dockWindowsMovable</anchor>
      <arglist>- whether the dock windows are movable</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>opaqueMoving</anchor>
      <arglist>- whether dock windows are moved opaquely</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>usesBigPixmaps</anchor>
      <arglist>- whether big pixmaps are enabled</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>usesTextLabel</anchor>
      <arglist>- whether text labels for toolbar buttons are enabled</arglist>
    </member>
    <member kind="function">
      <name>childEvent</name>
      <anchor>childEvent</anchor>
      <arglist>( QChildEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>setUpLayout</name>
      <anchor>setUpLayout</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>showDockMenu</name>
      <anchor>showDockMenu</anchor>
      <arglist>( const QPoint &amp; globalPos )</arglist>
    </member>
    <member kind="function">
      <name>menuAboutToShow</name>
      <anchor>menuAboutToShow</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QTextStream &amp; ts, const QMainWindow &amp; mainWindow )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QTextStream &amp; ts, QMainWindow &amp; mainWindow )</arglist>
    </member>
    <member kind="function">
      <name>QDockWindow</name>
      <anchor>setHorizontalStretchable</anchor>
      <arglist>() and</arglist>
    </member>
    <member kind="function">
      <name>setUsesBigPixmaps</name>
      <anchor>setUsesBigPixmaps</anchor>
      <arglist>() is used to set whether tool buttons should</arglist>
    </member>
    <member kind="function">
      <name>setUsesTextLabel</name>
      <anchor>setUsesTextLabel</anchor>
      <arglist>() is used to set whether tool buttons</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMap</name>
    <filename>qmap.html</filename>
    <member kind="function">
      <name>key_type</name>
      <anchor>key_type</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>mapped_type</name>
      <anchor>mapped_type</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>value_type</name>
      <anchor>value_type</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>pointer</name>
      <anchor>pointer</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>const_pointer</name>
      <anchor>const_pointer</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>reference</name>
      <anchor>reference</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>const_reference</name>
      <anchor>const_reference</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>size_type</name>
      <anchor>size_type</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>iterator</name>
      <anchor>iterator</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>const_iterator</name>
      <anchor>const_iterator</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>Iterator</name>
      <anchor>Iterator</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>ConstIterator</name>
      <anchor>ConstIterator</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>ValueType</name>
      <anchor>ValueType</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>QMap</name>
      <anchor>QMap</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QMap</name>
      <anchor>QMap</anchor>
      <arglist>( const QMap&lt;Key, T&gt; &amp; m )</arglist>
    </member>
    <member kind="function">
      <name>QMap</name>
      <anchor>QMap</anchor>
      <arglist>( const std::map&lt;Key, T&gt; &amp; m )</arglist>
    </member>
    <member kind="function">
      <name>QMap</name>
      <anchor>QMap</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QMap&lt;Key, T&gt; &amp; m )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const std::map&lt;Key, T&gt; &amp; m )</arglist>
    </member>
    <member kind="function">
      <name>begin</name>
      <anchor>begin</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>end</name>
      <anchor>end</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>begin</name>
      <anchor>begin</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>end</name>
      <anchor>end</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>constBegin</name>
      <anchor>constBegin</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>constEnd</name>
      <anchor>constEnd</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>replace</name>
      <anchor>replace</anchor>
      <arglist>( const Key &amp; k, const T &amp; v )</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>empty</name>
      <anchor>empty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>insert</name>
      <anchor>insert</anchor>
      <arglist>( const value_type &amp; x )</arglist>
    </member>
    <member kind="function">
      <name>erase</name>
      <anchor>erase</anchor>
      <arglist>( iterator it )</arglist>
    </member>
    <member kind="function">
      <name>erase</name>
      <anchor>erase</anchor>
      <arglist>( const key_type &amp; k )</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>( const key_type &amp; k ) const</arglist>
    </member>
    <member kind="function">
      <name>operator[]</name>
      <anchor>operator</anchor>
      <arglist>( const Key &amp; k )</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>find</name>
      <anchor>find</anchor>
      <arglist>( const Key &amp; k )</arglist>
    </member>
    <member kind="function">
      <name>find</name>
      <anchor>find</anchor>
      <arglist>( const Key &amp; k ) const</arglist>
    </member>
    <member kind="function">
      <name>operator[]</name>
      <anchor>operator</anchor>
      <arglist>( const Key &amp; k ) const</arglist>
    </member>
    <member kind="function">
      <name>contains</name>
      <anchor>contains</anchor>
      <arglist>( const Key &amp; k ) const</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>keys</name>
      <anchor>keys</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>values</name>
      <anchor>values</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>insert</name>
      <anchor>insert</anchor>
      <arglist>( const Key &amp; key, const T &amp; value, bool overwrite = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>( iterator it )</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>( const Key &amp; k )</arglist>
    </member>
    <member kind="function">
      <name>detach</name>
      <anchor>detach</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QMap&lt;Key, T&gt; &amp; m )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QMap&lt;Key, T&gt; &amp; m )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMapConstIterator</name>
    <filename>qmapconstiterator.html</filename>
    <member kind="function">
      <name>iterator_category</name>
      <anchor>iterator_category</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>value_type</name>
      <anchor>value_type</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>pointer</name>
      <anchor>pointer</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>reference</name>
      <anchor>reference</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>QMapConstIterator</name>
      <anchor>QMapConstIterator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QMapConstIterator</name>
      <anchor>QMapConstIterator</anchor>
      <arglist>( QMapNode&lt;K, T&gt; * p )</arglist>
    </member>
    <member kind="function">
      <name>QMapConstIterator</name>
      <anchor>QMapConstIterator</anchor>
      <arglist>( const QMapConstIterator&lt;K, T&gt; &amp; it )</arglist>
    </member>
    <member kind="function">
      <name>QMapConstIterator</name>
      <anchor>QMapConstIterator</anchor>
      <arglist>( const QMapIterator&lt;K, T&gt; &amp; it )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QMapConstIterator&lt;K, T&gt; &amp; it ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QMapConstIterator&lt;K, T&gt; &amp; it ) const</arglist>
    </member>
    <member kind="function">
      <name>operator*</name>
      <anchor>operator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>key</name>
      <anchor>key</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>data</name>
      <anchor>data</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>operator++</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>operator++</name>
      <anchor>operator</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>operator--</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>operator--</name>
      <anchor>operator</anchor>
      <arglist>( int )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMapIterator</name>
    <filename>qmapiterator.html</filename>
    <member kind="function">
      <name>iterator_category</name>
      <anchor>iterator_category</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>value_type</name>
      <anchor>value_type</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>pointer</name>
      <anchor>pointer</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>reference</name>
      <anchor>reference</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>QMapIterator</name>
      <anchor>QMapIterator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QMapIterator</name>
      <anchor>QMapIterator</anchor>
      <arglist>( QMapNode&lt;K, T&gt; * p )</arglist>
    </member>
    <member kind="function">
      <name>QMapIterator</name>
      <anchor>QMapIterator</anchor>
      <arglist>( const QMapIterator&lt;K, T&gt; &amp; it )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QMapIterator&lt;K, T&gt; &amp; it ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QMapIterator&lt;K, T&gt; &amp; it ) const</arglist>
    </member>
    <member kind="function">
      <name>operator*</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>operator*</name>
      <anchor>operator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>key</name>
      <anchor>key</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>data</name>
      <anchor>data</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>data</name>
      <anchor>data</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>operator++</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>operator++</name>
      <anchor>operator</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>operator--</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>operator--</name>
      <anchor>operator</anchor>
      <arglist>( int )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMemArray</name>
    <filename>qmemarray.html</filename>
    <member kind="function">
      <name>Iterator</name>
      <anchor>Iterator</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>ConstIterator</name>
      <anchor>ConstIterator</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>QMemArray</name>
      <anchor>QMemArray</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QMemArray</name>
      <anchor>QMemArray</anchor>
      <arglist>( int size )</arglist>
    </member>
    <member kind="function">
      <name>QMemArray</name>
      <anchor>QMemArray</anchor>
      <arglist>( const QMemArray&lt;type&gt; &amp; a )</arglist>
    </member>
    <member kind="function">
      <name>QMemArray</name>
      <anchor>QMemArray</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QMemArray&lt;type&gt; &amp; a )</arglist>
    </member>
    <member kind="function">
      <name>data</name>
      <anchor>data</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>nrefs</name>
      <anchor>nrefs</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isNull</name>
      <anchor>isNull</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>resize</name>
      <anchor>resize</anchor>
      <arglist>( uint size )</arglist>
    </member>
    <member kind="function">
      <name>resize</name>
      <anchor>resize</anchor>
      <arglist>( uint size, Optimization optim )</arglist>
    </member>
    <member kind="function">
      <name>truncate</name>
      <anchor>truncate</anchor>
      <arglist>( uint pos )</arglist>
    </member>
    <member kind="function">
      <name>fill</name>
      <anchor>fill</anchor>
      <arglist>( const type &amp; v, int size = -1 )</arglist>
    </member>
    <member kind="function">
      <name>detach</name>
      <anchor>detach</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>copy</name>
      <anchor>copy</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>assign</name>
      <anchor>assign</anchor>
      <arglist>( const QMemArray&lt;type&gt; &amp; a )</arglist>
    </member>
    <member kind="function">
      <name>assign</name>
      <anchor>assign</anchor>
      <arglist>( const type * data, uint size )</arglist>
    </member>
    <member kind="function">
      <name>duplicate</name>
      <anchor>duplicate</anchor>
      <arglist>( const QMemArray&lt;type&gt; &amp; a )</arglist>
    </member>
    <member kind="function">
      <name>duplicate</name>
      <anchor>duplicate</anchor>
      <arglist>( const type * data, uint size )</arglist>
    </member>
    <member kind="function">
      <name>setRawData</name>
      <anchor>setRawData</anchor>
      <arglist>( const type * data, uint size )</arglist>
    </member>
    <member kind="function">
      <name>resetRawData</name>
      <anchor>resetRawData</anchor>
      <arglist>( const type * data, uint size )</arglist>
    </member>
    <member kind="function">
      <name>find</name>
      <anchor>find</anchor>
      <arglist>( const type &amp; v, uint index = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>contains</name>
      <anchor>contains</anchor>
      <arglist>( const type &amp; v ) const</arglist>
    </member>
    <member kind="function">
      <name>sort</name>
      <anchor>sort</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>bsearch</name>
      <anchor>bsearch</anchor>
      <arglist>( const type &amp; v ) const</arglist>
    </member>
    <member kind="function">
      <name>operator[]</name>
      <anchor>operator</anchor>
      <arglist>( int index ) const</arglist>
    </member>
    <member kind="function">
      <name>at</name>
      <anchor>at</anchor>
      <arglist>( uint index ) const</arglist>
    </member>
    <member kind="function">
      <name>const</name>
      <anchor>operator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QMemArray&lt;type&gt; &amp; a ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QMemArray&lt;type&gt; &amp; a ) const</arglist>
    </member>
    <member kind="function">
      <name>begin</name>
      <anchor>begin</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>end</name>
      <anchor>end</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>begin</name>
      <anchor>begin</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>end</name>
      <anchor>end</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>QMemArray</name>
      <anchor>QMemArray</anchor>
      <arglist>( int, int )</arglist>
    </member>
    <member kind="function">
      <name>qChecksum</name>
      <anchor>qChecksum</anchor>
      <arglist>( const char * data, uint len )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QByteArray &amp; a )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QByteArray &amp; a )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMenuBar</name>
    <filename>qmenubar.html</filename>
    <member kind="function">
      <name>QMenuBar</name>
      <anchor>QMenuBar</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QMenuBar</name>
      <anchor>QMenuBar</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>show</name>
      <anchor>show</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>hide</name>
      <anchor>hide</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>heightForWidth</name>
      <anchor>heightForWidth</anchor>
      <arglist>( int max_width ) const</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Separator</anchor>
      <arglist>{ Never = 0, InWindowsStyle = 1 }</arglist>
    </member>
    <member kind="function">
      <name>setDefaultUp</name>
      <anchor>setDefaultUp</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>isDefaultUp</name>
      <anchor>isDefaultUp</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>activated</name>
      <anchor>activated</anchor>
      <arglist>( int id )</arglist>
    </member>
    <member kind="function">
      <name>highlighted</name>
      <anchor>highlighted</anchor>
      <arglist>( int id )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QString &amp; text, const QObject * receiver, const char * member, const QKeySequence &amp; accel = 0, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, const QString &amp; text, const QObject * receiver, const char * member, const QKeySequence &amp; accel = 0, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QPixmap &amp; pixmap, const QObject * receiver, const char * member, const QKeySequence &amp; accel = 0, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, const QPixmap &amp; pixmap, const QObject * receiver, const char * member, const QKeySequence &amp; accel = 0, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QString &amp; text, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, const QString &amp; text, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QString &amp; text, QPopupMenu * popup, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, const QString &amp; text, QPopupMenu * popup, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QPixmap &amp; pixmap, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>a</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, const QPixmap &amp; pixmap, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>b</name>
      <anchor>insertItem</anchor>
      <arglist>( const QPixmap &amp; pixmap, QPopupMenu * popup, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>c</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, const QPixmap &amp; pixmap, QPopupMenu * popup, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>d</name>
      <anchor>insertItem</anchor>
      <arglist>( QWidget * widget, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>e</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, QCustomMenuItem * custom, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>f</name>
      <anchor>insertItem</anchor>
      <arglist>( QCustomMenuItem * custom, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertSeparator</name>
      <anchor>insertSeparator</anchor>
      <arglist>( int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>removeItem</name>
      <anchor>removeItem</anchor>
      <arglist>( int id )</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>isItemEnabled</name>
      <anchor>isItemEnabled</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>setItemEnabled</name>
      <anchor>setItemEnabled</anchor>
      <arglist>( int id, bool enable )</arglist>
    </member>
    <member kind="function">
      <name>isItemVisible</name>
      <anchor>isItemVisible</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>setItemVisible</name>
      <anchor>setItemVisible</anchor>
      <arglist>( int id, bool visible )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>defaultUp</anchor>
      <arglist>- the popup orientation</arglist>
    </member>
    <member kind="function">
      <name>drawContents</name>
      <anchor>drawContents</anchor>
      <arglist>( QPainter * p )</arglist>
    </member>
    <member kind="function">
      <name>menuContentsChanged</name>
      <anchor>menuContentsChanged</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>menuStateChanged</name>
      <anchor>menuStateChanged</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMenuData</name>
    <filename>qmenudata.html</filename>
    <member kind="function">
      <name>QMenuData</name>
      <anchor>QMenuData</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QMenuData</name>
      <anchor>QMenuData</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QString &amp; text, const QObject * receiver, const char * member, const QKeySequence &amp; accel = 0, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, const QString &amp; text, const QObject * receiver, const char * member, const QKeySequence &amp; accel = 0, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QPixmap &amp; pixmap, const QObject * receiver, const char * member, const QKeySequence &amp; accel = 0, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, const QPixmap &amp; pixmap, const QObject * receiver, const char * member, const QKeySequence &amp; accel = 0, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QString &amp; text, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, const QString &amp; text, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QString &amp; text, QPopupMenu * popup, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, const QString &amp; text, QPopupMenu * popup, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QPixmap &amp; pixmap, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>a</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, const QPixmap &amp; pixmap, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>b</name>
      <anchor>insertItem</anchor>
      <arglist>( const QPixmap &amp; pixmap, QPopupMenu * popup, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>c</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, const QPixmap &amp; pixmap, QPopupMenu * popup, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>d</name>
      <anchor>insertItem</anchor>
      <arglist>( QWidget * widget, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>e</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, QCustomMenuItem * custom, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>f</name>
      <anchor>insertItem</anchor>
      <arglist>( QCustomMenuItem * custom, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertSeparator</name>
      <anchor>insertSeparator</anchor>
      <arglist>( int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>removeItem</name>
      <anchor>removeItem</anchor>
      <arglist>( int id )</arglist>
    </member>
    <member kind="function">
      <name>removeItemAt</name>
      <anchor>removeItemAt</anchor>
      <arglist>( int index )</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>accel</name>
      <anchor>accel</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>setAccel</name>
      <anchor>setAccel</anchor>
      <arglist>( const QKeySequence &amp; key, int id )</arglist>
    </member>
    <member kind="function">
      <name>iconSet</name>
      <anchor>iconSet</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>pixmap</name>
      <anchor>pixmap</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>setWhatsThis</name>
      <anchor>setWhatsThis</anchor>
      <arglist>( int id, const QString &amp; text )</arglist>
    </member>
    <member kind="function">
      <name>whatsThis</name>
      <anchor>whatsThis</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>changeItem</name>
      <anchor>changeItem</anchor>
      <arglist>( int id, const QString &amp; text )</arglist>
    </member>
    <member kind="function">
      <name>changeItem</name>
      <anchor>changeItem</anchor>
      <arglist>( int id, const QPixmap &amp; pixmap )</arglist>
    </member>
    <member kind="function">
      <name>changeItem</name>
      <anchor>changeItem</anchor>
      <arglist>( int id, const QIconSet &amp; icon, const QString &amp; text )</arglist>
    </member>
    <member kind="function">
      <name>changeItem</name>
      <anchor>changeItem</anchor>
      <arglist>( int id, const QIconSet &amp; icon, const QPixmap &amp; pixmap )</arglist>
    </member>
    <member kind="function">
      <name>isItemActive</name>
      <anchor>isItemActive</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>isItemEnabled</name>
      <anchor>isItemEnabled</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>setItemEnabled</name>
      <anchor>setItemEnabled</anchor>
      <arglist>( int id, bool enable )</arglist>
    </member>
    <member kind="function">
      <name>isItemChecked</name>
      <anchor>isItemChecked</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>setItemChecked</name>
      <anchor>setItemChecked</anchor>
      <arglist>( int id, bool check )</arglist>
    </member>
    <member kind="function">
      <name>isItemVisible</name>
      <anchor>isItemVisible</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>setItemVisible</name>
      <anchor>setItemVisible</anchor>
      <arglist>( int id, bool visible )</arglist>
    </member>
    <member kind="function">
      <name>updateItem</name>
      <anchor>updateItem</anchor>
      <arglist>( int id )</arglist>
    </member>
    <member kind="function">
      <name>indexOf</name>
      <anchor>indexOf</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>idAt</name>
      <anchor>idAt</anchor>
      <arglist>( int index ) const</arglist>
    </member>
    <member kind="function">
      <name>setId</name>
      <anchor>setId</anchor>
      <arglist>( int index, int id )</arglist>
    </member>
    <member kind="function">
      <name>connectItem</name>
      <anchor>connectItem</anchor>
      <arglist>( int id, const QObject * receiver, const char * member )</arglist>
    </member>
    <member kind="function">
      <name>disconnectItem</name>
      <anchor>disconnectItem</anchor>
      <arglist>( int id, const QObject * receiver, const char * member )</arglist>
    </member>
    <member kind="function">
      <name>setItemParameter</name>
      <anchor>setItemParameter</anchor>
      <arglist>( int id, int param )</arglist>
    </member>
    <member kind="function">
      <name>itemParameter</name>
      <anchor>itemParameter</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>findItem</name>
      <anchor>findItem</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>findItem</name>
      <anchor>findItem</anchor>
      <arglist>( int id, QMenuData ** parent ) const</arglist>
    </member>
    <member kind="function">
      <name>activateItemAt</name>
      <anchor>activateItemAt</anchor>
      <arglist>( int index )</arglist>
    </member>
    <member kind="function">
      <name>menuContentsChanged</name>
      <anchor>menuContentsChanged</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>menuStateChanged</name>
      <anchor>menuStateChanged</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>menuInsPopup</name>
      <anchor>menuInsPopup</anchor>
      <arglist>( QPopupMenu * )</arglist>
    </member>
    <member kind="function">
      <name>menuDelPopup</name>
      <anchor>menuDelPopup</anchor>
      <arglist>( QPopupMenu * )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMessageBox</name>
    <filename>qmessagebox.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>Icon</anchor>
      <arglist>{ NoIcon = 0, Information = 1, Warning = 2, Critical = 3, Question = 4 }</arglist>
    </member>
    <member kind="function">
      <name>QMessageBox</name>
      <anchor>QMessageBox</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QMessageBox</name>
      <anchor>QMessageBox</anchor>
      <arglist>( const QString &amp; caption, const QString &amp; text, Icon icon, int button0, int button1, int button2, QWidget * parent = 0, const char * name = 0, bool modal = TRUE, WFlags f = WStyle_DialogBorder )</arglist>
    </member>
    <member kind="function">
      <name>QMessageBox</name>
      <anchor>QMessageBox</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setText</name>
      <anchor>setText</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>icon</name>
      <anchor>icon</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setIcon</name>
      <anchor>setIcon</anchor>
      <arglist>( Icon )</arglist>
    </member>
    <member kind="function">
      <name>iconPixmap</name>
      <anchor>iconPixmap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setIconPixmap</name>
      <anchor>setIconPixmap</anchor>
      <arglist>( const QPixmap &amp; )</arglist>
    </member>
    <member kind="function">
      <name>buttonText</name>
      <anchor>buttonText</anchor>
      <arglist>( int button ) const</arglist>
    </member>
    <member kind="function">
      <name>setButtonText</name>
      <anchor>setButtonText</anchor>
      <arglist>( int button, const QString &amp; text )</arglist>
    </member>
    <member kind="function">
      <name>adjustSize</name>
      <anchor>adjustSize</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>textFormat</name>
      <anchor>textFormat</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setTextFormat</name>
      <anchor>setTextFormat</anchor>
      <arglist>( TextFormat )</arglist>
    </member>
    <member kind="function">
      <name>information</name>
      <anchor>information</anchor>
      <arglist>( QWidget * parent, const QString &amp; caption, const QString &amp; text, int button0, int button1 = 0, int button2 = 0 )</arglist>
    </member>
    <member kind="function">
      <name>information</name>
      <anchor>information</anchor>
      <arglist>( QWidget * parent, const QString &amp; caption, const QString &amp; text, const QString &amp; button0Text = QString::null, const QString &amp; button1Text = QString::null, const QString &amp; button2Text = QString::null, int defaultButtonNumber = 0, int escapeButtonNumber = -1 )</arglist>
    </member>
    <member kind="function">
      <name>question</name>
      <anchor>question</anchor>
      <arglist>( QWidget * parent, const QString &amp; caption, const QString &amp; text, int button0, int button1 = 0, int button2 = 0 )</arglist>
    </member>
    <member kind="function">
      <name>question</name>
      <anchor>question</anchor>
      <arglist>( QWidget * parent, const QString &amp; caption, const QString &amp; text, const QString &amp; button0Text = QString::null, const QString &amp; button1Text = QString::null, const QString &amp; button2Text = QString::null, int defaultButtonNumber = 0, int escapeButtonNumber = -1 )</arglist>
    </member>
    <member kind="function">
      <name>warning</name>
      <anchor>warning</anchor>
      <arglist>( QWidget * parent, const QString &amp; caption, const QString &amp; text, int button0, int button1, int button2 = 0 )</arglist>
    </member>
    <member kind="function">
      <name>warning</name>
      <anchor>warning</anchor>
      <arglist>( QWidget * parent, const QString &amp; caption, const QString &amp; text, const QString &amp; button0Text = QString::null, const QString &amp; button1Text = QString::null, const QString &amp; button2Text = QString::null, int defaultButtonNumber = 0, int escapeButtonNumber = -1 )</arglist>
    </member>
    <member kind="function">
      <name>critical</name>
      <anchor>critical</anchor>
      <arglist>( QWidget * parent, const QString &amp; caption, const QString &amp; text, int button0, int button1, int button2 = 0 )</arglist>
    </member>
    <member kind="function">
      <name>critical</name>
      <anchor>critical</anchor>
      <arglist>( QWidget * parent, const QString &amp; caption, const QString &amp; text, const QString &amp; button0Text = QString::null, const QString &amp; button1Text = QString::null, const QString &amp; button2Text = QString::null, int defaultButtonNumber = 0, int escapeButtonNumber = -1 )</arglist>
    </member>
    <member kind="function">
      <name>about</name>
      <anchor>about</anchor>
      <arglist>( QWidget * parent, const QString &amp; caption, const QString &amp; text )</arglist>
    </member>
    <member kind="function">
      <name>aboutQt</name>
      <anchor>aboutQt</anchor>
      <arglist>( QWidget * parent, const QString &amp; caption = QString::null )</arglist>
    </member>
    <member kind="function">
      <name>standardIcon</name>
      <anchor>standardIcon</anchor>
      <arglist>( Icon icon )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>icon</anchor>
      <arglist>- the message box&apos;s icon</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>iconPixmap</anchor>
      <arglist>- the current icon</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>text</anchor>
      <arglist>- the message box text to be displayed</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>textFormat</anchor>
      <arglist>- the format of the text displayed by the message box</arglist>
    </member>
    <member kind="function">
      <name>parent</name>
      <anchor>icon</anchor>
      <arglist>if that exists.</arglist>
    </member>
    <member kind="function">
      <name>main</name>
      <anchor>mainWidget</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMetaObject</name>
    <filename>qmetaobject.html</filename>
    <member kind="function">
      <name>className</name>
      <anchor>className</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>superClassName</name>
      <anchor>superClassName</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>superClass</name>
      <anchor>superClass</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>inherits</name>
      <anchor>inherits</anchor>
      <arglist>( const char * clname ) const</arglist>
    </member>
    <member kind="function">
      <name>numSlots</name>
      <anchor>numSlots</anchor>
      <arglist>( bool super = FALSE ) const</arglist>
    </member>
    <member kind="function">
      <name>numSignals</name>
      <anchor>numSignals</anchor>
      <arglist>( bool super = FALSE ) const</arglist>
    </member>
    <member kind="function">
      <name>slotNames</name>
      <anchor>slotNames</anchor>
      <arglist>( bool super = FALSE ) const</arglist>
    </member>
    <member kind="function">
      <name>signalNames</name>
      <anchor>signalNames</anchor>
      <arglist>( bool super = FALSE ) const</arglist>
    </member>
    <member kind="function">
      <name>numClassInfo</name>
      <anchor>numClassInfo</anchor>
      <arglist>( bool super = FALSE ) const</arglist>
    </member>
    <member kind="function">
      <name>classInfo</name>
      <anchor>classInfo</anchor>
      <arglist>( int index, bool super = FALSE ) const</arglist>
    </member>
    <member kind="function">
      <name>classInfo</name>
      <anchor>classInfo</anchor>
      <arglist>( const char * name, bool super = FALSE ) const</arglist>
    </member>
    <member kind="function">
      <name>property</name>
      <anchor>property</anchor>
      <arglist>( int index, bool super = FALSE ) const</arglist>
    </member>
    <member kind="function">
      <name>findProperty</name>
      <anchor>findProperty</anchor>
      <arglist>( const char * name, bool super = FALSE ) const</arglist>
    </member>
    <member kind="function">
      <name>propertyNames</name>
      <anchor>propertyNames</anchor>
      <arglist>( bool super = FALSE ) const</arglist>
    </member>
    <member kind="function">
      <name>numProperties</name>
      <anchor>numProperties</anchor>
      <arglist>( bool super = FALSE ) const</arglist>
    </member>
    <member kind="function">
      <name>className</name>
      <anchor>className</anchor>
      <arglist>() to get the name of a class.</arglist>
    </member>
    <member kind="function">
      <name>superClassName</name>
      <anchor>superClassName</anchor>
      <arglist>() to get the name of the superclass.</arglist>
    </member>
    <member kind="function">
      <name>inherits</name>
      <anchor>inherits</anchor>
      <arglist>(), the function called by</arglist>
    </member>
    <member kind="function">
      <name>superClass</name>
      <anchor>superClass</anchor>
      <arglist>() to access the superclass&apos;s</arglist>
    </member>
    <member kind="function">
      <name>numSlots</name>
      <anchor>numSlots</anchor>
      <arglist>(),</arglist>
    </member>
    <member kind="function">
      <name>property</name>
      <anchor>property</anchor>
      <arglist>() and</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMetaProperty</name>
    <filename>qmetaproperty.html</filename>
    <member kind="function">
      <name>type</name>
      <anchor>type</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>name</name>
      <anchor>name</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>writable</name>
      <anchor>writable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isSetType</name>
      <anchor>isSetType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEnumType</name>
      <anchor>isEnumType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>enumKeys</name>
      <anchor>enumKeys</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>keyToValue</name>
      <anchor>keyToValue</anchor>
      <arglist>( const char * key ) const</arglist>
    </member>
    <member kind="function">
      <name>valueToKey</name>
      <anchor>valueToKey</anchor>
      <arglist>( int value ) const</arglist>
    </member>
    <member kind="function">
      <name>keysToValue</name>
      <anchor>keysToValue</anchor>
      <arglist>( const QStrList &amp; keys ) const</arglist>
    </member>
    <member kind="function">
      <name>valueToKeys</name>
      <anchor>valueToKeys</anchor>
      <arglist>( int value ) const</arglist>
    </member>
    <member kind="function">
      <name>designable</name>
      <anchor>designable</anchor>
      <arglist>( QObject * o = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>scriptable</name>
      <anchor>scriptable</anchor>
      <arglist>( QObject * o = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>stored</name>
      <anchor>stored</anchor>
      <arglist>( QObject * o = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>reset</name>
      <anchor>reset</anchor>
      <arglist>( QObject * o ) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMimeSource</name>
    <filename>qmimesource.html</filename>
    <member kind="function">
      <name>QMimeSource</name>
      <anchor>QMimeSource</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QMimeSource</name>
      <anchor>QMimeSource</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>format</name>
      <anchor>format</anchor>
      <arglist>( int i = 0 ) const = 0</arglist>
    </member>
    <member kind="function">
      <name>provides</name>
      <anchor>provides</anchor>
      <arglist>( const char * mimeType ) const</arglist>
    </member>
    <member kind="function">
      <name>encodedData</name>
      <anchor>encodedData</anchor>
      <arglist>( const char * ) const = 0</arglist>
    </member>
    <member kind="function">
      <name>serialNumber</name>
      <anchor>serialNumber</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMimeSourceFactory</name>
    <filename>qmimesourcefactory.html</filename>
    <member kind="function">
      <name>QMimeSourceFactory</name>
      <anchor>QMimeSourceFactory</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QMimeSourceFactory</name>
      <anchor>QMimeSourceFactory</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>data</name>
      <anchor>data</anchor>
      <arglist>( const QString &amp; abs_name ) const</arglist>
    </member>
    <member kind="function">
      <name>makeAbsolute</name>
      <anchor>makeAbsolute</anchor>
      <arglist>( const QString &amp; abs_or_rel_name, const QString &amp; context ) const</arglist>
    </member>
    <member kind="function">
      <name>data</name>
      <anchor>data</anchor>
      <arglist>( const QString &amp; abs_or_rel_name, const QString &amp; context ) const</arglist>
    </member>
    <member kind="function">
      <name>setText</name>
      <anchor>setText</anchor>
      <arglist>( const QString &amp; abs_name, const QString &amp; text )</arglist>
    </member>
    <member kind="function">
      <name>setImage</name>
      <anchor>setImage</anchor>
      <arglist>( const QString &amp; abs_name, const QImage &amp; image )</arglist>
    </member>
    <member kind="function">
      <name>setPixmap</name>
      <anchor>setPixmap</anchor>
      <arglist>( const QString &amp; abs_name, const QPixmap &amp; pixmap )</arglist>
    </member>
    <member kind="function">
      <name>setData</name>
      <anchor>setData</anchor>
      <arglist>( const QString &amp; abs_name, QMimeSource * data )</arglist>
    </member>
    <member kind="function">
      <name>setFilePath</name>
      <anchor>setFilePath</anchor>
      <arglist>( const QStringList &amp; path )</arglist>
    </member>
    <member kind="function">
      <name>filePath</name>
      <anchor>filePath</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>addFilePath</name>
      <anchor>addFilePath</anchor>
      <arglist>( const QString &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>setExtensionType</name>
      <anchor>setExtensionType</anchor>
      <arglist>( const QString &amp; ext, const char * mimetype )</arglist>
    </member>
    <member kind="function">
      <name>defaultFactory</name>
      <anchor>defaultFactory</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setDefaultFactory</name>
      <anchor>setDefaultFactory</anchor>
      <arglist>( QMimeSourceFactory * factory )</arglist>
    </member>
    <member kind="function">
      <name>takeDefaultFactory</name>
      <anchor>takeDefaultFactory</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>addFactory</name>
      <anchor>addFactory</anchor>
      <arglist>( QMimeSourceFactory * f )</arglist>
    </member>
    <member kind="function">
      <name>removeFactory</name>
      <anchor>removeFactory</anchor>
      <arglist>( QMimeSourceFactory * f )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMotifPlusStyle</name>
    <filename>qmotifplusstyle.html</filename>
    <member kind="function">
      <name>QMotifPlusStyle</name>
      <anchor>QMotifPlusStyle</anchor>
      <arglist>( bool hoveringHighlight = TRUE )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMotifStyle</name>
    <filename>qmotifstyle.html</filename>
    <member kind="function">
      <name>QMotifStyle</name>
      <anchor>QMotifStyle</anchor>
      <arglist>( bool useHighlightCols = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>setUseHighlightColors</name>
      <anchor>setUseHighlightColors</anchor>
      <arglist>( bool arg )</arglist>
    </member>
    <member kind="function">
      <name>useHighlightColors</name>
      <anchor>useHighlightColors</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMouseDriverFactory</name>
    <filename>qmousedriverfactory.html</filename>
    <member kind="function">
      <name>keys</name>
      <anchor>keys</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>create</name>
      <anchor>create</anchor>
      <arglist>( const QString &amp; key, const QString &amp; device )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMouseDriverPlugin</name>
    <filename>qmousedriverplugin.html</filename>
    <member kind="function">
      <name>QMouseDriverPlugin</name>
      <anchor>QMouseDriverPlugin</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QMouseDriverPlugin</name>
      <anchor>QMouseDriverPlugin</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>keys</name>
      <anchor>keys</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>create</name>
      <anchor>create</anchor>
      <arglist>( const QString &amp; driver, const QString &amp; device ) = 0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMouseEvent</name>
    <filename>qmouseevent.html</filename>
    <member kind="function">
      <name>QMouseEvent</name>
      <anchor>QMouseEvent</anchor>
      <arglist>( Type type, const QPoint &amp; pos, int button, int state )</arglist>
    </member>
    <member kind="function">
      <name>QMouseEvent</name>
      <anchor>QMouseEvent</anchor>
      <arglist>( Type type, const QPoint &amp; pos, const QPoint &amp; globalPos, int button, int state )</arglist>
    </member>
    <member kind="function">
      <name>pos</name>
      <anchor>pos</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>globalPos</name>
      <anchor>globalPos</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>x</name>
      <anchor>x</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>y</name>
      <anchor>y</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>globalX</name>
      <anchor>globalX</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>globalY</name>
      <anchor>globalY</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>button</name>
      <anchor>button</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>state</name>
      <anchor>state</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>stateAfter</name>
      <anchor>stateAfter</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isAccepted</name>
      <anchor>isAccepted</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>accept</name>
      <anchor>accept</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>ignore</name>
      <anchor>ignore</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMoveEvent</name>
    <filename>qmoveevent.html</filename>
    <member kind="function">
      <name>QMoveEvent</name>
      <anchor>QMoveEvent</anchor>
      <arglist>( const QPoint &amp; pos, const QPoint &amp; oldPos )</arglist>
    </member>
    <member kind="function">
      <name>pos</name>
      <anchor>pos</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>oldPos</name>
      <anchor>oldPos</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMovie</name>
    <filename>qmovie.html</filename>
    <member kind="function">
      <name>QMovie</name>
      <anchor>QMovie</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QMovie</name>
      <anchor>QMovie</anchor>
      <arglist>( int bufsize )</arglist>
    </member>
    <member kind="function">
      <name>QMovie</name>
      <anchor>QMovie</anchor>
      <arglist>( QDataSource * src, int bufsize = 1024 )</arglist>
    </member>
    <member kind="function">
      <name>QMovie</name>
      <anchor>QMovie</anchor>
      <arglist>( const QString &amp; fileName, int bufsize = 1024 )</arglist>
    </member>
    <member kind="function">
      <name>QMovie</name>
      <anchor>QMovie</anchor>
      <arglist>( QByteArray data, int bufsize = 1024 )</arglist>
    </member>
    <member kind="function">
      <name>QMovie</name>
      <anchor>QMovie</anchor>
      <arglist>( const QMovie &amp; movie )</arglist>
    </member>
    <member kind="function">
      <name>QMovie</name>
      <anchor>QMovie</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QMovie &amp; movie )</arglist>
    </member>
    <member kind="function">
      <name>pushSpace</name>
      <anchor>pushSpace</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>pushData</name>
      <anchor>pushData</anchor>
      <arglist>( const uchar * data, int length )</arglist>
    </member>
    <member kind="function">
      <name>backgroundColor</name>
      <anchor>backgroundColor</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setBackgroundColor</name>
      <anchor>setBackgroundColor</anchor>
      <arglist>( const QColor &amp; c )</arglist>
    </member>
    <member kind="function">
      <name>getValidRect</name>
      <anchor>getValidRect</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>framePixmap</name>
      <anchor>framePixmap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>frameImage</name>
      <anchor>frameImage</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isNull</name>
      <anchor>isNull</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>frameNumber</name>
      <anchor>frameNumber</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>steps</name>
      <anchor>steps</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>paused</name>
      <anchor>paused</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>finished</name>
      <anchor>finished</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>running</name>
      <anchor>running</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>unpause</name>
      <anchor>unpause</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>pause</name>
      <anchor>pause</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>step</name>
      <anchor>step</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>step</name>
      <anchor>step</anchor>
      <arglist>( int steps )</arglist>
    </member>
    <member kind="function">
      <name>restart</name>
      <anchor>restart</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>speed</name>
      <anchor>speed</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSpeed</name>
      <anchor>setSpeed</anchor>
      <arglist>( int percent )</arglist>
    </member>
    <member kind="function">
      <name>connectResize</name>
      <anchor>connectResize</anchor>
      <arglist>( QObject * receiver, const char * member )</arglist>
    </member>
    <member kind="function">
      <name>disconnectResize</name>
      <anchor>disconnectResize</anchor>
      <arglist>( QObject * receiver, const char * member = 0 )</arglist>
    </member>
    <member kind="function">
      <name>connectUpdate</name>
      <anchor>connectUpdate</anchor>
      <arglist>( QObject * receiver, const char * member )</arglist>
    </member>
    <member kind="function">
      <name>disconnectUpdate</name>
      <anchor>disconnectUpdate</anchor>
      <arglist>( QObject * receiver, const char * member = 0 )</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Status</anchor>
      <arglist>{ SourceEmpty = -2, UnrecognizedFormat = -1, Paused = 1, EndOfFrame = 2, EndOfLoop = 3, EndOfMovie = 4, SpeedChanged = 5 }</arglist>
    </member>
    <member kind="function">
      <name>connectStatus</name>
      <anchor>connectStatus</anchor>
      <arglist>( QObject * receiver, const char * member )</arglist>
    </member>
    <member kind="function">
      <name>disconnectStatus</name>
      <anchor>disconnectStatus</anchor>
      <arglist>( QObject * receiver, const char * member = 0 )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMultiLineEdit</name>
    <filename>qmultilineedit.html</filename>
    <member kind="function">
      <name>QMultiLineEdit</name>
      <anchor>QMultiLineEdit</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>textLine</name>
      <anchor>textLine</anchor>
      <arglist>( int line ) const</arglist>
    </member>
    <member kind="function">
      <name>numLines</name>
      <anchor>numLines</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>insertLine</name>
      <anchor>insertLine</anchor>
      <arglist>( const QString &amp; txt, int line = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertAt</name>
      <anchor>insertAt</anchor>
      <arglist>( const QString &amp; s, int line, int col, bool mark )</arglist>
    </member>
    <member kind="function">
      <name>removeLine</name>
      <anchor>removeLine</anchor>
      <arglist>( int paragraph )</arglist>
    </member>
    <member kind="function">
      <name>setCursorPosition</name>
      <anchor>setCursorPosition</anchor>
      <arglist>( int line, int col, bool mark )</arglist>
    </member>
    <member kind="function">
      <name>atBeginning</name>
      <anchor>atBeginning</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>atEnd</name>
      <anchor>atEnd</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAlignment</name>
      <anchor>setAlignment</anchor>
      <arglist>( int flags )</arglist>
    </member>
    <member kind="function">
      <name>alignment</name>
      <anchor>alignment</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setEdited</name>
      <anchor>setEdited</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>edited</name>
      <anchor>edited</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>hasMarkedText</name>
      <anchor>hasMarkedText</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>markedText</name>
      <anchor>markedText</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>cursorWordForward</name>
      <anchor>cursorWordForward</anchor>
      <arglist>( bool mark )</arglist>
    </member>
    <member kind="function">
      <name>cursorWordBackward</name>
      <anchor>cursorWordBackward</anchor>
      <arglist>( bool mark )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>alignment</anchor>
      <arglist>- the editor&apos;s paragraph alignment</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>atBeginning</anchor>
      <arglist>- whether the cursor is placed at the beginning of the text</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>atEnd</anchor>
      <arglist>- whether the cursor is placed at the end of the text</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>edited</anchor>
      <arglist>- whether the document has been edited by the user</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>numLines</anchor>
      <arglist>- the number of paragraphs in the editor</arglist>
    </member>
    <member kind="function">
      <name>cursorPoint</name>
      <anchor>cursorPoint</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>insertAndMark</name>
      <anchor>insertAndMark</anchor>
      <arglist>( const QString &amp; str, bool mark )</arglist>
    </member>
    <member kind="function">
      <name>newLine</name>
      <anchor>newLine</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>killLine</name>
      <anchor>killLine</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>pageUp</name>
      <anchor>pageUp</anchor>
      <arglist>( bool mark = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>pageDown</name>
      <anchor>pageDown</anchor>
      <arglist>( bool mark = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>cursorLeft</name>
      <anchor>cursorLeft</anchor>
      <arglist>( bool mark = FALSE, bool wrap = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>cursorRight</name>
      <anchor>cursorRight</anchor>
      <arglist>( bool mark = FALSE, bool wrap = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>cursorUp</name>
      <anchor>cursorUp</anchor>
      <arglist>( bool mark = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>cursorDown</name>
      <anchor>cursorDown</anchor>
      <arglist>( bool mark = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>backspace</name>
      <anchor>backspace</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>home</name>
      <anchor>home</anchor>
      <arglist>( bool mark = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>end</name>
      <anchor>end</anchor>
      <arglist>( bool mark = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>getMarkedRegion</name>
      <anchor>getMarkedRegion</anchor>
      <arglist>( int * line1, int * col1, int * line2, int * col2 ) const</arglist>
    </member>
    <member kind="function">
      <name>lineLength</name>
      <anchor>lineLength</anchor>
      <arglist>( int row ) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMutex</name>
    <filename>qmutex.html</filename>
    <member kind="function">
      <name>QMutex</name>
      <anchor>QMutex</anchor>
      <arglist>( bool recursive = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>QMutex</name>
      <anchor>QMutex</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>lock</name>
      <anchor>lock</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>unlock</name>
      <anchor>unlock</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>locked</name>
      <anchor>locked</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>tryLock</name>
      <anchor>tryLock</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QMutexLocker</name>
    <filename>qmutexlocker.html</filename>
    <member kind="function">
      <name>QMutexLocker</name>
      <anchor>QMutexLocker</anchor>
      <arglist>( QMutex * mutex )</arglist>
    </member>
    <member kind="function">
      <name>QMutexLocker</name>
      <anchor>QMutexLocker</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>mutex</name>
      <anchor>mutex</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QNetworkOperation</name>
    <filename>qnetworkoperation.html</filename>
    <member kind="function">
      <name>QNetworkOperation</name>
      <anchor>QNetworkOperation</anchor>
      <arglist>( QNetworkProtocol::Operation operation, const QString &amp; arg0, const QString &amp; arg1, const QString &amp; arg2 )</arglist>
    </member>
    <member kind="function">
      <name>QNetworkOperation</name>
      <anchor>QNetworkOperation</anchor>
      <arglist>( QNetworkProtocol::Operation operation, const QByteArray &amp; arg0, const QByteArray &amp; arg1, const QByteArray &amp; arg2 )</arglist>
    </member>
    <member kind="function">
      <name>QNetworkOperation</name>
      <anchor>QNetworkOperation</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setState</name>
      <anchor>setState</anchor>
      <arglist>( QNetworkProtocol::State state )</arglist>
    </member>
    <member kind="function">
      <name>setProtocolDetail</name>
      <anchor>setProtocolDetail</anchor>
      <arglist>( const QString &amp; detail )</arglist>
    </member>
    <member kind="function">
      <name>setErrorCode</name>
      <anchor>setErrorCode</anchor>
      <arglist>( int ec )</arglist>
    </member>
    <member kind="function">
      <name>setArg</name>
      <anchor>setArg</anchor>
      <arglist>( int num, const QString &amp; arg )</arglist>
    </member>
    <member kind="function">
      <name>setRawArg</name>
      <anchor>setRawArg</anchor>
      <arglist>( int num, const QByteArray &amp; arg )</arglist>
    </member>
    <member kind="function">
      <name>operation</name>
      <anchor>operation</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>state</name>
      <anchor>state</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>arg</name>
      <anchor>arg</anchor>
      <arglist>( int num ) const</arglist>
    </member>
    <member kind="function">
      <name>rawArg</name>
      <anchor>rawArg</anchor>
      <arglist>( int num ) const</arglist>
    </member>
    <member kind="function">
      <name>protocolDetail</name>
      <anchor>protocolDetail</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>errorCode</name>
      <anchor>errorCode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>free</name>
      <anchor>free</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QNetworkProtocol</name>
    <filename>qnetworkprotocol.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>State</anchor>
      <arglist>{ StWaiting = 0, StInProgress, StDone, StFailed, StStopped }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Operation</anchor>
      <arglist>{ OpListChildren = 1, OpMkDir = 2, OpMkdir = OpMkDir, OpRemove = 4, OpRename = 8, OpGet = 32, OpPut = 64 }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ConnectionState</anchor>
      <arglist>{ ConHostFound, ConConnected, ConClosed }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Error</anchor>
      <arglist>{ NoError = 0, ErrValid, ErrUnknownProtocol, ErrUnsupported, ErrParse, ErrLoginIncorrect, ErrHostNotFound, ErrListChildren, ErrListChlidren = ErrListChildren, ErrMkDir, ErrMkdir = ErrMkDir, ErrRemove, ErrRename, ErrGet, ErrPut, ErrFileNotExisting, ErrPermissionDenied }</arglist>
    </member>
    <member kind="function">
      <name>QNetworkProtocol</name>
      <anchor>QNetworkProtocol</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QNetworkProtocol</name>
      <anchor>QNetworkProtocol</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setUrl</name>
      <anchor>setUrl</anchor>
      <arglist>( QUrlOperator * u )</arglist>
    </member>
    <member kind="function">
      <name>setAutoDelete</name>
      <anchor>setAutoDelete</anchor>
      <arglist>( bool b, int i = 10000 )</arglist>
    </member>
    <member kind="function">
      <name>autoDelete</name>
      <anchor>autoDelete</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>supportedOperations</name>
      <anchor>supportedOperations</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>addOperation</name>
      <anchor>addOperation</anchor>
      <arglist>( QNetworkOperation * op )</arglist>
    </member>
    <member kind="function">
      <name>url</name>
      <anchor>url</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>operationInProgress</name>
      <anchor>operationInProgress</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>clearOperationQueue</name>
      <anchor>clearOperationQueue</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>stop</name>
      <anchor>stop</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>data</name>
      <anchor>data</anchor>
      <arglist>( const QByteArray &amp; data, QNetworkOperation * op )</arglist>
    </member>
    <member kind="function">
      <name>connectionStateChanged</name>
      <anchor>connectionStateChanged</anchor>
      <arglist>( int state, const QString &amp; data )</arglist>
    </member>
    <member kind="function">
      <name>finished</name>
      <anchor>finished</anchor>
      <arglist>( QNetworkOperation * op )</arglist>
    </member>
    <member kind="function">
      <name>start</name>
      <anchor>start</anchor>
      <arglist>( QNetworkOperation * op )</arglist>
    </member>
    <member kind="function">
      <name>newChildren</name>
      <anchor>newChildren</anchor>
      <arglist>( const QValueList&lt;QUrlInfo&gt; &amp; i, QNetworkOperation * op )</arglist>
    </member>
    <member kind="function">
      <name>newChild</name>
      <anchor>newChild</anchor>
      <arglist>( const QUrlInfo &amp; i, QNetworkOperation * op )</arglist>
    </member>
    <member kind="function">
      <name>createdDirectory</name>
      <anchor>createdDirectory</anchor>
      <arglist>( const QUrlInfo &amp; i, QNetworkOperation * op )</arglist>
    </member>
    <member kind="function">
      <name>removed</name>
      <anchor>removed</anchor>
      <arglist>( QNetworkOperation * op )</arglist>
    </member>
    <member kind="function">
      <name>itemChanged</name>
      <anchor>itemChanged</anchor>
      <arglist>( QNetworkOperation * op )</arglist>
    </member>
    <member kind="function">
      <name>dataTransferProgress</name>
      <anchor>dataTransferProgress</anchor>
      <arglist>( int bytesDone, int bytesTotal, QNetworkOperation * op )</arglist>
    </member>
    <member kind="function">
      <name>registerNetworkProtocol</name>
      <anchor>registerNetworkProtocol</anchor>
      <arglist>( const QString &amp; protocol, QNetworkProtocolFactoryBase * protocolFactory )</arglist>
    </member>
    <member kind="function">
      <name>getNetworkProtocol</name>
      <anchor>getNetworkProtocol</anchor>
      <arglist>( const QString &amp; protocol )</arglist>
    </member>
    <member kind="function">
      <name>hasOnlyLocalFileSystem</name>
      <anchor>hasOnlyLocalFileSystem</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>operationListChildren</name>
      <anchor>operationListChildren</anchor>
      <arglist>( QNetworkOperation * op )</arglist>
    </member>
    <member kind="function">
      <name>operationMkDir</name>
      <anchor>operationMkDir</anchor>
      <arglist>( QNetworkOperation * op )</arglist>
    </member>
    <member kind="function">
      <name>operationRemove</name>
      <anchor>operationRemove</anchor>
      <arglist>( QNetworkOperation * op )</arglist>
    </member>
    <member kind="function">
      <name>operationRename</name>
      <anchor>operationRename</anchor>
      <arglist>( QNetworkOperation * op )</arglist>
    </member>
    <member kind="function">
      <name>operationGet</name>
      <anchor>operationGet</anchor>
      <arglist>( QNetworkOperation * op )</arglist>
    </member>
    <member kind="function">
      <name>operationPut</name>
      <anchor>operationPut</anchor>
      <arglist>( QNetworkOperation * op )</arglist>
    </member>
    <member kind="function">
      <name>checkConnection</name>
      <anchor>checkConnection</anchor>
      <arglist>( QNetworkOperation * op )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QNPInstance</name>
    <filename>qnpinstance.html</filename>
    <member kind="function">
      <name>QNPInstance</name>
      <anchor>QNPInstance</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>argc</name>
      <anchor>argc</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>argn</name>
      <anchor>argn</anchor>
      <arglist>( int i ) const</arglist>
    </member>
    <member kind="function">
      <name>argv</name>
      <anchor>argv</anchor>
      <arglist>( int i ) const</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Reason</anchor>
      <arglist>{ ReasonDone = 0, ReasonBreak = 1, ReasonError = 2, ReasonUnknown = -1 }</arglist>
    </member>
    <member kind="function">
      <name>arg</name>
      <anchor>arg</anchor>
      <arglist>( const char * name ) const</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>InstanceMode</anchor>
      <arglist>{ Embed = 1, Full = 2, Background = 3 }</arglist>
    </member>
    <member kind="function">
      <name>mode</name>
      <anchor>mode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>userAgent</name>
      <anchor>userAgent</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>newWindow</name>
      <anchor>newWindow</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>widget</name>
      <anchor>widget</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>StreamMode</anchor>
      <arglist>{ Normal = 1, Seek = 2, AsFile = 3, AsFileOnly = 4 }</arglist>
    </member>
    <member kind="function">
      <name>newStreamCreated</name>
      <anchor>newStreamCreated</anchor>
      <arglist>( QNPStream *, StreamMode &amp; smode )</arglist>
    </member>
    <member kind="function">
      <name>writeReady</name>
      <anchor>writeReady</anchor>
      <arglist>( QNPStream * )</arglist>
    </member>
    <member kind="function">
      <name>write</name>
      <anchor>write</anchor>
      <arglist>( QNPStream *, int offset, int len, void * buffer )</arglist>
    </member>
    <member kind="function">
      <name>streamDestroyed</name>
      <anchor>streamDestroyed</anchor>
      <arglist>( QNPStream * )</arglist>
    </member>
    <member kind="function">
      <name>status</name>
      <anchor>status</anchor>
      <arglist>( const char * msg )</arglist>
    </member>
    <member kind="function">
      <name>getURLNotify</name>
      <anchor>getURLNotify</anchor>
      <arglist>( const char * url, const char * window = 0, void * data = 0 )</arglist>
    </member>
    <member kind="function">
      <name>getURL</name>
      <anchor>getURL</anchor>
      <arglist>( const char * url, const char * window = 0 )</arglist>
    </member>
    <member kind="function">
      <name>postURL</name>
      <anchor>postURL</anchor>
      <arglist>( const char * url, const char * window, uint len, const char * buf, bool file )</arglist>
    </member>
    <member kind="function">
      <name>newStream</name>
      <anchor>newStream</anchor>
      <arglist>( const char * mimetype, const char * window, bool as_file = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>streamAsFile</name>
      <anchor>streamAsFile</anchor>
      <arglist>( QNPStream *, const char * fname )</arglist>
    </member>
    <member kind="function">
      <name>getJavaPeer</name>
      <anchor>getJavaPeer</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>notifyURL</name>
      <anchor>notifyURL</anchor>
      <arglist>( const char * url, Reason r, void * notifyData )</arglist>
    </member>
    <member kind="function">
      <name>printFullPage</name>
      <anchor>printFullPage</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>print</name>
      <anchor>print</anchor>
      <arglist>( QPainter * )</arglist>
    </member>
    <member kind="function">
      <name>QNPInstance</name>
      <anchor>QNPInstance</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QNPlugin</name>
    <filename>qnplugin.html</filename>
    <member kind="function">
      <name>QNPlugin</name>
      <anchor>QNPlugin</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>getVersionInfo</name>
      <anchor>getVersionInfo</anchor>
      <arglist>( int &amp; plugin_major, int &amp; plugin_minor, int &amp; browser_major, int &amp; browser_minor )</arglist>
    </member>
    <member kind="function">
      <name>newInstance</name>
      <anchor>newInstance</anchor>
      <arglist>() = 0</arglist>
    </member>
    <member kind="function">
      <name>getMIMEDescription</name>
      <anchor>getMIMEDescription</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>getPluginNameString</name>
      <anchor>getPluginNameString</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>getPluginDescriptionString</name>
      <anchor>getPluginDescriptionString</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>getJavaClass</name>
      <anchor>getJavaClass</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>unuseJavaClass</name>
      <anchor>unuseJavaClass</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>getJavaEnv</name>
      <anchor>getJavaEnv</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>create</name>
      <anchor>create</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>actual</name>
      <anchor>actual</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QNPlugin</name>
      <anchor>QNPlugin</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QNPStream</name>
    <filename>qnpstream.html</filename>
    <member kind="function">
      <name>QNPStream</name>
      <anchor>QNPStream</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>url</name>
      <anchor>url</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>end</name>
      <anchor>end</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>lastModified</name>
      <anchor>lastModified</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>type</name>
      <anchor>type</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>seekable</name>
      <anchor>seekable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>okay</name>
      <anchor>okay</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>complete</name>
      <anchor>complete</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>requestRead</name>
      <anchor>requestRead</anchor>
      <arglist>( int offset, uint length )</arglist>
    </member>
    <member kind="function">
      <name>write</name>
      <anchor>write</anchor>
      <arglist>( int len, void * buffer )</arglist>
    </member>
    <member kind="function">
      <name>instance</name>
      <anchor>instance</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QNPStream</name>
      <anchor>QNPStream</anchor>
      <arglist>( QNPInstance * in, const char * mt, _NPStream * st, bool se )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QNPWidget</name>
    <filename>qnpwidget.html</filename>
    <member kind="function">
      <name>QNPWidget</name>
      <anchor>QNPWidget</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QNPWidget</name>
      <anchor>QNPWidget</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>enterInstance</name>
      <anchor>enterInstance</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>leaveInstance</name>
      <anchor>leaveInstance</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>instance</name>
      <anchor>instance</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QObject</name>
    <filename>qobject.html</filename>
    <member kind="function">
      <name>QObject</name>
      <anchor>QObject</anchor>
      <arglist>( QObject * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QObject</name>
      <anchor>QObject</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>className</name>
      <anchor>className</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>metaObject</name>
      <anchor>metaObject</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>event</name>
      <anchor>event</anchor>
      <arglist>( QEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>eventFilter</name>
      <anchor>eventFilter</anchor>
      <arglist>( QObject * watched, QEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>isA</name>
      <anchor>isA</anchor>
      <arglist>( const char * clname ) const</arglist>
    </member>
    <member kind="function">
      <name>inherits</name>
      <anchor>inherits</anchor>
      <arglist>( const char * clname ) const</arglist>
    </member>
    <member kind="function">
      <name>name</name>
      <anchor>name</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>name</name>
      <anchor>name</anchor>
      <arglist>( const char * defaultName ) const</arglist>
    </member>
    <member kind="function">
      <name>setName</name>
      <anchor>setName</anchor>
      <arglist>( const char * name )</arglist>
    </member>
    <member kind="function">
      <name>isWidgetType</name>
      <anchor>isWidgetType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>highPriority</name>
      <anchor>highPriority</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>signalsBlocked</name>
      <anchor>signalsBlocked</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>blockSignals</name>
      <anchor>blockSignals</anchor>
      <arglist>( bool block )</arglist>
    </member>
    <member kind="function">
      <name>startTimer</name>
      <anchor>startTimer</anchor>
      <arglist>( int interval )</arglist>
    </member>
    <member kind="function">
      <name>killTimer</name>
      <anchor>killTimer</anchor>
      <arglist>( int id )</arglist>
    </member>
    <member kind="function">
      <name>killTimers</name>
      <anchor>killTimers</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>child</name>
      <anchor>child</anchor>
      <arglist>( const char * objName, const char * inheritsClass = 0, bool recursiveSearch = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>children</name>
      <anchor>children</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>queryList</name>
      <anchor>queryList</anchor>
      <arglist>( const char * inheritsClass = 0, const char * objName = 0, bool regexpMatch = TRUE, bool recursiveSearch = TRUE ) const</arglist>
    </member>
    <member kind="function">
      <name>insertChild</name>
      <anchor>insertChild</anchor>
      <arglist>( QObject * obj )</arglist>
    </member>
    <member kind="function">
      <name>removeChild</name>
      <anchor>removeChild</anchor>
      <arglist>( QObject * obj )</arglist>
    </member>
    <member kind="function">
      <name>installEventFilter</name>
      <anchor>installEventFilter</anchor>
      <arglist>( const QObject * filterObj )</arglist>
    </member>
    <member kind="function">
      <name>removeEventFilter</name>
      <anchor>removeEventFilter</anchor>
      <arglist>( const QObject * obj )</arglist>
    </member>
    <member kind="function">
      <name>connect</name>
      <anchor>connect</anchor>
      <arglist>( const QObject * sender, const char * signal, const char * member ) const</arglist>
    </member>
    <member kind="function">
      <name>disconnect</name>
      <anchor>disconnect</anchor>
      <arglist>( const char * signal = 0, const QObject * receiver = 0, const char * member = 0 )</arglist>
    </member>
    <member kind="function">
      <name>disconnect</name>
      <anchor>disconnect</anchor>
      <arglist>( const QObject * receiver, const char * member = 0 )</arglist>
    </member>
    <member kind="function">
      <name>dumpObjectTree</name>
      <anchor>dumpObjectTree</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>dumpObjectInfo</name>
      <anchor>dumpObjectInfo</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setProperty</name>
      <anchor>setProperty</anchor>
      <arglist>( const char * name, const QVariant &amp; value )</arglist>
    </member>
    <member kind="function">
      <name>property</name>
      <anchor>property</anchor>
      <arglist>( const char * name ) const</arglist>
    </member>
    <member kind="function">
      <name>parent</name>
      <anchor>parent</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>deleteLater</name>
      <anchor>deleteLater</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>destroyed</name>
      <anchor>destroyed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>destroyed</name>
      <anchor>destroyed</anchor>
      <arglist>( QObject * obj )</arglist>
    </member>
    <member kind="function">
      <name>tr</name>
      <anchor>tr</anchor>
      <arglist>( const char * sourceText, const char * comment )</arglist>
    </member>
    <member kind="function">
      <name>trUtf8</name>
      <anchor>trUtf8</anchor>
      <arglist>( const char * sourceText, const char * comment )</arglist>
    </member>
    <member kind="function">
      <name>objectTrees</name>
      <anchor>objectTrees</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>connect</name>
      <anchor>connect</anchor>
      <arglist>( const QObject * sender, const char * signal, const QObject * receiver, const char * member )</arglist>
    </member>
    <member kind="function">
      <name>disconnect</name>
      <anchor>disconnect</anchor>
      <arglist>( const QObject * sender, const char * signal, const QObject * receiver, const char * member )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>name</anchor>
      <arglist>- the name of this object</arglist>
    </member>
    <member kind="function">
      <name>sender</name>
      <anchor>sender</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>timerEvent</name>
      <anchor>timerEvent</anchor>
      <arglist>( QTimerEvent * )</arglist>
    </member>
    <member kind="function">
      <name>childEvent</name>
      <anchor>childEvent</anchor>
      <arglist>( QChildEvent * )</arglist>
    </member>
    <member kind="function">
      <name>customEvent</name>
      <anchor>customEvent</anchor>
      <arglist>( QCustomEvent * )</arglist>
    </member>
    <member kind="function">
      <name>connectNotify</name>
      <anchor>connectNotify</anchor>
      <arglist>( const char * signal )</arglist>
    </member>
    <member kind="function">
      <name>disconnectNotify</name>
      <anchor>disconnectNotify</anchor>
      <arglist>( const char * signal )</arglist>
    </member>
    <member kind="function">
      <name>checkConnectArgs</name>
      <anchor>checkConnectArgs</anchor>
      <arglist>( const char * signal, const QObject * receiver, const char * member )</arglist>
    </member>
    <member kind="function">
      <name>normalizeSignalSlot</name>
      <anchor>normalizeSignalSlot</anchor>
      <arglist>( const char * signalSlot )</arglist>
    </member>
    <member kind="function">
      <name>qt_find_obj_child</name>
      <anchor>qt_find_obj_child</anchor>
      <arglist>( QObject * parent, const char * type, const char * name )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QObjectCleanupHandler</name>
    <filename>qobjectcleanuphandler.html</filename>
    <member kind="function">
      <name>QObjectCleanupHandler</name>
      <anchor>QObjectCleanupHandler</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QObjectCleanupHandler</name>
      <anchor>QObjectCleanupHandler</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>add</name>
      <anchor>add</anchor>
      <arglist>( QObject * object )</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>( QObject * object )</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QObjectList</name>
    <filename>qobjectlist.html</filename>
    <member kind="function">
      <name>QObjectList</name>
      <anchor>QObjectList</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QObjectList</name>
      <anchor>QObjectList</anchor>
      <arglist>( const QObjectList &amp; list )</arglist>
    </member>
    <member kind="function">
      <name>QObjectList</name>
      <anchor>QObjectList</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QObjectList &amp; list )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QObjectListIterator</name>
    <filename>qobjectlistiterator.html</filename>
    <member kind="function">
      <name>QObjectListIterator</name>
      <anchor>QObjectListIterator</anchor>
      <arglist>( const QObjectList &amp; list )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QObjectListIterator &amp; it )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPaintDevice</name>
    <filename>qpaintdevice.html</filename>
    <member kind="function">
      <name>QPaintDevice</name>
      <anchor>QPaintDevice</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>isExtDev</name>
      <anchor>isExtDev</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>paintingActive</name>
      <anchor>paintingActive</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>handle</name>
      <anchor>handle</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>x11Display</name>
      <anchor>x11Display</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>x11Screen</name>
      <anchor>x11Screen</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>x11Depth</name>
      <anchor>x11Depth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>x11Cells</name>
      <anchor>x11Cells</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>x11Colormap</name>
      <anchor>x11Colormap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>x11DefaultColormap</name>
      <anchor>x11DefaultColormap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>x11Visual</name>
      <anchor>x11Visual</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>x11DefaultVisual</name>
      <anchor>x11DefaultVisual</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>x11AppDisplay</name>
      <anchor>x11AppDisplay</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>x11AppScreen</name>
      <anchor>x11AppScreen</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>x11AppDpiX</name>
      <anchor>x11AppDpiX</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>x11AppDpiY</name>
      <anchor>x11AppDpiY</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>x11SetAppDpiX</name>
      <anchor>x11SetAppDpiX</anchor>
      <arglist>( int dpi )</arglist>
    </member>
    <member kind="function">
      <name>x11SetAppDpiY</name>
      <anchor>x11SetAppDpiY</anchor>
      <arglist>( int dpi )</arglist>
    </member>
    <member kind="function">
      <name>x11AppDepth</name>
      <anchor>x11AppDepth</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>x11AppCells</name>
      <anchor>x11AppCells</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>x11AppRootWindow</name>
      <anchor>x11AppRootWindow</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>x11AppColormap</name>
      <anchor>x11AppColormap</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>x11AppDefaultColormap</name>
      <anchor>x11AppDefaultColormap</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>x11AppVisual</name>
      <anchor>x11AppVisual</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>x11AppDefaultVisual</name>
      <anchor>x11AppDefaultVisual</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>x11AppDepth</name>
      <anchor>x11AppDepth</anchor>
      <arglist>( int screen )</arglist>
    </member>
    <member kind="function">
      <name>x11AppCells</name>
      <anchor>x11AppCells</anchor>
      <arglist>( int screen )</arglist>
    </member>
    <member kind="function">
      <name>x11AppRootWindow</name>
      <anchor>x11AppRootWindow</anchor>
      <arglist>( int screen )</arglist>
    </member>
    <member kind="function">
      <name>x11AppColormap</name>
      <anchor>x11AppColormap</anchor>
      <arglist>( int screen )</arglist>
    </member>
    <member kind="function">
      <name>x11AppVisual</name>
      <anchor>x11AppVisual</anchor>
      <arglist>( int screen )</arglist>
    </member>
    <member kind="function">
      <name>x11AppDefaultColormap</name>
      <anchor>x11AppDefaultColormap</anchor>
      <arglist>( int screen )</arglist>
    </member>
    <member kind="function">
      <name>x11AppDefaultVisual</name>
      <anchor>x11AppDefaultVisual</anchor>
      <arglist>( int screen )</arglist>
    </member>
    <member kind="function">
      <name>x11AppDpiX</name>
      <anchor>x11AppDpiX</anchor>
      <arglist>( int screen )</arglist>
    </member>
    <member kind="function">
      <name>x11AppDpiY</name>
      <anchor>x11AppDpiY</anchor>
      <arglist>( int screen )</arglist>
    </member>
    <member kind="function">
      <name>x11SetAppDpiX</name>
      <anchor>x11SetAppDpiX</anchor>
      <arglist>( int dpi, int screen )</arglist>
    </member>
    <member kind="function">
      <name>x11SetAppDpiY</name>
      <anchor>x11SetAppDpiY</anchor>
      <arglist>( int dpi, int screen )</arglist>
    </member>
    <member kind="function">
      <name>QPaintDevice</name>
      <anchor>QPaintDevice</anchor>
      <arglist>( uint devflags )</arglist>
    </member>
    <member kind="function">
      <name>cmd</name>
      <anchor>cmd</anchor>
      <arglist>( int, QPainter *, QPDevCmdParam * )</arglist>
    </member>
    <member kind="function">
      <name>bitBlt</name>
      <anchor>bitBlt</anchor>
      <arglist>( QPaintDevice * dst, int dx, int dy, const QPaintDevice * src, int sx, int sy, int sw, int sh, Qt::RasterOp rop, bool ignoreMask )</arglist>
    </member>
    <member kind="function">
      <name>bitBlt</name>
      <anchor>bitBlt</anchor>
      <arglist>( QPaintDevice * dst, const QPoint &amp; dp, const QPaintDevice * src, const QRect &amp; sr, RasterOp rop )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPaintDeviceMetrics</name>
    <filename>qpaintdevicemetrics.html</filename>
    <member kind="function">
      <name>QPaintDeviceMetrics</name>
      <anchor>QPaintDeviceMetrics</anchor>
      <arglist>( const QPaintDevice * pd )</arglist>
    </member>
    <member kind="function">
      <name>width</name>
      <anchor>width</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>height</name>
      <anchor>height</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>widthMM</name>
      <anchor>widthMM</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>heightMM</name>
      <anchor>heightMM</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>logicalDpiX</name>
      <anchor>logicalDpiX</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>logicalDpiY</name>
      <anchor>logicalDpiY</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>numColors</name>
      <anchor>numColors</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>depth</name>
      <anchor>depth</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPainter</name>
    <filename>qpainter.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>CoordinateMode</anchor>
      <arglist>{ CoordDevice, CoordPainter }</arglist>
    </member>
    <member kind="function">
      <name>QPainter</name>
      <anchor>QPainter</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QPainter</name>
      <anchor>QPainter</anchor>
      <arglist>( const QPaintDevice * pd, bool unclipped = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>QPainter</name>
      <anchor>QPainter</anchor>
      <arglist>( const QPaintDevice * pd, const QWidget * copyAttributes, bool unclipped = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>QPainter</name>
      <anchor>QPainter</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>begin</name>
      <anchor>begin</anchor>
      <arglist>( const QPaintDevice * pd, bool unclipped = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>begin</name>
      <anchor>begin</anchor>
      <arglist>( const QPaintDevice * pd, const QWidget * copyAttributes, bool unclipped = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>end</name>
      <anchor>end</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>device</name>
      <anchor>device</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isActive</name>
      <anchor>isActive</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>flush</name>
      <anchor>flush</anchor>
      <arglist>( const QRegion &amp; region, CoordinateMode cm = CoordDevice )</arglist>
    </member>
    <member kind="function">
      <name>flush</name>
      <anchor>flush</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>save</name>
      <anchor>save</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>restore</name>
      <anchor>restore</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>fontMetrics</name>
      <anchor>fontMetrics</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>fontInfo</name>
      <anchor>fontInfo</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>font</name>
      <anchor>font</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setFont</name>
      <anchor>setFont</anchor>
      <arglist>( const QFont &amp; font )</arglist>
    </member>
    <member kind="function">
      <name>pen</name>
      <anchor>pen</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPen</name>
      <anchor>setPen</anchor>
      <arglist>( const QPen &amp; pen )</arglist>
    </member>
    <member kind="function">
      <name>setPen</name>
      <anchor>setPen</anchor>
      <arglist>( PenStyle style )</arglist>
    </member>
    <member kind="function">
      <name>setPen</name>
      <anchor>setPen</anchor>
      <arglist>( const QColor &amp; color )</arglist>
    </member>
    <member kind="function">
      <name>brush</name>
      <anchor>brush</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setBrush</name>
      <anchor>setBrush</anchor>
      <arglist>( const QBrush &amp; brush )</arglist>
    </member>
    <member kind="function">
      <name>setBrush</name>
      <anchor>setBrush</anchor>
      <arglist>( BrushStyle style )</arglist>
    </member>
    <member kind="function">
      <name>setBrush</name>
      <anchor>setBrush</anchor>
      <arglist>( const QColor &amp; color )</arglist>
    </member>
    <member kind="function">
      <name>backgroundColor</name>
      <anchor>backgroundColor</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setBackgroundColor</name>
      <anchor>setBackgroundColor</anchor>
      <arglist>( const QColor &amp; c )</arglist>
    </member>
    <member kind="function">
      <name>backgroundMode</name>
      <anchor>backgroundMode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setBackgroundMode</name>
      <anchor>setBackgroundMode</anchor>
      <arglist>( BGMode m )</arglist>
    </member>
    <member kind="function">
      <name>rasterOp</name>
      <anchor>rasterOp</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setRasterOp</name>
      <anchor>setRasterOp</anchor>
      <arglist>( RasterOp r )</arglist>
    </member>
    <member kind="function">
      <name>brushOrigin</name>
      <anchor>brushOrigin</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setBrushOrigin</name>
      <anchor>setBrushOrigin</anchor>
      <arglist>( int x, int y )</arglist>
    </member>
    <member kind="function">
      <name>setBrushOrigin</name>
      <anchor>setBrushOrigin</anchor>
      <arglist>( const QPoint &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>hasViewXForm</name>
      <anchor>hasViewXForm</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>hasWorldXForm</name>
      <anchor>hasWorldXForm</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setViewXForm</name>
      <anchor>setViewXForm</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>window</name>
      <anchor>window</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setWindow</name>
      <anchor>setWindow</anchor>
      <arglist>( const QRect &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>setWindow</name>
      <anchor>setWindow</anchor>
      <arglist>( int x, int y, int w, int h )</arglist>
    </member>
    <member kind="function">
      <name>viewport</name>
      <anchor>viewport</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setViewport</name>
      <anchor>setViewport</anchor>
      <arglist>( const QRect &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>setViewport</name>
      <anchor>setViewport</anchor>
      <arglist>( int x, int y, int w, int h )</arglist>
    </member>
    <member kind="function">
      <name>setWorldXForm</name>
      <anchor>setWorldXForm</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>worldMatrix</name>
      <anchor>worldMatrix</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setWorldMatrix</name>
      <anchor>setWorldMatrix</anchor>
      <arglist>( const QWMatrix &amp; m, bool combine = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>scale</name>
      <anchor>scale</anchor>
      <arglist>( double sx, double sy )</arglist>
    </member>
    <member kind="function">
      <name>shear</name>
      <anchor>shear</anchor>
      <arglist>( double sh, double sv )</arglist>
    </member>
    <member kind="function">
      <name>rotate</name>
      <anchor>rotate</anchor>
      <arglist>( double a )</arglist>
    </member>
    <member kind="function">
      <name>translate</name>
      <anchor>translate</anchor>
      <arglist>( double dx, double dy )</arglist>
    </member>
    <member kind="function">
      <name>resetXForm</name>
      <anchor>resetXForm</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>xForm</name>
      <anchor>xForm</anchor>
      <arglist>( const QPoint &amp; pv ) const</arglist>
    </member>
    <member kind="function">
      <name>xForm</name>
      <anchor>xForm</anchor>
      <arglist>( const QRect &amp; rv ) const</arglist>
    </member>
    <member kind="function">
      <name>xForm</name>
      <anchor>xForm</anchor>
      <arglist>( const QPointArray &amp; av ) const</arglist>
    </member>
    <member kind="function">
      <name>xForm</name>
      <anchor>xForm</anchor>
      <arglist>( const QPointArray &amp; av, int index, int npoints ) const</arglist>
    </member>
    <member kind="function">
      <name>xFormDev</name>
      <anchor>xFormDev</anchor>
      <arglist>( const QPoint &amp; pd ) const</arglist>
    </member>
    <member kind="function">
      <name>xFormDev</name>
      <anchor>xFormDev</anchor>
      <arglist>( const QRect &amp; rd ) const</arglist>
    </member>
    <member kind="function">
      <name>xFormDev</name>
      <anchor>xFormDev</anchor>
      <arglist>( const QPointArray &amp; ad ) const</arglist>
    </member>
    <member kind="function">
      <name>xFormDev</name>
      <anchor>xFormDev</anchor>
      <arglist>( const QPointArray &amp; ad, int index, int npoints ) const</arglist>
    </member>
    <member kind="function">
      <name>setClipping</name>
      <anchor>setClipping</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>hasClipping</name>
      <anchor>hasClipping</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>clipRegion</name>
      <anchor>clipRegion</anchor>
      <arglist>( CoordinateMode m = CoordDevice ) const</arglist>
    </member>
    <member kind="function">
      <name>setClipRect</name>
      <anchor>setClipRect</anchor>
      <arglist>( const QRect &amp; r, CoordinateMode m = CoordDevice )</arglist>
    </member>
    <member kind="function">
      <name>setClipRect</name>
      <anchor>setClipRect</anchor>
      <arglist>( int x, int y, int w, int h, CoordinateMode m = CoordDevice )</arglist>
    </member>
    <member kind="function">
      <name>setClipRegion</name>
      <anchor>setClipRegion</anchor>
      <arglist>( const QRegion &amp; rgn, CoordinateMode m = CoordDevice )</arglist>
    </member>
    <member kind="function">
      <name>drawPoint</name>
      <anchor>drawPoint</anchor>
      <arglist>( int x, int y )</arglist>
    </member>
    <member kind="function">
      <name>drawPoint</name>
      <anchor>drawPoint</anchor>
      <arglist>( const QPoint &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>drawPoints</name>
      <anchor>drawPoints</anchor>
      <arglist>( const QPointArray &amp; a, int index = 0, int npoints = -1 )</arglist>
    </member>
    <member kind="function">
      <name>drawLine</name>
      <anchor>drawLine</anchor>
      <arglist>( int x1, int y1, int x2, int y2 )</arglist>
    </member>
    <member kind="function">
      <name>drawLine</name>
      <anchor>drawLine</anchor>
      <arglist>( const QPoint &amp; p1, const QPoint &amp; p2 )</arglist>
    </member>
    <member kind="function">
      <name>drawRect</name>
      <anchor>drawRect</anchor>
      <arglist>( int x, int y, int w, int h )</arglist>
    </member>
    <member kind="function">
      <name>drawRect</name>
      <anchor>drawRect</anchor>
      <arglist>( const QRect &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>drawWinFocusRect</name>
      <anchor>drawWinFocusRect</anchor>
      <arglist>( int x, int y, int w, int h )</arglist>
    </member>
    <member kind="function">
      <name>drawWinFocusRect</name>
      <anchor>drawWinFocusRect</anchor>
      <arglist>( int x, int y, int w, int h, const QColor &amp; bgColor )</arglist>
    </member>
    <member kind="function">
      <name>drawWinFocusRect</name>
      <anchor>drawWinFocusRect</anchor>
      <arglist>( const QRect &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>drawWinFocusRect</name>
      <anchor>drawWinFocusRect</anchor>
      <arglist>( const QRect &amp; r, const QColor &amp; bgColor )</arglist>
    </member>
    <member kind="function">
      <name>drawRoundRect</name>
      <anchor>drawRoundRect</anchor>
      <arglist>( int x, int y, int w, int h, int xRnd = 25, int yRnd = 25 )</arglist>
    </member>
    <member kind="function">
      <name>drawRoundRect</name>
      <anchor>drawRoundRect</anchor>
      <arglist>( const QRect &amp; r, int xRnd = 25, int yRnd = 25 )</arglist>
    </member>
    <member kind="function">
      <name>drawEllipse</name>
      <anchor>drawEllipse</anchor>
      <arglist>( int x, int y, int w, int h )</arglist>
    </member>
    <member kind="function">
      <name>drawEllipse</name>
      <anchor>drawEllipse</anchor>
      <arglist>( const QRect &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>drawArc</name>
      <anchor>drawArc</anchor>
      <arglist>( int x, int y, int w, int h, int a, int alen )</arglist>
    </member>
    <member kind="function">
      <name>drawArc</name>
      <anchor>drawArc</anchor>
      <arglist>( const QRect &amp; r, int a, int alen )</arglist>
    </member>
    <member kind="function">
      <name>drawPie</name>
      <anchor>drawPie</anchor>
      <arglist>( int x, int y, int w, int h, int a, int alen )</arglist>
    </member>
    <member kind="function">
      <name>drawPie</name>
      <anchor>drawPie</anchor>
      <arglist>( const QRect &amp; r, int a, int alen )</arglist>
    </member>
    <member kind="function">
      <name>drawChord</name>
      <anchor>drawChord</anchor>
      <arglist>( int x, int y, int w, int h, int a, int alen )</arglist>
    </member>
    <member kind="function">
      <name>drawChord</name>
      <anchor>drawChord</anchor>
      <arglist>( const QRect &amp; r, int a, int alen )</arglist>
    </member>
    <member kind="function">
      <name>drawLineSegments</name>
      <anchor>drawLineSegments</anchor>
      <arglist>( const QPointArray &amp; a, int index = 0, int nlines = -1 )</arglist>
    </member>
    <member kind="function">
      <name>drawPolyline</name>
      <anchor>drawPolyline</anchor>
      <arglist>( const QPointArray &amp; a, int index = 0, int npoints = -1 )</arglist>
    </member>
    <member kind="function">
      <name>drawPolygon</name>
      <anchor>drawPolygon</anchor>
      <arglist>( const QPointArray &amp; a, bool winding = FALSE, int index = 0, int npoints = -1 )</arglist>
    </member>
    <member kind="function">
      <name>drawConvexPolygon</name>
      <anchor>drawConvexPolygon</anchor>
      <arglist>( const QPointArray &amp; pa, int index = 0, int npoints = -1 )</arglist>
    </member>
    <member kind="function">
      <name>drawCubicBezier</name>
      <anchor>drawCubicBezier</anchor>
      <arglist>( const QPointArray &amp; a, int index = 0 )</arglist>
    </member>
    <member kind="function">
      <name>drawPixmap</name>
      <anchor>drawPixmap</anchor>
      <arglist>( int x, int y, const QPixmap &amp; pixmap, int sx = 0, int sy = 0, int sw = -1, int sh = -1 )</arglist>
    </member>
    <member kind="function">
      <name>drawPixmap</name>
      <anchor>drawPixmap</anchor>
      <arglist>( const QPoint &amp; p, const QPixmap &amp; pm, const QRect &amp; sr )</arglist>
    </member>
    <member kind="function">
      <name>drawPixmap</name>
      <anchor>drawPixmap</anchor>
      <arglist>( const QPoint &amp; p, const QPixmap &amp; pm )</arglist>
    </member>
    <member kind="function">
      <name>drawPixmap</name>
      <anchor>drawPixmap</anchor>
      <arglist>( const QRect &amp; r, const QPixmap &amp; pm )</arglist>
    </member>
    <member kind="function">
      <name>drawImage</name>
      <anchor>drawImage</anchor>
      <arglist>( int x, int y, const QImage &amp; image, int sx = 0, int sy = 0, int sw = -1, int sh = -1, int conversionFlags = 0 )</arglist>
    </member>
    <member kind="function">
      <name>drawImage</name>
      <anchor>drawImage</anchor>
      <arglist>( const QPoint &amp;, const QImage &amp;, const QRect &amp; sr, int conversionFlags = 0 )</arglist>
    </member>
    <member kind="function">
      <name>drawImage</name>
      <anchor>drawImage</anchor>
      <arglist>( const QPoint &amp; p, const QImage &amp; i, int conversion_flags = 0 )</arglist>
    </member>
    <member kind="function">
      <name>drawImage</name>
      <anchor>drawImage</anchor>
      <arglist>( const QRect &amp; r, const QImage &amp; i )</arglist>
    </member>
    <member kind="function">
      <name>drawTiledPixmap</name>
      <anchor>drawTiledPixmap</anchor>
      <arglist>( int x, int y, int w, int h, const QPixmap &amp; pixmap, int sx = 0, int sy = 0 )</arglist>
    </member>
    <member kind="function">
      <name>drawTiledPixmap</name>
      <anchor>drawTiledPixmap</anchor>
      <arglist>( const QRect &amp; r, const QPixmap &amp; pm, const QPoint &amp; sp )</arglist>
    </member>
    <member kind="function">
      <name>drawTiledPixmap</name>
      <anchor>drawTiledPixmap</anchor>
      <arglist>( const QRect &amp; r, const QPixmap &amp; pm )</arglist>
    </member>
    <member kind="function">
      <name>drawPicture</name>
      <anchor>drawPicture</anchor>
      <arglist>( int x, int y, const QPicture &amp; pic )</arglist>
    </member>
    <member kind="function">
      <name>drawPicture</name>
      <anchor>drawPicture</anchor>
      <arglist>( const QPoint &amp; p, const QPicture &amp; pic )</arglist>
    </member>
    <member kind="function">
      <name>fillRect</name>
      <anchor>fillRect</anchor>
      <arglist>( int x, int y, int w, int h, const QBrush &amp; brush )</arglist>
    </member>
    <member kind="function">
      <name>fillRect</name>
      <anchor>fillRect</anchor>
      <arglist>( const QRect &amp; r, const QBrush &amp; brush )</arglist>
    </member>
    <member kind="function">
      <name>eraseRect</name>
      <anchor>eraseRect</anchor>
      <arglist>( int x, int y, int w, int h )</arglist>
    </member>
    <member kind="function">
      <name>eraseRect</name>
      <anchor>eraseRect</anchor>
      <arglist>( const QRect &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>TextDirection</anchor>
      <arglist>{ Auto, RTL, LTR }</arglist>
    </member>
    <member kind="function">
      <name>drawText</name>
      <anchor>drawText</anchor>
      <arglist>( int x, int y, const QString &amp;, int len = -1, TextDirection dir = Auto )</arglist>
    </member>
    <member kind="function">
      <name>drawText</name>
      <anchor>drawText</anchor>
      <arglist>( const QPoint &amp;, const QString &amp;, int len = -1, TextDirection dir = Auto )</arglist>
    </member>
    <member kind="function">
      <name>drawText</name>
      <anchor>drawText</anchor>
      <arglist>( int x, int y, const QString &amp;, int pos, int len, TextDirection dir = Auto )</arglist>
    </member>
    <member kind="function">
      <name>drawText</name>
      <anchor>drawText</anchor>
      <arglist>( const QPoint &amp; p, const QString &amp;, int pos, int len, TextDirection dir = Auto )</arglist>
    </member>
    <member kind="function">
      <name>drawText</name>
      <anchor>drawText</anchor>
      <arglist>( int x, int y, int w, int h, int flags, const QString &amp;, int len = -1, QRect * br = 0, QTextParag ** internal = 0 )</arglist>
    </member>
    <member kind="function">
      <name>drawText</name>
      <anchor>drawText</anchor>
      <arglist>( const QRect &amp; r, int tf, const QString &amp; str, int len = -1, QRect * brect = 0, QTextParag ** internal = 0 )</arglist>
    </member>
    <member kind="function">
      <name>boundingRect</name>
      <anchor>boundingRect</anchor>
      <arglist>( int x, int y, int w, int h, int flags, const QString &amp;, int len = -1, QTextParag ** intern = 0 )</arglist>
    </member>
    <member kind="function">
      <name>boundingRect</name>
      <anchor>boundingRect</anchor>
      <arglist>( const QRect &amp; r, int flags, const QString &amp; str, int len = -1, QTextParag ** internal = 0 )</arglist>
    </member>
    <member kind="function">
      <name>tabStops</name>
      <anchor>tabStops</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setTabStops</name>
      <anchor>setTabStops</anchor>
      <arglist>( int ts )</arglist>
    </member>
    <member kind="function">
      <name>tabArray</name>
      <anchor>tabArray</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setTabArray</name>
      <anchor>setTabArray</anchor>
      <arglist>( int * ta )</arglist>
    </member>
    <member kind="function">
      <name>handle</name>
      <anchor>handle</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>redirect</name>
      <anchor>redirect</anchor>
      <arglist>( QPaintDevice * pdev, QPaintDevice * replacement )</arglist>
    </member>
    <member kind="function">
      <name>qDrawShadeLine</name>
      <anchor>qDrawShadeLine</anchor>
      <arglist>( QPainter * p, int x1, int y1, int x2, int y2, const QColorGroup &amp; g, bool sunken, int lineWidth, int midLineWidth )</arglist>
    </member>
    <member kind="function">
      <name>qDrawShadeRect</name>
      <anchor>qDrawShadeRect</anchor>
      <arglist>( QPainter * p, int x, int y, int w, int h, const QColorGroup &amp; g, bool sunken, int lineWidth, int midLineWidth, const QBrush * fill )</arglist>
    </member>
    <member kind="function">
      <name>qDrawShadePanel</name>
      <anchor>qDrawShadePanel</anchor>
      <arglist>( QPainter * p, int x, int y, int w, int h, const QColorGroup &amp; g, bool sunken, int lineWidth, const QBrush * fill )</arglist>
    </member>
    <member kind="function">
      <name>qDrawWinButton</name>
      <anchor>qDrawWinButton</anchor>
      <arglist>( QPainter * p, int x, int y, int w, int h, const QColorGroup &amp; g, bool sunken, const QBrush * fill )</arglist>
    </member>
    <member kind="function">
      <name>qDrawWinPanel</name>
      <anchor>qDrawWinPanel</anchor>
      <arglist>( QPainter * p, int x, int y, int w, int h, const QColorGroup &amp; g, bool sunken, const QBrush * fill )</arglist>
    </member>
    <member kind="function">
      <name>qDrawPlainRect</name>
      <anchor>qDrawPlainRect</anchor>
      <arglist>( QPainter * p, int x, int y, int w, int h, const QColor &amp; c, int lineWidth, const QBrush * fill )</arglist>
    </member>
    <member kind="function">
      <name>translate</name>
      <anchor>translate</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>scale</name>
      <anchor>scale</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>shear</name>
      <anchor>shear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>rotate</name>
      <anchor>rotate</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPaintEvent</name>
    <filename>qpaintevent.html</filename>
    <member kind="function">
      <name>QPaintEvent</name>
      <anchor>QPaintEvent</anchor>
      <arglist>( const QRegion &amp; paintRegion, bool erased = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>QPaintEvent</name>
      <anchor>QPaintEvent</anchor>
      <arglist>( const QRect &amp; paintRect, bool erased = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>rect</name>
      <anchor>rect</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>region</name>
      <anchor>region</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>erased</name>
      <anchor>erased</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPair</name>
    <filename>qpair.html</filename>
    <member kind="function">
      <name>first_type</name>
      <anchor>first_type</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>second_type</name>
      <anchor>second_type</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>QPair</name>
      <anchor>QPair</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QPair</name>
      <anchor>QPair</anchor>
      <arglist>( const T1 &amp; t1, const T2 &amp; t2 )</arglist>
    </member>
    <member kind="function">
      <name>qMakePair</name>
      <anchor>qMakePair</anchor>
      <arglist>( T1 t1, T2 t2 )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPalette</name>
    <filename>qpalette.html</filename>
    <member kind="function">
      <name>QPalette</name>
      <anchor>QPalette</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QPalette</name>
      <anchor>QPalette</anchor>
      <arglist>( const QColor &amp; button, const QColor &amp; background )</arglist>
    </member>
    <member kind="function">
      <name>QPalette</name>
      <anchor>QPalette</anchor>
      <arglist>( const QColorGroup &amp; active, const QColorGroup &amp; disabled, const QColorGroup &amp; inactive )</arglist>
    </member>
    <member kind="function">
      <name>QPalette</name>
      <anchor>QPalette</anchor>
      <arglist>( const QPalette &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>QPalette</name>
      <anchor>QPalette</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPalette &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ColorGroup</anchor>
      <arglist>{ Disabled, Active, Inactive, NColorGroups, Normal = Active }</arglist>
    </member>
    <member kind="function">
      <name>color</name>
      <anchor>color</anchor>
      <arglist>( ColorGroup gr, QColorGroup::ColorRole r ) const</arglist>
    </member>
    <member kind="function">
      <name>brush</name>
      <anchor>brush</anchor>
      <arglist>( ColorGroup gr, QColorGroup::ColorRole r ) const</arglist>
    </member>
    <member kind="function">
      <name>setColor</name>
      <anchor>setColor</anchor>
      <arglist>( ColorGroup gr, QColorGroup::ColorRole r, const QColor &amp; c )</arglist>
    </member>
    <member kind="function">
      <name>setBrush</name>
      <anchor>setBrush</anchor>
      <arglist>( ColorGroup gr, QColorGroup::ColorRole r, const QBrush &amp; b )</arglist>
    </member>
    <member kind="function">
      <name>setColor</name>
      <anchor>setColor</anchor>
      <arglist>( QColorGroup::ColorRole r, const QColor &amp; c )</arglist>
    </member>
    <member kind="function">
      <name>setBrush</name>
      <anchor>setBrush</anchor>
      <arglist>( QColorGroup::ColorRole r, const QBrush &amp; b )</arglist>
    </member>
    <member kind="function">
      <name>copy</name>
      <anchor>copy</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>active</name>
      <anchor>active</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>disabled</name>
      <anchor>disabled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>inactive</name>
      <anchor>inactive</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setActive</name>
      <anchor>setActive</anchor>
      <arglist>( const QColorGroup &amp; g )</arglist>
    </member>
    <member kind="function">
      <name>setDisabled</name>
      <anchor>setDisabled</anchor>
      <arglist>( const QColorGroup &amp; g )</arglist>
    </member>
    <member kind="function">
      <name>setInactive</name>
      <anchor>setInactive</anchor>
      <arglist>( const QColorGroup &amp; g )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPalette &amp; p ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPalette &amp; p ) const</arglist>
    </member>
    <member kind="function">
      <name>isCopyOf</name>
      <anchor>isCopyOf</anchor>
      <arglist>( const QPalette &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>serialNumber</name>
      <anchor>serialNumber</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QPalette &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QPalette &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>active</name>
      <anchor>active</anchor>
      <arglist>() group is used for the window that has</arglist>
    </member>
    <member kind="function">
      <name>inactive</name>
      <anchor>inactive</anchor>
      <arglist>() group is used for other windows.</arglist>
    </member>
    <member kind="function">
      <name>disabled</name>
      <anchor>disabled</anchor>
      <arglist>() group is used for widgets (not windows) that are</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPen</name>
    <filename>qpen.html</filename>
    <member kind="function">
      <name>QPen</name>
      <anchor>QPen</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QPen</name>
      <anchor>QPen</anchor>
      <arglist>( PenStyle style )</arglist>
    </member>
    <member kind="function">
      <name>QPen</name>
      <anchor>QPen</anchor>
      <arglist>( const QColor &amp; color, uint width = 0, PenStyle style = SolidLine )</arglist>
    </member>
    <member kind="function">
      <name>QPen</name>
      <anchor>QPen</anchor>
      <arglist>( const QColor &amp; cl, uint w, PenStyle s, PenCapStyle c, PenJoinStyle j )</arglist>
    </member>
    <member kind="function">
      <name>QPen</name>
      <anchor>QPen</anchor>
      <arglist>( const QPen &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>QPen</name>
      <anchor>QPen</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPen &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>style</name>
      <anchor>style</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setStyle</name>
      <anchor>setStyle</anchor>
      <arglist>( PenStyle s )</arglist>
    </member>
    <member kind="function">
      <name>width</name>
      <anchor>width</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setWidth</name>
      <anchor>setWidth</anchor>
      <arglist>( uint w )</arglist>
    </member>
    <member kind="function">
      <name>color</name>
      <anchor>color</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setColor</name>
      <anchor>setColor</anchor>
      <arglist>( const QColor &amp; c )</arglist>
    </member>
    <member kind="function">
      <name>capStyle</name>
      <anchor>capStyle</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setCapStyle</name>
      <anchor>setCapStyle</anchor>
      <arglist>( PenCapStyle c )</arglist>
    </member>
    <member kind="function">
      <name>joinStyle</name>
      <anchor>joinStyle</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setJoinStyle</name>
      <anchor>setJoinStyle</anchor>
      <arglist>( PenJoinStyle j )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPen &amp; p ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPen &amp; p ) const</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QPen &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QPen &amp; p )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPicture</name>
    <filename>qpicture.html</filename>
    <member kind="function">
      <name>QPicture</name>
      <anchor>QPicture</anchor>
      <arglist>( int formatVersion = -1 )</arglist>
    </member>
    <member kind="function">
      <name>QPicture</name>
      <anchor>QPicture</anchor>
      <arglist>( const QPicture &amp; pic )</arglist>
    </member>
    <member kind="function">
      <name>QPicture</name>
      <anchor>QPicture</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>isNull</name>
      <anchor>isNull</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>data</name>
      <anchor>data</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setData</name>
      <anchor>setData</anchor>
      <arglist>( const char * data, uint size )</arglist>
    </member>
    <member kind="function">
      <name>play</name>
      <anchor>play</anchor>
      <arglist>( QPainter * painter )</arglist>
    </member>
    <member kind="function">
      <name>load</name>
      <anchor>load</anchor>
      <arglist>( QIODevice * dev, const char * format = 0 )</arglist>
    </member>
    <member kind="function">
      <name>load</name>
      <anchor>load</anchor>
      <arglist>( const QString &amp; fileName, const char * format = 0 )</arglist>
    </member>
    <member kind="function">
      <name>save</name>
      <anchor>save</anchor>
      <arglist>( QIODevice * dev, const char * format = 0 )</arglist>
    </member>
    <member kind="function">
      <name>save</name>
      <anchor>save</anchor>
      <arglist>( const QString &amp; fileName, const char * format = 0 )</arglist>
    </member>
    <member kind="function">
      <name>boundingRect</name>
      <anchor>boundingRect</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setBoundingRect</name>
      <anchor>setBoundingRect</anchor>
      <arglist>( const QRect &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPicture &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>metric</name>
      <anchor>metric</anchor>
      <arglist>( int m ) const</arglist>
    </member>
    <member kind="function">
      <name>detach</name>
      <anchor>detach</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>copy</name>
      <anchor>copy</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QPicture &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QPicture &amp; r )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPixmap</name>
    <filename>qpixmap.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>ColorMode</anchor>
      <arglist>{ Auto, Color, Mono }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Optimization</anchor>
      <arglist>{ DefaultOptim, NoOptim, MemoryOptim = NoOptim, NormalOptim, BestOptim }</arglist>
    </member>
    <member kind="function">
      <name>QPixmap</name>
      <anchor>QPixmap</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QPixmap</name>
      <anchor>QPixmap</anchor>
      <arglist>( const QImage &amp; image )</arglist>
    </member>
    <member kind="function">
      <name>QPixmap</name>
      <anchor>QPixmap</anchor>
      <arglist>( int w, int h, int depth = -1, Optimization optimization = DefaultOptim )</arglist>
    </member>
    <member kind="function">
      <name>QPixmap</name>
      <anchor>QPixmap</anchor>
      <arglist>( const QSize &amp; size, int depth = -1, Optimization optimization = DefaultOptim )</arglist>
    </member>
    <member kind="function">
      <name>QPixmap</name>
      <anchor>QPixmap</anchor>
      <arglist>( const QString &amp; fileName, const char * format = 0, ColorMode mode = Auto )</arglist>
    </member>
    <member kind="function">
      <name>QPixmap</name>
      <anchor>QPixmap</anchor>
      <arglist>( const QString &amp; fileName, const char * format, int conversion_flags )</arglist>
    </member>
    <member kind="function">
      <name>QPixmap</name>
      <anchor>QPixmap</anchor>
      <arglist>( const char * xpm[] )</arglist>
    </member>
    <member kind="function">
      <name>QPixmap</name>
      <anchor>QPixmap</anchor>
      <arglist>( const QByteArray &amp; img_data )</arglist>
    </member>
    <member kind="function">
      <name>QPixmap</name>
      <anchor>QPixmap</anchor>
      <arglist>( const QPixmap &amp; pixmap )</arglist>
    </member>
    <member kind="function">
      <name>QPixmap</name>
      <anchor>QPixmap</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPixmap &amp; pixmap )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QImage &amp; image )</arglist>
    </member>
    <member kind="function">
      <name>isNull</name>
      <anchor>isNull</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>width</name>
      <anchor>width</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>height</name>
      <anchor>height</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rect</name>
      <anchor>rect</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>depth</name>
      <anchor>depth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>fill</name>
      <anchor>fill</anchor>
      <arglist>( const QColor &amp; fillColor = Qt::white )</arglist>
    </member>
    <member kind="function">
      <name>fill</name>
      <anchor>fill</anchor>
      <arglist>( const QWidget * widget, int xofs, int yofs )</arglist>
    </member>
    <member kind="function">
      <name>fill</name>
      <anchor>fill</anchor>
      <arglist>( const QWidget * widget, const QPoint &amp; ofs )</arglist>
    </member>
    <member kind="function">
      <name>resize</name>
      <anchor>resize</anchor>
      <arglist>( int w, int h )</arglist>
    </member>
    <member kind="function">
      <name>resize</name>
      <anchor>resize</anchor>
      <arglist>( const QSize &amp; size )</arglist>
    </member>
    <member kind="function">
      <name>mask</name>
      <anchor>mask</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMask</name>
      <anchor>setMask</anchor>
      <arglist>( const QBitmap &amp; newmask )</arglist>
    </member>
    <member kind="function">
      <name>selfMask</name>
      <anchor>selfMask</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>hasAlpha</name>
      <anchor>hasAlpha</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>hasAlphaChannel</name>
      <anchor>hasAlphaChannel</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>createHeuristicMask</name>
      <anchor>createHeuristicMask</anchor>
      <arglist>( bool clipTight = TRUE ) const</arglist>
    </member>
    <member kind="function">
      <name>xForm</name>
      <anchor>xForm</anchor>
      <arglist>( const QWMatrix &amp; matrix ) const</arglist>
    </member>
    <member kind="function">
      <name>convertToImage</name>
      <anchor>convertToImage</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>convertFromImage</name>
      <anchor>convertFromImage</anchor>
      <arglist>( const QImage &amp; image, ColorMode mode = Auto )</arglist>
    </member>
    <member kind="function">
      <name>convertFromImage</name>
      <anchor>convertFromImage</anchor>
      <arglist>( const QImage &amp; img, int conversion_flags )</arglist>
    </member>
    <member kind="function">
      <name>load</name>
      <anchor>load</anchor>
      <arglist>( const QString &amp; fileName, const char * format = 0, ColorMode mode = Auto )</arglist>
    </member>
    <member kind="function">
      <name>load</name>
      <anchor>load</anchor>
      <arglist>( const QString &amp; fileName, const char * format, int conversion_flags )</arglist>
    </member>
    <member kind="function">
      <name>loadFromData</name>
      <anchor>loadFromData</anchor>
      <arglist>( const uchar * buf, uint len, const char * format = 0, ColorMode mode = Auto )</arglist>
    </member>
    <member kind="function">
      <name>loadFromData</name>
      <anchor>loadFromData</anchor>
      <arglist>( const uchar * buf, uint len, const char * format, int conversion_flags )</arglist>
    </member>
    <member kind="function">
      <name>loadFromData</name>
      <anchor>loadFromData</anchor>
      <arglist>( const QByteArray &amp; buf, const char * format = 0, int conversion_flags = 0 )</arglist>
    </member>
    <member kind="function">
      <name>save</name>
      <anchor>save</anchor>
      <arglist>( const QString &amp; fileName, const char * format, int quality = -1 ) const</arglist>
    </member>
    <member kind="function">
      <name>save</name>
      <anchor>save</anchor>
      <arglist>( QIODevice * device, const char * format, int quality = -1 ) const</arglist>
    </member>
    <member kind="function">
      <name>serialNumber</name>
      <anchor>serialNumber</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>optimization</name>
      <anchor>optimization</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setOptimization</name>
      <anchor>setOptimization</anchor>
      <arglist>( Optimization optimization )</arglist>
    </member>
    <member kind="function">
      <name>detach</name>
      <anchor>detach</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>isQBitmap</name>
      <anchor>isQBitmap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>metric</name>
      <anchor>metric</anchor>
      <arglist>( int m ) const</arglist>
    </member>
    <member kind="function">
      <name>defaultDepth</name>
      <anchor>defaultDepth</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>fromMimeSource</name>
      <anchor>fromMimeSource</anchor>
      <arglist>( const QString &amp; abs_name )</arglist>
    </member>
    <member kind="function">
      <name>grabWindow</name>
      <anchor>grabWindow</anchor>
      <arglist>( WId window, int x = 0, int y = 0, int w = -1, int h = -1 )</arglist>
    </member>
    <member kind="function">
      <name>grabWidget</name>
      <anchor>grabWidget</anchor>
      <arglist>( QWidget * widget, int x = 0, int y = 0, int w = -1, int h = -1 )</arglist>
    </member>
    <member kind="function">
      <name>trueMatrix</name>
      <anchor>trueMatrix</anchor>
      <arglist>( const QWMatrix &amp; matrix, int w, int h )</arglist>
    </member>
    <member kind="function">
      <name>imageFormat</name>
      <anchor>imageFormat</anchor>
      <arglist>( const QString &amp; fileName )</arglist>
    </member>
    <member kind="function">
      <name>defaultOptimization</name>
      <anchor>defaultOptimization</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setDefaultOptimization</name>
      <anchor>setDefaultOptimization</anchor>
      <arglist>( Optimization optimization )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QPixmap &amp; pixmap )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QPixmap &amp; pixmap )</arglist>
    </member>
    <member kind="function">
      <name>copyBlt</name>
      <anchor>copyBlt</anchor>
      <arglist>( QPixmap * dst, int dx, int dy, const QPixmap * src, int sx, int sy, int sw, int sh )</arglist>
    </member>
    <member kind="function">
      <name>bitBlt</name>
      <anchor>bitBlt</anchor>
      <arglist>() the pixmap contents onto the widget.</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ColorMode</anchor>
      <arglist>or</arglist>
    </member>
    <member kind="function">
      <name>QPixmap</name>
      <anchor>defaultOptimization</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Optimization</anchor>
      <arglist>).</arglist>
    </member>
    <member kind="function">
      <name>setDefaultOptimization</name>
      <anchor>setDefaultOptimization</anchor>
      <arglist>() to set the default optimization</arglist>
    </member>
    <member kind="function">
      <name>setOptimization</name>
      <anchor>setOptimization</anchor>
      <arglist>() to set the optimization for individual</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPixmapCache</name>
    <filename>qpixmapcache.html</filename>
    <member kind="function">
      <name>cacheLimit</name>
      <anchor>cacheLimit</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setCacheLimit</name>
      <anchor>setCacheLimit</anchor>
      <arglist>( int n )</arglist>
    </member>
    <member kind="function">
      <name>find</name>
      <anchor>find</anchor>
      <arglist>( const QString &amp; key )</arglist>
    </member>
    <member kind="function">
      <name>find</name>
      <anchor>find</anchor>
      <arglist>( const QString &amp; key, QPixmap &amp; pm )</arglist>
    </member>
    <member kind="function">
      <name>insert</name>
      <anchor>insert</anchor>
      <arglist>( const QString &amp; key, const QPixmap &amp; pm )</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>( const QString &amp; key )</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPlatinumStyle</name>
    <filename>qplatinumstyle.html</filename>
    <member kind="function">
      <name>QPlatinumStyle</name>
      <anchor>QPlatinumStyle</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>mixedColor</name>
      <anchor>mixedColor</anchor>
      <arglist>( const QColor &amp; c1, const QColor &amp; c2 ) const</arglist>
    </member>
    <member kind="function">
      <name>drawRiffles</name>
      <anchor>drawRiffles</anchor>
      <arglist>( QPainter * p, int x, int y, int w, int h, const QColorGroup &amp; g, bool horizontal ) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPNGImagePacker</name>
    <filename>qpngimagepacker.html</filename>
    <member kind="function">
      <name>QPNGImagePacker</name>
      <anchor>QPNGImagePacker</anchor>
      <arglist>( QIODevice * iod, int storage_depth, int conversionflags )</arglist>
    </member>
    <member kind="function">
      <name>setPixelAlignment</name>
      <anchor>setPixelAlignment</anchor>
      <arglist>( int x )</arglist>
    </member>
    <member kind="function">
      <name>packImage</name>
      <anchor>packImage</anchor>
      <arglist>( const QImage &amp; img )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPoint</name>
    <filename>qpoint.html</filename>
    <member kind="function">
      <name>QPoint</name>
      <anchor>QPoint</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QPoint</name>
      <anchor>QPoint</anchor>
      <arglist>( int xpos, int ypos )</arglist>
    </member>
    <member kind="function">
      <name>isNull</name>
      <anchor>isNull</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>x</name>
      <anchor>x</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>y</name>
      <anchor>y</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setX</name>
      <anchor>setX</anchor>
      <arglist>( int x )</arglist>
    </member>
    <member kind="function">
      <name>setY</name>
      <anchor>setY</anchor>
      <arglist>( int y )</arglist>
    </member>
    <member kind="function">
      <name>manhattanLength</name>
      <anchor>manhattanLength</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rx</name>
      <anchor>rx</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>ry</name>
      <anchor>ry</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPoint &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPoint &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( int c )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( double c )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( int c )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( double c )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPoint &amp; p1, const QPoint &amp; p2 )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPoint &amp; p1, const QPoint &amp; p2 )</arglist>
    </member>
    <member kind="function">
      <name>operator+</name>
      <anchor>operator</anchor>
      <arglist>( const QPoint &amp; p1, const QPoint &amp; p2 )</arglist>
    </member>
    <member kind="function">
      <name>operator-</name>
      <anchor>operator</anchor>
      <arglist>( const QPoint &amp; p1, const QPoint &amp; p2 )</arglist>
    </member>
    <member kind="function">
      <name>operator*</name>
      <anchor>operator</anchor>
      <arglist>( const QPoint &amp; p, int c )</arglist>
    </member>
    <member kind="function">
      <name>operator*</name>
      <anchor>operator</anchor>
      <arglist>( int c, const QPoint &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>operator*</name>
      <anchor>operator</anchor>
      <arglist>( const QPoint &amp; p, double c )</arglist>
    </member>
    <member kind="function">
      <name>operator*</name>
      <anchor>operator</anchor>
      <arglist>( double c, const QPoint &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>operator-</name>
      <anchor>operator</anchor>
      <arglist>( const QPoint &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>operator/</name>
      <anchor>operator</anchor>
      <arglist>( const QPoint &amp; p, int c )</arglist>
    </member>
    <member kind="function">
      <name>operator/</name>
      <anchor>operator</anchor>
      <arglist>( const QPoint &amp; p, double c )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QPoint &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QPoint &amp; p )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPointArray</name>
    <filename>qpointarray.html</filename>
    <member kind="function">
      <name>QPointArray</name>
      <anchor>QPointArray</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QPointArray</name>
      <anchor>QPointArray</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QPointArray</name>
      <anchor>QPointArray</anchor>
      <arglist>( int size )</arglist>
    </member>
    <member kind="function">
      <name>QPointArray</name>
      <anchor>QPointArray</anchor>
      <arglist>( const QPointArray &amp; a )</arglist>
    </member>
    <member kind="function">
      <name>QPointArray</name>
      <anchor>QPointArray</anchor>
      <arglist>( const QRect &amp; r, bool closed = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPointArray &amp; a )</arglist>
    </member>
    <member kind="function">
      <name>copy</name>
      <anchor>copy</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>translate</name>
      <anchor>translate</anchor>
      <arglist>( int dx, int dy )</arglist>
    </member>
    <member kind="function">
      <name>boundingRect</name>
      <anchor>boundingRect</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>point</name>
      <anchor>point</anchor>
      <arglist>( uint index, int * x, int * y ) const</arglist>
    </member>
    <member kind="function">
      <name>point</name>
      <anchor>point</anchor>
      <arglist>( uint index ) const</arglist>
    </member>
    <member kind="function">
      <name>setPoint</name>
      <anchor>setPoint</anchor>
      <arglist>( uint index, int x, int y )</arglist>
    </member>
    <member kind="function">
      <name>setPoint</name>
      <anchor>setPoint</anchor>
      <arglist>( uint i, const QPoint &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>putPoints</name>
      <anchor>putPoints</anchor>
      <arglist>( int index, int nPoints, int firstx, int firsty, ... )</arglist>
    </member>
    <member kind="function">
      <name>putPoints</name>
      <anchor>putPoints</anchor>
      <arglist>( int index, int nPoints, const QPointArray &amp; from, int fromIndex = 0 )</arglist>
    </member>
    <member kind="function">
      <name>makeArc</name>
      <anchor>makeArc</anchor>
      <arglist>( int x, int y, int w, int h, int a1, int a2 )</arglist>
    </member>
    <member kind="function">
      <name>makeEllipse</name>
      <anchor>makeEllipse</anchor>
      <arglist>( int x, int y, int w, int h )</arglist>
    </member>
    <member kind="function">
      <name>makeArc</name>
      <anchor>makeArc</anchor>
      <arglist>( int x, int y, int w, int h, int a1, int a2, const QWMatrix &amp; xf )</arglist>
    </member>
    <member kind="function">
      <name>cubicBezier</name>
      <anchor>cubicBezier</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QPointArray &amp; a )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QPointArray &amp; a )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPopupMenu</name>
    <filename>qpopupmenu.html</filename>
    <member kind="function">
      <name>QPopupMenu</name>
      <anchor>QPopupMenu</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QPopupMenu</name>
      <anchor>QPopupMenu</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>popup</name>
      <anchor>popup</anchor>
      <arglist>( const QPoint &amp; pos, int indexAtPoint = -1 )</arglist>
    </member>
    <member kind="function">
      <name>updateItem</name>
      <anchor>updateItem</anchor>
      <arglist>( int id )</arglist>
    </member>
    <member kind="function">
      <name>setCheckable</name>
      <anchor>setCheckable</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>isCheckable</name>
      <anchor>isCheckable</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>exec</name>
      <anchor>exec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>exec</name>
      <anchor>exec</anchor>
      <arglist>( const QPoint &amp; pos, int indexAtPoint = 0 )</arglist>
    </member>
    <member kind="function">
      <name>setActiveItem</name>
      <anchor>setActiveItem</anchor>
      <arglist>( int i )</arglist>
    </member>
    <member kind="function">
      <name>idAt</name>
      <anchor>idAt</anchor>
      <arglist>( int index ) const</arglist>
    </member>
    <member kind="function">
      <name>idAt</name>
      <anchor>idAt</anchor>
      <arglist>( const QPoint &amp; pos ) const</arglist>
    </member>
    <member kind="function">
      <name>insertTearOffHandle</name>
      <anchor>insertTearOffHandle</anchor>
      <arglist>( int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>activated</name>
      <anchor>activated</anchor>
      <arglist>( int id )</arglist>
    </member>
    <member kind="function">
      <name>highlighted</name>
      <anchor>highlighted</anchor>
      <arglist>( int id )</arglist>
    </member>
    <member kind="function">
      <name>aboutToShow</name>
      <anchor>aboutToShow</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>aboutToHide</name>
      <anchor>aboutToHide</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QString &amp; text, const QObject * receiver, const char * member, const QKeySequence &amp; accel = 0, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, const QString &amp; text, const QObject * receiver, const char * member, const QKeySequence &amp; accel = 0, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QPixmap &amp; pixmap, const QObject * receiver, const char * member, const QKeySequence &amp; accel = 0, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, const QPixmap &amp; pixmap, const QObject * receiver, const char * member, const QKeySequence &amp; accel = 0, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QString &amp; text, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, const QString &amp; text, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QString &amp; text, QPopupMenu * popup, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, const QString &amp; text, QPopupMenu * popup, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertItem</name>
      <anchor>insertItem</anchor>
      <arglist>( const QPixmap &amp; pixmap, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>a</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, const QPixmap &amp; pixmap, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>b</name>
      <anchor>insertItem</anchor>
      <arglist>( const QPixmap &amp; pixmap, QPopupMenu * popup, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>c</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, const QPixmap &amp; pixmap, QPopupMenu * popup, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>d</name>
      <anchor>insertItem</anchor>
      <arglist>( QWidget * widget, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>e</name>
      <anchor>insertItem</anchor>
      <arglist>( const QIconSet &amp; icon, QCustomMenuItem * custom, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>f</name>
      <anchor>insertItem</anchor>
      <arglist>( QCustomMenuItem * custom, int id = -1, int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>insertSeparator</name>
      <anchor>insertSeparator</anchor>
      <arglist>( int index = -1 )</arglist>
    </member>
    <member kind="function">
      <name>removeItem</name>
      <anchor>removeItem</anchor>
      <arglist>( int id )</arglist>
    </member>
    <member kind="function">
      <name>removeItemAt</name>
      <anchor>removeItemAt</anchor>
      <arglist>( int index )</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>accel</name>
      <anchor>accel</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>setAccel</name>
      <anchor>setAccel</anchor>
      <arglist>( const QKeySequence &amp; key, int id )</arglist>
    </member>
    <member kind="function">
      <name>iconSet</name>
      <anchor>iconSet</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>pixmap</name>
      <anchor>pixmap</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>setWhatsThis</name>
      <anchor>setWhatsThis</anchor>
      <arglist>( int id, const QString &amp; text )</arglist>
    </member>
    <member kind="function">
      <name>whatsThis</name>
      <anchor>whatsThis</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>changeItem</name>
      <anchor>changeItem</anchor>
      <arglist>( int id, const QString &amp; text )</arglist>
    </member>
    <member kind="function">
      <name>changeItem</name>
      <anchor>changeItem</anchor>
      <arglist>( int id, const QPixmap &amp; pixmap )</arglist>
    </member>
    <member kind="function">
      <name>changeItem</name>
      <anchor>changeItem</anchor>
      <arglist>( int id, const QIconSet &amp; icon, const QString &amp; text )</arglist>
    </member>
    <member kind="function">
      <name>changeItem</name>
      <anchor>changeItem</anchor>
      <arglist>( int id, const QIconSet &amp; icon, const QPixmap &amp; pixmap )</arglist>
    </member>
    <member kind="function">
      <name>isItemEnabled</name>
      <anchor>isItemEnabled</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>setItemEnabled</name>
      <anchor>setItemEnabled</anchor>
      <arglist>( int id, bool enable )</arglist>
    </member>
    <member kind="function">
      <name>isItemChecked</name>
      <anchor>isItemChecked</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>setItemChecked</name>
      <anchor>setItemChecked</anchor>
      <arglist>( int id, bool check )</arglist>
    </member>
    <member kind="function">
      <name>isItemVisible</name>
      <anchor>isItemVisible</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>setItemVisible</name>
      <anchor>setItemVisible</anchor>
      <arglist>( int id, bool visible )</arglist>
    </member>
    <member kind="function">
      <name>connectItem</name>
      <anchor>connectItem</anchor>
      <arglist>( int id, const QObject * receiver, const char * member )</arglist>
    </member>
    <member kind="function">
      <name>disconnectItem</name>
      <anchor>disconnectItem</anchor>
      <arglist>( int id, const QObject * receiver, const char * member )</arglist>
    </member>
    <member kind="function">
      <name>setItemParameter</name>
      <anchor>setItemParameter</anchor>
      <arglist>( int id, int param )</arglist>
    </member>
    <member kind="function">
      <name>itemParameter</name>
      <anchor>itemParameter</anchor>
      <arglist>( int id ) const</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>checkable</anchor>
      <arglist>- whether the display of check marks on menu items is enabled</arglist>
    </member>
    <member kind="function">
      <name>itemHeight</name>
      <anchor>itemHeight</anchor>
      <arglist>( int row ) const</arglist>
    </member>
    <member kind="function">
      <name>itemHeight</name>
      <anchor>itemHeight</anchor>
      <arglist>( QMenuItem * mi ) const</arglist>
    </member>
    <member kind="function">
      <name>drawItem</name>
      <anchor>drawItem</anchor>
      <arglist>( QPainter * p, int tab_, QMenuItem * mi, bool act, int x, int y, int w, int h )</arglist>
    </member>
    <member kind="function">
      <name>drawContents</name>
      <anchor>drawContents</anchor>
      <arglist>( QPainter * p )</arglist>
    </member>
    <member kind="function">
      <name>columns</name>
      <anchor>columns</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPrinter</name>
    <filename>qprinter.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>PrinterMode</anchor>
      <arglist>{ ScreenResolution, PrinterResolution, HighResolution, Compatible }</arglist>
    </member>
    <member kind="function">
      <name>QPrinter</name>
      <anchor>QPrinter</anchor>
      <arglist>( PrinterMode m = ScreenResolution )</arglist>
    </member>
    <member kind="function">
      <name>QPrinter</name>
      <anchor>QPrinter</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Orientation</anchor>
      <arglist>{ Portrait, Landscape }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>PageSize</anchor>
      <arglist>{ A4, B5, Letter, Legal, Executive, A0, A1, A2, A3, A5, A6, A7, A8, A9, B0, B1, B10, B2, B3, B4, B6, B7, B8, B9, C5E, Comm10E, DLE, Folio, Ledger, Tabloid, Custom, NPageSize = Custom }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>PageOrder</anchor>
      <arglist>{ FirstPageFirst, LastPageFirst }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ColorMode</anchor>
      <arglist>{ GrayScale, Color }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>PaperSource</anchor>
      <arglist>{ OnlyOne, Lower, Middle, Manual, Envelope, EnvelopeManual, Auto, Tractor, SmallFormat, LargeFormat, LargeCapacity, Cassette, FormSource }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>PrintRange</anchor>
      <arglist>{ AllPages, Selection, PageRange }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>PrinterOption</anchor>
      <arglist>{ PrintToFile, PrintSelection, PrintPageRange }</arglist>
    </member>
    <member kind="function">
      <name>printerName</name>
      <anchor>printerName</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPrinterName</name>
      <anchor>setPrinterName</anchor>
      <arglist>( const QString &amp; name )</arglist>
    </member>
    <member kind="function">
      <name>outputToFile</name>
      <anchor>outputToFile</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setOutputToFile</name>
      <anchor>setOutputToFile</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>outputFileName</name>
      <anchor>outputFileName</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setOutputFileName</name>
      <anchor>setOutputFileName</anchor>
      <arglist>( const QString &amp; fileName )</arglist>
    </member>
    <member kind="function">
      <name>printProgram</name>
      <anchor>printProgram</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPrintProgram</name>
      <anchor>setPrintProgram</anchor>
      <arglist>( const QString &amp; printProg )</arglist>
    </member>
    <member kind="function">
      <name>printerSelectionOption</name>
      <anchor>printerSelectionOption</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPrinterSelectionOption</name>
      <anchor>setPrinterSelectionOption</anchor>
      <arglist>( const QString &amp; option )</arglist>
    </member>
    <member kind="function">
      <name>docName</name>
      <anchor>docName</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setDocName</name>
      <anchor>setDocName</anchor>
      <arglist>( const QString &amp; name )</arglist>
    </member>
    <member kind="function">
      <name>creator</name>
      <anchor>creator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setCreator</name>
      <anchor>setCreator</anchor>
      <arglist>( const QString &amp; creator )</arglist>
    </member>
    <member kind="function">
      <name>orientation</name>
      <anchor>orientation</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setOrientation</name>
      <anchor>setOrientation</anchor>
      <arglist>( Orientation orientation )</arglist>
    </member>
    <member kind="function">
      <name>pageSize</name>
      <anchor>pageSize</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPageSize</name>
      <anchor>setPageSize</anchor>
      <arglist>( PageSize newPageSize )</arglist>
    </member>
    <member kind="function">
      <name>setWinPageSize</name>
      <anchor>setWinPageSize</anchor>
      <arglist>( short winPageSize )</arglist>
    </member>
    <member kind="function">
      <name>winPageSize</name>
      <anchor>winPageSize</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPageOrder</name>
      <anchor>setPageOrder</anchor>
      <arglist>( PageOrder newPageOrder )</arglist>
    </member>
    <member kind="function">
      <name>pageOrder</name>
      <anchor>pageOrder</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setResolution</name>
      <anchor>setResolution</anchor>
      <arglist>( int dpi )</arglist>
    </member>
    <member kind="function">
      <name>resolution</name>
      <anchor>resolution</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setColorMode</name>
      <anchor>setColorMode</anchor>
      <arglist>( ColorMode newColorMode )</arglist>
    </member>
    <member kind="function">
      <name>colorMode</name>
      <anchor>colorMode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setFullPage</name>
      <anchor>setFullPage</anchor>
      <arglist>( bool fp )</arglist>
    </member>
    <member kind="function">
      <name>fullPage</name>
      <anchor>fullPage</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>margins</name>
      <anchor>margins</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMargins</name>
      <anchor>setMargins</anchor>
      <arglist>( uint top, uint left, uint bottom, uint right )</arglist>
    </member>
    <member kind="function">
      <name>margins</name>
      <anchor>margins</anchor>
      <arglist>( uint * top, uint * left, uint * bottom, uint * right ) const</arglist>
    </member>
    <member kind="function">
      <name>fromPage</name>
      <anchor>fromPage</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>toPage</name>
      <anchor>toPage</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setFromTo</name>
      <anchor>setFromTo</anchor>
      <arglist>( int fromPage, int toPage )</arglist>
    </member>
    <member kind="function">
      <name>minPage</name>
      <anchor>minPage</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>maxPage</name>
      <anchor>maxPage</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMinMax</name>
      <anchor>setMinMax</anchor>
      <arglist>( int minPage, int maxPage )</arglist>
    </member>
    <member kind="function">
      <name>numCopies</name>
      <anchor>numCopies</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setNumCopies</name>
      <anchor>setNumCopies</anchor>
      <arglist>( int numCopies )</arglist>
    </member>
    <member kind="function">
      <name>printRange</name>
      <anchor>printRange</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPrintRange</name>
      <anchor>setPrintRange</anchor>
      <arglist>( PrintRange range )</arglist>
    </member>
    <member kind="function">
      <name>newPage</name>
      <anchor>newPage</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>abort</name>
      <anchor>abort</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>aborted</name>
      <anchor>aborted</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setup</name>
      <anchor>setup</anchor>
      <arglist>( QWidget * parent = 0 )</arglist>
    </member>
    <member kind="function">
      <name>paperSource</name>
      <anchor>paperSource</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPaperSource</name>
      <anchor>setPaperSource</anchor>
      <arglist>( PaperSource source )</arglist>
    </member>
    <member kind="function">
      <name>setOptionEnabled</name>
      <anchor>setOptionEnabled</anchor>
      <arglist>( PrinterOption option, bool enable )</arglist>
    </member>
    <member kind="function">
      <name>isOptionEnabled</name>
      <anchor>isOptionEnabled</anchor>
      <arglist>( PrinterOption option )</arglist>
    </member>
    <member kind="function">
      <name>setOrientation</name>
      <anchor>setOrientation</anchor>
      <arglist>() tells QPrinter which page orientation to use (virtual).</arglist>
    </member>
    <member kind="function">
      <name>setPageSize</name>
      <anchor>setPageSize</anchor>
      <arglist>() tells QPrinter what page size to expect from the</arglist>
    </member>
    <member kind="function">
      <name>setResolution</name>
      <anchor>setResolution</anchor>
      <arglist>() tells QPrinter what resolution you wish the</arglist>
    </member>
    <member kind="function">
      <name>setFullPage</name>
      <anchor>setFullPage</anchor>
      <arglist>() tells QPrinter whether you want to deal with the</arglist>
    </member>
    <member kind="function">
      <name>setNumCopies</name>
      <anchor>setNumCopies</anchor>
      <arglist>() tells QPrinter how many copies of the document</arglist>
    </member>
    <member kind="function">
      <name>setMinMax</name>
      <anchor>setMinMax</anchor>
      <arglist>() tells QPrinter and QPrintDialog what the allowed</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QProcess</name>
    <filename>qprocess.html</filename>
    <member kind="function">
      <name>QProcess</name>
      <anchor>QProcess</anchor>
      <arglist>( QObject * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QProcess</name>
      <anchor>QProcess</anchor>
      <arglist>( const QString &amp; arg0, QObject * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QProcess</name>
      <anchor>QProcess</anchor>
      <arglist>( const QStringList &amp; args, QObject * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QProcess</name>
      <anchor>QProcess</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>arguments</name>
      <anchor>arguments</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>clearArguments</name>
      <anchor>clearArguments</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setArguments</name>
      <anchor>setArguments</anchor>
      <arglist>( const QStringList &amp; args )</arglist>
    </member>
    <member kind="function">
      <name>addArgument</name>
      <anchor>addArgument</anchor>
      <arglist>( const QString &amp; arg )</arglist>
    </member>
    <member kind="function">
      <name>workingDirectory</name>
      <anchor>workingDirectory</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setWorkingDirectory</name>
      <anchor>setWorkingDirectory</anchor>
      <arglist>( const QDir &amp; dir )</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Communication</anchor>
      <arglist>{ Stdin = 0x01, Stdout = 0x02, Stderr = 0x04, DupStderr = 0x08 }</arglist>
    </member>
    <member kind="function">
      <name>setCommunication</name>
      <anchor>setCommunication</anchor>
      <arglist>( int commFlags )</arglist>
    </member>
    <member kind="function">
      <name>communication</name>
      <anchor>communication</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>start</name>
      <anchor>start</anchor>
      <arglist>( QStringList * env = 0 )</arglist>
    </member>
    <member kind="function">
      <name>launch</name>
      <anchor>launch</anchor>
      <arglist>( const QString &amp; buf, QStringList * env = 0 )</arglist>
    </member>
    <member kind="function">
      <name>launch</name>
      <anchor>launch</anchor>
      <arglist>( const QByteArray &amp; buf, QStringList * env = 0 )</arglist>
    </member>
    <member kind="function">
      <name>isRunning</name>
      <anchor>isRunning</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>normalExit</name>
      <anchor>normalExit</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>exitStatus</name>
      <anchor>exitStatus</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>readStdout</name>
      <anchor>readStdout</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>readStderr</name>
      <anchor>readStderr</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>canReadLineStdout</name>
      <anchor>canReadLineStdout</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>canReadLineStderr</name>
      <anchor>canReadLineStderr</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>readLineStdout</name>
      <anchor>readLineStdout</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>readLineStderr</name>
      <anchor>readLineStderr</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>processIdentifier</name>
      <anchor>processIdentifier</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>tryTerminate</name>
      <anchor>tryTerminate</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>kill</name>
      <anchor>kill</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>writeToStdin</name>
      <anchor>writeToStdin</anchor>
      <arglist>( const QByteArray &amp; buf )</arglist>
    </member>
    <member kind="function">
      <name>writeToStdin</name>
      <anchor>writeToStdin</anchor>
      <arglist>( const QString &amp; buf )</arglist>
    </member>
    <member kind="function">
      <name>closeStdin</name>
      <anchor>closeStdin</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>readyReadStdout</name>
      <anchor>readyReadStdout</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>readyReadStderr</name>
      <anchor>readyReadStderr</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>processExited</name>
      <anchor>processExited</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>wroteToStdin</name>
      <anchor>wroteToStdin</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>launchFinished</name>
      <anchor>launchFinished</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QProgressBar</name>
    <filename>qprogressbar.html</filename>
    <member kind="function">
      <name>QProgressBar</name>
      <anchor>QProgressBar</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QProgressBar</name>
      <anchor>QProgressBar</anchor>
      <arglist>( int totalSteps, QWidget * parent = 0, const char * name = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>totalSteps</name>
      <anchor>totalSteps</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>progress</name>
      <anchor>progress</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>progressString</name>
      <anchor>progressString</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setCenterIndicator</name>
      <anchor>setCenterIndicator</anchor>
      <arglist>( bool on )</arglist>
    </member>
    <member kind="function">
      <name>centerIndicator</name>
      <anchor>centerIndicator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setIndicatorFollowsStyle</name>
      <anchor>setIndicatorFollowsStyle</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>indicatorFollowsStyle</name>
      <anchor>indicatorFollowsStyle</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>percentageVisible</name>
      <anchor>percentageVisible</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPercentageVisible</name>
      <anchor>setPercentageVisible</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>reset</name>
      <anchor>reset</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setTotalSteps</name>
      <anchor>setTotalSteps</anchor>
      <arglist>( int totalSteps )</arglist>
    </member>
    <member kind="function">
      <name>setProgress</name>
      <anchor>setProgress</anchor>
      <arglist>( int progress )</arglist>
    </member>
    <member kind="function">
      <name>setProgress</name>
      <anchor>setProgress</anchor>
      <arglist>( int progress, int totalSteps )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>centerIndicator</anchor>
      <arglist>- whether the indicator string should be centered</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>indicatorFollowsStyle</anchor>
      <arglist>- whether the display of the indicator string should follow the GUI style</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>percentageVisible</anchor>
      <arglist>- whether the current progress value is displayed</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>progress</anchor>
      <arglist>- the current amount of progress</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>progressString</anchor>
      <arglist>- the amount of progress as a string</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>totalSteps</anchor>
      <arglist>- the total number of steps</arglist>
    </member>
    <member kind="function">
      <name>setIndicator</name>
      <anchor>setIndicator</anchor>
      <arglist>( QString &amp; indicator, int progress, int totalSteps )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QProgressDialog</name>
    <filename>qprogressdialog.html</filename>
    <member kind="function">
      <name>QProgressDialog</name>
      <anchor>QProgressDialog</anchor>
      <arglist>( QWidget * creator = 0, const char * name = 0, bool modal = FALSE, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QProgressDialog</name>
      <anchor>QProgressDialog</anchor>
      <arglist>( const QString &amp; labelText, const QString &amp; cancelButtonText, int totalSteps, QWidget * creator = 0, const char * name = 0, bool modal = FALSE, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QProgressDialog</name>
      <anchor>QProgressDialog</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setLabel</name>
      <anchor>setLabel</anchor>
      <arglist>( QLabel * label )</arglist>
    </member>
    <member kind="function">
      <name>setCancelButton</name>
      <anchor>setCancelButton</anchor>
      <arglist>( QPushButton * cancelButton )</arglist>
    </member>
    <member kind="function">
      <name>setBar</name>
      <anchor>setBar</anchor>
      <arglist>( QProgressBar * bar )</arglist>
    </member>
    <member kind="function">
      <name>wasCanceled</name>
      <anchor>wasCanceled</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>totalSteps</name>
      <anchor>totalSteps</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>progress</name>
      <anchor>progress</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>sizeHint</name>
      <anchor>sizeHint</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>labelText</name>
      <anchor>labelText</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoReset</name>
      <anchor>setAutoReset</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>autoReset</name>
      <anchor>autoReset</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoClose</name>
      <anchor>setAutoClose</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>autoClose</name>
      <anchor>autoClose</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>minimumDuration</name>
      <anchor>minimumDuration</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>cancel</name>
      <anchor>cancel</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>reset</name>
      <anchor>reset</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setTotalSteps</name>
      <anchor>setTotalSteps</anchor>
      <arglist>( int totalSteps )</arglist>
    </member>
    <member kind="function">
      <name>setProgress</name>
      <anchor>setProgress</anchor>
      <arglist>( int progress )</arglist>
    </member>
    <member kind="function">
      <name>setProgress</name>
      <anchor>setProgress</anchor>
      <arglist>( int progress, int totalSteps )</arglist>
    </member>
    <member kind="function">
      <name>setLabelText</name>
      <anchor>setLabelText</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>setCancelButtonText</name>
      <anchor>setCancelButtonText</anchor>
      <arglist>( const QString &amp; cancelButtonText )</arglist>
    </member>
    <member kind="function">
      <name>setMinimumDuration</name>
      <anchor>setMinimumDuration</anchor>
      <arglist>( int ms )</arglist>
    </member>
    <member kind="function">
      <name>canceled</name>
      <anchor>canceled</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>autoClose</anchor>
      <arglist>- whether the dialog gets hidden by reset()</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>autoReset</anchor>
      <arglist>- whether the progress dialog calls reset() as soon as progress() equals totalSteps()</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>labelText</anchor>
      <arglist>- the label&apos;s text</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>minimumDuration</anchor>
      <arglist>- the time that must pass before the dialog appears</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>progress</anchor>
      <arglist>- the current amount of progress made</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>totalSteps</anchor>
      <arglist>- the total number of steps</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>wasCanceled</anchor>
      <arglist>- whether the dialog was canceled</arglist>
    </member>
    <member kind="function">
      <name>forceShow</name>
      <anchor>forceShow</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPtrCollection</name>
    <filename>qptrcollection.html</filename>
    <member kind="function">
      <name>autoDelete</name>
      <anchor>autoDelete</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoDelete</name>
      <anchor>setAutoDelete</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const = 0</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>() = 0</arglist>
    </member>
    <member kind="function">
      <name>Item</name>
      <anchor>Item</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <name>QPtrCollection</name>
      <anchor>QPtrCollection</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QPtrCollection</name>
      <anchor>QPtrCollection</anchor>
      <arglist>( const QPtrCollection &amp; source )</arglist>
    </member>
    <member kind="function">
      <name>QPtrCollection</name>
      <anchor>QPtrCollection</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>newItem</name>
      <anchor>newItem</anchor>
      <arglist>( Item d )</arglist>
    </member>
    <member kind="function">
      <name>deleteItem</name>
      <anchor>deleteItem</anchor>
      <arglist>( Item d ) = 0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPtrDict</name>
    <filename>qptrdict.html</filename>
    <member kind="function">
      <name>QPtrDict</name>
      <anchor>QPtrDict</anchor>
      <arglist>( int size = 17 )</arglist>
    </member>
    <member kind="function">
      <name>QPtrDict</name>
      <anchor>QPtrDict</anchor>
      <arglist>( const QPtrDict&lt;type&gt; &amp; dict )</arglist>
    </member>
    <member kind="function">
      <name>QPtrDict</name>
      <anchor>QPtrDict</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPtrDict&lt;type&gt; &amp; dict )</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>insert</name>
      <anchor>insert</anchor>
      <arglist>( void * key, const type * item )</arglist>
    </member>
    <member kind="function">
      <name>replace</name>
      <anchor>replace</anchor>
      <arglist>( void * key, const type * item )</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>( void * key )</arglist>
    </member>
    <member kind="function">
      <name>take</name>
      <anchor>take</anchor>
      <arglist>( void * key )</arglist>
    </member>
    <member kind="function">
      <name>find</name>
      <anchor>find</anchor>
      <arglist>( void * key ) const</arglist>
    </member>
    <member kind="function">
      <name>operator[]</name>
      <anchor>operator</anchor>
      <arglist>( void * key ) const</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>resize</name>
      <anchor>resize</anchor>
      <arglist>( uint newsize )</arglist>
    </member>
    <member kind="function">
      <name>statistics</name>
      <anchor>statistics</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>autoDelete</name>
      <anchor>autoDelete</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoDelete</name>
      <anchor>setAutoDelete</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>read</name>
      <anchor>read</anchor>
      <arglist>( QDataStream &amp; s, QPtrCollection::Item &amp; item )</arglist>
    </member>
    <member kind="function">
      <name>write</name>
      <anchor>write</anchor>
      <arglist>( QDataStream &amp; s, QPtrCollection::Item ) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPtrDictIterator</name>
    <filename>qptrdictiterator.html</filename>
    <member kind="function">
      <name>QPtrDictIterator</name>
      <anchor>QPtrDictIterator</anchor>
      <arglist>( const QPtrDict&lt;type&gt; &amp; dict )</arglist>
    </member>
    <member kind="function">
      <name>QPtrDictIterator</name>
      <anchor>QPtrDictIterator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>toFirst</name>
      <anchor>toFirst</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>type</name>
      <anchor>operator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>current</name>
      <anchor>current</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>currentKey</name>
      <anchor>currentKey</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>operator()</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>operator++</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( uint jump )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPtrList</name>
    <filename>qptrlist.html</filename>
    <member kind="function">
      <name>QPtrList</name>
      <anchor>QPtrList</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QPtrList</name>
      <anchor>QPtrList</anchor>
      <arglist>( const QPtrList&lt;type&gt; &amp; list )</arglist>
    </member>
    <member kind="function">
      <name>QPtrList</name>
      <anchor>QPtrList</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPtrList&lt;type&gt; &amp; list )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPtrList&lt;type&gt; &amp; list ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPtrList&lt;type&gt; &amp; list ) const</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>insert</name>
      <anchor>insert</anchor>
      <arglist>( uint index, const type * item )</arglist>
    </member>
    <member kind="function">
      <name>inSort</name>
      <anchor>inSort</anchor>
      <arglist>( const type * item )</arglist>
    </member>
    <member kind="function">
      <name>prepend</name>
      <anchor>prepend</anchor>
      <arglist>( const type * item )</arglist>
    </member>
    <member kind="function">
      <name>append</name>
      <anchor>append</anchor>
      <arglist>( const type * item )</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>( uint index )</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>( const type * item )</arglist>
    </member>
    <member kind="function">
      <name>removeRef</name>
      <anchor>removeRef</anchor>
      <arglist>( const type * item )</arglist>
    </member>
    <member kind="function">
      <name>removeNode</name>
      <anchor>removeNode</anchor>
      <arglist>( QLNode * node )</arglist>
    </member>
    <member kind="function">
      <name>removeFirst</name>
      <anchor>removeFirst</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>removeLast</name>
      <anchor>removeLast</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>take</name>
      <anchor>take</anchor>
      <arglist>( uint index )</arglist>
    </member>
    <member kind="function">
      <name>take</name>
      <anchor>take</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>takeNode</name>
      <anchor>takeNode</anchor>
      <arglist>( QLNode * node )</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>sort</name>
      <anchor>sort</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>find</name>
      <anchor>find</anchor>
      <arglist>( const type * item )</arglist>
    </member>
    <member kind="function">
      <name>findNext</name>
      <anchor>findNext</anchor>
      <arglist>( const type * item )</arglist>
    </member>
    <member kind="function">
      <name>findRef</name>
      <anchor>findRef</anchor>
      <arglist>( const type * item )</arglist>
    </member>
    <member kind="function">
      <name>findNextRef</name>
      <anchor>findNextRef</anchor>
      <arglist>( const type * item )</arglist>
    </member>
    <member kind="function">
      <name>contains</name>
      <anchor>contains</anchor>
      <arglist>( const type * item ) const</arglist>
    </member>
    <member kind="function">
      <name>containsRef</name>
      <anchor>containsRef</anchor>
      <arglist>( const type * item ) const</arglist>
    </member>
    <member kind="function">
      <name>replace</name>
      <anchor>replace</anchor>
      <arglist>( uint index, const type * item )</arglist>
    </member>
    <member kind="function">
      <name>at</name>
      <anchor>at</anchor>
      <arglist>( uint index )</arglist>
    </member>
    <member kind="function">
      <name>at</name>
      <anchor>at</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>current</name>
      <anchor>current</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>currentNode</name>
      <anchor>currentNode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>getFirst</name>
      <anchor>getFirst</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>getLast</name>
      <anchor>getLast</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>first</name>
      <anchor>first</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>last</name>
      <anchor>last</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>next</name>
      <anchor>next</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>prev</name>
      <anchor>prev</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toVector</name>
      <anchor>toVector</anchor>
      <arglist>( QGVector * vec ) const</arglist>
    </member>
    <member kind="function">
      <name>autoDelete</name>
      <anchor>autoDelete</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoDelete</name>
      <anchor>setAutoDelete</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>compareItems</name>
      <anchor>compareItems</anchor>
      <arglist>( QPtrCollection::Item item1, QPtrCollection::Item item2 )</arglist>
    </member>
    <member kind="function">
      <name>read</name>
      <anchor>read</anchor>
      <arglist>( QDataStream &amp; s, QPtrCollection::Item &amp; item )</arglist>
    </member>
    <member kind="function">
      <name>write</name>
      <anchor>write</anchor>
      <arglist>( QDataStream &amp; s, QPtrCollection::Item item ) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPtrListIterator</name>
    <filename>qptrlistiterator.html</filename>
    <member kind="function">
      <name>QPtrListIterator</name>
      <anchor>QPtrListIterator</anchor>
      <arglist>( const QPtrList&lt;type&gt; &amp; list )</arglist>
    </member>
    <member kind="function">
      <name>QPtrListIterator</name>
      <anchor>QPtrListIterator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>atFirst</name>
      <anchor>atFirst</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>atLast</name>
      <anchor>atLast</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>toFirst</name>
      <anchor>toFirst</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toLast</name>
      <anchor>toLast</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>type</name>
      <anchor>operator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>operator*</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>current</name>
      <anchor>current</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>operator()</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>operator++</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( uint jump )</arglist>
    </member>
    <member kind="function">
      <name>operator--</name>
      <anchor>operator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( uint jump )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPtrListIterator&lt;type&gt; &amp; it )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPtrQueue</name>
    <filename>qptrqueue.html</filename>
    <member kind="function">
      <name>QPtrQueue</name>
      <anchor>QPtrQueue</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QPtrQueue</name>
      <anchor>QPtrQueue</anchor>
      <arglist>( const QPtrQueue&lt;type&gt; &amp; queue )</arglist>
    </member>
    <member kind="function">
      <name>QPtrQueue</name>
      <anchor>QPtrQueue</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPtrQueue&lt;type&gt; &amp; queue )</arglist>
    </member>
    <member kind="function">
      <name>autoDelete</name>
      <anchor>autoDelete</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoDelete</name>
      <anchor>setAutoDelete</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>enqueue</name>
      <anchor>enqueue</anchor>
      <arglist>( const type * d )</arglist>
    </member>
    <member kind="function">
      <name>dequeue</name>
      <anchor>dequeue</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>head</name>
      <anchor>head</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>type</name>
      <anchor>operator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>current</name>
      <anchor>current</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>read</name>
      <anchor>read</anchor>
      <arglist>( QDataStream &amp; s, QPtrCollection::Item &amp; item )</arglist>
    </member>
    <member kind="function">
      <name>write</name>
      <anchor>write</anchor>
      <arglist>( QDataStream &amp; s, QPtrCollection::Item item ) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPtrStack</name>
    <filename>qptrstack.html</filename>
    <member kind="function">
      <name>QPtrStack</name>
      <anchor>QPtrStack</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QPtrStack</name>
      <anchor>QPtrStack</anchor>
      <arglist>( const QPtrStack&lt;type&gt; &amp; s )</arglist>
    </member>
    <member kind="function">
      <name>QPtrStack</name>
      <anchor>QPtrStack</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPtrStack&lt;type&gt; &amp; s )</arglist>
    </member>
    <member kind="function">
      <name>autoDelete</name>
      <anchor>autoDelete</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoDelete</name>
      <anchor>setAutoDelete</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>push</name>
      <anchor>push</anchor>
      <arglist>( const type * d )</arglist>
    </member>
    <member kind="function">
      <name>pop</name>
      <anchor>pop</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>top</name>
      <anchor>top</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>type</name>
      <anchor>operator</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>current</name>
      <anchor>current</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>read</name>
      <anchor>read</anchor>
      <arglist>( QDataStream &amp; s, QPtrCollection::Item &amp; item )</arglist>
    </member>
    <member kind="function">
      <name>write</name>
      <anchor>write</anchor>
      <arglist>( QDataStream &amp; s, QPtrCollection::Item item ) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPtrVector</name>
    <filename>qptrvector.html</filename>
    <member kind="function">
      <name>QPtrVector</name>
      <anchor>QPtrVector</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QPtrVector</name>
      <anchor>QPtrVector</anchor>
      <arglist>( uint size )</arglist>
    </member>
    <member kind="function">
      <name>QPtrVector</name>
      <anchor>QPtrVector</anchor>
      <arglist>( const QPtrVector&lt;type&gt; &amp; v )</arglist>
    </member>
    <member kind="function">
      <name>QPtrVector</name>
      <anchor>QPtrVector</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPtrVector&lt;type&gt; &amp; v )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QPtrVector&lt;type&gt; &amp; v ) const</arglist>
    </member>
    <member kind="function">
      <name>data</name>
      <anchor>data</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>count</name>
      <anchor>count</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isNull</name>
      <anchor>isNull</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>resize</name>
      <anchor>resize</anchor>
      <arglist>( uint size )</arglist>
    </member>
    <member kind="function">
      <name>insert</name>
      <anchor>insert</anchor>
      <arglist>( uint i, const type * d )</arglist>
    </member>
    <member kind="function">
      <name>remove</name>
      <anchor>remove</anchor>
      <arglist>( uint i )</arglist>
    </member>
    <member kind="function">
      <name>take</name>
      <anchor>take</anchor>
      <arglist>( uint i )</arglist>
    </member>
    <member kind="function">
      <name>clear</name>
      <anchor>clear</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>fill</name>
      <anchor>fill</anchor>
      <arglist>( const type * d, int size = -1 )</arglist>
    </member>
    <member kind="function">
      <name>sort</name>
      <anchor>sort</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>bsearch</name>
      <anchor>bsearch</anchor>
      <arglist>( const type * d ) const</arglist>
    </member>
    <member kind="function">
      <name>findRef</name>
      <anchor>findRef</anchor>
      <arglist>( const type * d, uint i = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>find</name>
      <anchor>find</anchor>
      <arglist>( const type * d, uint i = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>containsRef</name>
      <anchor>containsRef</anchor>
      <arglist>( const type * d ) const</arglist>
    </member>
    <member kind="function">
      <name>contains</name>
      <anchor>contains</anchor>
      <arglist>( const type * d ) const</arglist>
    </member>
    <member kind="function">
      <name>operator[]</name>
      <anchor>operator</anchor>
      <arglist>( int i ) const</arglist>
    </member>
    <member kind="function">
      <name>at</name>
      <anchor>at</anchor>
      <arglist>( uint i ) const</arglist>
    </member>
    <member kind="function">
      <name>autoDelete</name>
      <anchor>autoDelete</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoDelete</name>
      <anchor>setAutoDelete</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>compareItems</name>
      <anchor>compareItems</anchor>
      <arglist>( QPtrCollection::Item d1, QPtrCollection::Item d2 )</arglist>
    </member>
    <member kind="function">
      <name>read</name>
      <anchor>read</anchor>
      <arglist>( QDataStream &amp; s, QPtrCollection::Item &amp; item )</arglist>
    </member>
    <member kind="function">
      <name>write</name>
      <anchor>write</anchor>
      <arglist>( QDataStream &amp; s, QPtrCollection::Item item ) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPushButton</name>
    <filename>qpushbutton.html</filename>
    <member kind="function">
      <name>QPushButton</name>
      <anchor>QPushButton</anchor>
      <arglist>( QWidget * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QPushButton</name>
      <anchor>QPushButton</anchor>
      <arglist>( const QString &amp; text, QWidget * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QPushButton</name>
      <anchor>QPushButton</anchor>
      <arglist>( const QIconSet &amp; icon, const QString &amp; text, QWidget * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QPushButton</name>
      <anchor>QPushButton</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setToggleButton</name>
      <anchor>setToggleButton</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>autoDefault</name>
      <anchor>autoDefault</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoDefault</name>
      <anchor>setAutoDefault</anchor>
      <arglist>( bool autoDef )</arglist>
    </member>
    <member kind="function">
      <name>isDefault</name>
      <anchor>isDefault</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setDefault</name>
      <anchor>setDefault</anchor>
      <arglist>( bool def )</arglist>
    </member>
    <member kind="function">
      <name>setPopup</name>
      <anchor>setPopup</anchor>
      <arglist>( QPopupMenu * popup )</arglist>
    </member>
    <member kind="function">
      <name>popup</name>
      <anchor>popup</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setIconSet</name>
      <anchor>setIconSet</anchor>
      <arglist>( const QIconSet &amp; )</arglist>
    </member>
    <member kind="function">
      <name>iconSet</name>
      <anchor>iconSet</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setFlat</name>
      <anchor>setFlat</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>isFlat</name>
      <anchor>isFlat</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setOn</name>
      <anchor>setOn</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setText</name>
      <anchor>setText</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>pixmap</name>
      <anchor>pixmap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPixmap</name>
      <anchor>setPixmap</anchor>
      <arglist>( const QPixmap &amp; )</arglist>
    </member>
    <member kind="function">
      <name>accel</name>
      <anchor>accel</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAccel</name>
      <anchor>setAccel</anchor>
      <arglist>( const QKeySequence &amp; )</arglist>
    </member>
    <member kind="function">
      <name>isToggleButton</name>
      <anchor>isToggleButton</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setDown</name>
      <anchor>setDown</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>isDown</name>
      <anchor>isDown</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isOn</name>
      <anchor>isOn</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>state</name>
      <anchor>state</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>autoRepeat</name>
      <anchor>autoRepeat</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoRepeat</name>
      <anchor>setAutoRepeat</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>isExclusiveToggle</name>
      <anchor>isExclusiveToggle</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>group</name>
      <anchor>group</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>toggle</name>
      <anchor>toggle</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>pressed</name>
      <anchor>pressed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>released</name>
      <anchor>released</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>clicked</name>
      <anchor>clicked</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toggled</name>
      <anchor>toggled</anchor>
      <arglist>( bool on )</arglist>
    </member>
    <member kind="function">
      <name>stateChanged</name>
      <anchor>stateChanged</anchor>
      <arglist>( int state )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>autoDefault</anchor>
      <arglist>- whether the push button is the auto default button</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>autoMask</anchor>
      <arglist>- whether the button is automatically masked</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>default</anchor>
      <arglist>- whether the push button is the default button</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>flat</anchor>
      <arglist>- whether the border is disabled</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>iconSet</anchor>
      <arglist>- the icon set on the push button</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>on</anchor>
      <arglist>- whether the push button is toggled</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>toggleButton</anchor>
      <arglist>- whether the button is a toggle button</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QQueue</name>
    <filename>qqueue.html</filename>
  </compound>
  <compound kind="class">
    <name>QRadioButton</name>
    <filename>qradiobutton.html</filename>
    <member kind="function">
      <name>QRadioButton</name>
      <anchor>QRadioButton</anchor>
      <arglist>( QWidget * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QRadioButton</name>
      <anchor>QRadioButton</anchor>
      <arglist>( const QString &amp; text, QWidget * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>isChecked</name>
      <anchor>isChecked</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setChecked</name>
      <anchor>setChecked</anchor>
      <arglist>( bool check )</arglist>
    </member>
    <member kind="function">
      <name>text</name>
      <anchor>text</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setText</name>
      <anchor>setText</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
    <member kind="function">
      <name>pixmap</name>
      <anchor>pixmap</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPixmap</name>
      <anchor>setPixmap</anchor>
      <arglist>( const QPixmap &amp; )</arglist>
    </member>
    <member kind="function">
      <name>accel</name>
      <anchor>accel</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAccel</name>
      <anchor>setAccel</anchor>
      <arglist>( const QKeySequence &amp; )</arglist>
    </member>
    <member kind="function">
      <name>isToggleButton</name>
      <anchor>isToggleButton</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setDown</name>
      <anchor>setDown</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>isDown</name>
      <anchor>isDown</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isOn</name>
      <anchor>isOn</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>state</name>
      <anchor>state</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>autoRepeat</name>
      <anchor>autoRepeat</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setAutoRepeat</name>
      <anchor>setAutoRepeat</anchor>
      <arglist>( bool )</arglist>
    </member>
    <member kind="function">
      <name>isExclusiveToggle</name>
      <anchor>isExclusiveToggle</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>group</name>
      <anchor>group</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>toggle</name>
      <anchor>toggle</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>pressed</name>
      <anchor>pressed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>released</name>
      <anchor>released</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>clicked</name>
      <anchor>clicked</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>toggled</name>
      <anchor>toggled</anchor>
      <arglist>( bool on )</arglist>
    </member>
    <member kind="function">
      <name>stateChanged</name>
      <anchor>stateChanged</anchor>
      <arglist>( int state )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>autoMask</anchor>
      <arglist>- whether the radio button is automatically masked</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>checked</anchor>
      <arglist>- whether the radio button is checked</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QRangeControl</name>
    <filename>qrangecontrol.html</filename>
    <member kind="function">
      <name>QRangeControl</name>
      <anchor>QRangeControl</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QRangeControl</name>
      <anchor>QRangeControl</anchor>
      <arglist>( int minValue, int maxValue, int lineStep, int pageStep, int value )</arglist>
    </member>
    <member kind="function">
      <name>QRangeControl</name>
      <anchor>QRangeControl</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>value</name>
      <anchor>value</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setValue</name>
      <anchor>setValue</anchor>
      <arglist>( int value )</arglist>
    </member>
    <member kind="function">
      <name>addPage</name>
      <anchor>addPage</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>subtractPage</name>
      <anchor>subtractPage</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>addLine</name>
      <anchor>addLine</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>subtractLine</name>
      <anchor>subtractLine</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>minValue</name>
      <anchor>minValue</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>maxValue</name>
      <anchor>maxValue</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setRange</name>
      <anchor>setRange</anchor>
      <arglist>( int minValue, int maxValue )</arglist>
    </member>
    <member kind="function">
      <name>setMinValue</name>
      <anchor>setMinValue</anchor>
      <arglist>( int minVal )</arglist>
    </member>
    <member kind="function">
      <name>setMaxValue</name>
      <anchor>setMaxValue</anchor>
      <arglist>( int maxVal )</arglist>
    </member>
    <member kind="function">
      <name>lineStep</name>
      <anchor>lineStep</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>pageStep</name>
      <anchor>pageStep</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSteps</name>
      <anchor>setSteps</anchor>
      <arglist>( int lineStep, int pageStep )</arglist>
    </member>
    <member kind="function">
      <name>bound</name>
      <anchor>bound</anchor>
      <arglist>( int v ) const</arglist>
    </member>
    <member kind="function">
      <name>positionFromValue</name>
      <anchor>positionFromValue</anchor>
      <arglist>( int logical_val, int span ) const</arglist>
    </member>
    <member kind="function">
      <name>valueFromPosition</name>
      <anchor>valueFromPosition</anchor>
      <arglist>( int pos, int span ) const</arglist>
    </member>
    <member kind="function">
      <name>directSetValue</name>
      <anchor>directSetValue</anchor>
      <arglist>( int value )</arglist>
    </member>
    <member kind="function">
      <name>prevValue</name>
      <anchor>prevValue</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>valueChange</name>
      <anchor>valueChange</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>rangeChange</name>
      <anchor>rangeChange</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>stepChange</name>
      <anchor>stepChange</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QRect</name>
    <filename>qrect.html</filename>
    <member kind="function">
      <name>QRect</name>
      <anchor>QRect</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QRect</name>
      <anchor>QRect</anchor>
      <arglist>( const QPoint &amp; topLeft, const QPoint &amp; bottomRight )</arglist>
    </member>
    <member kind="function">
      <name>QRect</name>
      <anchor>QRect</anchor>
      <arglist>( const QPoint &amp; topLeft, const QSize &amp; size )</arglist>
    </member>
    <member kind="function">
      <name>QRect</name>
      <anchor>QRect</anchor>
      <arglist>( int left, int top, int width, int height )</arglist>
    </member>
    <member kind="function">
      <name>isNull</name>
      <anchor>isNull</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isValid</name>
      <anchor>isValid</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>normalize</name>
      <anchor>normalize</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>left</name>
      <anchor>left</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>top</name>
      <anchor>top</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>right</name>
      <anchor>right</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>bottom</name>
      <anchor>bottom</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rLeft</name>
      <anchor>rLeft</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>rTop</name>
      <anchor>rTop</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>rRight</name>
      <anchor>rRight</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>rBottom</name>
      <anchor>rBottom</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>x</name>
      <anchor>x</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>y</name>
      <anchor>y</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setLeft</name>
      <anchor>setLeft</anchor>
      <arglist>( int pos )</arglist>
    </member>
    <member kind="function">
      <name>setTop</name>
      <anchor>setTop</anchor>
      <arglist>( int pos )</arglist>
    </member>
    <member kind="function">
      <name>setRight</name>
      <anchor>setRight</anchor>
      <arglist>( int pos )</arglist>
    </member>
    <member kind="function">
      <name>setBottom</name>
      <anchor>setBottom</anchor>
      <arglist>( int pos )</arglist>
    </member>
    <member kind="function">
      <name>setX</name>
      <anchor>setX</anchor>
      <arglist>( int x )</arglist>
    </member>
    <member kind="function">
      <name>setY</name>
      <anchor>setY</anchor>
      <arglist>( int y )</arglist>
    </member>
    <member kind="function">
      <name>setTopLeft</name>
      <anchor>setTopLeft</anchor>
      <arglist>( const QPoint &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>setBottomRight</name>
      <anchor>setBottomRight</anchor>
      <arglist>( const QPoint &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>setTopRight</name>
      <anchor>setTopRight</anchor>
      <arglist>( const QPoint &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>setBottomLeft</name>
      <anchor>setBottomLeft</anchor>
      <arglist>( const QPoint &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>topLeft</name>
      <anchor>topLeft</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>bottomRight</name>
      <anchor>bottomRight</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>topRight</name>
      <anchor>topRight</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>bottomLeft</name>
      <anchor>bottomLeft</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>center</name>
      <anchor>center</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rect</name>
      <anchor>rect</anchor>
      <arglist>( int * x, int * y, int * w, int * h ) const</arglist>
    </member>
    <member kind="function">
      <name>coords</name>
      <anchor>coords</anchor>
      <arglist>( int * xp1, int * yp1, int * xp2, int * yp2 ) const</arglist>
    </member>
    <member kind="function">
      <name>moveLeft</name>
      <anchor>moveLeft</anchor>
      <arglist>( int pos )</arglist>
    </member>
    <member kind="function">
      <name>moveTop</name>
      <anchor>moveTop</anchor>
      <arglist>( int pos )</arglist>
    </member>
    <member kind="function">
      <name>moveRight</name>
      <anchor>moveRight</anchor>
      <arglist>( int pos )</arglist>
    </member>
    <member kind="function">
      <name>moveBottom</name>
      <anchor>moveBottom</anchor>
      <arglist>( int pos )</arglist>
    </member>
    <member kind="function">
      <name>moveTopLeft</name>
      <anchor>moveTopLeft</anchor>
      <arglist>( const QPoint &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>moveBottomRight</name>
      <anchor>moveBottomRight</anchor>
      <arglist>( const QPoint &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>moveTopRight</name>
      <anchor>moveTopRight</anchor>
      <arglist>( const QPoint &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>moveBottomLeft</name>
      <anchor>moveBottomLeft</anchor>
      <arglist>( const QPoint &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>moveCenter</name>
      <anchor>moveCenter</anchor>
      <arglist>( const QPoint &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>moveBy</name>
      <anchor>moveBy</anchor>
      <arglist>( int dx, int dy )</arglist>
    </member>
    <member kind="function">
      <name>setRect</name>
      <anchor>setRect</anchor>
      <arglist>( int x, int y, int w, int h )</arglist>
    </member>
    <member kind="function">
      <name>setCoords</name>
      <anchor>setCoords</anchor>
      <arglist>( int xp1, int yp1, int xp2, int yp2 )</arglist>
    </member>
    <member kind="function">
      <name>addCoords</name>
      <anchor>addCoords</anchor>
      <arglist>( int xp1, int yp1, int xp2, int yp2 )</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>width</name>
      <anchor>width</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>height</name>
      <anchor>height</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setWidth</name>
      <anchor>setWidth</anchor>
      <arglist>( int w )</arglist>
    </member>
    <member kind="function">
      <name>setHeight</name>
      <anchor>setHeight</anchor>
      <arglist>( int h )</arglist>
    </member>
    <member kind="function">
      <name>setSize</name>
      <anchor>setSize</anchor>
      <arglist>( const QSize &amp; s )</arglist>
    </member>
    <member kind="function">
      <name>operator|</name>
      <anchor>operator</anchor>
      <arglist>( const QRect &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>and</name>
      <anchor>operator</anchor>
      <arglist>( const QRect &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QRect &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>and</name>
      <anchor>operator</anchor>
      <arglist>( const QRect &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>contains</name>
      <anchor>contains</anchor>
      <arglist>( const QPoint &amp; p, bool proper = FALSE ) const</arglist>
    </member>
    <member kind="function">
      <name>contains</name>
      <anchor>contains</anchor>
      <arglist>( int x, int y ) const</arglist>
    </member>
    <member kind="function">
      <name>contains</name>
      <anchor>contains</anchor>
      <arglist>( int x, int y, bool proper ) const</arglist>
    </member>
    <member kind="function">
      <name>contains</name>
      <anchor>contains</anchor>
      <arglist>( const QRect &amp; r, bool proper = FALSE ) const</arglist>
    </member>
    <member kind="function">
      <name>unite</name>
      <anchor>unite</anchor>
      <arglist>( const QRect &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>intersect</name>
      <anchor>intersect</anchor>
      <arglist>( const QRect &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>intersects</name>
      <anchor>intersects</anchor>
      <arglist>( const QRect &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QRect &amp; r1, const QRect &amp; r2 )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QRect &amp; r1, const QRect &amp; r2 )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QRect &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QRect &amp; r )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QRegExp</name>
    <filename>qregexp.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>CaretMode</anchor>
      <arglist>{ CaretAtZero, CaretAtOffset, CaretWontMatch }</arglist>
    </member>
    <member kind="function">
      <name>QRegExp</name>
      <anchor>QRegExp</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QRegExp</name>
      <anchor>QRegExp</anchor>
      <arglist>( const QString &amp; pattern, bool caseSensitive = TRUE, bool wildcard = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>QRegExp</name>
      <anchor>QRegExp</anchor>
      <arglist>( const QRegExp &amp; rx )</arglist>
    </member>
    <member kind="function">
      <name>QRegExp</name>
      <anchor>QRegExp</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QRegExp &amp; rx )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QRegExp &amp; rx ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QRegExp &amp; rx ) const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isValid</name>
      <anchor>isValid</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>pattern</name>
      <anchor>pattern</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPattern</name>
      <anchor>setPattern</anchor>
      <arglist>( const QString &amp; pattern )</arglist>
    </member>
    <member kind="function">
      <name>caseSensitive</name>
      <anchor>caseSensitive</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setCaseSensitive</name>
      <anchor>setCaseSensitive</anchor>
      <arglist>( bool sensitive )</arglist>
    </member>
    <member kind="function">
      <name>wildcard</name>
      <anchor>wildcard</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setWildcard</name>
      <anchor>setWildcard</anchor>
      <arglist>( bool wildcard )</arglist>
    </member>
    <member kind="function">
      <name>minimal</name>
      <anchor>minimal</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMinimal</name>
      <anchor>setMinimal</anchor>
      <arglist>( bool minimal )</arglist>
    </member>
    <member kind="function">
      <name>exactMatch</name>
      <anchor>exactMatch</anchor>
      <arglist>( const QString &amp; str ) const</arglist>
    </member>
    <member kind="function">
      <name>search</name>
      <anchor>search</anchor>
      <arglist>( const QString &amp; str, int offset = 0, CaretMode caretMode = CaretAtZero ) const</arglist>
    </member>
    <member kind="function">
      <name>searchRev</name>
      <anchor>searchRev</anchor>
      <arglist>( const QString &amp; str, int offset = -1, CaretMode caretMode = CaretAtZero ) const</arglist>
    </member>
    <member kind="function">
      <name>matchedLength</name>
      <anchor>matchedLength</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>numCaptures</name>
      <anchor>numCaptures</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>capturedTexts</name>
      <anchor>capturedTexts</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>cap</name>
      <anchor>cap</anchor>
      <arglist>( int nth = 0 )</arglist>
    </member>
    <member kind="function">
      <name>pos</name>
      <anchor>pos</anchor>
      <arglist>( int nth = 0 )</arglist>
    </member>
    <member kind="function">
      <name>errorString</name>
      <anchor>errorString</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>escape</name>
      <anchor>escape</anchor>
      <arglist>( const QString &amp; str )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QRegExpValidator</name>
    <filename>qregexpvalidator.html</filename>
    <member kind="function">
      <name>QRegExpValidator</name>
      <anchor>QRegExpValidator</anchor>
      <arglist>( QObject * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QRegExpValidator</name>
      <anchor>QRegExpValidator</anchor>
      <arglist>( const QRegExp &amp; rx, QObject * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QRegExpValidator</name>
      <anchor>QRegExpValidator</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>validate</name>
      <anchor>validate</anchor>
      <arglist>( QString &amp; input, int &amp; pos ) const</arglist>
    </member>
    <member kind="function">
      <name>setRegExp</name>
      <anchor>setRegExp</anchor>
      <arglist>( const QRegExp &amp; rx )</arglist>
    </member>
    <member kind="function">
      <name>regExp</name>
      <anchor>regExp</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QRegion</name>
    <filename>qregion.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>RegionType</anchor>
      <arglist>{ Rectangle, Ellipse }</arglist>
    </member>
    <member kind="function">
      <name>QRegion</name>
      <anchor>QRegion</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QRegion</name>
      <anchor>QRegion</anchor>
      <arglist>( int x, int y, int w, int h, RegionType t = Rectangle )</arglist>
    </member>
    <member kind="function">
      <name>QRegion</name>
      <anchor>QRegion</anchor>
      <arglist>( const QRect &amp; r, RegionType t = Rectangle )</arglist>
    </member>
    <member kind="function">
      <name>QRegion</name>
      <anchor>QRegion</anchor>
      <arglist>( const QPointArray &amp; a, bool winding = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>QRegion</name>
      <anchor>QRegion</anchor>
      <arglist>( const QRegion &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>QRegion</name>
      <anchor>QRegion</anchor>
      <arglist>( const QBitmap &amp; bm )</arglist>
    </member>
    <member kind="function">
      <name>QRegion</name>
      <anchor>QRegion</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QRegion &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>isNull</name>
      <anchor>isNull</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>contains</name>
      <anchor>contains</anchor>
      <arglist>( const QPoint &amp; p ) const</arglist>
    </member>
    <member kind="function">
      <name>contains</name>
      <anchor>contains</anchor>
      <arglist>( const QRect &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>translate</name>
      <anchor>translate</anchor>
      <arglist>( int dx, int dy )</arglist>
    </member>
    <member kind="function">
      <name>unite</name>
      <anchor>unite</anchor>
      <arglist>( const QRegion &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>intersect</name>
      <anchor>intersect</anchor>
      <arglist>( const QRegion &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>subtract</name>
      <anchor>subtract</anchor>
      <arglist>( const QRegion &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>eor</name>
      <anchor>eor</anchor>
      <arglist>( const QRegion &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>boundingRect</name>
      <anchor>boundingRect</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rects</name>
      <anchor>rects</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>operator|</name>
      <anchor>operator</anchor>
      <arglist>( const QRegion &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>operator+</name>
      <anchor>operator</anchor>
      <arglist>( const QRegion &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>and</name>
      <anchor>operator</anchor>
      <arglist>( const QRegion &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>operator-</name>
      <anchor>operator</anchor>
      <arglist>( const QRegion &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>operator^</name>
      <anchor>operator</anchor>
      <arglist>( const QRegion &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QRegion &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QRegion &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>and</name>
      <anchor>operator</anchor>
      <arglist>( const QRegion &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QRegion &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QRegion &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QRegion &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QRegion &amp; r ) const</arglist>
    </member>
    <member kind="function">
      <name>handle</name>
      <anchor>handle</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QRegion &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QRegion &amp; r )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QResizeEvent</name>
    <filename>qresizeevent.html</filename>
    <member kind="function">
      <name>QResizeEvent</name>
      <anchor>QResizeEvent</anchor>
      <arglist>( const QSize &amp; size, const QSize &amp; oldSize )</arglist>
    </member>
    <member kind="function">
      <name>size</name>
      <anchor>size</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>oldSize</name>
      <anchor>oldSize</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QScreen</name>
    <filename>qscreen.html</filename>
    <member kind="function">
      <name>QScreen</name>
      <anchor>QScreen</anchor>
      <arglist>( int display_id )</arglist>
    </member>
    <member kind="function">
      <name>QScreen</name>
      <anchor>QScreen</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>initDevice</name>
      <anchor>initDevice</anchor>
      <arglist>() = 0</arglist>
    </member>
    <member kind="function">
      <name>connect</name>
      <anchor>connect</anchor>
      <arglist>( const QString &amp; displaySpec ) = 0</arglist>
    </member>
    <member kind="function">
      <name>disconnect</name>
      <anchor>disconnect</anchor>
      <arglist>() = 0</arglist>
    </member>
    <member kind="function">
      <name>initCursor</name>
      <anchor>initCursor</anchor>
      <arglist>( void * end_of_location, bool init = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>shutdownDevice</name>
      <anchor>shutdownDevice</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setMode</name>
      <anchor>setMode</anchor>
      <arglist>( int, int, int ) = 0</arglist>
    </member>
    <member kind="function">
      <name>supportsDepth</name>
      <anchor>supportsDepth</anchor>
      <arglist>( int d ) const</arglist>
    </member>
    <member kind="function">
      <name>createGfx</name>
      <anchor>createGfx</anchor>
      <arglist>( unsigned char * bytes, int w, int h, int d, int linestep )</arglist>
    </member>
    <member kind="function">
      <name>screenGfx</name>
      <anchor>screenGfx</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>save</name>
      <anchor>save</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>restore</name>
      <anchor>restore</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>blank</name>
      <anchor>blank</anchor>
      <arglist>( bool on )</arglist>
    </member>
    <member kind="function">
      <name>pixmapOffsetAlignment</name>
      <anchor>pixmapOffsetAlignment</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>pixmapLinestepAlignment</name>
      <anchor>pixmapLinestepAlignment</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>onCard</name>
      <anchor>onCard</anchor>
      <arglist>( unsigned char * p ) const</arglist>
    </member>
    <member kind="function">
      <name>onCard</name>
      <anchor>onCard</anchor>
      <arglist>( unsigned char * p, ulong &amp; offset ) const</arglist>
    </member>
    <member kind="function">
      <name>set</name>
      <anchor>set</anchor>
      <arglist>( unsigned int, unsigned int, unsigned int, unsigned int )</arglist>
    </member>
    <member kind="function">
      <name>alloc</name>
      <anchor>alloc</anchor>
      <arglist>( unsigned int r, unsigned int g, unsigned int b )</arglist>
    </member>
    <member kind="function">
      <name>width</name>
      <anchor>width</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>height</name>
      <anchor>height</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>depth</name>
      <anchor>depth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>pixmapDepth</name>
      <anchor>pixmapDepth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>pixelType</name>
      <anchor>pixelType</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>linestep</name>
      <anchor>linestep</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>deviceWidth</name>
      <anchor>deviceWidth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>deviceHeight</name>
      <anchor>deviceHeight</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>base</name>
      <anchor>base</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>cache</name>
      <anchor>cache</anchor>
      <arglist>( int, int )</arglist>
    </member>
    <member kind="function">
      <name>uncache</name>
      <anchor>uncache</anchor>
      <arglist>( uchar * )</arglist>
    </member>
    <member kind="function">
      <name>screenSize</name>
      <anchor>screenSize</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>totalSize</name>
      <anchor>totalSize</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>clut</name>
      <anchor>clut</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>numCols</name>
      <anchor>numCols</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>mapToDevice</name>
      <anchor>mapToDevice</anchor>
      <arglist>( const QSize &amp; s ) const</arglist>
    </member>
    <member kind="function">
      <name>mapFromDevice</name>
      <anchor>mapFromDevice</anchor>
      <arglist>( const QSize &amp; s ) const</arglist>
    </member>
    <member kind="function">
      <name>mapToDevice</name>
      <anchor>mapToDevice</anchor>
      <arglist>( const QPoint &amp;, const QSize &amp; ) const</arglist>
    </member>
    <member kind="function">
      <name>mapFromDevice</name>
      <anchor>mapFromDevice</anchor>
      <arglist>( const QPoint &amp;, const QSize &amp; ) const</arglist>
    </member>
    <member kind="function">
      <name>mapToDevice</name>
      <anchor>mapToDevice</anchor>
      <arglist>( const QRect &amp; r, const QSize &amp; ) const</arglist>
    </member>
    <member kind="function">
      <name>mapFromDevice</name>
      <anchor>mapFromDevice</anchor>
      <arglist>( const QRect &amp; r, const QSize &amp; ) const</arglist>
    </member>
    <member kind="function">
      <name>mapToDevice</name>
      <anchor>mapToDevice</anchor>
      <arglist>( const QImage &amp; i ) const</arglist>
    </member>
    <member kind="function">
      <name>mapFromDevice</name>
      <anchor>mapFromDevice</anchor>
      <arglist>( const QImage &amp; i ) const</arglist>
    </member>
    <member kind="function">
      <name>mapToDevice</name>
      <anchor>mapToDevice</anchor>
      <arglist>( const QRegion &amp; r, const QSize &amp; ) const</arglist>
    </member>
    <member kind="function">
      <name>mapFromDevice</name>
      <anchor>mapFromDevice</anchor>
      <arglist>( const QRegion &amp; r, const QSize &amp; ) const</arglist>
    </member>
    <member kind="function">
      <name>transformOrientation</name>
      <anchor>transformOrientation</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isTransformed</name>
      <anchor>isTransformed</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isInterlaced</name>
      <anchor>isInterlaced</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setDirty</name>
      <anchor>setDirty</anchor>
      <arglist>( const QRect &amp; )</arglist>
    </member>
    <member kind="function">
      <name>opType</name>
      <anchor>opType</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>lastOp</name>
      <anchor>lastOp</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QScrollBar</name>
    <filename>qscrollbar.html</filename>
    <member kind="function">
      <name>QScrollBar</name>
      <anchor>QScrollBar</anchor>
      <arglist>( QWidget * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QScrollBar</name>
      <anchor>QScrollBar</anchor>
      <arglist>( Orientation orientation, QWidget * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QScrollBar</name>
      <anchor>QScrollBar</anchor>
      <arglist>( int minValue, int maxValue, int lineStep, int pageStep, int value, Orientation orientation, QWidget * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QScrollBar</name>
      <anchor>QScrollBar</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setOrientation</name>
      <anchor>setOrientation</anchor>
      <arglist>( Orientation )</arglist>
    </member>
    <member kind="function">
      <name>orientation</name>
      <anchor>orientation</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setTracking</name>
      <anchor>setTracking</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>tracking</name>
      <anchor>tracking</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>draggingSlider</name>
      <anchor>draggingSlider</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPalette</name>
      <anchor>setPalette</anchor>
      <arglist>( const QPalette &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>minValue</name>
      <anchor>minValue</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>maxValue</name>
      <anchor>maxValue</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMinValue</name>
      <anchor>setMinValue</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>setMaxValue</name>
      <anchor>setMaxValue</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>lineStep</name>
      <anchor>lineStep</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>pageStep</name>
      <anchor>pageStep</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setLineStep</name>
      <anchor>setLineStep</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>setPageStep</name>
      <anchor>setPageStep</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>value</name>
      <anchor>value</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>sliderStart</name>
      <anchor>sliderStart</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>sliderRect</name>
      <anchor>sliderRect</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setValue</name>
      <anchor>setValue</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>valueChanged</name>
      <anchor>valueChanged</anchor>
      <arglist>( int value )</arglist>
    </member>
    <member kind="function">
      <name>sliderPressed</name>
      <anchor>sliderPressed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>sliderMoved</name>
      <anchor>sliderMoved</anchor>
      <arglist>( int value )</arglist>
    </member>
    <member kind="function">
      <name>sliderReleased</name>
      <anchor>sliderReleased</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>nextLine</name>
      <anchor>nextLine</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>prevLine</name>
      <anchor>prevLine</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>nextPage</name>
      <anchor>nextPage</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>prevPage</name>
      <anchor>prevPage</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>draggingSlider</anchor>
      <arglist>- whether the user has clicked the mouse on the slider and is currently dragging it</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>lineStep</anchor>
      <arglist>- the line step</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>maxValue</anchor>
      <arglist>- the scroll bar&apos;s maximum value</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>minValue</anchor>
      <arglist>- the scroll bar&apos;s minimum value</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>orientation</anchor>
      <arglist>- the orientation of the scroll bar</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>pageStep</anchor>
      <arglist>- the page step</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>tracking</anchor>
      <arglist>- whether scroll bar tracking is enabled</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>value</anchor>
      <arglist>- the scroll bar&apos;s value</arglist>
    </member>
    <member kind="function">
      <name>hideEvent</name>
      <anchor>hideEvent</anchor>
      <arglist>( QHideEvent * )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QScrollView</name>
    <filename>qscrollview.html</filename>
    <member kind="function">
      <name>QScrollView</name>
      <anchor>QScrollView</anchor>
      <arglist>( QWidget * parent = 0, const char * name = 0, WFlags f = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QScrollView</name>
      <anchor>QScrollView</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ResizePolicy</anchor>
      <arglist>{ Default, Manual, AutoOne, AutoOneFit }</arglist>
    </member>
    <member kind="function">
      <name>setResizePolicy</name>
      <anchor>setResizePolicy</anchor>
      <arglist>( ResizePolicy )</arglist>
    </member>
    <member kind="function">
      <name>resizePolicy</name>
      <anchor>resizePolicy</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>removeChild</name>
      <anchor>removeChild</anchor>
      <arglist>( QWidget * child )</arglist>
    </member>
    <member kind="function">
      <name>addChild</name>
      <anchor>addChild</anchor>
      <arglist>( QWidget * child, int x = 0, int y = 0 )</arglist>
    </member>
    <member kind="function">
      <name>moveChild</name>
      <anchor>moveChild</anchor>
      <arglist>( QWidget * child, int x, int y )</arglist>
    </member>
    <member kind="function">
      <name>childX</name>
      <anchor>childX</anchor>
      <arglist>( QWidget * child )</arglist>
    </member>
    <member kind="function">
      <name>childY</name>
      <anchor>childY</anchor>
      <arglist>( QWidget * child )</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ScrollBarMode</anchor>
      <arglist>{ Auto, AlwaysOff, AlwaysOn }</arglist>
    </member>
    <member kind="function">
      <name>vScrollBarMode</name>
      <anchor>vScrollBarMode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setVScrollBarMode</name>
      <anchor>setVScrollBarMode</anchor>
      <arglist>( ScrollBarMode )</arglist>
    </member>
    <member kind="function">
      <name>hScrollBarMode</name>
      <anchor>hScrollBarMode</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setHScrollBarMode</name>
      <anchor>setHScrollBarMode</anchor>
      <arglist>( ScrollBarMode )</arglist>
    </member>
    <member kind="function">
      <name>cornerWidget</name>
      <anchor>cornerWidget</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setCornerWidget</name>
      <anchor>setCornerWidget</anchor>
      <arglist>( QWidget * corner )</arglist>
    </member>
    <member kind="function">
      <name>horizontalScrollBar</name>
      <anchor>horizontalScrollBar</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>verticalScrollBar</name>
      <anchor>verticalScrollBar</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>viewport</name>
      <anchor>viewport</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>clipper</name>
      <anchor>clipper</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>visibleWidth</name>
      <anchor>visibleWidth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>visibleHeight</name>
      <anchor>visibleHeight</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>contentsWidth</name>
      <anchor>contentsWidth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>contentsHeight</name>
      <anchor>contentsHeight</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>contentsX</name>
      <anchor>contentsX</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>contentsY</name>
      <anchor>contentsY</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>updateContents</name>
      <anchor>updateContents</anchor>
      <arglist>( int x, int y, int w, int h )</arglist>
    </member>
    <member kind="function">
      <name>updateContents</name>
      <anchor>updateContents</anchor>
      <arglist>( const QRect &amp; r )</arglist>
    </member>
    <member kind="function">
      <name>updateContents</name>
      <anchor>updateContents</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>repaintContents</name>
      <anchor>repaintContents</anchor>
      <arglist>( int x, int y, int w, int h, bool erase = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>repaintContents</name>
      <anchor>repaintContents</anchor>
      <arglist>( const QRect &amp; r, bool erase = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>repaintContents</name>
      <anchor>repaintContents</anchor>
      <arglist>( bool erase = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>contentsToViewport</name>
      <anchor>contentsToViewport</anchor>
      <arglist>( int x, int y, int &amp; vx, int &amp; vy ) const</arglist>
    </member>
    <member kind="function">
      <name>viewportToContents</name>
      <anchor>viewportToContents</anchor>
      <arglist>( int vx, int vy, int &amp; x, int &amp; y ) const</arglist>
    </member>
    <member kind="function">
      <name>contentsToViewport</name>
      <anchor>contentsToViewport</anchor>
      <arglist>( const QPoint &amp; p ) const</arglist>
    </member>
    <member kind="function">
      <name>viewportToContents</name>
      <anchor>viewportToContents</anchor>
      <arglist>( const QPoint &amp; vp ) const</arglist>
    </member>
    <member kind="function">
      <name>enableClipper</name>
      <anchor>enableClipper</anchor>
      <arglist>( bool y )</arglist>
    </member>
    <member kind="function">
      <name>setStaticBackground</name>
      <anchor>setStaticBackground</anchor>
      <arglist>( bool y )</arglist>
    </member>
    <member kind="function">
      <name>hasStaticBackground</name>
      <anchor>hasStaticBackground</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>viewportSize</name>
      <anchor>viewportSize</anchor>
      <arglist>( int x, int y ) const</arglist>
    </member>
    <member kind="function">
      <name>isHorizontalSliderPressed</name>
      <anchor>isHorizontalSliderPressed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>isVerticalSliderPressed</name>
      <anchor>isVerticalSliderPressed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setDragAutoScroll</name>
      <anchor>setDragAutoScroll</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>dragAutoScroll</name>
      <anchor>dragAutoScroll</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>resizeContents</name>
      <anchor>resizeContents</anchor>
      <arglist>( int w, int h )</arglist>
    </member>
    <member kind="function">
      <name>scrollBy</name>
      <anchor>scrollBy</anchor>
      <arglist>( int dx, int dy )</arglist>
    </member>
    <member kind="function">
      <name>setContentsPos</name>
      <anchor>setContentsPos</anchor>
      <arglist>( int x, int y )</arglist>
    </member>
    <member kind="function">
      <name>ensureVisible</name>
      <anchor>ensureVisible</anchor>
      <arglist>( int x, int y )</arglist>
    </member>
    <member kind="function">
      <name>ensureVisible</name>
      <anchor>ensureVisible</anchor>
      <arglist>( int x, int y, int xmargin, int ymargin )</arglist>
    </member>
    <member kind="function">
      <name>center</name>
      <anchor>center</anchor>
      <arglist>( int x, int y )</arglist>
    </member>
    <member kind="function">
      <name>center</name>
      <anchor>center</anchor>
      <arglist>( int x, int y, float xmargin, float ymargin )</arglist>
    </member>
    <member kind="function">
      <name>updateScrollBars</name>
      <anchor>updateScrollBars</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>contentsMoving</name>
      <anchor>contentsMoving</anchor>
      <arglist>( int x, int y )</arglist>
    </member>
    <member kind="function">
      <name>horizontalSliderPressed</name>
      <anchor>horizontalSliderPressed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>horizontalSliderReleased</name>
      <anchor>horizontalSliderReleased</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>verticalSliderPressed</name>
      <anchor>verticalSliderPressed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>verticalSliderReleased</name>
      <anchor>verticalSliderReleased</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>contentsHeight</anchor>
      <arglist>- the height of the contents area</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>contentsWidth</anchor>
      <arglist>- the width of the contents area</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>contentsX</anchor>
      <arglist>- the X coordinate of the contents that are at the left edge of the viewport</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>contentsY</anchor>
      <arglist>- the Y coordinate of the contents that are at the top edge of the viewport</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>dragAutoScroll</anchor>
      <arglist>- whether autoscrolling in drag move events is enabled</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>hScrollBarMode</anchor>
      <arglist>- the mode for the horizontal scroll bar</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>resizePolicy</anchor>
      <arglist>- the resize policy</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>vScrollBarMode</anchor>
      <arglist>- the mode for the vertical scroll bar</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>visibleHeight</anchor>
      <arglist>- the vertical amount of the content that is visible</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>visibleWidth</anchor>
      <arglist>- the horizontal amount of the content that is visible</arglist>
    </member>
    <member kind="function">
      <name>drawContents</name>
      <anchor>drawContents</anchor>
      <arglist>( QPainter * p, int clipx, int clipy, int clipw, int cliph )</arglist>
    </member>
    <member kind="function">
      <name>drawContentsOffset</name>
      <anchor>drawContentsOffset</anchor>
      <arglist>( QPainter * p, int offsetx, int offsety, int clipx, int clipy, int clipw, int cliph )</arglist>
    </member>
    <member kind="function">
      <name>contentsMousePressEvent</name>
      <anchor>contentsMousePressEvent</anchor>
      <arglist>( QMouseEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>contentsMouseReleaseEvent</name>
      <anchor>contentsMouseReleaseEvent</anchor>
      <arglist>( QMouseEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>contentsMouseDoubleClickEvent</name>
      <anchor>contentsMouseDoubleClickEvent</anchor>
      <arglist>( QMouseEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>contentsMouseMoveEvent</name>
      <anchor>contentsMouseMoveEvent</anchor>
      <arglist>( QMouseEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>contentsDragEnterEvent</name>
      <anchor>contentsDragEnterEvent</anchor>
      <arglist>( QDragEnterEvent * )</arglist>
    </member>
    <member kind="function">
      <name>contentsDragMoveEvent</name>
      <anchor>contentsDragMoveEvent</anchor>
      <arglist>( QDragMoveEvent * )</arglist>
    </member>
    <member kind="function">
      <name>contentsDragLeaveEvent</name>
      <anchor>contentsDragLeaveEvent</anchor>
      <arglist>( QDragLeaveEvent * )</arglist>
    </member>
    <member kind="function">
      <name>contentsDropEvent</name>
      <anchor>contentsDropEvent</anchor>
      <arglist>( QDropEvent * )</arglist>
    </member>
    <member kind="function">
      <name>contentsWheelEvent</name>
      <anchor>contentsWheelEvent</anchor>
      <arglist>( QWheelEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>contentsContextMenuEvent</name>
      <anchor>contentsContextMenuEvent</anchor>
      <arglist>( QContextMenuEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>viewportPaintEvent</name>
      <anchor>viewportPaintEvent</anchor>
      <arglist>( QPaintEvent * pe )</arglist>
    </member>
    <member kind="function">
      <name>viewportResizeEvent</name>
      <anchor>viewportResizeEvent</anchor>
      <arglist>( QResizeEvent * )</arglist>
    </member>
    <member kind="function">
      <name>setMargins</name>
      <anchor>setMargins</anchor>
      <arglist>( int left, int top, int right, int bottom )</arglist>
    </member>
    <member kind="function">
      <name>leftMargin</name>
      <anchor>leftMargin</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>topMargin</name>
      <anchor>topMargin</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>rightMargin</name>
      <anchor>rightMargin</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>bottomMargin</name>
      <anchor>bottomMargin</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setHBarGeometry</name>
      <anchor>setHBarGeometry</anchor>
      <arglist>( QScrollBar &amp; hbar, int x, int y, int w, int h )</arglist>
    </member>
    <member kind="function">
      <name>setVBarGeometry</name>
      <anchor>setVBarGeometry</anchor>
      <arglist>( QScrollBar &amp; vbar, int x, int y, int w, int h )</arglist>
    </member>
    <member kind="function">
      <name>eventFilter</name>
      <anchor>eventFilter</anchor>
      <arglist>( QObject * obj, QEvent * e )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QSemaphore</name>
    <filename>qsemaphore.html</filename>
    <member kind="function">
      <name>QSemaphore</name>
      <anchor>QSemaphore</anchor>
      <arglist>( int maxcount )</arglist>
    </member>
    <member kind="function">
      <name>QSemaphore</name>
      <anchor>QSemaphore</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>available</name>
      <anchor>available</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>total</name>
      <anchor>total</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>operator++</name>
      <anchor>operator</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>operator--</name>
      <anchor>operator</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( int n )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( int n )</arglist>
    </member>
    <member kind="function">
      <name>tryAccess</name>
      <anchor>tryAccess</anchor>
      <arglist>( int n )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QServerSocket</name>
    <filename>qserversocket.html</filename>
    <member kind="function">
      <name>QServerSocket</name>
      <anchor>QServerSocket</anchor>
      <arglist>( Q_UINT16 port, int backlog = 1, QObject * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QServerSocket</name>
      <anchor>QServerSocket</anchor>
      <arglist>( const QHostAddress &amp; address, Q_UINT16 port, int backlog = 1, QObject * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QServerSocket</name>
      <anchor>QServerSocket</anchor>
      <arglist>( QObject * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QServerSocket</name>
      <anchor>QServerSocket</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>ok</name>
      <anchor>ok</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>port</name>
      <anchor>port</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>socket</name>
      <anchor>socket</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSocket</name>
      <anchor>setSocket</anchor>
      <arglist>( int socket )</arglist>
    </member>
    <member kind="function">
      <name>address</name>
      <anchor>address</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>newConnection</name>
      <anchor>newConnection</anchor>
      <arglist>( int socket ) = 0</arglist>
    </member>
    <member kind="function">
      <name>socketDevice</name>
      <anchor>socketDevice</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QSessionManager</name>
    <filename>qsessionmanager.html</filename>
    <member kind="function">
      <name>sessionId</name>
      <anchor>sessionId</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>sessionKey</name>
      <anchor>sessionKey</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>handle</name>
      <anchor>handle</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>allowsInteraction</name>
      <anchor>allowsInteraction</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>allowsErrorInteraction</name>
      <anchor>allowsErrorInteraction</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>release</name>
      <anchor>release</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>cancel</name>
      <anchor>cancel</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>RestartHint</anchor>
      <arglist>{ RestartIfRunning, RestartAnyway, RestartImmediately, RestartNever }</arglist>
    </member>
    <member kind="function">
      <name>setRestartHint</name>
      <anchor>setRestartHint</anchor>
      <arglist>( RestartHint hint )</arglist>
    </member>
    <member kind="function">
      <name>restartHint</name>
      <anchor>restartHint</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setRestartCommand</name>
      <anchor>setRestartCommand</anchor>
      <arglist>( const QStringList &amp; command )</arglist>
    </member>
    <member kind="function">
      <name>restartCommand</name>
      <anchor>restartCommand</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setDiscardCommand</name>
      <anchor>setDiscardCommand</anchor>
      <arglist>( const QStringList &amp; )</arglist>
    </member>
    <member kind="function">
      <name>discardCommand</name>
      <anchor>discardCommand</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setManagerProperty</name>
      <anchor>setManagerProperty</anchor>
      <arglist>( const QString &amp; name, const QString &amp; value )</arglist>
    </member>
    <member kind="function">
      <name>setManagerProperty</name>
      <anchor>setManagerProperty</anchor>
      <arglist>( const QString &amp; name, const QStringList &amp; value )</arglist>
    </member>
    <member kind="function">
      <name>isPhase2</name>
      <anchor>isPhase2</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>requestPhase2</name>
      <anchor>requestPhase2</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QSettings</name>
    <filename>qsettings.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>Format</anchor>
      <arglist>{ Native = 0, Ini }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>System</anchor>
      <arglist>{ Unix = 0, Windows, Mac }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>Scope</anchor>
      <arglist>{ User, Global }</arglist>
    </member>
    <member kind="function">
      <name>QSettings</name>
      <anchor>QSettings</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QSettings</name>
      <anchor>QSettings</anchor>
      <arglist>( Format format )</arglist>
    </member>
    <member kind="function">
      <name>QSettings</name>
      <anchor>QSettings</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>writeEntry</name>
      <anchor>writeEntry</anchor>
      <arglist>( const QString &amp; key, bool value )</arglist>
    </member>
    <member kind="function">
      <name>writeEntry</name>
      <anchor>writeEntry</anchor>
      <arglist>( const QString &amp; key, double value )</arglist>
    </member>
    <member kind="function">
      <name>writeEntry</name>
      <anchor>writeEntry</anchor>
      <arglist>( const QString &amp; key, int value )</arglist>
    </member>
    <member kind="function">
      <name>writeEntry</name>
      <anchor>writeEntry</anchor>
      <arglist>( const QString &amp; key, const QString &amp; value )</arglist>
    </member>
    <member kind="function">
      <name>writeEntry</name>
      <anchor>writeEntry</anchor>
      <arglist>( const QString &amp; key, const QStringList &amp; value )</arglist>
    </member>
    <member kind="function">
      <name>entryList</name>
      <anchor>entryList</anchor>
      <arglist>( const QString &amp; key ) const</arglist>
    </member>
    <member kind="function">
      <name>subkeyList</name>
      <anchor>subkeyList</anchor>
      <arglist>( const QString &amp; key ) const</arglist>
    </member>
    <member kind="function">
      <name>readListEntry</name>
      <anchor>readListEntry</anchor>
      <arglist>( const QString &amp; key, bool * ok = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>readEntry</name>
      <anchor>readEntry</anchor>
      <arglist>( const QString &amp; key, const QString &amp; def = QString::null, bool * ok = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>readNumEntry</name>
      <anchor>readNumEntry</anchor>
      <arglist>( const QString &amp; key, int def = 0, bool * ok = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>readDoubleEntry</name>
      <anchor>readDoubleEntry</anchor>
      <arglist>( const QString &amp; key, double def = 0, bool * ok = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>readBoolEntry</name>
      <anchor>readBoolEntry</anchor>
      <arglist>( const QString &amp; key, bool def = FALSE, bool * ok = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>removeEntry</name>
      <anchor>removeEntry</anchor>
      <arglist>( const QString &amp; key )</arglist>
    </member>
    <member kind="function">
      <name>insertSearchPath</name>
      <anchor>insertSearchPath</anchor>
      <arglist>( System s, const QString &amp; path )</arglist>
    </member>
    <member kind="function">
      <name>removeSearchPath</name>
      <anchor>removeSearchPath</anchor>
      <arglist>( System s, const QString &amp; path )</arglist>
    </member>
    <member kind="function">
      <name>setPath</name>
      <anchor>setPath</anchor>
      <arglist>( const QString &amp; domain, const QString &amp; product, Scope scope = Global )</arglist>
    </member>
    <member kind="function">
      <name>beginGroup</name>
      <anchor>beginGroup</anchor>
      <arglist>( const QString &amp; group )</arglist>
    </member>
    <member kind="function">
      <name>endGroup</name>
      <anchor>endGroup</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>resetGroup</name>
      <anchor>resetGroup</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>group</name>
      <anchor>group</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QSGIStyle</name>
    <filename>qsgistyle.html</filename>
    <member kind="function">
      <name>QSGIStyle</name>
      <anchor>QSGIStyle</anchor>
      <arglist>( bool useHighlightCols = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>QSGIStyle</name>
      <anchor>QSGIStyle</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QShowEvent</name>
    <filename>qshowevent.html</filename>
    <member kind="function">
      <name>QShowEvent</name>
      <anchor>QShowEvent</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QSignal</name>
    <filename>qsignal.html</filename>
    <member kind="function">
      <name>QSignal</name>
      <anchor>QSignal</anchor>
      <arglist>( QObject * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QSignal</name>
      <anchor>QSignal</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>connect</name>
      <anchor>connect</anchor>
      <arglist>( const QObject * receiver, const char * member )</arglist>
    </member>
    <member kind="function">
      <name>disconnect</name>
      <anchor>disconnect</anchor>
      <arglist>( const QObject * receiver, const char * member = 0 )</arglist>
    </member>
    <member kind="function">
      <name>activate</name>
      <anchor>activate</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setValue</name>
      <anchor>setValue</anchor>
      <arglist>( const QVariant &amp; value )</arglist>
    </member>
    <member kind="function">
      <name>value</name>
      <anchor>value</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QSignalMapper</name>
    <filename>qsignalmapper.html</filename>
    <member kind="function">
      <name>QSignalMapper</name>
      <anchor>QSignalMapper</anchor>
      <arglist>( QObject * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QSignalMapper</name>
      <anchor>QSignalMapper</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setMapping</name>
      <anchor>setMapping</anchor>
      <arglist>( const QObject * sender, int identifier )</arglist>
    </member>
    <member kind="function">
      <name>setMapping</name>
      <anchor>setMapping</anchor>
      <arglist>( const QObject * sender, const QString &amp; identifier )</arglist>
    </member>
    <member kind="function">
      <name>removeMappings</name>
      <anchor>removeMappings</anchor>
      <arglist>( const QObject * sender )</arglist>
    </member>
    <member kind="function">
      <name>map</name>
      <anchor>map</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>mapped</name>
      <anchor>mapped</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>mapped</name>
      <anchor>mapped</anchor>
      <arglist>( const QString &amp; )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QSimpleRichText</name>
    <filename>qsimplerichtext.html</filename>
    <member kind="function">
      <name>QSimpleRichText</name>
      <anchor>QSimpleRichText</anchor>
      <arglist>( const QString &amp; text, const QFont &amp; fnt, const QString &amp; context = QString::null, const QStyleSheet * sheet = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QSimpleRichText</name>
      <anchor>QSimpleRichText</anchor>
      <arglist>( const QString &amp; text, const QFont &amp; fnt, const QString &amp; context, const QStyleSheet * sheet, const QMimeSourceFactory * factory, int pageBreak = -1, const QColor &amp; linkColor = Qt::blue, bool linkUnderline = TRUE )</arglist>
    </member>
    <member kind="function">
      <name>QSimpleRichText</name>
      <anchor>QSimpleRichText</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setWidth</name>
      <anchor>setWidth</anchor>
      <arglist>( int w )</arglist>
    </member>
    <member kind="function">
      <name>setWidth</name>
      <anchor>setWidth</anchor>
      <arglist>( QPainter * p, int w )</arglist>
    </member>
    <member kind="function">
      <name>setDefaultFont</name>
      <anchor>setDefaultFont</anchor>
      <arglist>( const QFont &amp; f )</arglist>
    </member>
    <member kind="function">
      <name>width</name>
      <anchor>width</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>widthUsed</name>
      <anchor>widthUsed</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>height</name>
      <anchor>height</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>adjustSize</name>
      <anchor>adjustSize</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>draw</name>
      <anchor>draw</anchor>
      <arglist>( QPainter * p, int x, int y, const QRect &amp; clipRect, const QColorGroup &amp; cg, const QBrush * paper = 0 ) const</arglist>
    </member>
    <member kind="function">
      <name>context</name>
      <anchor>context</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>anchorAt</name>
      <anchor>anchorAt</anchor>
      <arglist>( const QPoint &amp; pos ) const</arglist>
    </member>
    <member kind="function">
      <name>inText</name>
      <anchor>inText</anchor>
      <arglist>( const QPoint &amp; pos ) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QSize</name>
    <filename>qsize.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>ScaleMode</anchor>
      <arglist>{ ScaleFree, ScaleMin, ScaleMax }</arglist>
    </member>
    <member kind="function">
      <name>QSize</name>
      <anchor>QSize</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QSize</name>
      <anchor>QSize</anchor>
      <arglist>( int w, int h )</arglist>
    </member>
    <member kind="function">
      <name>isNull</name>
      <anchor>isNull</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isEmpty</name>
      <anchor>isEmpty</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>isValid</name>
      <anchor>isValid</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>width</name>
      <anchor>width</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>height</name>
      <anchor>height</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setWidth</name>
      <anchor>setWidth</anchor>
      <arglist>( int w )</arglist>
    </member>
    <member kind="function">
      <name>setHeight</name>
      <anchor>setHeight</anchor>
      <arglist>( int h )</arglist>
    </member>
    <member kind="function">
      <name>transpose</name>
      <anchor>transpose</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>scale</name>
      <anchor>scale</anchor>
      <arglist>( int w, int h, ScaleMode mode )</arglist>
    </member>
    <member kind="function">
      <name>scale</name>
      <anchor>scale</anchor>
      <arglist>( const QSize &amp; s, ScaleMode mode )</arglist>
    </member>
    <member kind="function">
      <name>expandedTo</name>
      <anchor>expandedTo</anchor>
      <arglist>( const QSize &amp; otherSize ) const</arglist>
    </member>
    <member kind="function">
      <name>boundedTo</name>
      <anchor>boundedTo</anchor>
      <arglist>( const QSize &amp; otherSize ) const</arglist>
    </member>
    <member kind="function">
      <name>rwidth</name>
      <anchor>rwidth</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>rheight</name>
      <anchor>rheight</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QSize &amp; s )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QSize &amp; s )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( int c )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( double c )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( int c )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( double c )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QSize &amp; s1, const QSize &amp; s2 )</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QSize &amp; s1, const QSize &amp; s2 )</arglist>
    </member>
    <member kind="function">
      <name>operator+</name>
      <anchor>operator</anchor>
      <arglist>( const QSize &amp; s1, const QSize &amp; s2 )</arglist>
    </member>
    <member kind="function">
      <name>operator-</name>
      <anchor>operator</anchor>
      <arglist>( const QSize &amp; s1, const QSize &amp; s2 )</arglist>
    </member>
    <member kind="function">
      <name>operator*</name>
      <anchor>operator</anchor>
      <arglist>( const QSize &amp; s, int c )</arglist>
    </member>
    <member kind="function">
      <name>operator*</name>
      <anchor>operator</anchor>
      <arglist>( int c, const QSize &amp; s )</arglist>
    </member>
    <member kind="function">
      <name>operator*</name>
      <anchor>operator</anchor>
      <arglist>( const QSize &amp; s, double c )</arglist>
    </member>
    <member kind="function">
      <name>operator*</name>
      <anchor>operator</anchor>
      <arglist>( double c, const QSize &amp; s )</arglist>
    </member>
    <member kind="function">
      <name>operator/</name>
      <anchor>operator</anchor>
      <arglist>( const QSize &amp; s, int c )</arglist>
    </member>
    <member kind="function">
      <name>operator/</name>
      <anchor>operator</anchor>
      <arglist>( const QSize &amp; s, double c )</arglist>
    </member>
    <member kind="function">
      <name>lt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, const QSize &amp; sz )</arglist>
    </member>
    <member kind="function">
      <name>gt</name>
      <anchor>operator</anchor>
      <arglist>( QDataStream &amp; s, QSize &amp; sz )</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ScaleMode</anchor>
      <arglist>, the size is set to (</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ScaleMode</anchor>
      <arglist>, the current size is scaled to a rectangle</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ScaleMode</anchor>
      <arglist>, the current size is scaled to a rectangle</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QSizeGrip</name>
    <filename>qsizegrip.html</filename>
    <member kind="function">
      <name>QSizeGrip</name>
      <anchor>QSizeGrip</anchor>
      <arglist>( QWidget * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QSizeGrip</name>
      <anchor>QSizeGrip</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>sizeHint</name>
      <anchor>sizeHint</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>paintEvent</name>
      <anchor>paintEvent</anchor>
      <arglist>( QPaintEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>mousePressEvent</name>
      <anchor>mousePressEvent</anchor>
      <arglist>( QMouseEvent * e )</arglist>
    </member>
    <member kind="function">
      <name>mouseMoveEvent</name>
      <anchor>mouseMoveEvent</anchor>
      <arglist>( QMouseEvent * e )</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QSizePolicy</name>
    <filename>qsizepolicy.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>SizeType</anchor>
      <arglist>{ Fixed = 0, Minimum = MayGrow, Maximum = MayShrink, Preferred = MayGrow | MayShrink, MinimumExpanding = MayGrow | ExpMask, Expanding = MayGrow | MayShrink | ExpMask, Ignored = ExpMask }</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>ExpandData</anchor>
      <arglist>{ NoDirection = 0, Horizontally = 1, Vertically = 2, Horizontal = Horizontally, Vertical = Vertically, BothDirections = Horizontally | Vertically }</arglist>
    </member>
    <member kind="function">
      <name>QSizePolicy</name>
      <anchor>QSizePolicy</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QSizePolicy</name>
      <anchor>QSizePolicy</anchor>
      <arglist>( SizeType hor, SizeType ver, bool hfw = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>QSizePolicy</name>
      <anchor>QSizePolicy</anchor>
      <arglist>( SizeType hor, SizeType ver, uchar horStretch, uchar verStretch, bool hfw = FALSE )</arglist>
    </member>
    <member kind="function">
      <name>horData</name>
      <anchor>horData</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>verData</name>
      <anchor>verData</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>mayShrinkHorizontally</name>
      <anchor>mayShrinkHorizontally</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>mayShrinkVertically</name>
      <anchor>mayShrinkVertically</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>mayGrowHorizontally</name>
      <anchor>mayGrowHorizontally</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>mayGrowVertically</name>
      <anchor>mayGrowVertically</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>expanding</name>
      <anchor>expanding</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setHorData</name>
      <anchor>setHorData</anchor>
      <arglist>( SizeType d )</arglist>
    </member>
    <member kind="function">
      <name>setVerData</name>
      <anchor>setVerData</anchor>
      <arglist>( SizeType d )</arglist>
    </member>
    <member kind="function">
      <name>setHeightForWidth</name>
      <anchor>setHeightForWidth</anchor>
      <arglist>( bool b )</arglist>
    </member>
    <member kind="function">
      <name>hasHeightForWidth</name>
      <anchor>hasHeightForWidth</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QSizePolicy &amp; s ) const</arglist>
    </member>
    <member kind="function">
      <name>eq</name>
      <anchor>operator</anchor>
      <arglist>( const QSizePolicy &amp; s ) const</arglist>
    </member>
    <member kind="function">
      <name>horStretch</name>
      <anchor>horStretch</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>verStretch</name>
      <anchor>verStretch</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setHorStretch</name>
      <anchor>setHorStretch</anchor>
      <arglist>( uchar sf )</arglist>
    </member>
    <member kind="function">
      <name>setVerStretch</name>
      <anchor>setVerStretch</anchor>
      <arglist>( uchar sf )</arglist>
    </member>
    <member kind="function">
      <name>transpose</name>
      <anchor>transpose</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QWidget</name>
      <anchor>sizeHint</anchor>
      <arglist>() is the only acceptable</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QSjisCodec</name>
    <filename>qsjiscodec.html</filename>
    <member kind="function">
      <name>mimeName</name>
      <anchor>mimeName</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>QSjisCodec</name>
      <anchor>QSjisCodec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>QSjisCodec</name>
      <anchor>QSjisCodec</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QSlider</name>
    <filename>qslider.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>TickSetting</anchor>
      <arglist>{ NoMarks = 0, Above = 1, Left = Above, Below = 2, Right = Below, Both = 3 }</arglist>
    </member>
    <member kind="function">
      <name>QSlider</name>
      <anchor>QSlider</anchor>
      <arglist>( QWidget * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QSlider</name>
      <anchor>QSlider</anchor>
      <arglist>( Orientation orientation, QWidget * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QSlider</name>
      <anchor>QSlider</anchor>
      <arglist>( int minValue, int maxValue, int pageStep, int value, Orientation orientation, QWidget * parent, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QSlider</name>
      <anchor>QSlider</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setOrientation</name>
      <anchor>setOrientation</anchor>
      <arglist>( Orientation )</arglist>
    </member>
    <member kind="function">
      <name>orientation</name>
      <anchor>orientation</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setTracking</name>
      <anchor>setTracking</anchor>
      <arglist>( bool enable )</arglist>
    </member>
    <member kind="function">
      <name>tracking</name>
      <anchor>tracking</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setPalette</name>
      <anchor>setPalette</anchor>
      <arglist>( const QPalette &amp; p )</arglist>
    </member>
    <member kind="function">
      <name>sliderStart</name>
      <anchor>sliderStart</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>sliderRect</name>
      <anchor>sliderRect</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setTickmarks</name>
      <anchor>setTickmarks</anchor>
      <arglist>( TickSetting )</arglist>
    </member>
    <member kind="function">
      <name>tickmarks</name>
      <anchor>tickmarks</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setTickInterval</name>
      <anchor>setTickInterval</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>tickInterval</name>
      <anchor>tickInterval</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>minValue</name>
      <anchor>minValue</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>maxValue</name>
      <anchor>maxValue</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setMinValue</name>
      <anchor>setMinValue</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>setMaxValue</name>
      <anchor>setMaxValue</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>lineStep</name>
      <anchor>lineStep</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>pageStep</name>
      <anchor>pageStep</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setLineStep</name>
      <anchor>setLineStep</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>setPageStep</name>
      <anchor>setPageStep</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>value</name>
      <anchor>value</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setValue</name>
      <anchor>setValue</anchor>
      <arglist>( int )</arglist>
    </member>
    <member kind="function">
      <name>addStep</name>
      <anchor>addStep</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>subtractStep</name>
      <anchor>subtractStep</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>valueChanged</name>
      <anchor>valueChanged</anchor>
      <arglist>( int value )</arglist>
    </member>
    <member kind="function">
      <name>sliderPressed</name>
      <anchor>sliderPressed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>sliderMoved</name>
      <anchor>sliderMoved</anchor>
      <arglist>( int value )</arglist>
    </member>
    <member kind="function">
      <name>sliderReleased</name>
      <anchor>sliderReleased</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setRange</name>
      <anchor>setRange</anchor>
      <arglist>( int minValue, int maxValue )</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>lineStep</anchor>
      <arglist>- the current line step</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>maxValue</anchor>
      <arglist>- the current maximum value of the slider</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>minValue</anchor>
      <arglist>- the current minimum value of the slider</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>orientation</anchor>
      <arglist>- the slider&apos;s orientation</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>pageStep</anchor>
      <arglist>- the current page step</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>tickInterval</anchor>
      <arglist>- the interval between tickmarks</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>tickmarks</anchor>
      <arglist>- the tickmark settings for this slider</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>tracking</anchor>
      <arglist>- whether slider tracking is enabled</arglist>
    </member>
    <member kind="function">
      <name>prop</name>
      <anchor>value</anchor>
      <arglist>- the current slider value</arglist>
    </member>
    <member kind="function">
      <name>valueChange</name>
      <anchor>valueChange</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>rangeChange</name>
      <anchor>rangeChange</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QSocket</name>
    <filename>qsocket.html</filename>
    <member kind="function">
      <name>enum</name>
      <anchor>Error</anchor>
      <arglist>{ ErrConnectionRefused, ErrHostNotFound, ErrSocketRead }</arglist>
    </member>
    <member kind="function">
      <name>QSocket</name>
      <anchor>QSocket</anchor>
      <arglist>( QObject * parent = 0, const char * name = 0 )</arglist>
    </member>
    <member kind="function">
      <name>QSocket</name>
      <anchor>QSocket</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>enum</name>
      <anchor>State</anchor>
      <arglist>{ Idle, HostLookup, Connecting, Connected, Closing, Connection = Connected }</arglist>
    </member>
    <member kind="function">
      <name>state</name>
      <anchor>state</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>socket</name>
      <anchor>socket</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <name>setSocket</name>
      <anchor>setSocket</anchor>
      <arglist>( int socket )</arglist>
    </member>
    <member kind="function">
      <name>socketDevice</name>
      <anchor>socketDevice</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <name>setSocketDevice</name>
      