/*
 * main.cpp for lisa, kio_lan and kcm module
 *
 *  Copyright (C) 2000 Alexander Neundorf <neundorf@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef LISA_SETUPWIZARD_H
#define LISA_SETUPWIZARD_H

#include "kcmlisa.h"
#include "kcmkiolan.h"

#include "findnic.h"

#include <qspinbox.h>
#include <qcheckbox.h>
#include <krestrictedline.h>
#include <q3wizard.h>
#include <kglobal.h>
#include <qlayout.h>
#include <qlabel.h>
#include <q3listbox.h>


#include <kcmodule.h>
#include <kvbox.h>


class SetupWizard:public Q3Wizard
{
   Q_OBJECT
   public:
      SetupWizard(QWidget* parent, LisaConfigInfo* configInfo);
      ~SetupWizard();
      virtual void showPage(QWidget* page);
      void clearAll();
   protected slots:
      virtual void next();
      virtual void accept();
      void checkIPAddress(const QString& address);
   protected:
      void applyLisaConfigInfo(LisaConfigInfo& lci);

      void setupPage1();
      void setupNoNicPage();
      void setupMultiNicPage();
      void setupSearchPage();
      void setupAddressesPage();
      void setupAllowedPage();
      void setupBcastPage();
      void setupUpdateIntervalPage();
      void setupAdvancedSettingsPage();
      void setupFinalPage();
      void setupRest();

      KVBox* m_page1;
      KVBox* m_noNicPage;
      KVBox* m_multiNicPage;
      KVBox* m_searchPage;
      KVBox* m_addressesPage;
      KVBox* m_allowedAddressesPage;
      KVBox* m_bcastPage;
      KVBox* m_intervalPage;
      KVBox* m_advancedPage;
      KVBox* m_finalPage;


      Q3ListBox *m_nicListBox;
      QLabel *m_trustedHostsLabel;
      QCheckBox *m_ping;
      QCheckBox *m_nmblookup;
      KRestrictedLine* m_pingAddresses;
      KRestrictedLine* m_allowedAddresses;
      KRestrictedLine* m_bcastAddress;
      KRestrictedLine* m_manualAddress;
      QSpinBox* m_updatePeriod;
      QCheckBox* m_deliverUnnamedHosts;
      QSpinBox* m_firstWait;
      QSpinBox* m_maxPingsAtOnce;
      QCheckBox* m_secondScan;
      QSpinBox* m_secondWait;

      NICList* m_nics;
      LisaConfigInfo* m_configInfo;
};


#endif

