/*
 * knewstickerconfig.h
 *
 * Copyright (c) 2000, 2001 Frerich Raabe <raabe@kde.org>
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 */
#ifndef KNEWSTICKERCONFIG_H
#define KNEWSTICKERCONFIG_H

#include "ui_knewstickerconfigwidget.h"
#include "configaccess.h"
#include "newsengine.h"

#include <kdialog.h>

#include <qevent.h>
#include <qfont.h>
#include <q3listview.h>
//Added by qt3to4:
#include <QPixmap>
#include <QResizeEvent>

class KNewsTickerConfig;
class NewsIconMgr;
class ConfigAccess;

class KNewsTickerConfigWidget : public QWidget, public Ui::KNewsTickerConfigWidget
{
public:
  KNewsTickerConfigWidget( QWidget *parent ) : QWidget( parent ) {
    setupUi( this );
  }
};


class CategoryItem : public Q3ListViewItem
{
	public:
		CategoryItem(Q3ListView *, const QString &);

		void setOpen(bool);
};

class NewsSourceItem : public Q3CheckListItem
{
	public:
		NewsSourceItem(KNewsTickerConfig *, CategoryItem *, const NewsSourceBase::Data &);

		NewsSourceBase::Data data() const;
		void setData(const NewsSourceBase::Data &);
		void setIcon(const QPixmap &);

		Q3ListViewItem *parentItem() { return Q3CheckListItem::parent(); }
	
	private:
		QString      m_icon;
		bool         m_isProgram;
		NewsSourceBase::Subject m_subject;
		CategoryItem *m_parent;
		KNewsTickerConfig *m_kcm;
};

class KNewsTickerConfig : public KDialog
{
	Q_OBJECT
	friend class NewsSourceItem;
	public:
		explicit KNewsTickerConfig(ConfigAccess *, QWidget * = 0);

		void load();
		void save();
		void defaults();

	protected:
		void addNewsSource(const NewsSourceBase::Data &, bool = false);
		void modifyNewsSource(Q3ListViewItem *);
		void removeNewsSource();
		void addFilter(const ArticleFilter &);
		void removeFilter(Q3ListViewItem *);
		void resizeEvent(QResizeEvent *);
		void openModifyDialog();
		bool eventFilter(QObject *o, QEvent *e);
		void getNewsIcon(NewsSourceItem *, const KUrl &);

	protected slots:
		void slotNewsSourceContextMenu(K3ListView *, Q3ListViewItem *, const QPoint &);
		void slotChooseFont();
		void slotAddNewsSource();
		void slotAddFilter();
		void slotAddNewsSource(const NewsSourceBase::Data &);
		void slotRemoveNewsSource();
		void slotRemoveFilter();
		void slotModifyNewsSource();
		void slotModifyNewsSource(const NewsSourceBase::Data &);
		void slotModifyNewsSource(Q3ListViewItem *, const QPoint &, int);
		void slotNewsSourceSelectionChanged();
		void slotFilterSelectionChanged(Q3ListViewItem *);
		void slotFilterActionChanged(const QString &);
		void slotFilterNewsSourceChanged(const QString &);
		void slotFilterConditionChanged(const QString &);
		void slotFilterExpressionChanged(const QString &);
		virtual void slotOk();

	private slots:
		void slotGotNewsIcon(const KUrl &, const QPixmap &);

	private:
		ConfigAccess        *m_cfg;
		KNewsTickerConfigWidget *m_child;
		QFont               m_font;
		NewsSourceItem      *m_modifyItem;
		NewsIconMgr         *m_newsIconMgr;
		QMap<QString, NewsSourceItem *> m_itemIconMap;
};

#endif // KNEWSTICKERCONFIG_H
