/***************************************************************************
                          kwifimanager.cpp  -  description
                             -------------------
    begin                : Sam Apr  7 11:44:20 CEST 2001
    copyright            : (C) 2001-05 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for C++
#include <iostream>
#include <fstream>

// include files for QT
#include <QDateTime>
#include <QDir>
#include <QLayout>
#include <QToolTip>
#include <QImage>
#include <QBitmap>
#include <QTimer>
#include <QPushButton>
#include <QPixmap>
#include <QPainter>
#include <QByteArray>
#include <QTextStream>
#include <QGridLayout>
#include <QLabel>
#include <QApplication>
#include <QStringList>
// include files for KDE
#include <kapplication.h>
#include <kconfig.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kstandardaction.h>
#include <kstandarddirs.h>
#include <kmenu.h>
#include <kaction.h>
#include <kdebug.h>
#include <KStandardGuiItem>
#include <kmessagebox.h>
#include <ksystemtrayicon.h>
#include <kprocess.h>
#include <kglobal.h>
#include <kconfigdialog.h>
#include <ktoggleaction.h>
#include <kactioncollection.h>
// application specific includes
#include "asusled.h"
#include "networkscanning.h"
#include "kwifimanager.h"
#include "interface_wireless.h"
#include "interface_wireless_wirelessextensions.h"
#include "statistics.h"
#include "kwifi_settings.h"
#include "ui_config_behaviour.h"
#include "ui_config_appearance.h"
#include "kwifi_ifaceimpl.h"
#include "wifiadaptor.h"
#include <QtDBus>
#define ID_STATUS_MSG 1

QPixmap* KWiFiManagerApp::NO_CARD = 0;
QPixmap* KWiFiManagerApp::AD_HOC = 0;
QPixmap* KWiFiManagerApp::ALL_ALONE = 0;
QPixmap* KWiFiManagerApp::AP_CONNECT = 0;

QPixmap* KWiFiManagerApp::STRENGTHPIC[6];
QString  KWiFiManagerApp::strengthClassName[6];

QStringList KWiFiManagerApp::APs;

KWiFiManagerApp::KWiFiManagerApp ( QWidget *, const char *name ):
KMainWindow ( 0 ), device ( 0 ), m_shuttingDown ( false )
{
  setObjectName(name);
  new WifiAdaptor(this);
  QDBusConnection::sessionBus().registerObject("/KWifiManager", this);
  initAccessPointDatabase (  );

  KWiFiSettings::self (  )->readConfig (  );

  KStandardDirs finder;
  QString kdedir = finder.findResourceDir ( "data", "kwifimanager/pics/no_card.png" );
  kdedir += "kwifimanager/pics/";

  kDebug() << kdedir << endl;

  // FIXME: the following paths are QLineEdits in the GUI, but should be KUrlRequesters

  if ( KWiFiSettings::self (  )->useCustomStatusIcons (  ) )
    {
      NO_CARD = new QPixmap ( KWiFiSettings::self (  )->noCardPicture (  ) );
      AD_HOC = new QPixmap ( KWiFiSettings::self (  )->adHocPicture (  ) );
      ALL_ALONE = new QPixmap ( KWiFiSettings::self (  )->noAPPicture (  ) );
      AP_CONNECT = new QPixmap ( KWiFiSettings::self (  )->aPConnectionPicture (  ) );
    }
  else
    {
      NO_CARD = new QPixmap ( kdedir + "no_card.png" );
      AD_HOC = new QPixmap ( kdedir + "ad_hoc.png" );
      ALL_ALONE = new QPixmap ( kdedir + "all_alone.png" );
      AP_CONNECT = new QPixmap ( kdedir + "ap_connect.png" );
    }

  if ( KWiFiSettings::self (  )->useCustomStrengthIcons (  ) )
    {
      STRENGTHPIC[5] = new QPixmap ( KWiFiSettings::self (  )->veryGoodPicture (  ) );
      STRENGTHPIC[4] = new QPixmap ( KWiFiSettings::self (  )->goodPicture (  ) );
      STRENGTHPIC[3] = new QPixmap ( KWiFiSettings::self (  )->weakPicture (  ) );
      STRENGTHPIC[2] = new QPixmap ( KWiFiSettings::self (  )->minimumPicture (  ) );
      STRENGTHPIC[1] = new QPixmap ( KWiFiSettings::self (  )->noConnectionPicture (  ) );
      STRENGTHPIC[0] = new QPixmap ( KWiFiSettings::self (  )->noInformationAvailablePicture (  ) );
    }
  else
    {
      STRENGTHPIC[5] = new QPixmap ( kdedir + "excellent.png" );
      STRENGTHPIC[4] = new QPixmap ( kdedir + "good.png" );
      STRENGTHPIC[3] = new QPixmap ( kdedir + "marginal.png" );
      STRENGTHPIC[2] = new QPixmap ( kdedir + "oor_minimum.png" );
      STRENGTHPIC[1] = new QPixmap ( kdedir + "oor_down.png" );
      STRENGTHPIC[0] = new QPixmap ( kdedir + "offline.png" );
    }
  strengthClassName[0] = i18n ( "N/A" );
  strengthClassName[1] = i18n ( "OUT OF RANGE" );
  strengthClassName[2] = i18n ( "MINIMUM" );
  strengthClassName[3] = i18n ( "WEAK" );
  strengthClassName[4] = i18n ( "GOOD" );
  strengthClassName[5] = i18n ( "EXCELLENT" );

  initView (  );

  initActions (  );

  setAutoSaveSettings (  );

  resize ( sizeHint (  ) );

}


KWiFiManagerApp::~KWiFiManagerApp (  )
{
  kDebug (  ) << "Thank you for using KWiFiManager. You have made a simple program very happy." << endl;
}

void
KWiFiManagerApp::initAccessPointDatabase (  )
{
  KStandardDirs finder;
  QString kdedir = finder.findResourceDir ( "data", "kwifimanager/locations/NOWHERE.loc" );
  kdedir += "kwifimanager/locations/";
  QDir *locations = new QDir ( kdedir );
  if ( !locations->exists (  ) )
    kDebug (  ) << "A grave error occurred while searching for files with AccessPoint information." << endl;
  QStringList *entries = new QStringList ( locations->entryList (  ) );
  QString content;
  QString content2;
  for ( QStringList::Iterator it = entries->begin (  ); it != entries->end (  ); it++ )
    {
      if ( ( *it ) != "." && ( *it ) != ".." )
	{
	  QFile datei ( kdedir + ( *it ) );
	  datei.open ( QIODevice::ReadOnly );
	  while ( !( content = QString::fromUtf8 ( datei.readLine (  ) ) ).isEmpty (  ) )
	    {
	      QString temp ( content );
	      content.truncate ( content.indexOf ( ' ' ) );
	      content = content.toUpper (  );
	      content2 = temp.right ( temp.length (  ) - temp.indexOf ( ' ' ) - 1 );
	      content2.truncate ( content2.length (  ) - 1 );
	      APs << content << content2;
	    }
	  datei.close (  );
	}
    }
  delete entries;
  delete locations;
}

void
KWiFiManagerApp::slotLogESSID ( QString essid )
{
  static bool alreadyWarned = false;
  if ( !KWiFiSettings::self (  )->logHistory (  ) )
    return;
  QFile log_file ( KStandardDirs::locateLocal ( "data", "kwifimanager/kwifimanager.log", true ) );
  if (!alreadyWarned) {
	  kDebug (  ) << "Log file is " << log_file.fileName (  ) << endl;
	  alreadyWarned = true;
  }
  if ( !log_file.open ( QIODevice::WriteOnly | QIODevice::Append ) )
    kDebug (  ) << "Logging failed!" << endl;
  QTextStream stream ( &log_file );
  stream << QDateTime::currentDateTime (  ).toString (  ).toLatin1 (  );
  stream << " Entering network: " << essid.toLatin1 (  ) << endl;
  log_file.close (  );
}

void
KWiFiManagerApp::initActions (  )
{
  KSharedConfig::Ptr config = KGlobal::config(  );
  if ( config->hasGroup ( "General" ) )
    config->setGroup ( "General" );

  KStandardAction::quit ( this, SLOT ( slotFileQuit (  ) ), actionCollection (  ) );

  KStandardAction::preferences ( this, SLOT ( showSettings (  ) ), actionCollection (  ) );
  createGUI (  );
}


void
KWiFiManagerApp::initView (  )
{
	view = new QWidget ( this );
	  view->setBackgroundRole ( QPalette::Background );
	    setCentralWidget ( view );
	      zentrallayout = new QGridLayout ( view );
  iface_tabs = new QTabWidget( view );
  zentrallayout->addWidget(iface_tabs);

  setCaption (windowTitle( ).prepend( " - " ) );


  QString empty = "";
  KWiFi_Iface* newIface;

  // create instances of a wireless interface. When instances return a careOfInterface,
  // fire anoher instance and so all interfaces are iterated

  do { 
  	newIface = new KWiFi_Iface( this );
	connect(newIface,SIGNAL( interfaceChanged( KWiFi_Iface * ) ), this, SLOT( slotChangeInterfaceList( KWiFi_Iface * ) ) );
	slotChangeInterfaceList( newIface );
     }
     while (newIface->careOfInterface() != empty );

  iface_tabs->show();

}

void
KWiFiManagerApp::slotChangeInterfaceList ( KWiFi_Iface * iface )
{
	kDebug() << "slotChangeInterfaceList: careOf is " << iface->careOfInterface() << endl;
	if (iface->careOfInterface() != "") 
		{
		iface_tabs->addTab( iface, iface->careOfInterface( ) );
		setCaption ( windowTitle( ).prepend( " " + iface->careOfInterface( ) ) );
		}
	else
		{
		if (iface_tabs->indexOf( iface ) >= 0 ) iface_tabs->removeTab( iface_tabs->indexOf( iface ) );
		setCaption ( windowTitle( ).replace( " " + iface->careOfInterface( ), "" ) );
		}
}

void
KWiFiManagerApp::slotFileQuit (  )
{
  m_shuttingDown = true;
  kapp->quit (  );
}

void
KWiFiManagerApp::slotStartConfigEditor (  )
{
  KProcess startConf;
  startConf << "kdesu" << "kcmshell" << "kcmwifi";
  startConf.start ( KProcess::DontCare );
}

void
KWiFiManagerApp::saveProperties ( KConfig * conf )
{
  m_startDocked = !isVisible (  );
  conf->writeEntry ( "startDocked", m_startDocked );
  conf->writeEntry ( "wifidevice", device->get_interface_name (  ) );
  conf->sync (  );
}

void
KWiFiManagerApp::readProperties ( KConfig * conf )
{
  m_startDocked = conf->readEntry ( "startDocked", false );
  if ( m_startDocked )
    show (  );
  else
    hide (  );

  QString dev = conf->readEntry ( "wifidevice" );
  if ( !dev.isEmpty (  ) )
    device->setActiveDevice ( dev );
}

bool KWiFiManagerApp::queryClose (  )
{
  if ( !m_shuttingDown && !kapp->sessionSaving (  ) && KWiFiSettings::self()->stayInTrayOnClose() )
    {
      hide (  );
      return false;
    }
  return true;
}

bool KWiFiManagerApp::queryExit (  )
{
  // Save settings if auto-save is enabled, and settings have changed
  if ( settingsDirty (  ) && autoSaveSettings (  ) )
    saveAutoSaveSettings (  );
  return true;
}

void
KWiFiManagerApp::showSettings (  )
{
  if ( KConfigDialog::showDialog ( "settings" ) )
    return;

  appearance_container = new QWidget ( 0 );
  appearance_ui.setupUi ( appearance_container );

  behaviour_container = new QWidget ( 0 );
  behaviour_ui.setupUi ( behaviour_container );

  KConfigDialog *dialog = new KConfigDialog ( this, "settings", KWiFiSettings::self (  ),KPageDialog::List  );
  dialog->addPage ( behaviour_container, i18n ( "General" ), 0 );
  dialog->addPage ( appearance_container, i18n ( "Appearance" ), 0 );
  connect ( dialog, SIGNAL ( settingsChanged ( const QString & ) ), this, SLOT ( loadSettings (  ) ) );
  dialog->show (  );
}

void
KWiFiManagerApp::loadSettings (  )
{
}

#include "kwifimanager.moc"
