/*
  KPF - Public fileserver for KDE

  Copyright 2001 Rik Hemsley (rikkus) <rik@kde.org>

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to
  deal in the Software without restriction, including without limitation the
  rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
  sell copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
  WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include <qdir.h>
#include <qfileinfo.h>
//Added by qt3to4:
#include <QTimerEvent>
#include <QAbstractEventDispatcher>

#include "DirSelectWidget.h"
#include "DirSelectWidget.moc"

namespace KPF
{
  class DirSelectWidget::Private
  {
    public:

      QString pathToMakeVisible;
  };

  DirSelectWidget::DirSelectWidget
    (
      const QString & pathToMakeVisible,
      QWidget       * parent,
      const char    * name
    )
    : K3ListView(parent)
  {
    setObjectName(name);
    d = new Private;
    d->pathToMakeVisible = pathToMakeVisible;

    setRootIsDecorated(true);

    connect
      (
        this,
        SIGNAL(expanded(Q3ListViewItem *)),
        SLOT(slotExpanded(Q3ListViewItem *))
      );

    Q3ListViewItem * root = new Q3ListViewItem(this, "/");

    root->setExpandable(true);

    startTimer(0);
  }

  DirSelectWidget::~DirSelectWidget()
  {
    delete d;
  }

    void
  DirSelectWidget::timerEvent(QTimerEvent *)
  {
    QAbstractEventDispatcher::instance()->unregisterTimers(this);

    if (0 != firstChild())
      firstChild()->setOpen(true);
  }

    void
  DirSelectWidget::slotExpanded(Q3ListViewItem * item)
  {
    if (0 != item->firstChild())
      return;

    QString p(path(item));

    QDir dir(p);

    const QFileInfoList  entryInfoList =
      dir.entryInfoList(QDir::Dirs | QDir::Readable);

    for (int i = 0; i < entryInfoList.size(); ++i) {
      QFileInfo fileInfo = entryInfoList.at(i);
      if ( fileInfo.isDir() && fileInfo.isReadable())
      {
        Q3ListViewItem * i = new Q3ListViewItem(item, fileInfo.fileName());
        i->setExpandable(true);
      }
    }
  }

    QString
  DirSelectWidget::path(Q3ListViewItem * item) const
  {
    QString ret(item->text(0));

    while (0 != (item = item->parent()))
      ret.prepend('/' + item->text(0));

    return ret;
  }
}

// vim:ts=2:sw=2:tw=78:et
