# - Try to find the X11 VidMode extension
# Once done this will define
#
#  X11VIDMODE_FOUND - system has the X11 VidMode extension
#  X11VIDMODE_INCLUDE_DIR - the corresponding include directory
#  X11VIDMODE_LIBRARIES - the corresponding libraries

# Copyright (c) 2006, Brad Hards, <bradh@frogmouth.net>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.


if (X11VIDMODE_INCLUDE_DIR)
  # Already in cache, be silent
  set(X11VIDMODE_FIND_QUIETLY TRUE)
endif (X11VIDMODE_INCLUDE_DIR)

FIND_PATH(X11VIDMODE_INCLUDE_DIR X11/extensions/xf86vmode.h
  /usr/include
  /usr/local/include
)

FIND_LIBRARY(X11VIDMODE_LIBRARIES NAMES Xxf86vm
  PATHS
  /usr/lib
  /usr/local/lib
)

IF(X11VIDMODE_INCLUDE_DIR AND X11VIDMODE_LIBRARIES)
   SET(X11VIDMODE_FOUND TRUE)
ENDIF(X11VIDMODE_INCLUDE_DIR AND X11VIDMODE_LIBRARIES)

IF(X11VIDMODE_FOUND)
  IF(NOT X11VIDMODE_FIND_QUIETLY)
    MESSAGE(STATUS "Found X11VidMode extension: ${X11VIDMODE_LIBRARIES}")
  ENDIF(NOT X11VIDMODE_FIND_QUIETLY)
ELSE(X11VIDMODE_FOUND)
  IF(X11VIDMODE_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "Could not find X11VidMode extension")
  ENDIF(X11VIDMODE_FIND_REQUIRED)
ENDIF(X11VIDMODE_FOUND)

# show the variables only in the advanced view
MARK_AS_ADVANCED(X11VIDMODE_INCLUDE_DIR X11VIDMODE_LIBRARIES )


