# cmake macro to test SLP LIB

# Copyright (c) 2006, Laurent Montel, <montel@kde.org>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.


if (SLP_INCLUDE_DIR)
    # Already in cache, be silent
    set(SLP_FIND_QUIETLY TRUE)
endif (SLP_INCLUDE_DIR)


FIND_PATH(SLP_INCLUDE_DIR slp.h
    /usr/include
    /usr/local/include
)

FIND_LIBRARY(SLP_LIBRARIES NAMES slp
    PATHS
    /usr/lib
    /usr/local/lib
)
if (SLP_LIBRARIES AND SLP_INCLUDE_DIR)
    set(SLP_FOUND TRUE)
endif (SLP_LIBRARIES AND SLP_INCLUDE_DIR)

if (SLP_FOUND)
    if (NOT SLP_FIND_QUIETLY)
    message(STATUS "Found SLP: ${SLP_LIBRARIES}")
    endif (NOT SLP_FIND_QUIETLY)
else (SLP_FOUND)
    if (SLP_FIND_REQUIRED)
    message(FATAL_ERROR "Could NOT find SLP")
    endif (SLP_FIND_REQUIRED)
endif (SLP_FOUND)

MARK_AS_ADVANCED(SLP_INCLUDE_DIR SLP_LIBRARIES)
