// systray.h
//
// Copyright 2004 Stefan Gehn <metz AT gehn DOT net>
// Copyright 2000 Neil Stevens <multivac@fcmail.com>
// Copyright 1999 Charles Samuels <charles@kde.org>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#ifndef N_SYSTRAY_H
#define N_SYSTRAY_H

#include "noatun/plugin.h"

#include <qguardedptr.h>
#include <qtimer.h>
#include <qpixmap.h>

using namespace Noatun;

class KitSystemTray;
class QTimer;
class PassivePopup;
class KComponentData;

class NoatunSystray : public Plugin
{
Q_OBJECT
public:
	NoatunSystray(const KComponentData &instance, Global *parent, const char* name);
	~NoatunSystray();

	Interface *getInterface(const QString&);

public Q_SLOTS:
	void slotPlayPause();
	void slotStopped();

private Q_SLOTS:
	void slotLoadSettings();
	void slotBlinkTimer();
	void showPassivePopup();
	void slotIconThemeChanged();

private:
	enum TrayIcons { Base = 0, Stopped, Playing, Paused };

	void changeTray(TrayIcons iconState);
	void setTipText(const QString&);
	void updateCover();
	void removeCover();
	void createTrayPixmaps();
	QPixmap renderIcon(const QString &, const QString &) const;

private:
	QPointer<KitSystemTray> mTray;
	QTimer *mBlinkTimer;

	TrayIcons currentState;
	QPixmap trayPixmaps[4];

	PassivePopup *mPassivePopup;
	bool showingTrayStatus;
	QString tipText;
	QString tmpCoverPath;
};

#endif
