/***************************************************************************
                     A simple database-driven playlist for Noatun
                    ----------------.-----------------------------
    begin                : 02.06.2005
    copyright            : (C) 2005 by Stefan Gehn
    email                : Stefan Gehn <mETz81@web.de>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "playlisthandler.h"
#include "simpleplaylist.h"

#include <kurl.h>

PlaylistHandler::PlaylistHandler(SimplePlaylist *pl, int afterId)
{
	mPlaylist = pl;
	mAfterId = afterId;
	mFirst = 0;
}

int PlaylistHandler::getLast()
{
	return mAfterId;
}

int PlaylistHandler::getFirst()
{
	return mFirst;
}

void PlaylistHandler::readItem(const Noatun::PropertyMap &properties)
{
	Noatun::PropertyMap props = properties;
	KUrl url = KUrl::fromPathOrUrl(props["url"]);
	if (!url.isEmpty())
	{
		const QString lengthString = properties["length"];
		props.remove("url");
		props.remove("length");
		mAfterId = mPlaylist->addFile(url, (lengthString.isEmpty() ? -1 : lengthString.toInt()), props, mAfterId);
		if (mFirst == 0)
			mFirst = mAfterId;
	}
}

Noatun::PlaylistItem PlaylistHandler::writeItem()
{
	//TODO: Needed for playlist export
	Noatun::PlaylistItem ret;
	return ret;
}

